/*
 * Decompiled with CFR 0.152.
 */
package breeze.collection.mutable;

import breeze.collection.mutable.RingBuffer$;
import java.io.Serializable;
import scala.Function1;
import scala.Predef$;
import scala.collection.BuildFrom;
import scala.collection.IndexedSeqOps;
import scala.collection.IterableFactory;
import scala.collection.IterableFactory$;
import scala.collection.IterableOnce;
import scala.collection.Iterator;
import scala.collection.Iterator$;
import scala.collection.SeqFactory;
import scala.collection.StrictOptimizedIterableOps;
import scala.collection.StrictOptimizedSeqOps;
import scala.collection.generic.DefaultSerializable;
import scala.collection.immutable.Seq;
import scala.collection.mutable.AbstractBuffer;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.Builder;
import scala.collection.mutable.GrowableBuilder;
import scala.collection.mutable.IndexedBuffer;
import scala.collection.mutable.IndexedSeq;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.Scala3RunTime$;

public class RingBuffer<A>
extends AbstractBuffer<A>
implements IndexedBuffer<A>,
StrictOptimizedSeqOps<A, RingBuffer, RingBuffer<A>>,
DefaultSerializable,
Builder<A, Seq<A>> {
    private final int capacity;
    private final ArrayBuffer<A> buf;
    private int startPos;
    private int endPos;

    public static <A, B> BuildFrom<RingBuffer<A>, B, RingBuffer<B>> canBuildFrom() {
        return RingBuffer$.MODULE$.canBuildFrom();
    }

    public RingBuffer(int capacity) {
        this.capacity = capacity;
        IndexedSeqOps.$init$((IndexedSeqOps)this);
        scala.collection.IndexedSeq.$init$((scala.collection.IndexedSeq)this);
        scala.collection.mutable.IndexedSeqOps.$init$((scala.collection.mutable.IndexedSeqOps)this);
        IndexedSeq.$init$((IndexedSeq)this);
        IndexedBuffer.$init$((IndexedBuffer)this);
        StrictOptimizedIterableOps.$init$((StrictOptimizedIterableOps)this);
        StrictOptimizedSeqOps.$init$((StrictOptimizedSeqOps)this);
        DefaultSerializable.$init$((DefaultSerializable)this);
        Builder.$init$((Builder)this);
        this.buf = (ArrayBuffer)ArrayBuffer$.MODULE$.fill(capacity, RingBuffer::$init$$$anonfun$1);
        this.startPos = 0;
        this.endPos = 0;
    }

    public int capacity() {
        return this.capacity;
    }

    public boolean isFull() {
        return this.endPos < 0;
    }

    public int knownSize() {
        return this.length();
    }

    private int trueEnd() {
        return this.isFull() ? this.startPos : this.endPos;
    }

    public A apply(int n) {
        return (A)this.buf.apply(this.index(n));
    }

    public int length() {
        return this.isFull() ? this.capacity() : (this.endPos < this.startPos ? this.capacity() + this.endPos - this.startPos : this.endPos - this.startPos);
    }

    private int index(int i) {
        this.boundsCheck(i, this.boundsCheck$default$2());
        return (i + this.startPos) % this.capacity();
    }

    private void boundsCheck(int i, boolean inclusiveEnd) {
        if (i < 0 || i > this.length() || !inclusiveEnd && i == this.length()) {
            throw new IndexOutOfBoundsException(new StringBuilder(56).append(i).append(" out of bounds for RingBuffer with length ").append(this.length()).append(" and capacity ").append(this.capacity()).toString());
        }
    }

    private boolean boundsCheck$default$2() {
        return false;
    }

    public void update(int n, A x) {
        this.buf.update(this.index(n), x);
    }

    private int advance(int pos) {
        return (pos + 1) % this.capacity();
    }

    private int recede(int pos) {
        return pos - 1 < 0 ? this.capacity() - 1 : pos - 1;
    }

    public RingBuffer addOne(A x) {
        if (this.isFull()) {
            this.buf.update(this.startPos, x);
            this.startPos = this.advance(this.startPos);
        } else {
            this.buf.update(this.endPos, x);
            this.endPos = this.advance(this.endPos);
            if (this.endPos == this.startPos) {
                this.endPos = -1;
            }
        }
        return this;
    }

    public void clear() {
        this.startPos = 0;
        this.endPos = 0;
    }

    public RingBuffer prepend(A elem) {
        this.startPos = this.recede(this.startPos);
        this.buf.update(this.startPos, elem);
        if (this.endPos == this.startPos) {
            this.endPos = -1;
        }
        return this;
    }

    public void insertAll(int n, IterableOnce<A> elems) {
        if (n == this.length()) {
            this.$plus$plus$eq(elems);
        } else {
            this.boundsCheck(n, this.boundsCheck$default$2());
            RingBuffer toInsertAfter = (RingBuffer)((Object)this.slice(n, this.length()));
            this.dropRightInPlace(this.length() - n);
            this.$plus$plus$eq(elems);
            this.$plus$plus$eq((IterableOnce)toInsertAfter);
        }
    }

    public void insert(int idx, A elem) {
        this.insertAll(idx, (IterableOnce<A>)Iterator$.MODULE$.single(elem));
    }

    public void remove(int n, int count) {
        this.boundsCheck(n, true);
        this.boundsCheck(n + count, true);
        if (count != 0) {
            if (n + count == this.length()) {
                this.endPos = (this.trueEnd() + this.capacity() - count) % this.capacity();
                if (this.length() != n) {
                    throw Scala3RunTime$.MODULE$.assertFailed();
                }
            } else if (n == 0) {
                if (this.isFull()) {
                    this.endPos = this.startPos;
                }
                this.startPos += count;
                this.startPos %= this.capacity();
            } else {
                ArrayBuffer elements = (ArrayBuffer)this.to(IterableFactory$.MODULE$.toFactory((IterableFactory)ArrayBuffer$.MODULE$));
                elements.remove(n, count);
                this.clear();
                this.$plus$plus$eq((IterableOnce)elements);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public A remove(int n) {
        void var2_2;
        A v = this.apply(n);
        this.remove(n, 1);
        return var2_2;
    }

    public RingBuffer subtractOne(A elem) {
        int pos = this.indexOf(elem);
        if (pos >= 0) {
            this.remove(pos);
        }
        return this;
    }

    public RingBuffer<A> clone() {
        return (RingBuffer)new RingBuffer<A>(this.capacity()).$plus$plus$eq((IterableOnce)this);
    }

    public String className() {
        return "RingBuffer";
    }

    public Iterator<A> iterator() {
        return Iterator$.MODULE$.range(0, this.length()).map((Function1 & Serializable)n -> this.iterator$$anonfun$1(BoxesRunTime.unboxToInt((Object)n)));
    }

    public String stateString() {
        scala.collection.mutable.StringBuilder out = new scala.collection.mutable.StringBuilder("RingBuffer(");
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.capacity()).foreach((Function1 & Serializable)i -> this.stateString$$anonfun$1(out, BoxesRunTime.unboxToInt((Object)i)));
        out.$plus$plus$eq(")");
        return out.toString();
    }

    public Seq<A> result() {
        return this.iterator().toIndexedSeq();
    }

    public RingBuffer<A> fromSpecific(IterableOnce<A> coll) {
        return (RingBuffer)new RingBuffer<A>(this.capacity()).$plus$plus$eq((IterableOnce)coll.iterator().to(IterableFactory$.MODULE$.toFactory((IterableFactory)ArrayBuffer$.MODULE$)));
    }

    public Builder<A, RingBuffer<A>> newSpecificBuilder() {
        return new GrowableBuilder(new RingBuffer<A>(this.capacity()));
    }

    public RingBuffer<A> empty() {
        return new RingBuffer<A>(this.capacity());
    }

    public SeqFactory<RingBuffer> iterableFactory() {
        return new SeqFactory<RingBuffer>(this){
            private final /* synthetic */ RingBuffer $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                IterableFactory.$init$((IterableFactory)this);
                SeqFactory.$init$((SeqFactory)this);
            }

            public Builder newBuilder() {
                return RingBuffer$.MODULE$.canBuildFrom().newBuilder((Object)((Object)this.$outer));
            }

            public RingBuffer empty() {
                return (RingBuffer)((Object)this.newBuilder().result());
            }

            public RingBuffer from(IterableOnce f) {
                return (RingBuffer)((Object)((Builder)this.newBuilder().$plus$plus$eq(f)).result());
            }
        };
    }

    private static final Object $init$$$anonfun$1() {
        return null;
    }

    private final /* synthetic */ Object iterator$$anonfun$1(int n) {
        return this.apply(n);
    }

    private final /* synthetic */ scala.collection.mutable.StringBuilder stateString$$anonfun$1(scala.collection.mutable.StringBuilder out$1, int i) {
        scala.collection.mutable.StringBuilder stringBuilder;
        if (i != 0) {
            out$1.$plus$plus$eq(", ");
        }
        if (i == this.startPos && this.startPos == this.endPos) {
            stringBuilder = out$1.$plus$plus$eq("`'");
        } else {
            if (i == this.trueEnd()) {
                out$1.$plus$plus$eq("'");
            }
            if (i == this.startPos) {
                out$1.$plus$plus$eq("`");
            }
            stringBuilder = out$1.$plus$plus$eq(this.buf.apply(i).toString());
        }
        return stringBuilder;
    }
}

