/*
 * Decompiled with CFR 0.152.
 */
package breeze.linalg.operators;

import breeze.linalg.DenseMatrix;
import breeze.linalg.DenseMatrix$;
import breeze.linalg.DenseVector;
import breeze.linalg.DenseVector$;
import breeze.linalg.ImmutableNumericOps;
import breeze.linalg.Transpose;
import breeze.linalg.operators.DenseMatrix_SlicingOps_LowPrio;
import breeze.linalg.operators.DenseMatrix_TraversalOps;
import breeze.linalg.operators.HasOps$;
import breeze.linalg.package$;
import breeze.linalg.support.CanSlice2;
import breeze.linalg.support.RangeExtender$;
import scala.;
import scala.$less$colon$less$;
import scala.collection.StringOps$;
import scala.collection.immutable.$colon$colon$;
import scala.collection.immutable.Range;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public interface DenseMatrix_SlicingOps
extends DenseMatrix_SlicingOps_LowPrio,
DenseMatrix_TraversalOps {
    public static CanSlice2 canSliceCol$(DenseMatrix_SlicingOps $this) {
        return $this.canSliceCol();
    }

    default public <V> CanSlice2<DenseMatrix<V>, $colon$colon$, Object, DenseVector<V>> canSliceCol() {
        return new CanSlice2<DenseMatrix<V>, $colon$colon$, Object, DenseVector<V>>(){

            public DenseVector apply(DenseMatrix m, $colon$colon$ ignored, int colWNegative) {
                DenseVector<V> denseVector;
                int col;
                if (colWNegative < -m.cols() || colWNegative >= m.cols()) {
                    throw new ArrayIndexOutOfBoundsException("Column must be in bounds for slice!");
                }
                int n = col = colWNegative < 0 ? colWNegative + m.cols() : colWNegative;
                if (!m.isTranspose()) {
                    int n2 = col * m.majorStride() + m.offset();
                    denseVector = DenseVector$.MODULE$.create(m.data(), n2, 1, m.rows());
                } else {
                    int n3 = m.offset() + col;
                    denseVector = DenseVector$.MODULE$.create(m.data(), n3, m.majorStride(), m.rows());
                }
                return denseVector;
            }
        };
    }

    public static CanSlice2 canSliceRow$(DenseMatrix_SlicingOps $this) {
        return $this.canSliceRow();
    }

    default public <V> CanSlice2<DenseMatrix<V>, Object, $colon$colon$, Transpose<DenseVector<V>>> canSliceRow() {
        return new CanSlice2<DenseMatrix<V>, Object, $colon$colon$, Transpose<DenseVector<V>>>(this){
            private final /* synthetic */ DenseMatrix_SlicingOps $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public Transpose apply(DenseMatrix m, int rowWNegative, $colon$colon$ ignored) {
                return (Transpose)((ImmutableNumericOps)this.$outer.canSliceCol().apply(m.t(HasOps$.MODULE$.canTranspose_DM()), scala.package$.MODULE$.$colon$colon(), BoxesRunTime.boxToInteger((int)rowWNegative))).t(HasOps$.MODULE$.transposeTensor((.less.colon.less)$less$colon$less$.MODULE$.refl()));
            }
        };
    }

    public static CanSlice2 canSliceRows$(DenseMatrix_SlicingOps $this) {
        return $this.canSliceRows();
    }

    default public <V> CanSlice2<DenseMatrix<V>, Range, $colon$colon$, DenseMatrix<V>> canSliceRows() {
        return new CanSlice2<DenseMatrix<V>, Range, $colon$colon$, DenseMatrix<V>>(this){
            private final /* synthetic */ DenseMatrix_SlicingOps $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public DenseMatrix apply(DenseMatrix m, Range rowsWNegative, $colon$colon$ ignored) {
                DenseMatrix<V> denseMatrix;
                Range rows = RangeExtender$.MODULE$.getRangeWithoutNegativeIndexes$extension(package$.MODULE$.RangeToRangeExtender(rowsWNegative), m.rows());
                if (rows.isEmpty()) {
                    denseMatrix = DenseMatrix$.MODULE$.create(0, m.cols(), m.data(), 0, 0, DenseMatrix$.MODULE$.create$default$6());
                } else if (!m.isTranspose()) {
                    if (rows.step() != 1) {
                        throw new IllegalArgumentException(StringOps$.MODULE$.format$extension("requirement failed: %s", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{new StringBuilder(80).append("Sorry, we can't support row ranges with step sizes other than 1").append(": ").append("rows.step.==(1)").toString()})));
                    }
                    int first = rows.head();
                    if (rows.last() >= m.rows()) {
                        throw new IllegalArgumentException(StringOps$.MODULE$.format$extension("requirement failed: %s", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"rows.last.<(m.rows)"})));
                    }
                    if (rows.last() >= m.rows()) {
                        throw new IndexOutOfBoundsException(new StringBuilder(45).append("Row slice of ").append(rows).append(" was bigger than matrix rows of ").append(m.rows()).toString());
                    }
                    denseMatrix = DenseMatrix$.MODULE$.create(rows.length(), m.cols(), m.data(), m.offset() + first, m.majorStride(), DenseMatrix$.MODULE$.create$default$6());
                } else {
                    denseMatrix = (DenseMatrix<V>)((ImmutableNumericOps)this.$outer.canSliceCols().apply(m.t(HasOps$.MODULE$.canTranspose_DM()), scala.package$.MODULE$.$colon$colon(), rows)).t(HasOps$.MODULE$.canTranspose_DM());
                }
                return denseMatrix;
            }
        };
    }

    public static CanSlice2 canSliceCols$(DenseMatrix_SlicingOps $this) {
        return $this.canSliceCols();
    }

    default public <V> CanSlice2<DenseMatrix<V>, $colon$colon$, Range, DenseMatrix<V>> canSliceCols() {
        return new CanSlice2<DenseMatrix<V>, $colon$colon$, Range, DenseMatrix<V>>(this){
            private final /* synthetic */ DenseMatrix_SlicingOps $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public DenseMatrix apply(DenseMatrix m, $colon$colon$ ignored, Range colsWNegative) {
                DenseMatrix<V> denseMatrix;
                Range cols = RangeExtender$.MODULE$.getRangeWithoutNegativeIndexes$extension(package$.MODULE$.RangeToRangeExtender(colsWNegative), m.cols());
                if (cols.isEmpty()) {
                    denseMatrix = DenseMatrix$.MODULE$.create(m.rows(), 0, m.data(), 0, m.rows(), DenseMatrix$.MODULE$.create$default$6());
                } else if (!m.isTranspose()) {
                    int first = cols.head();
                    if (cols.last() >= m.cols()) {
                        throw new IndexOutOfBoundsException(new StringBuilder(45).append("Col slice of ").append(cols).append(" was bigger than matrix cols of ").append(m.cols()).toString());
                    }
                    denseMatrix = DenseMatrix$.MODULE$.create(m.rows(), cols.length(), m.data(), m.offset() + first * m.majorStride(), m.majorStride() * cols.step(), DenseMatrix$.MODULE$.create$default$6());
                } else {
                    denseMatrix = (DenseMatrix<V>)((ImmutableNumericOps)this.$outer.canSliceRows().apply(m.t(HasOps$.MODULE$.canTranspose_DM()), cols, scala.package$.MODULE$.$colon$colon())).t(HasOps$.MODULE$.canTranspose_DM());
                }
                return denseMatrix;
            }
        };
    }

    public static CanSlice2 canSliceColsAndRows$(DenseMatrix_SlicingOps $this) {
        return $this.canSliceColsAndRows();
    }

    default public <V> CanSlice2<DenseMatrix<V>, Range, Range, DenseMatrix<V>> canSliceColsAndRows() {
        return new CanSlice2<DenseMatrix<V>, Range, Range, DenseMatrix<V>>(this){
            private final /* synthetic */ DenseMatrix_SlicingOps $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public DenseMatrix apply(DenseMatrix m, Range rowsWNegative, Range colsWNegative) {
                DenseMatrix<V> denseMatrix;
                Range rows = RangeExtender$.MODULE$.getRangeWithoutNegativeIndexes$extension(package$.MODULE$.RangeToRangeExtender(rowsWNegative), m.rows());
                Range cols = RangeExtender$.MODULE$.getRangeWithoutNegativeIndexes$extension(package$.MODULE$.RangeToRangeExtender(colsWNegative), m.cols());
                if (rows.isEmpty() || cols.isEmpty()) {
                    denseMatrix = DenseMatrix$.MODULE$.create(rows.size(), cols.size(), m.data(), 0, 0, DenseMatrix$.MODULE$.create$default$6());
                } else if (!m.isTranspose()) {
                    if (rows.step() != 1) {
                        throw new IllegalArgumentException(StringOps$.MODULE$.format$extension("requirement failed: %s", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{new StringBuilder(108).append("Sorry, we can't support row ranges with step sizes other than 1 for non transposed matrices").append(": ").append("rows.step.==(1)").toString()})));
                    }
                    int first = cols.head();
                    if (rows.last() >= m.rows()) {
                        throw new IndexOutOfBoundsException(new StringBuilder(45).append("Row slice of ").append(rows).append(" was bigger than matrix rows of ").append(m.rows()).toString());
                    }
                    if (cols.last() >= m.cols()) {
                        throw new IndexOutOfBoundsException(new StringBuilder(45).append("Col slice of ").append(cols).append(" was bigger than matrix cols of ").append(m.cols()).toString());
                    }
                    denseMatrix = DenseMatrix$.MODULE$.create(rows.length(), cols.length(), m.data(), m.offset() + first * m.majorStride() + rows.head(), m.majorStride() * cols.step(), DenseMatrix$.MODULE$.create$default$6());
                } else {
                    if (cols.step() != 1) {
                        throw new IllegalArgumentException(StringOps$.MODULE$.format$extension("requirement failed: %s", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{new StringBuilder(104).append("Sorry, we can't support col ranges with step sizes other than 1 for transposed matrices").append(": ").append("cols.step.==(1)").toString()})));
                    }
                    denseMatrix = (DenseMatrix<V>)((ImmutableNumericOps)this.$outer.canSliceColsAndRows().apply(m.t(HasOps$.MODULE$.canTranspose_DM()), cols, rows)).t(HasOps$.MODULE$.canTranspose_DM());
                }
                return denseMatrix;
            }
        };
    }

    public static CanSlice2 canSlicePartOfCol$(DenseMatrix_SlicingOps $this) {
        return $this.canSlicePartOfCol();
    }

    default public <V> CanSlice2<DenseMatrix<V>, Range, Object, DenseVector<V>> canSlicePartOfCol() {
        return new CanSlice2<DenseMatrix<V>, Range, Object, DenseVector<V>>(){

            public DenseVector apply(DenseMatrix m, Range rowsWNegative, int colWNegative) {
                DenseVector<V> denseVector;
                int col;
                Range rows = RangeExtender$.MODULE$.getRangeWithoutNegativeIndexes$extension(package$.MODULE$.RangeToRangeExtender(rowsWNegative), m.rows());
                if (colWNegative < -m.cols() || colWNegative >= m.cols()) {
                    throw new ArrayIndexOutOfBoundsException("Row must be in bounds for slice!");
                }
                int n = col = colWNegative < 0 ? colWNegative + m.cols() : colWNegative;
                if (rows.isEmpty()) {
                    denseVector = DenseVector$.MODULE$.create(m.data(), 0, 0, 0);
                } else if (!m.isTranspose()) {
                    if (rows.last() >= m.rows()) {
                        throw new IndexOutOfBoundsException(new StringBuilder(45).append("Row slice of ").append(rows).append(" was bigger than matrix rows of ").append(m.rows()).toString());
                    }
                    denseVector = DenseVector$.MODULE$.create(m.data(), col * m.majorStride() + m.offset() + rows.head(), rows.step(), rows.length());
                } else {
                    denseVector = DenseVector$.MODULE$.create(m.data(), m.offset() + col + rows.head() * m.majorStride(), m.majorStride() * rows.step(), rows.length());
                }
                return denseVector;
            }
        };
    }

    public static CanSlice2 canSlicePartOfRow$(DenseMatrix_SlicingOps $this) {
        return $this.canSlicePartOfRow();
    }

    default public <V> CanSlice2<DenseMatrix<V>, Object, Range, Transpose<DenseVector<V>>> canSlicePartOfRow() {
        return new CanSlice2<DenseMatrix<V>, Object, Range, Transpose<DenseVector<V>>>(this){
            private final /* synthetic */ DenseMatrix_SlicingOps $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public Transpose apply(DenseMatrix m, int rowWNegative, Range colsWNegative) {
                return (Transpose)((ImmutableNumericOps)this.$outer.canSlicePartOfCol().apply(m.t(HasOps$.MODULE$.canTranspose_DM()), colsWNegative, BoxesRunTime.boxToInteger((int)rowWNegative))).t(HasOps$.MODULE$.transposeTensor((.less.colon.less)$less$colon$less$.MODULE$.refl()));
            }
        };
    }
}

