/*
 * Decompiled with CFR 0.152.
 */
package breeze.linalg.operators;

import breeze.generic.UFunc;
import breeze.linalg.CSCMatrix;
import breeze.linalg.SparseVector;
import breeze.linalg.SparseVector$;
import breeze.linalg.Transpose;
import breeze.linalg.Vector;
import breeze.linalg.VectorBuilder;
import breeze.linalg.VectorBuilder$;
import breeze.linalg.operators.BinaryRegistry;
import breeze.linalg.operators.OpAdd$;
import breeze.linalg.operators.OpDiv$;
import breeze.linalg.operators.OpMod$;
import breeze.linalg.operators.OpMulInner$;
import breeze.linalg.operators.OpMulMatrix$;
import breeze.linalg.operators.OpMulScalar$;
import breeze.linalg.operators.OpPow$;
import breeze.linalg.operators.OpSet$;
import breeze.linalg.operators.OpSub$;
import breeze.linalg.operators.SparseVectorExpandOps$;
import breeze.linalg.operators.SparseVector_DenseMatrixOps;
import breeze.linalg.operators.SparseVector_GenericOps;
import breeze.linalg.operators.TernaryUpdateRegistry;
import breeze.linalg.operators.VectorOps;
import breeze.linalg.scaleAdd$;
import breeze.linalg.support.CanZipMapKeyValues;
import breeze.linalg.support.CanZipMapValues;
import breeze.math.PowImplicits$;
import breeze.math.Ring;
import breeze.math.Semiring;
import breeze.math.Semiring$;
import breeze.storage.Zero;
import breeze.storage.Zero$;
import breeze.util.ArrayUtil$;
import java.util.Arrays;
import scala.Array$;
import scala.Function2;
import scala.Function3;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.math.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.Arrays$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public interface SparseVectorExpandOps
extends VectorOps,
SparseVector_DenseMatrixOps,
SparseVector_GenericOps {
    public static void $init$(SparseVectorExpandOps $this) {
        $this.breeze$linalg$operators$SparseVectorExpandOps$_setter_$impl_Op_SV_SV_eq_SV_Int_OpAdd_$eq(new UFunc.UImpl2<OpAdd$, SparseVector<Object>, SparseVector<Object>, SparseVector<Object>>($this){
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                ((BinaryRegistry)Predef$.MODULE$.implicitly($outer.impl_Op_V_V_eq_V_idempotent_Int_OpAdd())).register(this, ClassTag$.MODULE$.apply(SparseVector.class), ClassTag$.MODULE$.apply(SparseVector.class));
            }

            public SparseVector apply(SparseVector a, SparseVector b) {
                if (b.length() != a.length()) {
                    throw new IllegalArgumentException(StringOps$.MODULE$.format$extension("requirement failed: %s", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{new StringBuilder(55).append("Vectors must be the same length!").append(": ").append("b.length.==(a.length)").toString()})));
                }
                int asize = a.activeSize();
                int bsize = b.activeSize();
                int q = 0;
                int[] resultI = new int[asize + bsize];
                int[] resultV = new int[asize + bsize];
                int resultOff = 0;
                int boff = 0;
                for (int aoff = 0; aoff < asize; ++aoff) {
                    int n;
                    while (boff < bsize && b.indexAt(boff) < a.indexAt(aoff)) {
                        resultI[resultOff] = b.indexAt(boff);
                        resultV[resultOff] = q + BoxesRunTime.unboxToInt(b.valueAt(boff));
                        ++resultOff;
                        ++boff;
                    }
                    if (boff < bsize && b.indexAt(boff) == a.indexAt(aoff)) {
                        int bv = BoxesRunTime.unboxToInt(b.valueAt(boff));
                        ++boff;
                        n = bv;
                    } else {
                        n = q;
                    }
                    int bvalue = n;
                    resultI[resultOff] = a.indexAt(aoff);
                    resultV[resultOff] = BoxesRunTime.unboxToInt(a.valueAt(aoff)) + bvalue;
                    ++resultOff;
                }
                while (boff < bsize) {
                    resultI[resultOff] = b.indexAt(boff);
                    resultV[resultOff] = q + BoxesRunTime.unboxToInt(b.valueAt(boff));
                    ++resultOff;
                    ++boff;
                }
                return resultOff != resultI.length ? new SparseVector<Object>(Arrays.copyOf(resultI, resultOff), Arrays.copyOf(resultV, resultOff), resultOff, a.length(), Zero$.MODULE$.IntZero()) : new SparseVector<Object>(resultI, resultV, resultOff, a.length(), Zero$.MODULE$.IntZero());
            }
        });
        $this.breeze$linalg$operators$SparseVectorExpandOps$_setter_$impl_Op_SV_SV_eq_SV_Double_OpAdd_$eq(new UFunc.UImpl2<OpAdd$, SparseVector<Object>, SparseVector<Object>, SparseVector<Object>>($this){
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                ((BinaryRegistry)Predef$.MODULE$.implicitly($outer.impl_Op_V_V_eq_V_idempotent_Double_OpAdd())).register(this, ClassTag$.MODULE$.apply(SparseVector.class), ClassTag$.MODULE$.apply(SparseVector.class));
            }

            public SparseVector apply(SparseVector a, SparseVector b) {
                if (b.length() != a.length()) {
                    throw new IllegalArgumentException(StringOps$.MODULE$.format$extension("requirement failed: %s", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{new StringBuilder(55).append("Vectors must be the same length!").append(": ").append("b.length.==(a.length)").toString()})));
                }
                int asize = a.activeSize();
                int bsize = b.activeSize();
                double q = 0.0;
                int[] resultI = new int[asize + bsize];
                double[] resultV = new double[asize + bsize];
                int resultOff = 0;
                int boff = 0;
                for (int aoff = 0; aoff < asize; ++aoff) {
                    double d;
                    while (boff < bsize && b.indexAt(boff) < a.indexAt(aoff)) {
                        resultI[resultOff] = b.indexAt(boff);
                        resultV[resultOff] = q + BoxesRunTime.unboxToDouble(b.valueAt(boff));
                        ++resultOff;
                        ++boff;
                    }
                    if (boff < bsize && b.indexAt(boff) == a.indexAt(aoff)) {
                        double bv = BoxesRunTime.unboxToDouble(b.valueAt(boff));
                        ++boff;
                        d = bv;
                    } else {
                        d = q;
                    }
                    double bvalue = d;
                    resultI[resultOff] = a.indexAt(aoff);
                    resultV[resultOff] = BoxesRunTime.unboxToDouble(a.valueAt(aoff)) + bvalue;
                    ++resultOff;
                }
                while (boff < bsize) {
                    resultI[resultOff] = b.indexAt(boff);
                    resultV[resultOff] = q + BoxesRunTime.unboxToDouble(b.valueAt(boff));
                    ++resultOff;
                    ++boff;
                }
                return resultOff != resultI.length ? new SparseVector<Object>(Arrays.copyOf(resultI, resultOff), Arrays.copyOf(resultV, resultOff), resultOff, a.length(), Zero$.MODULE$.DoubleZero()) : new SparseVector<Object>(resultI, resultV, resultOff, a.length(), Zero$.MODULE$.DoubleZero());
            }
        });
        $this.breeze$linalg$operators$SparseVectorExpandOps$_setter_$impl_Op_SV_SV_eq_SV_Float_OpAdd_$eq(new UFunc.UImpl2<OpAdd$, SparseVector<Object>, SparseVector<Object>, SparseVector<Object>>($this){
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                ((BinaryRegistry)Predef$.MODULE$.implicitly($outer.impl_Op_V_V_eq_V_idempotent_Float_OpAdd())).register(this, ClassTag$.MODULE$.apply(SparseVector.class), ClassTag$.MODULE$.apply(SparseVector.class));
            }

            public SparseVector apply(SparseVector a, SparseVector b) {
                if (b.length() != a.length()) {
                    throw new IllegalArgumentException(StringOps$.MODULE$.format$extension("requirement failed: %s", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{new StringBuilder(55).append("Vectors must be the same length!").append(": ").append("b.length.==(a.length)").toString()})));
                }
                int asize = a.activeSize();
                int bsize = b.activeSize();
                float q = 0.0f;
                int[] resultI = new int[asize + bsize];
                float[] resultV = new float[asize + bsize];
                int resultOff = 0;
                int boff = 0;
                for (int aoff = 0; aoff < asize; ++aoff) {
                    float f;
                    while (boff < bsize && b.indexAt(boff) < a.indexAt(aoff)) {
                        resultI[resultOff] = b.indexAt(boff);
                        resultV[resultOff] = q + BoxesRunTime.unboxToFloat(b.valueAt(boff));
                        ++resultOff;
                        ++boff;
                    }
                    if (boff < bsize && b.indexAt(boff) == a.indexAt(aoff)) {
                        float bv = BoxesRunTime.unboxToFloat(b.valueAt(boff));
                        ++boff;
                        f = bv;
                    } else {
                        f = q;
                    }
                    float bvalue = f;
                    resultI[resultOff] = a.indexAt(aoff);
                    resultV[resultOff] = BoxesRunTime.unboxToFloat(a.valueAt(aoff)) + bvalue;
                    ++resultOff;
                }
                while (boff < bsize) {
                    resultI[resultOff] = b.indexAt(boff);
                    resultV[resultOff] = q + BoxesRunTime.unboxToFloat(b.valueAt(boff));
                    ++resultOff;
                    ++boff;
                }
                return resultOff != resultI.length ? new SparseVector<Object>(Arrays.copyOf(resultI, resultOff), Arrays.copyOf(resultV, resultOff), resultOff, a.length(), Zero$.MODULE$.FloatZero()) : new SparseVector<Object>(resultI, resultV, resultOff, a.length(), Zero$.MODULE$.FloatZero());
            }
        });
        $this.breeze$linalg$operators$SparseVectorExpandOps$_setter_$impl_Op_SV_SV_eq_SV_Long_OpAdd_$eq(new UFunc.UImpl2<OpAdd$, SparseVector<Object>, SparseVector<Object>, SparseVector<Object>>($this){
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                ((BinaryRegistry)Predef$.MODULE$.implicitly($outer.impl_Op_V_V_eq_V_idempotent_Long_OpAdd())).register(this, ClassTag$.MODULE$.apply(SparseVector.class), ClassTag$.MODULE$.apply(SparseVector.class));
            }

            public SparseVector apply(SparseVector a, SparseVector b) {
                if (b.length() != a.length()) {
                    throw new IllegalArgumentException(StringOps$.MODULE$.format$extension("requirement failed: %s", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{new StringBuilder(55).append("Vectors must be the same length!").append(": ").append("b.length.==(a.length)").toString()})));
                }
                int asize = a.activeSize();
                int bsize = b.activeSize();
                long q = 0L;
                int[] resultI = new int[asize + bsize];
                long[] resultV = new long[asize + bsize];
                int resultOff = 0;
                int boff = 0;
                for (int aoff = 0; aoff < asize; ++aoff) {
                    long l;
                    while (boff < bsize && b.indexAt(boff) < a.indexAt(aoff)) {
                        resultI[resultOff] = b.indexAt(boff);
                        resultV[resultOff] = q + BoxesRunTime.unboxToLong(b.valueAt(boff));
                        ++resultOff;
                        ++boff;
                    }
                    if (boff < bsize && b.indexAt(boff) == a.indexAt(aoff)) {
                        long bv = BoxesRunTime.unboxToLong(b.valueAt(boff));
                        ++boff;
                        l = bv;
                    } else {
                        l = q;
                    }
                    long bvalue = l;
                    resultI[resultOff] = a.indexAt(aoff);
                    resultV[resultOff] = BoxesRunTime.unboxToLong(a.valueAt(aoff)) + bvalue;
                    ++resultOff;
                }
                while (boff < bsize) {
                    resultI[resultOff] = b.indexAt(boff);
                    resultV[resultOff] = q + BoxesRunTime.unboxToLong(b.valueAt(boff));
                    ++resultOff;
                    ++boff;
                }
                return resultOff != resultI.length ? new SparseVector<Object>(Arrays.copyOf(resultI, resultOff), Arrays.copyOf(resultV, resultOff), resultOff, a.length(), Zero$.MODULE$.LongZero()) : new SparseVector<Object>(resultI, resultV, resultOff, a.length(), Zero$.MODULE$.LongZero());
            }
        });
        $this.breeze$linalg$operators$SparseVectorExpandOps$_setter_$impl_Op_SV_SV_eq_SV_Int_OpSub_$eq(new UFunc.UImpl2<OpSub$, SparseVector<Object>, SparseVector<Object>, SparseVector<Object>>($this){
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                ((BinaryRegistry)Predef$.MODULE$.implicitly($outer.impl_Op_V_V_eq_V_idempotent_Int_OpSub())).register(this, ClassTag$.MODULE$.apply(SparseVector.class), ClassTag$.MODULE$.apply(SparseVector.class));
            }

            public SparseVector apply(SparseVector a, SparseVector b) {
                if (b.length() != a.length()) {
                    throw new IllegalArgumentException(StringOps$.MODULE$.format$extension("requirement failed: %s", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{new StringBuilder(55).append("Vectors must be the same length!").append(": ").append("b.length.==(a.length)").toString()})));
                }
                int asize = a.activeSize();
                int bsize = b.activeSize();
                int q = 0;
                int[] resultI = new int[asize + bsize];
                int[] resultV = new int[asize + bsize];
                int resultOff = 0;
                int boff = 0;
                for (int aoff = 0; aoff < asize; ++aoff) {
                    int n;
                    while (boff < bsize && b.indexAt(boff) < a.indexAt(aoff)) {
                        resultI[resultOff] = b.indexAt(boff);
                        resultV[resultOff] = q - BoxesRunTime.unboxToInt(b.valueAt(boff));
                        ++resultOff;
                        ++boff;
                    }
                    if (boff < bsize && b.indexAt(boff) == a.indexAt(aoff)) {
                        int bv = BoxesRunTime.unboxToInt(b.valueAt(boff));
                        ++boff;
                        n = bv;
                    } else {
                        n = q;
                    }
                    int bvalue = n;
                    resultI[resultOff] = a.indexAt(aoff);
                    resultV[resultOff] = BoxesRunTime.unboxToInt(a.valueAt(aoff)) - bvalue;
                    ++resultOff;
                }
                while (boff < bsize) {
                    resultI[resultOff] = b.indexAt(boff);
                    resultV[resultOff] = q - BoxesRunTime.unboxToInt(b.valueAt(boff));
                    ++resultOff;
                    ++boff;
                }
                return resultOff != resultI.length ? new SparseVector<Object>(Arrays.copyOf(resultI, resultOff), Arrays.copyOf(resultV, resultOff), resultOff, a.length(), Zero$.MODULE$.IntZero()) : new SparseVector<Object>(resultI, resultV, resultOff, a.length(), Zero$.MODULE$.IntZero());
            }
        });
        $this.breeze$linalg$operators$SparseVectorExpandOps$_setter_$impl_Op_SV_SV_eq_SV_Double_OpSub_$eq(new UFunc.UImpl2<OpSub$, SparseVector<Object>, SparseVector<Object>, SparseVector<Object>>($this){
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                ((BinaryRegistry)Predef$.MODULE$.implicitly($outer.impl_Op_V_V_eq_V_idempotent_Double_OpSub())).register(this, ClassTag$.MODULE$.apply(SparseVector.class), ClassTag$.MODULE$.apply(SparseVector.class));
            }

            public SparseVector apply(SparseVector a, SparseVector b) {
                if (b.length() != a.length()) {
                    throw new IllegalArgumentException(StringOps$.MODULE$.format$extension("requirement failed: %s", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{new StringBuilder(55).append("Vectors must be the same length!").append(": ").append("b.length.==(a.length)").toString()})));
                }
                int asize = a.activeSize();
                int bsize = b.activeSize();
                double q = 0.0;
                int[] resultI = new int[asize + bsize];
                double[] resultV = new double[asize + bsize];
                int resultOff = 0;
                int boff = 0;
                for (int aoff = 0; aoff < asize; ++aoff) {
                    double d;
                    while (boff < bsize && b.indexAt(boff) < a.indexAt(aoff)) {
                        resultI[resultOff] = b.indexAt(boff);
                        resultV[resultOff] = q - BoxesRunTime.unboxToDouble(b.valueAt(boff));
                        ++resultOff;
                        ++boff;
                    }
                    if (boff < bsize && b.indexAt(boff) == a.indexAt(aoff)) {
                        double bv = BoxesRunTime.unboxToDouble(b.valueAt(boff));
                        ++boff;
                        d = bv;
                    } else {
                        d = q;
                    }
                    double bvalue = d;
                    resultI[resultOff] = a.indexAt(aoff);
                    resultV[resultOff] = BoxesRunTime.unboxToDouble(a.valueAt(aoff)) - bvalue;
                    ++resultOff;
                }
                while (boff < bsize) {
                    resultI[resultOff] = b.indexAt(boff);
                    resultV[resultOff] = q - BoxesRunTime.unboxToDouble(b.valueAt(boff));
                    ++resultOff;
                    ++boff;
                }
                return resultOff != resultI.length ? new SparseVector<Object>(Arrays.copyOf(resultI, resultOff), Arrays.copyOf(resultV, resultOff), resultOff, a.length(), Zero$.MODULE$.DoubleZero()) : new SparseVector<Object>(resultI, resultV, resultOff, a.length(), Zero$.MODULE$.DoubleZero());
            }
        });
        $this.breeze$linalg$operators$SparseVectorExpandOps$_setter_$impl_Op_SV_SV_eq_SV_Float_OpSub_$eq(new UFunc.UImpl2<OpSub$, SparseVector<Object>, SparseVector<Object>, SparseVector<Object>>($this){
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                ((BinaryRegistry)Predef$.MODULE$.implicitly($outer.impl_Op_V_V_eq_V_idempotent_Float_OpSub())).register(this, ClassTag$.MODULE$.apply(SparseVector.class), ClassTag$.MODULE$.apply(SparseVector.class));
            }

            public SparseVector apply(SparseVector a, SparseVector b) {
                if (b.length() != a.length()) {
                    throw new IllegalArgumentException(StringOps$.MODULE$.format$extension("requirement failed: %s", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{new StringBuilder(55).append("Vectors must be the same length!").append(": ").append("b.length.==(a.length)").toString()})));
                }
                int asize = a.activeSize();
                int bsize = b.activeSize();
                float q = 0.0f;
                int[] resultI = new int[asize + bsize];
                float[] resultV = new float[asize + bsize];
                int resultOff = 0;
                int boff = 0;
                for (int aoff = 0; aoff < asize; ++aoff) {
                    float f;
                    while (boff < bsize && b.indexAt(boff) < a.indexAt(aoff)) {
                        resultI[resultOff] = b.indexAt(boff);
                        resultV[resultOff] = q - BoxesRunTime.unboxToFloat(b.valueAt(boff));
                        ++resultOff;
                        ++boff;
                    }
                    if (boff < bsize && b.indexAt(boff) == a.indexAt(aoff)) {
                        float bv = BoxesRunTime.unboxToFloat(b.valueAt(boff));
                        ++boff;
                        f = bv;
                    } else {
                        f = q;
                    }
                    float bvalue = f;
                    resultI[resultOff] = a.indexAt(aoff);
                    resultV[resultOff] = BoxesRunTime.unboxToFloat(a.valueAt(aoff)) - bvalue;
                    ++resultOff;
                }
                while (boff < bsize) {
                    resultI[resultOff] = b.indexAt(boff);
                    resultV[resultOff] = q - BoxesRunTime.unboxToFloat(b.valueAt(boff));
                    ++resultOff;
                    ++boff;
                }
                return resultOff != resultI.length ? new SparseVector<Object>(Arrays.copyOf(resultI, resultOff), Arrays.copyOf(resultV, resultOff), resultOff, a.length(), Zero$.MODULE$.FloatZero()) : new SparseVector<Object>(resultI, resultV, resultOff, a.length(), Zero$.MODULE$.FloatZero());
            }
        });
        $this.breeze$linalg$operators$SparseVectorExpandOps$_setter_$impl_Op_SV_SV_eq_SV_Long_OpSub_$eq(new UFunc.UImpl2<OpSub$, SparseVector<Object>, SparseVector<Object>, SparseVector<Object>>($this){
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                ((BinaryRegistry)Predef$.MODULE$.implicitly($outer.impl_Op_V_V_eq_V_idempotent_Long_OpSub())).register(this, ClassTag$.MODULE$.apply(SparseVector.class), ClassTag$.MODULE$.apply(SparseVector.class));
            }

            public SparseVector apply(SparseVector a, SparseVector b) {
                if (b.length() != a.length()) {
                    throw new IllegalArgumentException(StringOps$.MODULE$.format$extension("requirement failed: %s", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{new StringBuilder(55).append("Vectors must be the same length!").append(": ").append("b.length.==(a.length)").toString()})));
                }
                int asize = a.activeSize();
                int bsize = b.activeSize();
                long q = 0L;
                int[] resultI = new int[asize + bsize];
                long[] resultV = new long[asize + bsize];
                int resultOff = 0;
                int boff = 0;
                for (int aoff = 0; aoff < asize; ++aoff) {
                    long l;
                    while (boff < bsize && b.indexAt(boff) < a.indexAt(aoff)) {
                        resultI[resultOff] = b.indexAt(boff);
                        resultV[resultOff] = q - BoxesRunTime.unboxToLong(b.valueAt(boff));
                        ++resultOff;
                        ++boff;
                    }
                    if (boff < bsize && b.indexAt(boff) == a.indexAt(aoff)) {
                        long bv = BoxesRunTime.unboxToLong(b.valueAt(boff));
                        ++boff;
                        l = bv;
                    } else {
                        l = q;
                    }
                    long bvalue = l;
                    resultI[resultOff] = a.indexAt(aoff);
                    resultV[resultOff] = BoxesRunTime.unboxToLong(a.valueAt(aoff)) - bvalue;
                    ++resultOff;
                }
                while (boff < bsize) {
                    resultI[resultOff] = b.indexAt(boff);
                    resultV[resultOff] = q - BoxesRunTime.unboxToLong(b.valueAt(boff));
                    ++resultOff;
                    ++boff;
                }
                return resultOff != resultI.length ? new SparseVector<Object>(Arrays.copyOf(resultI, resultOff), Arrays.copyOf(resultV, resultOff), resultOff, a.length(), Zero$.MODULE$.LongZero()) : new SparseVector<Object>(resultI, resultV, resultOff, a.length(), Zero$.MODULE$.LongZero());
            }
        });
        $this.breeze$linalg$operators$SparseVectorExpandOps$_setter_$impl_OpMulScalar_SV_SV_eq_SV_Int_$eq(new UFunc.UImpl2<OpMulScalar$, SparseVector<Object>, SparseVector<Object>, SparseVector<Object>>($this){
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                ((BinaryRegistry)Predef$.MODULE$.implicitly($outer.impl_Op_V_V_eq_V_nilpotent_Int())).register(this, ClassTag$.MODULE$.apply(SparseVector.class), ClassTag$.MODULE$.apply(SparseVector.class));
            }

            public SparseVector apply(SparseVector a, SparseVector b) {
                $anon$131 var3_3 = this;
                SparseVector sparseVector = b;
                SparseVector sparseVector2 = a;
                while (sparseVector.activeSize() < sparseVector2.activeSize()) {
                    $anon$131 var6_6 = var3_3;
                    SparseVector sparseVector3 = sparseVector;
                    SparseVector sparseVector4 = sparseVector2;
                    var3_3 = var6_6;
                    sparseVector2 = sparseVector3;
                    sparseVector = sparseVector4;
                }
                if (sparseVector.length() != sparseVector2.length()) {
                    throw new IllegalArgumentException(StringOps$.MODULE$.format$extension("requirement failed: %s", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{new StringBuilder(55).append("Vectors must be the same length!").append(": ").append("b.length.==(a.length)").toString()})));
                }
                int asize = sparseVector2.activeSize();
                int bsize = sparseVector.activeSize();
                int[] resultI = new int[package$.MODULE$.min(asize, bsize)];
                int[] resultV = new int[package$.MODULE$.min(asize, bsize)];
                int resultOff = 0;
                int aoff = 0;
                int boff = 0;
                while (aoff < asize) {
                    int aind = sparseVector2.indexAt(aoff);
                    boff = Arrays.binarySearch(sparseVector.index(), boff, package$.MODULE$.min(bsize, aind + 1), aind);
                    if (boff < 0) {
                        if ((boff ^= 0xFFFFFFFF) == bsize) {
                            aoff = asize;
                            continue;
                        }
                        int bind = sparseVector.indexAt(boff);
                        int newAoff = Arrays.binarySearch(sparseVector2.index(), aoff, package$.MODULE$.min(asize, bind + 1), bind);
                        if (newAoff < 0) {
                            newAoff ^= 0xFFFFFFFF;
                            ++boff;
                        }
                        if (newAoff <= aoff) {
                            throw new AssertionError((Object)StringOps$.MODULE$.format$extension("assertion failed: %s", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{new StringBuilder(17).append(new StringBuilder(6).append(bind).append(" ").append(aoff).append(" ").append(newAoff).append(" ").append(sparseVector2.index()[aoff]).append(" ").append(sparseVector2.index()[newAoff]).append(" ").append(sparseVector2).append(" ").append(sparseVector).toString()).append(": ").append("newAoff.>(aoff)").toString()})));
                        }
                        aoff = newAoff;
                        continue;
                    }
                    resultI[resultOff] = aind;
                    resultV[resultOff] = BoxesRunTime.unboxToInt(sparseVector2.valueAt(aoff)) * BoxesRunTime.unboxToInt(sparseVector.valueAt(boff));
                    ++aoff;
                    ++boff;
                    ++resultOff;
                }
                return resultOff != resultI.length ? new SparseVector<Object>(Arrays.copyOf(resultI, resultOff), Arrays.copyOf(resultV, resultOff), resultOff, sparseVector2.length(), Zero$.MODULE$.IntZero()) : new SparseVector<Object>(resultI, resultV, resultOff, sparseVector2.length(), Zero$.MODULE$.IntZero());
            }
        });
        $this.breeze$linalg$operators$SparseVectorExpandOps$_setter_$impl_OpMulScalar_SV_SV_eq_SV_Double_$eq(new UFunc.UImpl2<OpMulScalar$, SparseVector<Object>, SparseVector<Object>, SparseVector<Object>>($this){
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                ((BinaryRegistry)Predef$.MODULE$.implicitly($outer.impl_Op_V_V_eq_V_nilpotent_Double())).register(this, ClassTag$.MODULE$.apply(SparseVector.class), ClassTag$.MODULE$.apply(SparseVector.class));
            }

            public SparseVector apply(SparseVector a, SparseVector b) {
                $anon$132 var3_3 = this;
                SparseVector sparseVector = b;
                SparseVector sparseVector2 = a;
                while (sparseVector.activeSize() < sparseVector2.activeSize()) {
                    $anon$132 var6_6 = var3_3;
                    SparseVector sparseVector3 = sparseVector;
                    SparseVector sparseVector4 = sparseVector2;
                    var3_3 = var6_6;
                    sparseVector2 = sparseVector3;
                    sparseVector = sparseVector4;
                }
                if (sparseVector.length() != sparseVector2.length()) {
                    throw new IllegalArgumentException(StringOps$.MODULE$.format$extension("requirement failed: %s", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{new StringBuilder(55).append("Vectors must be the same length!").append(": ").append("b.length.==(a.length)").toString()})));
                }
                int asize = sparseVector2.activeSize();
                int bsize = sparseVector.activeSize();
                int[] resultI = new int[package$.MODULE$.min(asize, bsize)];
                double[] resultV = new double[package$.MODULE$.min(asize, bsize)];
                int resultOff = 0;
                int aoff = 0;
                int boff = 0;
                while (aoff < asize) {
                    int aind = sparseVector2.indexAt(aoff);
                    boff = Arrays.binarySearch(sparseVector.index(), boff, package$.MODULE$.min(bsize, aind + 1), aind);
                    if (boff < 0) {
                        if ((boff ^= 0xFFFFFFFF) == bsize) {
                            aoff = asize;
                            continue;
                        }
                        int bind = sparseVector.indexAt(boff);
                        int newAoff = Arrays.binarySearch(sparseVector2.index(), aoff, package$.MODULE$.min(asize, bind + 1), bind);
                        if (newAoff < 0) {
                            newAoff ^= 0xFFFFFFFF;
                            ++boff;
                        }
                        if (newAoff <= aoff) {
                            throw new AssertionError((Object)StringOps$.MODULE$.format$extension("assertion failed: %s", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{new StringBuilder(17).append(new StringBuilder(6).append(bind).append(" ").append(aoff).append(" ").append(newAoff).append(" ").append(sparseVector2.index()[aoff]).append(" ").append(sparseVector2.index()[newAoff]).append(" ").append(sparseVector2).append(" ").append(sparseVector).toString()).append(": ").append("newAoff.>(aoff)").toString()})));
                        }
                        aoff = newAoff;
                        continue;
                    }
                    resultI[resultOff] = aind;
                    resultV[resultOff] = BoxesRunTime.unboxToDouble(sparseVector2.valueAt(aoff)) * BoxesRunTime.unboxToDouble(sparseVector.valueAt(boff));
                    ++aoff;
                    ++boff;
                    ++resultOff;
                }
                return resultOff != resultI.length ? new SparseVector<Object>(Arrays.copyOf(resultI, resultOff), Arrays.copyOf(resultV, resultOff), resultOff, sparseVector2.length(), Zero$.MODULE$.DoubleZero()) : new SparseVector<Object>(resultI, resultV, resultOff, sparseVector2.length(), Zero$.MODULE$.DoubleZero());
            }
        });
        $this.breeze$linalg$operators$SparseVectorExpandOps$_setter_$impl_OpMulScalar_SV_SV_eq_SV_Float_$eq(new UFunc.UImpl2<OpMulScalar$, SparseVector<Object>, SparseVector<Object>, SparseVector<Object>>($this){
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                ((BinaryRegistry)Predef$.MODULE$.implicitly($outer.impl_Op_V_V_eq_V_nilpotent_Float())).register(this, ClassTag$.MODULE$.apply(SparseVector.class), ClassTag$.MODULE$.apply(SparseVector.class));
            }

            public SparseVector apply(SparseVector a, SparseVector b) {
                $anon$133 var3_3 = this;
                SparseVector sparseVector = b;
                SparseVector sparseVector2 = a;
                while (sparseVector.activeSize() < sparseVector2.activeSize()) {
                    $anon$133 var6_6 = var3_3;
                    SparseVector sparseVector3 = sparseVector;
                    SparseVector sparseVector4 = sparseVector2;
                    var3_3 = var6_6;
                    sparseVector2 = sparseVector3;
                    sparseVector = sparseVector4;
                }
                if (sparseVector.length() != sparseVector2.length()) {
                    throw new IllegalArgumentException(StringOps$.MODULE$.format$extension("requirement failed: %s", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{new StringBuilder(55).append("Vectors must be the same length!").append(": ").append("b.length.==(a.length)").toString()})));
                }
                int asize = sparseVector2.activeSize();
                int bsize = sparseVector.activeSize();
                int[] resultI = new int[package$.MODULE$.min(asize, bsize)];
                float[] resultV = new float[package$.MODULE$.min(asize, bsize)];
                int resultOff = 0;
                int aoff = 0;
                int boff = 0;
                while (aoff < asize) {
                    int aind = sparseVector2.indexAt(aoff);
                    boff = Arrays.binarySearch(sparseVector.index(), boff, package$.MODULE$.min(bsize, aind + 1), aind);
                    if (boff < 0) {
                        if ((boff ^= 0xFFFFFFFF) == bsize) {
                            aoff = asize;
                            continue;
                        }
                        int bind = sparseVector.indexAt(boff);
                        int newAoff = Arrays.binarySearch(sparseVector2.index(), aoff, package$.MODULE$.min(asize, bind + 1), bind);
                        if (newAoff < 0) {
                            newAoff ^= 0xFFFFFFFF;
                            ++boff;
                        }
                        if (newAoff <= aoff) {
                            throw new AssertionError((Object)StringOps$.MODULE$.format$extension("assertion failed: %s", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{new StringBuilder(17).append(new StringBuilder(6).append(bind).append(" ").append(aoff).append(" ").append(newAoff).append(" ").append(sparseVector2.index()[aoff]).append(" ").append(sparseVector2.index()[newAoff]).append(" ").append(sparseVector2).append(" ").append(sparseVector).toString()).append(": ").append("newAoff.>(aoff)").toString()})));
                        }
                        aoff = newAoff;
                        continue;
                    }
                    resultI[resultOff] = aind;
                    resultV[resultOff] = BoxesRunTime.unboxToFloat(sparseVector2.valueAt(aoff)) * BoxesRunTime.unboxToFloat(sparseVector.valueAt(boff));
                    ++aoff;
                    ++boff;
                    ++resultOff;
                }
                return resultOff != resultI.length ? new SparseVector<Object>(Arrays.copyOf(resultI, resultOff), Arrays.copyOf(resultV, resultOff), resultOff, sparseVector2.length(), Zero$.MODULE$.FloatZero()) : new SparseVector<Object>(resultI, resultV, resultOff, sparseVector2.length(), Zero$.MODULE$.FloatZero());
            }
        });
        $this.breeze$linalg$operators$SparseVectorExpandOps$_setter_$impl_OpMulScalar_SV_SV_eq_SV_Long_$eq(new UFunc.UImpl2<OpMulScalar$, SparseVector<Object>, SparseVector<Object>, SparseVector<Object>>($this){
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                ((BinaryRegistry)Predef$.MODULE$.implicitly($outer.impl_Op_V_V_eq_V_nilpotent_Long())).register(this, ClassTag$.MODULE$.apply(SparseVector.class), ClassTag$.MODULE$.apply(SparseVector.class));
            }

            public SparseVector apply(SparseVector a, SparseVector b) {
                $anon$134 var3_3 = this;
                SparseVector sparseVector = b;
                SparseVector sparseVector2 = a;
                while (sparseVector.activeSize() < sparseVector2.activeSize()) {
                    $anon$134 var6_6 = var3_3;
                    SparseVector sparseVector3 = sparseVector;
                    SparseVector sparseVector4 = sparseVector2;
                    var3_3 = var6_6;
                    sparseVector2 = sparseVector3;
                    sparseVector = sparseVector4;
                }
                if (sparseVector.length() != sparseVector2.length()) {
                    throw new IllegalArgumentException(StringOps$.MODULE$.format$extension("requirement failed: %s", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{new StringBuilder(55).append("Vectors must be the same length!").append(": ").append("b.length.==(a.length)").toString()})));
                }
                int asize = sparseVector2.activeSize();
                int bsize = sparseVector.activeSize();
                int[] resultI = new int[package$.MODULE$.min(asize, bsize)];
                long[] resultV = new long[package$.MODULE$.min(asize, bsize)];
                int resultOff = 0;
                int aoff = 0;
                int boff = 0;
                while (aoff < asize) {
                    int aind = sparseVector2.indexAt(aoff);
                    boff = Arrays.binarySearch(sparseVector.index(), boff, package$.MODULE$.min(bsize, aind + 1), aind);
                    if (boff < 0) {
                        if ((boff ^= 0xFFFFFFFF) == bsize) {
                            aoff = asize;
                            continue;
                        }
                        int bind = sparseVector.indexAt(boff);
                        int newAoff = Arrays.binarySearch(sparseVector2.index(), aoff, package$.MODULE$.min(asize, bind + 1), bind);
                        if (newAoff < 0) {
                            newAoff ^= 0xFFFFFFFF;
                            ++boff;
                        }
                        if (newAoff <= aoff) {
                            throw new AssertionError((Object)StringOps$.MODULE$.format$extension("assertion failed: %s", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{new StringBuilder(17).append(new StringBuilder(6).append(bind).append(" ").append(aoff).append(" ").append(newAoff).append(" ").append(sparseVector2.index()[aoff]).append(" ").append(sparseVector2.index()[newAoff]).append(" ").append(sparseVector2).append(" ").append(sparseVector).toString()).append(": ").append("newAoff.>(aoff)").toString()})));
                        }
                        aoff = newAoff;
                        continue;
                    }
                    resultI[resultOff] = aind;
                    resultV[resultOff] = BoxesRunTime.unboxToLong(sparseVector2.valueAt(aoff)) * BoxesRunTime.unboxToLong(sparseVector.valueAt(boff));
                    ++aoff;
                    ++boff;
                    ++resultOff;
                }
                return resultOff != resultI.length ? new SparseVector<Object>(Arrays.copyOf(resultI, resultOff), Arrays.copyOf(resultV, resultOff), resultOff, sparseVector2.length(), Zero$.MODULE$.LongZero()) : new SparseVector<Object>(resultI, resultV, resultOff, sparseVector2.length(), Zero$.MODULE$.LongZero());
            }
        });
        $this.breeze$linalg$operators$SparseVectorExpandOps$_setter_$impl_Op_SV_SV_eq_SV_Int_OpDiv_$eq(new UFunc.UImpl2<OpDiv$, SparseVector<Object>, SparseVector<Object>, SparseVector<Object>>($this){
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                ((BinaryRegistry)Predef$.MODULE$.implicitly($outer.impl_Op_V_V_eq_V_Int_OpDiv())).register(this, ClassTag$.MODULE$.apply(SparseVector.class), ClassTag$.MODULE$.apply(SparseVector.class));
            }

            public SparseVector apply(SparseVector a, SparseVector b) {
                if (b.length() != a.length()) {
                    throw new IllegalArgumentException(StringOps$.MODULE$.format$extension("requirement failed: %s", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{new StringBuilder(55).append("Vectors must be the same length!").append(": ").append("b.length.==(a.length)").toString()})));
                }
                VectorBuilder<Object> result = new VectorBuilder<Object>(a.length(), VectorBuilder$.MODULE$.$lessinit$greater$default$2(), Semiring$.MODULE$.semiringInt(), ClassTag$.MODULE$.apply(Integer.TYPE));
                for (int i = 0; i < a.length(); ++i) {
                    result.add(i, BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt(a.apply(i)) / BoxesRunTime.unboxToInt(b.apply(i)))));
                }
                return result.toSparseVector(true, true);
            }
        });
        $this.breeze$linalg$operators$SparseVectorExpandOps$_setter_$impl_Op_SV_SV_eq_SV_Double_OpDiv_$eq(new UFunc.UImpl2<OpDiv$, SparseVector<Object>, SparseVector<Object>, SparseVector<Object>>($this){
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                ((BinaryRegistry)Predef$.MODULE$.implicitly($outer.impl_Op_V_V_eq_V_Double_OpDiv())).register(this, ClassTag$.MODULE$.apply(SparseVector.class), ClassTag$.MODULE$.apply(SparseVector.class));
            }

            public SparseVector apply(SparseVector a, SparseVector b) {
                if (b.length() != a.length()) {
                    throw new IllegalArgumentException(StringOps$.MODULE$.format$extension("requirement failed: %s", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{new StringBuilder(55).append("Vectors must be the same length!").append(": ").append("b.length.==(a.length)").toString()})));
                }
                VectorBuilder<Object> result = new VectorBuilder<Object>(a.length(), VectorBuilder$.MODULE$.$lessinit$greater$default$2(), Semiring$.MODULE$.semiringD(), ClassTag$.MODULE$.apply(Double.TYPE));
                for (int i = 0; i < a.length(); ++i) {
                    result.add(i, BoxesRunTime.boxToDouble((double)(BoxesRunTime.unboxToDouble(a.apply(i)) / BoxesRunTime.unboxToDouble(b.apply(i)))));
                }
                return result.toSparseVector(true, true);
            }
        });
        $this.breeze$linalg$operators$SparseVectorExpandOps$_setter_$impl_Op_SV_SV_eq_SV_Float_OpDiv_$eq(new UFunc.UImpl2<OpDiv$, SparseVector<Object>, SparseVector<Object>, SparseVector<Object>>($this){
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                ((BinaryRegistry)Predef$.MODULE$.implicitly($outer.impl_Op_V_V_eq_V_Float_OpDiv())).register(this, ClassTag$.MODULE$.apply(SparseVector.class), ClassTag$.MODULE$.apply(SparseVector.class));
            }

            public SparseVector apply(SparseVector a, SparseVector b) {
                if (b.length() != a.length()) {
                    throw new IllegalArgumentException(StringOps$.MODULE$.format$extension("requirement failed: %s", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{new StringBuilder(55).append("Vectors must be the same length!").append(": ").append("b.length.==(a.length)").toString()})));
                }
                VectorBuilder<Object> result = new VectorBuilder<Object>(a.length(), VectorBuilder$.MODULE$.$lessinit$greater$default$2(), Semiring$.MODULE$.semiringFloat(), ClassTag$.MODULE$.apply(Float.TYPE));
                for (int i = 0; i < a.length(); ++i) {
                    result.add(i, BoxesRunTime.boxToFloat((float)(BoxesRunTime.unboxToFloat(a.apply(i)) / BoxesRunTime.unboxToFloat(b.apply(i)))));
                }
                return result.toSparseVector(true, true);
            }
        });
        $this.breeze$linalg$operators$SparseVectorExpandOps$_setter_$impl_Op_SV_SV_eq_SV_Long_OpDiv_$eq(new UFunc.UImpl2<OpDiv$, SparseVector<Object>, SparseVector<Object>, SparseVector<Object>>($this){
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                ((BinaryRegistry)Predef$.MODULE$.implicitly($outer.impl_Op_V_V_eq_V_Long_OpDiv())).register(this, ClassTag$.MODULE$.apply(SparseVector.class), ClassTag$.MODULE$.apply(SparseVector.class));
            }

            public SparseVector apply(SparseVector a, SparseVector b) {
                if (b.length() != a.length()) {
                    throw new IllegalArgumentException(StringOps$.MODULE$.format$extension("requirement failed: %s", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{new StringBuilder(55).append("Vectors must be the same length!").append(": ").append("b.length.==(a.length)").toString()})));
                }
                VectorBuilder<Object> result = new VectorBuilder<Object>(a.length(), VectorBuilder$.MODULE$.$lessinit$greater$default$2(), Semiring$.MODULE$.semiringLong(), ClassTag$.MODULE$.apply(Long.TYPE));
                for (int i = 0; i < a.length(); ++i) {
                    result.add(i, BoxesRunTime.boxToLong((long)(BoxesRunTime.unboxToLong(a.apply(i)) / BoxesRunTime.unboxToLong(b.apply(i)))));
                }
                return result.toSparseVector(true, true);
            }
        });
        $this.breeze$linalg$operators$SparseVectorExpandOps$_setter_$impl_Op_SV_SV_eq_SV_Int_OpSet_$eq(new UFunc.UImpl2<OpSet$, SparseVector<Object>, SparseVector<Object>, SparseVector<Object>>($this){
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                ((BinaryRegistry)Predef$.MODULE$.implicitly($outer.impl_Op_V_V_eq_V_Int_OpSet())).register(this, ClassTag$.MODULE$.apply(SparseVector.class), ClassTag$.MODULE$.apply(SparseVector.class));
            }

            public SparseVector apply(SparseVector a, SparseVector b) {
                if (b.length() != a.length()) {
                    throw new IllegalArgumentException(StringOps$.MODULE$.format$extension("requirement failed: %s", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{new StringBuilder(55).append("Vectors must be the same length!").append(": ").append("b.length.==(a.length)").toString()})));
                }
                VectorBuilder<Object> result = new VectorBuilder<Object>(a.length(), VectorBuilder$.MODULE$.$lessinit$greater$default$2(), Semiring$.MODULE$.semiringInt(), ClassTag$.MODULE$.apply(Integer.TYPE));
                for (int i = 0; i < a.length(); ++i) {
                    result.add(i, b.apply(i));
                }
                return result.toSparseVector(true, true);
            }
        });
        $this.breeze$linalg$operators$SparseVectorExpandOps$_setter_$impl_Op_SV_SV_eq_SV_Double_OpSet_$eq(new UFunc.UImpl2<OpSet$, SparseVector<Object>, SparseVector<Object>, SparseVector<Object>>($this){
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                ((BinaryRegistry)Predef$.MODULE$.implicitly($outer.impl_Op_V_V_eq_V_Double_OpSet())).register(this, ClassTag$.MODULE$.apply(SparseVector.class), ClassTag$.MODULE$.apply(SparseVector.class));
            }

            public SparseVector apply(SparseVector a, SparseVector b) {
                if (b.length() != a.length()) {
                    throw new IllegalArgumentException(StringOps$.MODULE$.format$extension("requirement failed: %s", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{new StringBuilder(55).append("Vectors must be the same length!").append(": ").append("b.length.==(a.length)").toString()})));
                }
                VectorBuilder<Object> result = new VectorBuilder<Object>(a.length(), VectorBuilder$.MODULE$.$lessinit$greater$default$2(), Semiring$.MODULE$.semiringD(), ClassTag$.MODULE$.apply(Double.TYPE));
                for (int i = 0; i < a.length(); ++i) {
                    result.add(i, b.apply(i));
                }
                return result.toSparseVector(true, true);
            }
        });
        $this.breeze$linalg$operators$SparseVectorExpandOps$_setter_$impl_Op_SV_SV_eq_SV_Float_OpSet_$eq(new UFunc.UImpl2<OpSet$, SparseVector<Object>, SparseVector<Object>, SparseVector<Object>>($this){
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                ((BinaryRegistry)Predef$.MODULE$.implicitly($outer.impl_Op_V_V_eq_V_Float_OpSet())).register(this, ClassTag$.MODULE$.apply(SparseVector.class), ClassTag$.MODULE$.apply(SparseVector.class));
            }

            public SparseVector apply(SparseVector a, SparseVector b) {
                if (b.length() != a.length()) {
                    throw new IllegalArgumentException(StringOps$.MODULE$.format$extension("requirement failed: %s", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{new StringBuilder(55).append("Vectors must be the same length!").append(": ").append("b.length.==(a.length)").toString()})));
                }
                VectorBuilder<Object> result = new VectorBuilder<Object>(a.length(), VectorBuilder$.MODULE$.$lessinit$greater$default$2(), Semiring$.MODULE$.semiringFloat(), ClassTag$.MODULE$.apply(Float.TYPE));
                for (int i = 0; i < a.length(); ++i) {
                    result.add(i, b.apply(i));
                }
                return result.toSparseVector(true, true);
            }
        });
        $this.breeze$linalg$operators$SparseVectorExpandOps$_setter_$impl_Op_SV_SV_eq_SV_Long_OpSet_$eq(new UFunc.UImpl2<OpSet$, SparseVector<Object>, SparseVector<Object>, SparseVector<Object>>($this){
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                ((BinaryRegistry)Predef$.MODULE$.implicitly($outer.impl_Op_V_V_eq_V_Long_OpSet())).register(this, ClassTag$.MODULE$.apply(SparseVector.class), ClassTag$.MODULE$.apply(SparseVector.class));
            }

            public SparseVector apply(SparseVector a, SparseVector b) {
                if (b.length() != a.length()) {
                    throw new IllegalArgumentException(StringOps$.MODULE$.format$extension("requirement failed: %s", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{new StringBuilder(55).append("Vectors must be the same length!").append(": ").append("b.length.==(a.length)").toString()})));
                }
                VectorBuilder<Object> result = new VectorBuilder<Object>(a.length(), VectorBuilder$.MODULE$.$lessinit$greater$default$2(), Semiring$.MODULE$.semiringLong(), ClassTag$.MODULE$.apply(Long.TYPE));
                for (int i = 0; i < a.length(); ++i) {
                    result.add(i, b.apply(i));
                }
                return result.toSparseVector(true, true);
            }
        });
        $this.breeze$linalg$operators$SparseVectorExpandOps$_setter_$impl_Op_SV_SV_eq_SV_Int_OpMod_$eq(new UFunc.UImpl2<OpMod$, SparseVector<Object>, SparseVector<Object>, SparseVector<Object>>($this){
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                ((BinaryRegistry)Predef$.MODULE$.implicitly($outer.impl_Op_V_V_eq_V_Int_OpMod())).register(this, ClassTag$.MODULE$.apply(SparseVector.class), ClassTag$.MODULE$.apply(SparseVector.class));
            }

            public SparseVector apply(SparseVector a, SparseVector b) {
                if (b.length() != a.length()) {
                    throw new IllegalArgumentException(StringOps$.MODULE$.format$extension("requirement failed: %s", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{new StringBuilder(55).append("Vectors must be the same length!").append(": ").append("b.length.==(a.length)").toString()})));
                }
                VectorBuilder<Object> result = new VectorBuilder<Object>(a.length(), VectorBuilder$.MODULE$.$lessinit$greater$default$2(), Semiring$.MODULE$.semiringInt(), ClassTag$.MODULE$.apply(Integer.TYPE));
                for (int i = 0; i < a.length(); ++i) {
                    result.add(i, BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt(a.apply(i)) % BoxesRunTime.unboxToInt(b.apply(i)))));
                }
                return result.toSparseVector(true, true);
            }
        });
        $this.breeze$linalg$operators$SparseVectorExpandOps$_setter_$impl_Op_SV_SV_eq_SV_Double_OpMod_$eq(new UFunc.UImpl2<OpMod$, SparseVector<Object>, SparseVector<Object>, SparseVector<Object>>($this){
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                ((BinaryRegistry)Predef$.MODULE$.implicitly($outer.impl_Op_V_V_eq_V_Double_OpMod())).register(this, ClassTag$.MODULE$.apply(SparseVector.class), ClassTag$.MODULE$.apply(SparseVector.class));
            }

            public SparseVector apply(SparseVector a, SparseVector b) {
                if (b.length() != a.length()) {
                    throw new IllegalArgumentException(StringOps$.MODULE$.format$extension("requirement failed: %s", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{new StringBuilder(55).append("Vectors must be the same length!").append(": ").append("b.length.==(a.length)").toString()})));
                }
                VectorBuilder<Object> result = new VectorBuilder<Object>(a.length(), VectorBuilder$.MODULE$.$lessinit$greater$default$2(), Semiring$.MODULE$.semiringD(), ClassTag$.MODULE$.apply(Double.TYPE));
                for (int i = 0; i < a.length(); ++i) {
                    result.add(i, BoxesRunTime.boxToDouble((double)(BoxesRunTime.unboxToDouble(a.apply(i)) % BoxesRunTime.unboxToDouble(b.apply(i)))));
                }
                return result.toSparseVector(true, true);
            }
        });
        $this.breeze$linalg$operators$SparseVectorExpandOps$_setter_$impl_Op_SV_SV_eq_SV_Float_OpMod_$eq(new UFunc.UImpl2<OpMod$, SparseVector<Object>, SparseVector<Object>, SparseVector<Object>>($this){
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                ((BinaryRegistry)Predef$.MODULE$.implicitly($outer.impl_Op_V_V_eq_V_Float_OpMod())).register(this, ClassTag$.MODULE$.apply(SparseVector.class), ClassTag$.MODULE$.apply(SparseVector.class));
            }

            public SparseVector apply(SparseVector a, SparseVector b) {
                if (b.length() != a.length()) {
                    throw new IllegalArgumentException(StringOps$.MODULE$.format$extension("requirement failed: %s", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{new StringBuilder(55).append("Vectors must be the same length!").append(": ").append("b.length.==(a.length)").toString()})));
                }
                VectorBuilder<Object> result = new VectorBuilder<Object>(a.length(), VectorBuilder$.MODULE$.$lessinit$greater$default$2(), Semiring$.MODULE$.semiringFloat(), ClassTag$.MODULE$.apply(Float.TYPE));
                for (int i = 0; i < a.length(); ++i) {
                    result.add(i, BoxesRunTime.boxToFloat((float)(BoxesRunTime.unboxToFloat(a.apply(i)) % BoxesRunTime.unboxToFloat(b.apply(i)))));
                }
                return result.toSparseVector(true, true);
            }
        });
        $this.breeze$linalg$operators$SparseVectorExpandOps$_setter_$impl_Op_SV_SV_eq_SV_Long_OpMod_$eq(new UFunc.UImpl2<OpMod$, SparseVector<Object>, SparseVector<Object>, SparseVector<Object>>($this){
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                ((BinaryRegistry)Predef$.MODULE$.implicitly($outer.impl_Op_V_V_eq_V_Long_OpMod())).register(this, ClassTag$.MODULE$.apply(SparseVector.class), ClassTag$.MODULE$.apply(SparseVector.class));
            }

            public SparseVector apply(SparseVector a, SparseVector b) {
                if (b.length() != a.length()) {
                    throw new IllegalArgumentException(StringOps$.MODULE$.format$extension("requirement failed: %s", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{new StringBuilder(55).append("Vectors must be the same length!").append(": ").append("b.length.==(a.length)").toString()})));
                }
                VectorBuilder<Object> result = new VectorBuilder<Object>(a.length(), VectorBuilder$.MODULE$.$lessinit$greater$default$2(), Semiring$.MODULE$.semiringLong(), ClassTag$.MODULE$.apply(Long.TYPE));
                for (int i = 0; i < a.length(); ++i) {
                    result.add(i, BoxesRunTime.boxToLong((long)(BoxesRunTime.unboxToLong(a.apply(i)) % BoxesRunTime.unboxToLong(b.apply(i)))));
                }
                return result.toSparseVector(true, true);
            }
        });
        $this.breeze$linalg$operators$SparseVectorExpandOps$_setter_$impl_Op_SV_SV_eq_SV_Int_OpPow_$eq(new UFunc.UImpl2<OpPow$, SparseVector<Object>, SparseVector<Object>, SparseVector<Object>>($this){
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                ((BinaryRegistry)Predef$.MODULE$.implicitly($outer.impl_Op_V_V_eq_V_Int_OpPow())).register(this, ClassTag$.MODULE$.apply(SparseVector.class), ClassTag$.MODULE$.apply(SparseVector.class));
            }

            public SparseVector apply(SparseVector a, SparseVector b) {
                if (b.length() != a.length()) {
                    throw new IllegalArgumentException(StringOps$.MODULE$.format$extension("requirement failed: %s", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{new StringBuilder(55).append("Vectors must be the same length!").append(": ").append("b.length.==(a.length)").toString()})));
                }
                VectorBuilder<Object> result = new VectorBuilder<Object>(a.length(), VectorBuilder$.MODULE$.$lessinit$greater$default$2(), Semiring$.MODULE$.semiringInt(), ClassTag$.MODULE$.apply(Integer.TYPE));
                for (int i = 0; i < a.length(); ++i) {
                    result.add(i, BoxesRunTime.boxToInteger((int)PowImplicits$.MODULE$.IntPow(BoxesRunTime.unboxToInt(a.apply(i))).pow(BoxesRunTime.unboxToInt(b.apply(i)))));
                }
                return result.toSparseVector(true, true);
            }
        });
        $this.breeze$linalg$operators$SparseVectorExpandOps$_setter_$impl_Op_SV_SV_eq_SV_Double_OpPow_$eq(new UFunc.UImpl2<OpPow$, SparseVector<Object>, SparseVector<Object>, SparseVector<Object>>($this){
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                ((BinaryRegistry)Predef$.MODULE$.implicitly($outer.impl_Op_V_V_eq_V_Double_OpPow())).register(this, ClassTag$.MODULE$.apply(SparseVector.class), ClassTag$.MODULE$.apply(SparseVector.class));
            }

            public SparseVector apply(SparseVector a, SparseVector b) {
                if (b.length() != a.length()) {
                    throw new IllegalArgumentException(StringOps$.MODULE$.format$extension("requirement failed: %s", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{new StringBuilder(55).append("Vectors must be the same length!").append(": ").append("b.length.==(a.length)").toString()})));
                }
                VectorBuilder<Object> result = new VectorBuilder<Object>(a.length(), VectorBuilder$.MODULE$.$lessinit$greater$default$2(), Semiring$.MODULE$.semiringD(), ClassTag$.MODULE$.apply(Double.TYPE));
                for (int i = 0; i < a.length(); ++i) {
                    result.add(i, BoxesRunTime.boxToDouble((double)PowImplicits$.MODULE$.DoublePow(BoxesRunTime.unboxToDouble(a.apply(i))).pow(BoxesRunTime.unboxToDouble(b.apply(i)))));
                }
                return result.toSparseVector(true, true);
            }
        });
        $this.breeze$linalg$operators$SparseVectorExpandOps$_setter_$impl_Op_SV_SV_eq_SV_Float_OpPow_$eq(new UFunc.UImpl2<OpPow$, SparseVector<Object>, SparseVector<Object>, SparseVector<Object>>($this){
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                ((BinaryRegistry)Predef$.MODULE$.implicitly($outer.impl_Op_V_V_eq_V_Float_OpPow())).register(this, ClassTag$.MODULE$.apply(SparseVector.class), ClassTag$.MODULE$.apply(SparseVector.class));
            }

            public SparseVector apply(SparseVector a, SparseVector b) {
                if (b.length() != a.length()) {
                    throw new IllegalArgumentException(StringOps$.MODULE$.format$extension("requirement failed: %s", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{new StringBuilder(55).append("Vectors must be the same length!").append(": ").append("b.length.==(a.length)").toString()})));
                }
                VectorBuilder<Object> result = new VectorBuilder<Object>(a.length(), VectorBuilder$.MODULE$.$lessinit$greater$default$2(), Semiring$.MODULE$.semiringFloat(), ClassTag$.MODULE$.apply(Float.TYPE));
                for (int i = 0; i < a.length(); ++i) {
                    result.add(i, BoxesRunTime.boxToFloat((float)PowImplicits$.MODULE$.FloatPow(BoxesRunTime.unboxToFloat(a.apply(i))).pow(BoxesRunTime.unboxToFloat(b.apply(i)))));
                }
                return result.toSparseVector(true, true);
            }
        });
        $this.breeze$linalg$operators$SparseVectorExpandOps$_setter_$impl_Op_SV_SV_eq_SV_Long_OpPow_$eq(new UFunc.UImpl2<OpPow$, SparseVector<Object>, SparseVector<Object>, SparseVector<Object>>($this){
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                ((BinaryRegistry)Predef$.MODULE$.implicitly($outer.impl_Op_V_V_eq_V_Long_OpPow())).register(this, ClassTag$.MODULE$.apply(SparseVector.class), ClassTag$.MODULE$.apply(SparseVector.class));
            }

            public SparseVector apply(SparseVector a, SparseVector b) {
                if (b.length() != a.length()) {
                    throw new IllegalArgumentException(StringOps$.MODULE$.format$extension("requirement failed: %s", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{new StringBuilder(55).append("Vectors must be the same length!").append(": ").append("b.length.==(a.length)").toString()})));
                }
                VectorBuilder<Object> result = new VectorBuilder<Object>(a.length(), VectorBuilder$.MODULE$.$lessinit$greater$default$2(), Semiring$.MODULE$.semiringLong(), ClassTag$.MODULE$.apply(Long.TYPE));
                for (int i = 0; i < a.length(); ++i) {
                    result.add(i, BoxesRunTime.boxToLong((long)PowImplicits$.MODULE$.LongPow(BoxesRunTime.unboxToLong(a.apply(i))).pow(BoxesRunTime.unboxToLong(b.apply(i)))));
                }
                return result.toSparseVector(true, true);
            }
        });
        $this.breeze$linalg$operators$SparseVectorExpandOps$_setter_$impl_Op_SV_V_eq_SV_Int_OpDiv_$eq(new UFunc.UImpl2<OpDiv$, SparseVector<Object>, Vector<Object>, SparseVector<Object>>($this){
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                ((BinaryRegistry)Predef$.MODULE$.implicitly($outer.impl_Op_V_V_eq_V_Int_OpDiv())).register(this, ClassTag$.MODULE$.apply(SparseVector.class), ClassTag$.MODULE$.apply(Vector.class));
            }

            public SparseVector apply(SparseVector a, Vector b) {
                if (b.length() != a.length()) {
                    throw new IllegalArgumentException(StringOps$.MODULE$.format$extension("requirement failed: %s", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{new StringBuilder(55).append("Vectors must be the same length!").append(": ").append("b.length.==(a.length)").toString()})));
                }
                VectorBuilder<Object> result = new VectorBuilder<Object>(a.length(), VectorBuilder$.MODULE$.$lessinit$greater$default$2(), Semiring$.MODULE$.semiringInt(), ClassTag$.MODULE$.apply(Integer.TYPE));
                int i = 0;
                int yy = a.length();
                while (i < a.length()) {
                    int n = i++;
                    result.add(n, BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt(a.apply(n)) / BoxesRunTime.unboxToInt(b.apply(BoxesRunTime.boxToInteger((int)n))))));
                }
                return result.toSparseVector(true, true);
            }
        });
        $this.breeze$linalg$operators$SparseVectorExpandOps$_setter_$impl_Op_SV_V_eq_SV_Double_OpDiv_$eq(new UFunc.UImpl2<OpDiv$, SparseVector<Object>, Vector<Object>, SparseVector<Object>>($this){
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                ((BinaryRegistry)Predef$.MODULE$.implicitly($outer.impl_Op_V_V_eq_V_Double_OpDiv())).register(this, ClassTag$.MODULE$.apply(SparseVector.class), ClassTag$.MODULE$.apply(Vector.class));
            }

            public SparseVector apply(SparseVector a, Vector b) {
                if (b.length() != a.length()) {
                    throw new IllegalArgumentException(StringOps$.MODULE$.format$extension("requirement failed: %s", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{new StringBuilder(55).append("Vectors must be the same length!").append(": ").append("b.length.==(a.length)").toString()})));
                }
                VectorBuilder<Object> result = new VectorBuilder<Object>(a.length(), VectorBuilder$.MODULE$.$lessinit$greater$default$2(), Semiring$.MODULE$.semiringD(), ClassTag$.MODULE$.apply(Double.TYPE));
                int i = 0;
                int yy = a.length();
                while (i < a.length()) {
                    int n = i++;
                    result.add(n, BoxesRunTime.boxToDouble((double)(BoxesRunTime.unboxToDouble(a.apply(n)) / BoxesRunTime.unboxToDouble(b.apply(BoxesRunTime.boxToInteger((int)n))))));
                }
                return result.toSparseVector(true, true);
            }
        });
        $this.breeze$linalg$operators$SparseVectorExpandOps$_setter_$impl_Op_SV_V_eq_SV_Float_OpDiv_$eq(new UFunc.UImpl2<OpDiv$, SparseVector<Object>, Vector<Object>, SparseVector<Object>>($this){
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                ((BinaryRegistry)Predef$.MODULE$.implicitly($outer.impl_Op_V_V_eq_V_Float_OpDiv())).register(this, ClassTag$.MODULE$.apply(SparseVector.class), ClassTag$.MODULE$.apply(Vector.class));
            }

            public SparseVector apply(SparseVector a, Vector b) {
                if (b.length() != a.length()) {
                    throw new IllegalArgumentException(StringOps$.MODULE$.format$extension("requirement failed: %s", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{new StringBuilder(55).append("Vectors must be the same length!").append(": ").append("b.length.==(a.length)").toString()})));
                }
                VectorBuilder<Object> result = new VectorBuilder<Object>(a.length(), VectorBuilder$.MODULE$.$lessinit$greater$default$2(), Semiring$.MODULE$.semiringFloat(), ClassTag$.MODULE$.apply(Float.TYPE));
                int i = 0;
                int yy = a.length();
                while (i < a.length()) {
                    int n = i++;
                    result.add(n, BoxesRunTime.boxToFloat((float)(BoxesRunTime.unboxToFloat(a.apply(n)) / BoxesRunTime.unboxToFloat(b.apply(BoxesRunTime.boxToInteger((int)n))))));
                }
                return result.toSparseVector(true, true);
            }
        });
        $this.breeze$linalg$operators$SparseVectorExpandOps$_setter_$impl_Op_SV_V_eq_SV_Long_OpDiv_$eq(new UFunc.UImpl2<OpDiv$, SparseVector<Object>, Vector<Object>, SparseVector<Object>>($this){
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                ((BinaryRegistry)Predef$.MODULE$.implicitly($outer.impl_Op_V_V_eq_V_Long_OpDiv())).register(this, ClassTag$.MODULE$.apply(SparseVector.class), ClassTag$.MODULE$.apply(Vector.class));
            }

            public SparseVector apply(SparseVector a, Vector b) {
                if (b.length() != a.length()) {
                    throw new IllegalArgumentException(StringOps$.MODULE$.format$extension("requirement failed: %s", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{new StringBuilder(55).append("Vectors must be the same length!").append(": ").append("b.length.==(a.length)").toString()})));
                }
                VectorBuilder<Object> result = new VectorBuilder<Object>(a.length(), VectorBuilder$.MODULE$.$lessinit$greater$default$2(), Semiring$.MODULE$.semiringLong(), ClassTag$.MODULE$.apply(Long.TYPE));
                int i = 0;
                int yy = a.length();
                while (i < a.length()) {
                    int n = i++;
                    result.add(n, BoxesRunTime.boxToLong((long)(BoxesRunTime.unboxToLong(a.apply(n)) / BoxesRunTime.unboxToLong(b.apply(BoxesRunTime.boxToInteger((int)n))))));
                }
                return result.toSparseVector(true, true);
            }
        });
        $this.breeze$linalg$operators$SparseVectorExpandOps$_setter_$impl_Op_SV_V_eq_SV_Int_OpSet_$eq(new UFunc.UImpl2<OpSet$, SparseVector<Object>, Vector<Object>, SparseVector<Object>>($this){
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                ((BinaryRegistry)Predef$.MODULE$.implicitly($outer.impl_Op_V_V_eq_V_Int_OpSet())).register(this, ClassTag$.MODULE$.apply(SparseVector.class), ClassTag$.MODULE$.apply(Vector.class));
            }

            public SparseVector apply(SparseVector a, Vector b) {
                if (b.length() != a.length()) {
                    throw new IllegalArgumentException(StringOps$.MODULE$.format$extension("requirement failed: %s", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{new StringBuilder(55).append("Vectors must be the same length!").append(": ").append("b.length.==(a.length)").toString()})));
                }
                VectorBuilder<Object> result = new VectorBuilder<Object>(a.length(), VectorBuilder$.MODULE$.$lessinit$greater$default$2(), Semiring$.MODULE$.semiringInt(), ClassTag$.MODULE$.apply(Integer.TYPE));
                int i = 0;
                int yy = a.length();
                while (i < a.length()) {
                    int n = i++;
                    result.add(n, b.apply(BoxesRunTime.boxToInteger((int)n)));
                }
                return result.toSparseVector(true, true);
            }
        });
        $this.breeze$linalg$operators$SparseVectorExpandOps$_setter_$impl_Op_SV_V_eq_SV_Double_OpSet_$eq(new UFunc.UImpl2<OpSet$, SparseVector<Object>, Vector<Object>, SparseVector<Object>>($this){
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                ((BinaryRegistry)Predef$.MODULE$.implicitly($outer.impl_Op_V_V_eq_V_Double_OpSet())).register(this, ClassTag$.MODULE$.apply(SparseVector.class), ClassTag$.MODULE$.apply(Vector.class));
            }

            public SparseVector apply(SparseVector a, Vector b) {
                if (b.length() != a.length()) {
                    throw new IllegalArgumentException(StringOps$.MODULE$.format$extension("requirement failed: %s", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{new StringBuilder(55).append("Vectors must be the same length!").append(": ").append("b.length.==(a.length)").toString()})));
                }
                VectorBuilder<Object> result = new VectorBuilder<Object>(a.length(), VectorBuilder$.MODULE$.$lessinit$greater$default$2(), Semiring$.MODULE$.semiringD(), ClassTag$.MODULE$.apply(Double.TYPE));
                int i = 0;
                int yy = a.length();
                while (i < a.length()) {
                    int n = i++;
                    result.add(n, b.apply(BoxesRunTime.boxToInteger((int)n)));
                }
                return result.toSparseVector(true, true);
            }
        });
        $this.breeze$linalg$operators$SparseVectorExpandOps$_setter_$impl_Op_SV_V_eq_SV_Float_OpSet_$eq(new UFunc.UImpl2<OpSet$, SparseVector<Object>, Vector<Object>, SparseVector<Object>>($this){
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                ((BinaryRegistry)Predef$.MODULE$.implicitly($outer.impl_Op_V_V_eq_V_Float_OpSet())).register(this, ClassTag$.MODULE$.apply(SparseVector.class), ClassTag$.MODULE$.apply(Vector.class));
            }

            public SparseVector apply(SparseVector a, Vector b) {
                if (b.length() != a.length()) {
                    throw new IllegalArgumentException(StringOps$.MODULE$.format$extension("requirement failed: %s", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{new StringBuilder(55).append("Vectors must be the same length!").append(": ").append("b.length.==(a.length)").toString()})));
                }
                VectorBuilder<Object> result = new VectorBuilder<Object>(a.length(), VectorBuilder$.MODULE$.$lessinit$greater$default$2(), Semiring$.MODULE$.semiringFloat(), ClassTag$.MODULE$.apply(Float.TYPE));
                int i = 0;
                int yy = a.length();
                while (i < a.length()) {
                    int n = i++;
                    result.add(n, b.apply(BoxesRunTime.boxToInteger((int)n)));
                }
                return result.toSparseVector(true, true);
            }
        });
        $this.breeze$linalg$operators$SparseVectorExpandOps$_setter_$impl_Op_SV_V_eq_SV_Long_OpSet_$eq(new UFunc.UImpl2<OpSet$, SparseVector<Object>, Vector<Object>, SparseVector<Object>>($this){
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                ((BinaryRegistry)Predef$.MODULE$.implicitly($outer.impl_Op_V_V_eq_V_Long_OpSet())).register(this, ClassTag$.MODULE$.apply(SparseVector.class), ClassTag$.MODULE$.apply(Vector.class));
            }

            public SparseVector apply(SparseVector a, Vector b) {
                if (b.length() != a.length()) {
                    throw new IllegalArgumentException(StringOps$.MODULE$.format$extension("requirement failed: %s", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{new StringBuilder(55).append("Vectors must be the same length!").append(": ").append("b.length.==(a.length)").toString()})));
                }
                VectorBuilder<Object> result = new VectorBuilder<Object>(a.length(), VectorBuilder$.MODULE$.$lessinit$greater$default$2(), Semiring$.MODULE$.semiringLong(), ClassTag$.MODULE$.apply(Long.TYPE));
                int i = 0;
                int yy = a.length();
                while (i < a.length()) {
                    int n = i++;
                    result.add(n, b.apply(BoxesRunTime.boxToInteger((int)n)));
                }
                return result.toSparseVector(true, true);
            }
        });
        $this.breeze$linalg$operators$SparseVectorExpandOps$_setter_$impl_Op_SV_V_eq_SV_Int_OpMod_$eq(new UFunc.UImpl2<OpMod$, SparseVector<Object>, Vector<Object>, SparseVector<Object>>($this){
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                ((BinaryRegistry)Predef$.MODULE$.implicitly($outer.impl_Op_V_V_eq_V_Int_OpMod())).register(this, ClassTag$.MODULE$.apply(SparseVector.class), ClassTag$.MODULE$.apply(Vector.class));
            }

            public SparseVector apply(SparseVector a, Vector b) {
                if (b.length() != a.length()) {
                    throw new IllegalArgumentException(StringOps$.MODULE$.format$extension("requirement failed: %s", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{new StringBuilder(55).append("Vectors must be the same length!").append(": ").append("b.length.==(a.length)").toString()})));
                }
                VectorBuilder<Object> result = new VectorBuilder<Object>(a.length(), VectorBuilder$.MODULE$.$lessinit$greater$default$2(), Semiring$.MODULE$.semiringInt(), ClassTag$.MODULE$.apply(Integer.TYPE));
                int i = 0;
                int yy = a.length();
                while (i < a.length()) {
                    int n = i++;
                    result.add(n, BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt(a.apply(n)) % BoxesRunTime.unboxToInt(b.apply(BoxesRunTime.boxToInteger((int)n))))));
                }
                return result.toSparseVector(true, true);
            }
        });
        $this.breeze$linalg$operators$SparseVectorExpandOps$_setter_$impl_Op_SV_V_eq_SV_Double_OpMod_$eq(new UFunc.UImpl2<OpMod$, SparseVector<Object>, Vector<Object>, SparseVector<Object>>($this){
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                ((BinaryRegistry)Predef$.MODULE$.implicitly($outer.impl_Op_V_V_eq_V_Double_OpMod())).register(this, ClassTag$.MODULE$.apply(SparseVector.class), ClassTag$.MODULE$.apply(Vector.class));
            }

            public SparseVector apply(SparseVector a, Vector b) {
                if (b.length() != a.length()) {
                    throw new IllegalArgumentException(StringOps$.MODULE$.format$extension("requirement failed: %s", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{new StringBuilder(55).append("Vectors must be the same length!").append(": ").append("b.length.==(a.length)").toString()})));
                }
                VectorBuilder<Object> result = new VectorBuilder<Object>(a.length(), VectorBuilder$.MODULE$.$lessinit$greater$default$2(), Semiring$.MODULE$.semiringD(), ClassTag$.MODULE$.apply(Double.TYPE));
                int i = 0;
                int yy = a.length();
                while (i < a.length()) {
                    int n = i++;
                    result.add(n, BoxesRunTime.boxToDouble((double)(BoxesRunTime.unboxToDouble(a.apply(n)) % BoxesRunTime.unboxToDouble(b.apply(BoxesRunTime.boxToInteger((int)n))))));
                }
                return result.toSparseVector(true, true);
            }
        });
        $this.breeze$linalg$operators$SparseVectorExpandOps$_setter_$impl_Op_SV_V_eq_SV_Float_OpMod_$eq(new UFunc.UImpl2<OpMod$, SparseVector<Object>, Vector<Object>, SparseVector<Object>>($this){
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                ((BinaryRegistry)Predef$.MODULE$.implicitly($outer.impl_Op_V_V_eq_V_Float_OpMod())).register(this, ClassTag$.MODULE$.apply(SparseVector.class), ClassTag$.MODULE$.apply(Vector.class));
            }

            public SparseVector apply(SparseVector a, Vector b) {
                if (b.length() != a.length()) {
                    throw new IllegalArgumentException(StringOps$.MODULE$.format$extension("requirement failed: %s", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{new StringBuilder(55).append("Vectors must be the same length!").append(": ").append("b.length.==(a.length)").toString()})));
                }
                VectorBuilder<Object> result = new VectorBuilder<Object>(a.length(), VectorBuilder$.MODULE$.$lessinit$greater$default$2(), Semiring$.MODULE$.semiringFloat(), ClassTag$.MODULE$.apply(Float.TYPE));
                int i = 0;
                int yy = a.length();
                while (i < a.length()) {
                    int n = i++;
                    result.add(n, BoxesRunTime.boxToFloat((float)(BoxesRunTime.unboxToFloat(a.apply(n)) % BoxesRunTime.unboxToFloat(b.apply(BoxesRunTime.boxToInteger((int)n))))));
                }
                return result.toSparseVector(true, true);
            }
        });
        $this.breeze$linalg$operators$SparseVectorExpandOps$_setter_$impl_Op_SV_V_eq_SV_Long_OpMod_$eq(new UFunc.UImpl2<OpMod$, SparseVector<Object>, Vector<Object>, SparseVector<Object>>($this){
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                ((BinaryRegistry)Predef$.MODULE$.implicitly($outer.impl_Op_V_V_eq_V_Long_OpMod())).register(this, ClassTag$.MODULE$.apply(SparseVector.class), ClassTag$.MODULE$.apply(Vector.class));
            }

            public SparseVector apply(SparseVector a, Vector b) {
                if (b.length() != a.length()) {
                    throw new IllegalArgumentException(StringOps$.MODULE$.format$extension("requirement failed: %s", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{new StringBuilder(55).append("Vectors must be the same length!").append(": ").append("b.length.==(a.length)").toString()})));
                }
                VectorBuilder<Object> result = new VectorBuilder<Object>(a.length(), VectorBuilder$.MODULE$.$lessinit$greater$default$2(), Semiring$.MODULE$.semiringLong(), ClassTag$.MODULE$.apply(Long.TYPE));
                int i = 0;
                int yy = a.length();
                while (i < a.length()) {
                    int n = i++;
                    result.add(n, BoxesRunTime.boxToLong((long)(BoxesRunTime.unboxToLong(a.apply(n)) % BoxesRunTime.unboxToLong(b.apply(BoxesRunTime.boxToInteger((int)n))))));
                }
                return result.toSparseVector(true, true);
            }
        });
        $this.breeze$linalg$operators$SparseVectorExpandOps$_setter_$impl_Op_SV_V_eq_SV_Int_OpPow_$eq(new UFunc.UImpl2<OpPow$, SparseVector<Object>, Vector<Object>, SparseVector<Object>>($this){
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                ((BinaryRegistry)Predef$.MODULE$.implicitly($outer.impl_Op_V_V_eq_V_Int_OpPow())).register(this, ClassTag$.MODULE$.apply(SparseVector.class), ClassTag$.MODULE$.apply(Vector.class));
            }

            public SparseVector apply(SparseVector a, Vector b) {
                if (b.length() != a.length()) {
                    throw new IllegalArgumentException(StringOps$.MODULE$.format$extension("requirement failed: %s", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{new StringBuilder(55).append("Vectors must be the same length!").append(": ").append("b.length.==(a.length)").toString()})));
                }
                VectorBuilder<Object> result = new VectorBuilder<Object>(a.length(), VectorBuilder$.MODULE$.$lessinit$greater$default$2(), Semiring$.MODULE$.semiringInt(), ClassTag$.MODULE$.apply(Integer.TYPE));
                int i = 0;
                int yy = a.length();
                while (i < a.length()) {
                    int n = i++;
                    result.add(n, BoxesRunTime.boxToInteger((int)PowImplicits$.MODULE$.IntPow(BoxesRunTime.unboxToInt(a.apply(n))).pow(BoxesRunTime.unboxToInt(b.apply(BoxesRunTime.boxToInteger((int)n))))));
                }
                return result.toSparseVector(true, true);
            }
        });
        $this.breeze$linalg$operators$SparseVectorExpandOps$_setter_$impl_Op_SV_V_eq_SV_Double_OpPow_$eq(new UFunc.UImpl2<OpPow$, SparseVector<Object>, Vector<Object>, SparseVector<Object>>($this){
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                ((BinaryRegistry)Predef$.MODULE$.implicitly($outer.impl_Op_V_V_eq_V_Double_OpPow())).register(this, ClassTag$.MODULE$.apply(SparseVector.class), ClassTag$.MODULE$.apply(Vector.class));
            }

            public SparseVector apply(SparseVector a, Vector b) {
                if (b.length() != a.length()) {
                    throw new IllegalArgumentException(StringOps$.MODULE$.format$extension("requirement failed: %s", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{new StringBuilder(55).append("Vectors must be the same length!").append(": ").append("b.length.==(a.length)").toString()})));
                }
                VectorBuilder<Object> result = new VectorBuilder<Object>(a.length(), VectorBuilder$.MODULE$.$lessinit$greater$default$2(), Semiring$.MODULE$.semiringD(), ClassTag$.MODULE$.apply(Double.TYPE));
                int i = 0;
                int yy = a.length();
                while (i < a.length()) {
                    int n = i++;
                    result.add(n, BoxesRunTime.boxToDouble((double)PowImplicits$.MODULE$.DoublePow(BoxesRunTime.unboxToDouble(a.apply(n))).pow(BoxesRunTime.unboxToDouble(b.apply(BoxesRunTime.boxToInteger((int)n))))));
                }
                return result.toSparseVector(true, true);
            }
        });
        $this.breeze$linalg$operators$SparseVectorExpandOps$_setter_$impl_Op_SV_V_eq_SV_Float_OpPow_$eq(new UFunc.UImpl2<OpPow$, SparseVector<Object>, Vector<Object>, SparseVector<Object>>($this){
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                ((BinaryRegistry)Predef$.MODULE$.implicitly($outer.impl_Op_V_V_eq_V_Float_OpPow())).register(this, ClassTag$.MODULE$.apply(SparseVector.class), ClassTag$.MODULE$.apply(Vector.class));
            }

            public SparseVector apply(SparseVector a, Vector b) {
                if (b.length() != a.length()) {
                    throw new IllegalArgumentException(StringOps$.MODULE$.format$extension("requirement failed: %s", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{new StringBuilder(55).append("Vectors must be the same length!").append(": ").append("b.length.==(a.length)").toString()})));
                }
                VectorBuilder<Object> result = new VectorBuilder<Object>(a.length(), VectorBuilder$.MODULE$.$lessinit$greater$default$2(), Semiring$.MODULE$.semiringFloat(), ClassTag$.MODULE$.apply(Float.TYPE));
                int i = 0;
                int yy = a.length();
                while (i < a.length()) {
                    int n = i++;
                    result.add(n, BoxesRunTime.boxToFloat((float)PowImplicits$.MODULE$.FloatPow(BoxesRunTime.unboxToFloat(a.apply(n))).pow(BoxesRunTime.unboxToFloat(b.apply(BoxesRunTime.boxToInteger((int)n))))));
                }
                return result.toSparseVector(true, true);
            }
        });
        $this.breeze$linalg$operators$SparseVectorExpandOps$_setter_$impl_Op_SV_V_eq_SV_Long_OpPow_$eq(new UFunc.UImpl2<OpPow$, SparseVector<Object>, Vector<Object>, SparseVector<Object>>($this){
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                ((BinaryRegistry)Predef$.MODULE$.implicitly($outer.impl_Op_V_V_eq_V_Long_OpPow())).register(this, ClassTag$.MODULE$.apply(SparseVector.class), ClassTag$.MODULE$.apply(Vector.class));
            }

            public SparseVector apply(SparseVector a, Vector b) {
                if (b.length() != a.length()) {
                    throw new IllegalArgumentException(StringOps$.MODULE$.format$extension("requirement failed: %s", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{new StringBuilder(55).append("Vectors must be the same length!").append(": ").append("b.length.==(a.length)").toString()})));
                }
                VectorBuilder<Object> result = new VectorBuilder<Object>(a.length(), VectorBuilder$.MODULE$.$lessinit$greater$default$2(), Semiring$.MODULE$.semiringLong(), ClassTag$.MODULE$.apply(Long.TYPE));
                int i = 0;
                int yy = a.length();
                while (i < a.length()) {
                    int n = i++;
                    result.add(n, BoxesRunTime.boxToLong((long)PowImplicits$.MODULE$.LongPow(BoxesRunTime.unboxToLong(a.apply(n))).pow(BoxesRunTime.unboxToLong(b.apply(BoxesRunTime.boxToInteger((int)n))))));
                }
                return result.toSparseVector(true, true);
            }
        });
        $this.breeze$linalg$operators$SparseVectorExpandOps$_setter_$impl_Op_SV_S_eq_SV_Int_OpAdd_$eq(new UFunc.UImpl2<OpAdd$, SparseVector<Object>, Object, SparseVector<Object>>($this){
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                ((BinaryRegistry)Predef$.MODULE$.implicitly($outer.impl_Op_V_S_eq_V_Int_OpAdd())).register(this, ClassTag$.MODULE$.apply(SparseVector.class), ClassTag$.MODULE$.apply(Integer.TYPE));
            }

            public SparseVector apply(SparseVector a, int b) {
                VectorBuilder<Object> result = new VectorBuilder<Object>(a.length(), VectorBuilder$.MODULE$.$lessinit$greater$default$2(), Semiring$.MODULE$.semiringInt(), ClassTag$.MODULE$.apply(Integer.TYPE));
                int yy = a.length();
                for (int i = 0; i < a.length(); ++i) {
                    int n = i;
                    int r = BoxesRunTime.unboxToInt(a.apply(n)) + b;
                    if (r == 0) continue;
                    result.add(n, BoxesRunTime.boxToInteger((int)r));
                }
                return result.toSparseVector(true, true);
            }
        });
        $this.breeze$linalg$operators$SparseVectorExpandOps$_setter_$impl_Op_SV_S_eq_SV_Double_OpAdd_$eq(new UFunc.UImpl2<OpAdd$, SparseVector<Object>, Object, SparseVector<Object>>($this){
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                ((BinaryRegistry)Predef$.MODULE$.implicitly($outer.impl_Op_V_S_eq_V_Double_OpAdd())).register(this, ClassTag$.MODULE$.apply(SparseVector.class), ClassTag$.MODULE$.apply(Double.TYPE));
            }

            public SparseVector apply(SparseVector a, double b) {
                VectorBuilder<Object> result = new VectorBuilder<Object>(a.length(), VectorBuilder$.MODULE$.$lessinit$greater$default$2(), Semiring$.MODULE$.semiringD(), ClassTag$.MODULE$.apply(Double.TYPE));
                int yy = a.length();
                for (int i = 0; i < a.length(); ++i) {
                    int n = i;
                    double r = BoxesRunTime.unboxToDouble(a.apply(n)) + b;
                    if (r == 0.0) continue;
                    result.add(n, BoxesRunTime.boxToDouble((double)r));
                }
                return result.toSparseVector(true, true);
            }
        });
        $this.breeze$linalg$operators$SparseVectorExpandOps$_setter_$impl_Op_SV_S_eq_SV_Float_OpAdd_$eq(new UFunc.UImpl2<OpAdd$, SparseVector<Object>, Object, SparseVector<Object>>($this){
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                ((BinaryRegistry)Predef$.MODULE$.implicitly($outer.impl_Op_V_S_eq_V_Float_OpAdd())).register(this, ClassTag$.MODULE$.apply(SparseVector.class), ClassTag$.MODULE$.apply(Float.TYPE));
            }

            public SparseVector apply(SparseVector a, float b) {
                VectorBuilder<Object> result = new VectorBuilder<Object>(a.length(), VectorBuilder$.MODULE$.$lessinit$greater$default$2(), Semiring$.MODULE$.semiringFloat(), ClassTag$.MODULE$.apply(Float.TYPE));
                int yy = a.length();
                for (int i = 0; i < a.length(); ++i) {
                    int n = i;
                    float r = BoxesRunTime.unboxToFloat(a.apply(n)) + b;
                    if (r == 0.0f) continue;
                    result.add(n, BoxesRunTime.boxToFloat((float)r));
                }
                return result.toSparseVector(true, true);
            }
        });
        $this.breeze$linalg$operators$SparseVectorExpandOps$_setter_$impl_Op_SV_S_eq_SV_Long_OpAdd_$eq(new UFunc.UImpl2<OpAdd$, SparseVector<Object>, Object, SparseVector<Object>>($this){
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                ((BinaryRegistry)Predef$.MODULE$.implicitly($outer.impl_Op_V_S_eq_V_Long_OpAdd())).register(this, ClassTag$.MODULE$.apply(SparseVector.class), ClassTag$.MODULE$.apply(Long.TYPE));
            }

            public SparseVector apply(SparseVector a, long b) {
                VectorBuilder<Object> result = new VectorBuilder<Object>(a.length(), VectorBuilder$.MODULE$.$lessinit$greater$default$2(), Semiring$.MODULE$.semiringLong(), ClassTag$.MODULE$.apply(Long.TYPE));
                int yy = a.length();
                for (int i = 0; i < a.length(); ++i) {
                    int n = i;
                    long r = BoxesRunTime.unboxToLong(a.apply(n)) + b;
                    if (r == 0L) continue;
                    result.add(n, BoxesRunTime.boxToLong((long)r));
                }
                return result.toSparseVector(true, true);
            }
        });
        $this.breeze$linalg$operators$SparseVectorExpandOps$_setter_$impl_Op_SV_S_eq_SV_Int_OpSub_$eq(new UFunc.UImpl2<OpSub$, SparseVector<Object>, Object, SparseVector<Object>>($this){
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                ((BinaryRegistry)Predef$.MODULE$.implicitly($outer.impl_Op_V_S_eq_V_Int_OpSub())).register(this, ClassTag$.MODULE$.apply(SparseVector.class), ClassTag$.MODULE$.apply(Integer.TYPE));
            }

            public SparseVector apply(SparseVector a, int b) {
                VectorBuilder<Object> result = new VectorBuilder<Object>(a.length(), VectorBuilder$.MODULE$.$lessinit$greater$default$2(), Semiring$.MODULE$.semiringInt(), ClassTag$.MODULE$.apply(Integer.TYPE));
                int yy = a.length();
                for (int i = 0; i < a.length(); ++i) {
                    int n = i;
                    int r = BoxesRunTime.unboxToInt(a.apply(n)) - b;
                    if (r == 0) continue;
                    result.add(n, BoxesRunTime.boxToInteger((int)r));
                }
                return result.toSparseVector(true, true);
            }
        });
        $this.breeze$linalg$operators$SparseVectorExpandOps$_setter_$impl_Op_SV_S_eq_SV_Double_OpSub_$eq(new UFunc.UImpl2<OpSub$, SparseVector<Object>, Object, SparseVector<Object>>($this){
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                ((BinaryRegistry)Predef$.MODULE$.implicitly($outer.impl_Op_V_S_eq_V_Double_OpSub())).register(this, ClassTag$.MODULE$.apply(SparseVector.class), ClassTag$.MODULE$.apply(Double.TYPE));
            }

            public SparseVector apply(SparseVector a, double b) {
                VectorBuilder<Object> result = new VectorBuilder<Object>(a.length(), VectorBuilder$.MODULE$.$lessinit$greater$default$2(), Semiring$.MODULE$.semiringD(), ClassTag$.MODULE$.apply(Double.TYPE));
                int yy = a.length();
                for (int i = 0; i < a.length(); ++i) {
                    int n = i;
                    double r = BoxesRunTime.unboxToDouble(a.apply(n)) - b;
                    if (r == 0.0) continue;
                    result.add(n, BoxesRunTime.boxToDouble((double)r));
                }
                return result.toSparseVector(true, true);
            }
        });
        $this.breeze$linalg$operators$SparseVectorExpandOps$_setter_$impl_Op_SV_S_eq_SV_Float_OpSub_$eq(new UFunc.UImpl2<OpSub$, SparseVector<Object>, Object, SparseVector<Object>>($this){
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                ((BinaryRegistry)Predef$.MODULE$.implicitly($outer.impl_Op_V_S_eq_V_Float_OpSub())).register(this, ClassTag$.MODULE$.apply(SparseVector.class), ClassTag$.MODULE$.apply(Float.TYPE));
            }

            public SparseVector apply(SparseVector a, float b) {
                VectorBuilder<Object> result = new VectorBuilder<Object>(a.length(), VectorBuilder$.MODULE$.$lessinit$greater$default$2(), Semiring$.MODULE$.semiringFloat(), ClassTag$.MODULE$.apply(Float.TYPE));
                int yy = a.length();
                for (int i = 0; i < a.length(); ++i) {
                    int n = i;
                    float r = BoxesRunTime.unboxToFloat(a.apply(n)) - b;
                    if (r == 0.0f) continue;
                    result.add(n, BoxesRunTime.boxToFloat((float)r));
                }
                return result.toSparseVector(true, true);
            }
        });
        $this.breeze$linalg$operators$SparseVectorExpandOps$_setter_$impl_Op_SV_S_eq_SV_Long_OpSub_$eq(new UFunc.UImpl2<OpSub$, SparseVector<Object>, Object, SparseVector<Object>>($this){
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                ((BinaryRegistry)Predef$.MODULE$.implicitly($outer.impl_Op_V_S_eq_V_Long_OpSub())).register(this, ClassTag$.MODULE$.apply(SparseVector.class), ClassTag$.MODULE$.apply(Long.TYPE));
            }

            public SparseVector apply(SparseVector a, long b) {
                VectorBuilder<Object> result = new VectorBuilder<Object>(a.length(), VectorBuilder$.MODULE$.$lessinit$greater$default$2(), Semiring$.MODULE$.semiringLong(), ClassTag$.MODULE$.apply(Long.TYPE));
                int yy = a.length();
                for (int i = 0; i < a.length(); ++i) {
                    int n = i;
                    long r = BoxesRunTime.unboxToLong(a.apply(n)) - b;
                    if (r == 0L) continue;
                    result.add(n, BoxesRunTime.boxToLong((long)r));
                }
                return result.toSparseVector(true, true);
            }
        });
        $this.breeze$linalg$operators$SparseVectorExpandOps$_setter_$impl_Op_SV_S_eq_SV_Int_OpSet_$eq(new UFunc.UImpl2<OpSet$, SparseVector<Object>, Object, SparseVector<Object>>($this){
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                ((BinaryRegistry)Predef$.MODULE$.implicitly($outer.impl_Op_V_S_eq_V_Int_OpSet())).register(this, ClassTag$.MODULE$.apply(SparseVector.class), ClassTag$.MODULE$.apply(Integer.TYPE));
            }

            public SparseVector apply(SparseVector a, int b) {
                VectorBuilder<Object> result = new VectorBuilder<Object>(a.length(), VectorBuilder$.MODULE$.$lessinit$greater$default$2(), Semiring$.MODULE$.semiringInt(), ClassTag$.MODULE$.apply(Integer.TYPE));
                int yy = a.length();
                for (int i = 0; i < a.length(); ++i) {
                    int n = i;
                    int r = b;
                    if (r == 0) continue;
                    result.add(n, BoxesRunTime.boxToInteger((int)r));
                }
                return result.toSparseVector(true, true);
            }
        });
        $this.breeze$linalg$operators$SparseVectorExpandOps$_setter_$impl_Op_SV_S_eq_SV_Double_OpSet_$eq(new UFunc.UImpl2<OpSet$, SparseVector<Object>, Object, SparseVector<Object>>($this){
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                ((BinaryRegistry)Predef$.MODULE$.implicitly($outer.impl_Op_V_S_eq_V_Double_OpSet())).register(this, ClassTag$.MODULE$.apply(SparseVector.class), ClassTag$.MODULE$.apply(Double.TYPE));
            }

            public SparseVector apply(SparseVector a, double b) {
                VectorBuilder<Object> result = new VectorBuilder<Object>(a.length(), VectorBuilder$.MODULE$.$lessinit$greater$default$2(), Semiring$.MODULE$.semiringD(), ClassTag$.MODULE$.apply(Double.TYPE));
                int yy = a.length();
                for (int i = 0; i < a.length(); ++i) {
                    int n = i;
                    double r = b;
                    if (r == 0.0) continue;
                    result.add(n, BoxesRunTime.boxToDouble((double)r));
                }
                return result.toSparseVector(true, true);
            }
        });
        $this.breeze$linalg$operators$SparseVectorExpandOps$_setter_$impl_Op_SV_S_eq_SV_Float_OpSet_$eq(new UFunc.UImpl2<OpSet$, SparseVector<Object>, Object, SparseVector<Object>>($this){
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                ((BinaryRegistry)Predef$.MODULE$.implicitly($outer.impl_Op_V_S_eq_V_Float_OpSet())).register(this, ClassTag$.MODULE$.apply(SparseVector.class), ClassTag$.MODULE$.apply(Float.TYPE));
            }

            public SparseVector apply(SparseVector a, float b) {
                VectorBuilder<Object> result = new VectorBuilder<Object>(a.length(), VectorBuilder$.MODULE$.$lessinit$greater$default$2(), Semiring$.MODULE$.semiringFloat(), ClassTag$.MODULE$.apply(Float.TYPE));
                int yy = a.length();
                for (int i = 0; i < a.length(); ++i) {
                    int n = i;
                    float r = b;
                    if (r == 0.0f) continue;
                    result.add(n, BoxesRunTime.boxToFloat((float)r));
                }
                return result.toSparseVector(true, true);
            }
        });
        $this.breeze$linalg$operators$SparseVectorExpandOps$_setter_$impl_Op_SV_S_eq_SV_Long_OpSet_$eq(new UFunc.UImpl2<OpSet$, SparseVector<Object>, Object, SparseVector<Object>>($this){
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                ((BinaryRegistry)Predef$.MODULE$.implicitly($outer.impl_Op_V_S_eq_V_Long_OpSet())).register(this, ClassTag$.MODULE$.apply(SparseVector.class), ClassTag$.MODULE$.apply(Long.TYPE));
            }

            public SparseVector apply(SparseVector a, long b) {
                VectorBuilder<Object> result = new VectorBuilder<Object>(a.length(), VectorBuilder$.MODULE$.$lessinit$greater$default$2(), Semiring$.MODULE$.semiringLong(), ClassTag$.MODULE$.apply(Long.TYPE));
                int yy = a.length();
                for (int i = 0; i < a.length(); ++i) {
                    int n = i;
                    long r = b;
                    if (r == 0L) continue;
                    result.add(n, BoxesRunTime.boxToLong((long)r));
                }
                return result.toSparseVector(true, true);
            }
        });
        $this.breeze$linalg$operators$SparseVectorExpandOps$_setter_$impl_Op_SV_S_eq_SV_Int_OpPow_$eq(new UFunc.UImpl2<OpPow$, SparseVector<Object>, Object, SparseVector<Object>>($this){
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                ((BinaryRegistry)Predef$.MODULE$.implicitly($outer.impl_Op_V_S_eq_V_Int_OpPow())).register(this, ClassTag$.MODULE$.apply(SparseVector.class), ClassTag$.MODULE$.apply(Integer.TYPE));
            }

            public SparseVector apply(SparseVector a, int b) {
                VectorBuilder<Object> result = new VectorBuilder<Object>(a.length(), VectorBuilder$.MODULE$.$lessinit$greater$default$2(), Semiring$.MODULE$.semiringInt(), ClassTag$.MODULE$.apply(Integer.TYPE));
                int yy = a.length();
                for (int i = 0; i < a.length(); ++i) {
                    int n = i;
                    int r = PowImplicits$.MODULE$.IntPow(BoxesRunTime.unboxToInt(a.apply(n))).pow(b);
                    if (r == 0) continue;
                    result.add(n, BoxesRunTime.boxToInteger((int)r));
                }
                return result.toSparseVector(true, true);
            }
        });
        $this.breeze$linalg$operators$SparseVectorExpandOps$_setter_$impl_Op_SV_S_eq_SV_Double_OpPow_$eq(new UFunc.UImpl2<OpPow$, SparseVector<Object>, Object, SparseVector<Object>>($this){
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                ((BinaryRegistry)Predef$.MODULE$.implicitly($outer.impl_Op_V_S_eq_V_Double_OpPow())).register(this, ClassTag$.MODULE$.apply(SparseVector.class), ClassTag$.MODULE$.apply(Double.TYPE));
            }

            public SparseVector apply(SparseVector a, double b) {
                VectorBuilder<Object> result = new VectorBuilder<Object>(a.length(), VectorBuilder$.MODULE$.$lessinit$greater$default$2(), Semiring$.MODULE$.semiringD(), ClassTag$.MODULE$.apply(Double.TYPE));
                int yy = a.length();
                for (int i = 0; i < a.length(); ++i) {
                    int n = i;
                    double r = PowImplicits$.MODULE$.DoublePow(BoxesRunTime.unboxToDouble(a.apply(n))).pow(b);
                    if (r == 0.0) continue;
                    result.add(n, BoxesRunTime.boxToDouble((double)r));
                }
                return result.toSparseVector(true, true);
            }
        });
        $this.breeze$linalg$operators$SparseVectorExpandOps$_setter_$impl_Op_SV_S_eq_SV_Float_OpPow_$eq(new UFunc.UImpl2<OpPow$, SparseVector<Object>, Object, SparseVector<Object>>($this){
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                ((BinaryRegistry)Predef$.MODULE$.implicitly($outer.impl_Op_V_S_eq_V_Float_OpPow())).register(this, ClassTag$.MODULE$.apply(SparseVector.class), ClassTag$.MODULE$.apply(Float.TYPE));
            }

            public SparseVector apply(SparseVector a, float b) {
                VectorBuilder<Object> result = new VectorBuilder<Object>(a.length(), VectorBuilder$.MODULE$.$lessinit$greater$default$2(), Semiring$.MODULE$.semiringFloat(), ClassTag$.MODULE$.apply(Float.TYPE));
                int yy = a.length();
                for (int i = 0; i < a.length(); ++i) {
                    int n = i;
                    float r = PowImplicits$.MODULE$.FloatPow(BoxesRunTime.unboxToFloat(a.apply(n))).pow(b);
                    if (r == 0.0f) continue;
                    result.add(n, BoxesRunTime.boxToFloat((float)r));
                }
                return result.toSparseVector(true, true);
            }
        });
        $this.breeze$linalg$operators$SparseVectorExpandOps$_setter_$impl_Op_SV_S_eq_SV_Long_OpPow_$eq(new UFunc.UImpl2<OpPow$, SparseVector<Object>, Object, SparseVector<Object>>($this){
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                ((BinaryRegistry)Predef$.MODULE$.implicitly($outer.impl_Op_V_S_eq_V_Long_OpPow())).register(this, ClassTag$.MODULE$.apply(SparseVector.class), ClassTag$.MODULE$.apply(Long.TYPE));
            }

            public SparseVector apply(SparseVector a, long b) {
                VectorBuilder<Object> result = new VectorBuilder<Object>(a.length(), VectorBuilder$.MODULE$.$lessinit$greater$default$2(), Semiring$.MODULE$.semiringLong(), ClassTag$.MODULE$.apply(Long.TYPE));
                int yy = a.length();
                for (int i = 0; i < a.length(); ++i) {
                    int n = i;
                    long r = PowImplicits$.MODULE$.LongPow(BoxesRunTime.unboxToLong(a.apply(n))).pow(b);
                    if (r == 0L) continue;
                    result.add(n, BoxesRunTime.boxToLong((long)r));
                }
                return result.toSparseVector(true, true);
            }
        });
        $this.breeze$linalg$operators$SparseVectorExpandOps$_setter_$impl_Op_SV_S_eq_SV_Int_OpDiv_$eq(new UFunc.UImpl2<OpDiv$, SparseVector<Object>, Object, SparseVector<Object>>($this){
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                ((BinaryRegistry)Predef$.MODULE$.implicitly($outer.impl_Op_V_S_eq_V_Int_OpDiv())).register(this, ClassTag$.MODULE$.apply(SparseVector.class), ClassTag$.MODULE$.apply(Integer.TYPE));
            }

            public SparseVector apply(SparseVector a, int b) {
                VectorBuilder<Object> result = new VectorBuilder<Object>(a.length(), VectorBuilder$.MODULE$.$lessinit$greater$default$2(), Semiring$.MODULE$.semiringInt(), ClassTag$.MODULE$.apply(Integer.TYPE));
                if (b == 0) {
                    int yy = a.length();
                    for (int i = 0; i < a.length(); ++i) {
                        int n = i;
                        int r = BoxesRunTime.unboxToInt(a.apply(n)) / b;
                        if (r == 0) continue;
                        result.add(n, BoxesRunTime.boxToInteger((int)r));
                    }
                } else {
                    int yy = a.activeSize();
                    for (int i = 0; i < a.activeSize(); ++i) {
                        int n = i;
                        int r = BoxesRunTime.unboxToInt(a.valueAt(n)) / b;
                        if (r == 0) continue;
                        result.add(a.indexAt(n), BoxesRunTime.boxToInteger((int)r));
                    }
                }
                return result.toSparseVector(true, true);
            }
        });
        $this.breeze$linalg$operators$SparseVectorExpandOps$_setter_$impl_Op_SV_S_eq_SV_Double_OpDiv_$eq(new UFunc.UImpl2<OpDiv$, SparseVector<Object>, Object, SparseVector<Object>>($this){
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                ((BinaryRegistry)Predef$.MODULE$.implicitly($outer.impl_Op_V_S_eq_V_Double_OpDiv())).register(this, ClassTag$.MODULE$.apply(SparseVector.class), ClassTag$.MODULE$.apply(Double.TYPE));
            }

            public SparseVector apply(SparseVector a, double b) {
                VectorBuilder<Object> result = new VectorBuilder<Object>(a.length(), VectorBuilder$.MODULE$.$lessinit$greater$default$2(), Semiring$.MODULE$.semiringD(), ClassTag$.MODULE$.apply(Double.TYPE));
                if (b == 0.0) {
                    int yy = a.length();
                    for (int i = 0; i < a.length(); ++i) {
                        int n = i;
                        double r = BoxesRunTime.unboxToDouble(a.apply(n)) / b;
                        if (r == 0.0) continue;
                        result.add(n, BoxesRunTime.boxToDouble((double)r));
                    }
                } else {
                    int yy = a.activeSize();
                    for (int i = 0; i < a.activeSize(); ++i) {
                        int n = i;
                        double r = BoxesRunTime.unboxToDouble(a.valueAt(n)) / b;
                        if (r == 0.0) continue;
                        result.add(a.indexAt(n), BoxesRunTime.boxToDouble((double)r));
                    }
                }
                return result.toSparseVector(true, true);
            }
        });
        $this.breeze$linalg$operators$SparseVectorExpandOps$_setter_$impl_Op_SV_S_eq_SV_Float_OpDiv_$eq(new UFunc.UImpl2<OpDiv$, SparseVector<Object>, Object, SparseVector<Object>>($this){
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                ((BinaryRegistry)Predef$.MODULE$.implicitly($outer.impl_Op_V_S_eq_V_Float_OpDiv())).register(this, ClassTag$.MODULE$.apply(SparseVector.class), ClassTag$.MODULE$.apply(Float.TYPE));
            }

            public SparseVector apply(SparseVector a, float b) {
                VectorBuilder<Object> result = new VectorBuilder<Object>(a.length(), VectorBuilder$.MODULE$.$lessinit$greater$default$2(), Semiring$.MODULE$.semiringFloat(), ClassTag$.MODULE$.apply(Float.TYPE));
                if (b == 0.0f) {
                    int yy = a.length();
                    for (int i = 0; i < a.length(); ++i) {
                        int n = i;
                        float r = BoxesRunTime.unboxToFloat(a.apply(n)) / b;
                        if (r == 0.0f) continue;
                        result.add(n, BoxesRunTime.boxToFloat((float)r));
                    }
                } else {
                    int yy = a.activeSize();
                    for (int i = 0; i < a.activeSize(); ++i) {
                        int n = i;
                        float r = BoxesRunTime.unboxToFloat(a.valueAt(n)) / b;
                        if (r == 0.0f) continue;
                        result.add(a.indexAt(n), BoxesRunTime.boxToFloat((float)r));
                    }
                }
                return result.toSparseVector(true, true);
            }
        });
        $this.breeze$linalg$operators$SparseVectorExpandOps$_setter_$impl_Op_SV_S_eq_SV_Long_OpDiv_$eq(new UFunc.UImpl2<OpDiv$, SparseVector<Object>, Object, SparseVector<Object>>($this){
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                ((BinaryRegistry)Predef$.MODULE$.implicitly($outer.impl_Op_V_S_eq_V_Long_OpDiv())).register(this, ClassTag$.MODULE$.apply(SparseVector.class), ClassTag$.MODULE$.apply(Long.TYPE));
            }

            public SparseVector apply(SparseVector a, long b) {
                VectorBuilder<Object> result = new VectorBuilder<Object>(a.length(), VectorBuilder$.MODULE$.$lessinit$greater$default$2(), Semiring$.MODULE$.semiringLong(), ClassTag$.MODULE$.apply(Long.TYPE));
                if (b == 0L) {
                    int yy = a.length();
                    for (int i = 0; i < a.length(); ++i) {
                        int n = i;
                        long r = BoxesRunTime.unboxToLong(a.apply(n)) / b;
                        if (r == 0L) continue;
                        result.add(n, BoxesRunTime.boxToLong((long)r));
                    }
                } else {
                    int yy = a.activeSize();
                    for (int i = 0; i < a.activeSize(); ++i) {
                        int n = i;
                        long r = BoxesRunTime.unboxToLong(a.valueAt(n)) / b;
                        if (r == 0L) continue;
                        result.add(a.indexAt(n), BoxesRunTime.boxToLong((long)r));
                    }
                }
                return result.toSparseVector(true, true);
            }
        });
        $this.breeze$linalg$operators$SparseVectorExpandOps$_setter_$impl_Op_SV_S_eq_SV_Int_OpMod_$eq(new UFunc.UImpl2<OpMod$, SparseVector<Object>, Object, SparseVector<Object>>($this){
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                ((BinaryRegistry)Predef$.MODULE$.implicitly($outer.impl_Op_V_S_eq_V_Int_OpMod())).register(this, ClassTag$.MODULE$.apply(SparseVector.class), ClassTag$.MODULE$.apply(Integer.TYPE));
            }

            public SparseVector apply(SparseVector a, int b) {
                VectorBuilder<Object> result = new VectorBuilder<Object>(a.length(), VectorBuilder$.MODULE$.$lessinit$greater$default$2(), Semiring$.MODULE$.semiringInt(), ClassTag$.MODULE$.apply(Integer.TYPE));
                if (b == 0) {
                    int yy = a.length();
                    for (int i = 0; i < a.length(); ++i) {
                        int n = i;
                        int r = BoxesRunTime.unboxToInt(a.apply(n)) % b;
                        if (r == 0) continue;
                        result.add(n, BoxesRunTime.boxToInteger((int)r));
                    }
                } else {
                    int yy = a.activeSize();
                    for (int i = 0; i < a.activeSize(); ++i) {
                        int n = i;
                        int r = BoxesRunTime.unboxToInt(a.valueAt(n)) % b;
                        if (r == 0) continue;
                        result.add(a.indexAt(n), BoxesRunTime.boxToInteger((int)r));
                    }
                }
                return result.toSparseVector(true, true);
            }
        });
        $this.breeze$linalg$operators$SparseVectorExpandOps$_setter_$impl_Op_SV_S_eq_SV_Double_OpMod_$eq(new UFunc.UImpl2<OpMod$, SparseVector<Object>, Object, SparseVector<Object>>($this){
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                ((BinaryRegistry)Predef$.MODULE$.implicitly($outer.impl_Op_V_S_eq_V_Double_OpMod())).register(this, ClassTag$.MODULE$.apply(SparseVector.class), ClassTag$.MODULE$.apply(Double.TYPE));
            }

            public SparseVector apply(SparseVector a, double b) {
                VectorBuilder<Object> result = new VectorBuilder<Object>(a.length(), VectorBuilder$.MODULE$.$lessinit$greater$default$2(), Semiring$.MODULE$.semiringD(), ClassTag$.MODULE$.apply(Double.TYPE));
                if (b == 0.0) {
                    int yy = a.length();
                    for (int i = 0; i < a.length(); ++i) {
                        int n = i;
                        double r = BoxesRunTime.unboxToDouble(a.apply(n)) % b;
                        if (r == 0.0) continue;
                        result.add(n, BoxesRunTime.boxToDouble((double)r));
                    }
                } else {
                    int yy = a.activeSize();
                    for (int i = 0; i < a.activeSize(); ++i) {
                        int n = i;
                        double r = BoxesRunTime.unboxToDouble(a.valueAt(n)) % b;
                        if (r == 0.0) continue;
                        result.add(a.indexAt(n), BoxesRunTime.boxToDouble((double)r));
                    }
                }
                return result.toSparseVector(true, true);
            }
        });
        $this.breeze$linalg$operators$SparseVectorExpandOps$_setter_$impl_Op_SV_S_eq_SV_Float_OpMod_$eq(new UFunc.UImpl2<OpMod$, SparseVector<Object>, Object, SparseVector<Object>>($this){
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                ((BinaryRegistry)Predef$.MODULE$.implicitly($outer.impl_Op_V_S_eq_V_Float_OpMod())).register(this, ClassTag$.MODULE$.apply(SparseVector.class), ClassTag$.MODULE$.apply(Float.TYPE));
            }

            public SparseVector apply(SparseVector a, float b) {
                VectorBuilder<Object> result = new VectorBuilder<Object>(a.length(), VectorBuilder$.MODULE$.$lessinit$greater$default$2(), Semiring$.MODULE$.semiringFloat(), ClassTag$.MODULE$.apply(Float.TYPE));
                if (b == 0.0f) {
                    int yy = a.length();
                    for (int i = 0; i < a.length(); ++i) {
                        int n = i;
                        float r = BoxesRunTime.unboxToFloat(a.apply(n)) % b;
                        if (r == 0.0f) continue;
                        result.add(n, BoxesRunTime.boxToFloat((float)r));
                    }
                } else {
                    int yy = a.activeSize();
                    for (int i = 0; i < a.activeSize(); ++i) {
                        int n = i;
                        float r = BoxesRunTime.unboxToFloat(a.valueAt(n)) % b;
                        if (r == 0.0f) continue;
                        result.add(a.indexAt(n), BoxesRunTime.boxToFloat((float)r));
                    }
                }
                return result.toSparseVector(true, true);
            }
        });
        $this.breeze$linalg$operators$SparseVectorExpandOps$_setter_$impl_Op_SV_S_eq_SV_Long_OpMod_$eq(new UFunc.UImpl2<OpMod$, SparseVector<Object>, Object, SparseVector<Object>>($this){
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                ((BinaryRegistry)Predef$.MODULE$.implicitly($outer.impl_Op_V_S_eq_V_Long_OpMod())).register(this, ClassTag$.MODULE$.apply(SparseVector.class), ClassTag$.MODULE$.apply(Long.TYPE));
            }

            public SparseVector apply(SparseVector a, long b) {
                VectorBuilder<Object> result = new VectorBuilder<Object>(a.length(), VectorBuilder$.MODULE$.$lessinit$greater$default$2(), Semiring$.MODULE$.semiringLong(), ClassTag$.MODULE$.apply(Long.TYPE));
                if (b == 0L) {
                    int yy = a.length();
                    for (int i = 0; i < a.length(); ++i) {
                        int n = i;
                        long r = BoxesRunTime.unboxToLong(a.apply(n)) % b;
                        if (r == 0L) continue;
                        result.add(n, BoxesRunTime.boxToLong((long)r));
                    }
                } else {
                    int yy = a.activeSize();
                    for (int i = 0; i < a.activeSize(); ++i) {
                        int n = i;
                        long r = BoxesRunTime.unboxToLong(a.valueAt(n)) % b;
                        if (r == 0L) continue;
                        result.add(a.indexAt(n), BoxesRunTime.boxToLong((long)r));
                    }
                }
                return result.toSparseVector(true, true);
            }
        });
        $this.breeze$linalg$operators$SparseVectorExpandOps$_setter_$impl_Op_SV_S_eq_SV_Int_OpMulScalar_$eq(new UFunc.UImpl2<OpMulScalar$, SparseVector<Object>, Object, SparseVector<Object>>($this){
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                ((BinaryRegistry)Predef$.MODULE$.implicitly($outer.impl_Op_V_S_eq_V_Int_OpMulScalar())).register(this, ClassTag$.MODULE$.apply(SparseVector.class), ClassTag$.MODULE$.apply(Integer.TYPE));
            }

            public SparseVector apply(SparseVector a, int b) {
                VectorBuilder<Object> result = new VectorBuilder<Object>(a.length(), VectorBuilder$.MODULE$.$lessinit$greater$default$2(), Semiring$.MODULE$.semiringInt(), ClassTag$.MODULE$.apply(Integer.TYPE));
                for (int i = 0; i < a.activeSize(); ++i) {
                    result.add(a.indexAt(i), BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt(a.valueAt(i)) * b)));
                }
                return result.toSparseVector(true, true);
            }
        });
        $this.breeze$linalg$operators$SparseVectorExpandOps$_setter_$impl_Op_SV_S_eq_SV_Double_OpMulScalar_$eq(new UFunc.UImpl2<OpMulScalar$, SparseVector<Object>, Object, SparseVector<Object>>($this){
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                ((BinaryRegistry)Predef$.MODULE$.implicitly($outer.impl_Op_V_S_eq_V_Double_OpMulScalar())).register(this, ClassTag$.MODULE$.apply(SparseVector.class), ClassTag$.MODULE$.apply(Double.TYPE));
            }

            public SparseVector apply(SparseVector a, double b) {
                VectorBuilder<Object> result = new VectorBuilder<Object>(a.length(), VectorBuilder$.MODULE$.$lessinit$greater$default$2(), Semiring$.MODULE$.semiringD(), ClassTag$.MODULE$.apply(Double.TYPE));
                for (int i = 0; i < a.activeSize(); ++i) {
                    result.add(a.indexAt(i), BoxesRunTime.boxToDouble((double)(BoxesRunTime.unboxToDouble(a.valueAt(i)) * b)));
                }
                return result.toSparseVector(true, true);
            }
        });
        $this.breeze$linalg$operators$SparseVectorExpandOps$_setter_$impl_Op_SV_S_eq_SV_Float_OpMulScalar_$eq(new UFunc.UImpl2<OpMulScalar$, SparseVector<Object>, Object, SparseVector<Object>>($this){
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                ((BinaryRegistry)Predef$.MODULE$.implicitly($outer.impl_Op_V_S_eq_V_Float_OpMulScalar())).register(this, ClassTag$.MODULE$.apply(SparseVector.class), ClassTag$.MODULE$.apply(Float.TYPE));
            }

            public SparseVector apply(SparseVector a, float b) {
                VectorBuilder<Object> result = new VectorBuilder<Object>(a.length(), VectorBuilder$.MODULE$.$lessinit$greater$default$2(), Semiring$.MODULE$.semiringFloat(), ClassTag$.MODULE$.apply(Float.TYPE));
                for (int i = 0; i < a.activeSize(); ++i) {
                    result.add(a.indexAt(i), BoxesRunTime.boxToFloat((float)(BoxesRunTime.unboxToFloat(a.valueAt(i)) * b)));
                }
                return result.toSparseVector(true, true);
            }
        });
        $this.breeze$linalg$operators$SparseVectorExpandOps$_setter_$impl_Op_SV_S_eq_SV_Long_OpMulScalar_$eq(new UFunc.UImpl2<OpMulScalar$, SparseVector<Object>, Object, SparseVector<Object>>($this){
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                ((BinaryRegistry)Predef$.MODULE$.implicitly($outer.impl_Op_V_S_eq_V_Long_OpMulScalar())).register(this, ClassTag$.MODULE$.apply(SparseVector.class), ClassTag$.MODULE$.apply(Long.TYPE));
            }

            public SparseVector apply(SparseVector a, long b) {
                VectorBuilder<Object> result = new VectorBuilder<Object>(a.length(), VectorBuilder$.MODULE$.$lessinit$greater$default$2(), Semiring$.MODULE$.semiringLong(), ClassTag$.MODULE$.apply(Long.TYPE));
                for (int i = 0; i < a.activeSize(); ++i) {
                    result.add(a.indexAt(i), BoxesRunTime.boxToLong((long)(BoxesRunTime.unboxToLong(a.valueAt(i)) * b)));
                }
                return result.toSparseVector(true, true);
            }
        });
        $this.breeze$linalg$operators$SparseVectorExpandOps$_setter_$impl_Op_SV_S_eq_SV_Int_OpMulMatrix_$eq(new UFunc.UImpl2<OpMulMatrix$, SparseVector<Object>, Object, SparseVector<Object>>($this){
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                ((BinaryRegistry)Predef$.MODULE$.implicitly($outer.impl_Op_V_S_eq_V_Int_OpMulMatrix())).register(this, ClassTag$.MODULE$.apply(SparseVector.class), ClassTag$.MODULE$.apply(Integer.TYPE));
            }

            public SparseVector apply(SparseVector a, int b) {
                VectorBuilder<Object> result = new VectorBuilder<Object>(a.length(), VectorBuilder$.MODULE$.$lessinit$greater$default$2(), Semiring$.MODULE$.semiringInt(), ClassTag$.MODULE$.apply(Integer.TYPE));
                for (int i = 0; i < a.activeSize(); ++i) {
                    result.add(a.indexAt(i), BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt(a.valueAt(i)) * b)));
                }
                return result.toSparseVector(true, true);
            }
        });
        $this.breeze$linalg$operators$SparseVectorExpandOps$_setter_$impl_Op_SV_S_eq_SV_Double_OpMulMatrix_$eq(new UFunc.UImpl2<OpMulMatrix$, SparseVector<Object>, Object, SparseVector<Object>>($this){
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                ((BinaryRegistry)Predef$.MODULE$.implicitly($outer.impl_Op_V_S_eq_V_Double_OpMulMatrix())).register(this, ClassTag$.MODULE$.apply(SparseVector.class), ClassTag$.MODULE$.apply(Double.TYPE));
            }

            public SparseVector apply(SparseVector a, double b) {
                VectorBuilder<Object> result = new VectorBuilder<Object>(a.length(), VectorBuilder$.MODULE$.$lessinit$greater$default$2(), Semiring$.MODULE$.semiringD(), ClassTag$.MODULE$.apply(Double.TYPE));
                for (int i = 0; i < a.activeSize(); ++i) {
                    result.add(a.indexAt(i), BoxesRunTime.boxToDouble((double)(BoxesRunTime.unboxToDouble(a.valueAt(i)) * b)));
                }
                return result.toSparseVector(true, true);
            }
        });
        $this.breeze$linalg$operators$SparseVectorExpandOps$_setter_$impl_Op_SV_S_eq_SV_Float_OpMulMatrix_$eq(new UFunc.UImpl2<OpMulMatrix$, SparseVector<Object>, Object, SparseVector<Object>>($this){
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                ((BinaryRegistry)Predef$.MODULE$.implicitly($outer.impl_Op_V_S_eq_V_Float_OpMulMatrix())).register(this, ClassTag$.MODULE$.apply(SparseVector.class), ClassTag$.MODULE$.apply(Float.TYPE));
            }

            public SparseVector apply(SparseVector a, float b) {
                VectorBuilder<Object> result = new VectorBuilder<Object>(a.length(), VectorBuilder$.MODULE$.$lessinit$greater$default$2(), Semiring$.MODULE$.semiringFloat(), ClassTag$.MODULE$.apply(Float.TYPE));
                for (int i = 0; i < a.activeSize(); ++i) {
                    result.add(a.indexAt(i), BoxesRunTime.boxToFloat((float)(BoxesRunTime.unboxToFloat(a.valueAt(i)) * b)));
                }
                return result.toSparseVector(true, true);
            }
        });
        $this.breeze$linalg$operators$SparseVectorExpandOps$_setter_$impl_Op_SV_S_eq_SV_Long_OpMulMatrix_$eq(new UFunc.UImpl2<OpMulMatrix$, SparseVector<Object>, Object, SparseVector<Object>>($this){
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                ((BinaryRegistry)Predef$.MODULE$.implicitly($outer.impl_Op_V_S_eq_V_Long_OpMulMatrix())).register(this, ClassTag$.MODULE$.apply(SparseVector.class), ClassTag$.MODULE$.apply(Long.TYPE));
            }

            public SparseVector apply(SparseVector a, long b) {
                VectorBuilder<Object> result = new VectorBuilder<Object>(a.length(), VectorBuilder$.MODULE$.$lessinit$greater$default$2(), Semiring$.MODULE$.semiringLong(), ClassTag$.MODULE$.apply(Long.TYPE));
                for (int i = 0; i < a.activeSize(); ++i) {
                    result.add(a.indexAt(i), BoxesRunTime.boxToLong((long)(BoxesRunTime.unboxToLong(a.valueAt(i)) * b)));
                }
                return result.toSparseVector(true, true);
            }
        });
        $this.breeze$linalg$operators$SparseVectorExpandOps$_setter_$impl_OpMulInner_SV_SV_eq_T_Int_$eq(new UFunc.UImpl2<OpMulInner$, SparseVector<Object>, SparseVector<Object>, Object>($this){
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                ((BinaryRegistry)Predef$.MODULE$.implicitly($outer.impl_OpMulInner_V_V_eq_S_Int())).register(this, ClassTag$.MODULE$.apply(SparseVector.class), ClassTag$.MODULE$.apply(SparseVector.class));
            }

            public int apply(SparseVector a, SparseVector b) {
                $anon$199 var3_3 = this;
                SparseVector sparseVector = b;
                SparseVector sparseVector2 = a;
                while (true) {
                    if (sparseVector.length() != sparseVector2.length()) {
                        throw new IllegalArgumentException(StringOps$.MODULE$.format$extension("requirement failed: %s", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{new StringBuilder(55).append("Vectors must be the same length!").append(": ").append("b.length.==(a.length)").toString()})));
                    }
                    if (sparseVector.activeSize() >= sparseVector2.activeSize()) break;
                    $anon$199 var6_6 = var3_3;
                    SparseVector sparseVector3 = sparseVector;
                    SparseVector sparseVector4 = sparseVector2;
                    var3_3 = var6_6;
                    sparseVector2 = sparseVector3;
                    sparseVector = sparseVector4;
                }
                return sparseVector2.activeSize() == 0 ? 0 : (sparseVector.activeSize() <= 32 ? var3_3.smallVectors(sparseVector2, sparseVector) : var3_3.bigVectors(sparseVector2, sparseVector));
            }

            public int smallVectors(SparseVector a, SparseVector b) {
                int asize = a.activeSize();
                int bsize = b.activeSize();
                int result = 0;
                int aoff = 0;
                int boff = 0;
                while (aoff < asize && boff < bsize) {
                    if (a.indexAt(aoff) < b.indexAt(boff)) {
                        ++aoff;
                        continue;
                    }
                    if (b.indexAt(boff) < a.indexAt(aoff)) {
                        ++boff;
                        continue;
                    }
                    result += BoxesRunTime.unboxToInt(a.valueAt(aoff)) * BoxesRunTime.unboxToInt(b.valueAt(boff));
                    ++aoff;
                    ++boff;
                }
                return result;
            }

            public int bigVectors(SparseVector a, SparseVector b) {
                int asize = a.activeSize();
                int bsize = b.activeSize();
                int result = 0;
                int aoff = 0;
                int boff = 0;
                while (aoff < asize) {
                    int aind = a.indexAt(aoff);
                    int bMax = package$.MODULE$.min(bsize, aind + 1);
                    boff = ArrayUtil$.MODULE$.gallopSearch(b.index(), boff, bMax, aind);
                    if (boff < 0) {
                        if ((boff ^= 0xFFFFFFFF) == bsize) {
                            aoff = asize;
                            continue;
                        }
                        int bind = b.indexAt(boff);
                        int aMax = package$.MODULE$.min(asize, bind + 1);
                        int newAoff = ArrayUtil$.MODULE$.gallopSearch(a.index(), aoff, aMax, bind);
                        if (newAoff < 0) {
                            newAoff ^= 0xFFFFFFFF;
                            ++boff;
                        }
                        aoff = newAoff;
                        continue;
                    }
                    result += BoxesRunTime.unboxToInt(a.valueAt(aoff)) * BoxesRunTime.unboxToInt(b.valueAt(boff));
                    ++aoff;
                    ++boff;
                }
                return result;
            }
        });
        $this.breeze$linalg$operators$SparseVectorExpandOps$_setter_$impl_OpMulInner_SV_SV_eq_T_Double_$eq(new UFunc.UImpl2<OpMulInner$, SparseVector<Object>, SparseVector<Object>, Object>($this){
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                ((BinaryRegistry)Predef$.MODULE$.implicitly($outer.impl_OpMulInner_V_V_eq_S_Double())).register(this, ClassTag$.MODULE$.apply(SparseVector.class), ClassTag$.MODULE$.apply(SparseVector.class));
            }

            public double apply(SparseVector a, SparseVector b) {
                $anon$200 var3_3 = this;
                SparseVector sparseVector = b;
                SparseVector sparseVector2 = a;
                while (true) {
                    if (sparseVector.length() != sparseVector2.length()) {
                        throw new IllegalArgumentException(StringOps$.MODULE$.format$extension("requirement failed: %s", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{new StringBuilder(55).append("Vectors must be the same length!").append(": ").append("b.length.==(a.length)").toString()})));
                    }
                    if (sparseVector.activeSize() >= sparseVector2.activeSize()) break;
                    $anon$200 var6_6 = var3_3;
                    SparseVector sparseVector3 = sparseVector;
                    SparseVector sparseVector4 = sparseVector2;
                    var3_3 = var6_6;
                    sparseVector2 = sparseVector3;
                    sparseVector = sparseVector4;
                }
                return sparseVector2.activeSize() == 0 ? 0.0 : (sparseVector.activeSize() <= 32 ? var3_3.smallVectors(sparseVector2, sparseVector) : var3_3.bigVectors(sparseVector2, sparseVector));
            }

            public double smallVectors(SparseVector a, SparseVector b) {
                int asize = a.activeSize();
                int bsize = b.activeSize();
                double result = 0.0;
                int aoff = 0;
                int boff = 0;
                while (aoff < asize && boff < bsize) {
                    if (a.indexAt(aoff) < b.indexAt(boff)) {
                        ++aoff;
                        continue;
                    }
                    if (b.indexAt(boff) < a.indexAt(aoff)) {
                        ++boff;
                        continue;
                    }
                    result += BoxesRunTime.unboxToDouble(a.valueAt(aoff)) * BoxesRunTime.unboxToDouble(b.valueAt(boff));
                    ++aoff;
                    ++boff;
                }
                return result;
            }

            public double bigVectors(SparseVector a, SparseVector b) {
                int asize = a.activeSize();
                int bsize = b.activeSize();
                double result = 0.0;
                int aoff = 0;
                int boff = 0;
                while (aoff < asize) {
                    int aind = a.indexAt(aoff);
                    int bMax = package$.MODULE$.min(bsize, aind + 1);
                    boff = ArrayUtil$.MODULE$.gallopSearch(b.index(), boff, bMax, aind);
                    if (boff < 0) {
                        if ((boff ^= 0xFFFFFFFF) == bsize) {
                            aoff = asize;
                            continue;
                        }
                        int bind = b.indexAt(boff);
                        int aMax = package$.MODULE$.min(asize, bind + 1);
                        int newAoff = ArrayUtil$.MODULE$.gallopSearch(a.index(), aoff, aMax, bind);
                        if (newAoff < 0) {
                            newAoff ^= 0xFFFFFFFF;
                            ++boff;
                        }
                        aoff = newAoff;
                        continue;
                    }
                    result += BoxesRunTime.unboxToDouble(a.valueAt(aoff)) * BoxesRunTime.unboxToDouble(b.valueAt(boff));
                    ++aoff;
                    ++boff;
                }
                return result;
            }
        });
        $this.breeze$linalg$operators$SparseVectorExpandOps$_setter_$impl_OpMulInner_SV_SV_eq_T_Float_$eq(new UFunc.UImpl2<OpMulInner$, SparseVector<Object>, SparseVector<Object>, Object>($this){
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                ((BinaryRegistry)Predef$.MODULE$.implicitly($outer.impl_OpMulInner_V_V_eq_S_Float())).register(this, ClassTag$.MODULE$.apply(SparseVector.class), ClassTag$.MODULE$.apply(SparseVector.class));
            }

            public float apply(SparseVector a, SparseVector b) {
                $anon$201 var3_3 = this;
                SparseVector sparseVector = b;
                SparseVector sparseVector2 = a;
                while (true) {
                    if (sparseVector.length() != sparseVector2.length()) {
                        throw new IllegalArgumentException(StringOps$.MODULE$.format$extension("requirement failed: %s", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{new StringBuilder(55).append("Vectors must be the same length!").append(": ").append("b.length.==(a.length)").toString()})));
                    }
                    if (sparseVector.activeSize() >= sparseVector2.activeSize()) break;
                    $anon$201 var6_6 = var3_3;
                    SparseVector sparseVector3 = sparseVector;
                    SparseVector sparseVector4 = sparseVector2;
                    var3_3 = var6_6;
                    sparseVector2 = sparseVector3;
                    sparseVector = sparseVector4;
                }
                return sparseVector2.activeSize() == 0 ? 0.0f : (sparseVector.activeSize() <= 32 ? var3_3.smallVectors(sparseVector2, sparseVector) : var3_3.bigVectors(sparseVector2, sparseVector));
            }

            public float smallVectors(SparseVector a, SparseVector b) {
                int asize = a.activeSize();
                int bsize = b.activeSize();
                float result = 0.0f;
                int aoff = 0;
                int boff = 0;
                while (aoff < asize && boff < bsize) {
                    if (a.indexAt(aoff) < b.indexAt(boff)) {
                        ++aoff;
                        continue;
                    }
                    if (b.indexAt(boff) < a.indexAt(aoff)) {
                        ++boff;
                        continue;
                    }
                    result += BoxesRunTime.unboxToFloat(a.valueAt(aoff)) * BoxesRunTime.unboxToFloat(b.valueAt(boff));
                    ++aoff;
                    ++boff;
                }
                return result;
            }

            public float bigVectors(SparseVector a, SparseVector b) {
                int asize = a.activeSize();
                int bsize = b.activeSize();
                float result = 0.0f;
                int aoff = 0;
                int boff = 0;
                while (aoff < asize) {
                    int aind = a.indexAt(aoff);
                    int bMax = package$.MODULE$.min(bsize, aind + 1);
                    boff = ArrayUtil$.MODULE$.gallopSearch(b.index(), boff, bMax, aind);
                    if (boff < 0) {
                        if ((boff ^= 0xFFFFFFFF) == bsize) {
                            aoff = asize;
                            continue;
                        }
                        int bind = b.indexAt(boff);
                        int aMax = package$.MODULE$.min(asize, bind + 1);
                        int newAoff = ArrayUtil$.MODULE$.gallopSearch(a.index(), aoff, aMax, bind);
                        if (newAoff < 0) {
                            newAoff ^= 0xFFFFFFFF;
                            ++boff;
                        }
                        aoff = newAoff;
                        continue;
                    }
                    result += BoxesRunTime.unboxToFloat(a.valueAt(aoff)) * BoxesRunTime.unboxToFloat(b.valueAt(boff));
                    ++aoff;
                    ++boff;
                }
                return result;
            }
        });
        $this.breeze$linalg$operators$SparseVectorExpandOps$_setter_$impl_OpMulInner_SV_SV_eq_T_Long_$eq(new UFunc.UImpl2<OpMulInner$, SparseVector<Object>, SparseVector<Object>, Object>($this){
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                ((BinaryRegistry)Predef$.MODULE$.implicitly($outer.impl_OpMulInner_V_V_eq_S_Long())).register(this, ClassTag$.MODULE$.apply(SparseVector.class), ClassTag$.MODULE$.apply(SparseVector.class));
            }

            public long apply(SparseVector a, SparseVector b) {
                $anon$202 var3_3 = this;
                SparseVector sparseVector = b;
                SparseVector sparseVector2 = a;
                while (true) {
                    if (sparseVector.length() != sparseVector2.length()) {
                        throw new IllegalArgumentException(StringOps$.MODULE$.format$extension("requirement failed: %s", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{new StringBuilder(55).append("Vectors must be the same length!").append(": ").append("b.length.==(a.length)").toString()})));
                    }
                    if (sparseVector.activeSize() >= sparseVector2.activeSize()) break;
                    $anon$202 var6_6 = var3_3;
                    SparseVector sparseVector3 = sparseVector;
                    SparseVector sparseVector4 = sparseVector2;
                    var3_3 = var6_6;
                    sparseVector2 = sparseVector3;
                    sparseVector = sparseVector4;
                }
                return sparseVector2.activeSize() == 0 ? 0L : (sparseVector.activeSize() <= 32 ? var3_3.smallVectors(sparseVector2, sparseVector) : var3_3.bigVectors(sparseVector2, sparseVector));
            }

            public long smallVectors(SparseVector a, SparseVector b) {
                int asize = a.activeSize();
                int bsize = b.activeSize();
                long result = 0L;
                int aoff = 0;
                int boff = 0;
                while (aoff < asize && boff < bsize) {
                    if (a.indexAt(aoff) < b.indexAt(boff)) {
                        ++aoff;
                        continue;
                    }
                    if (b.indexAt(boff) < a.indexAt(aoff)) {
                        ++boff;
                        continue;
                    }
                    result += BoxesRunTime.unboxToLong(a.valueAt(aoff)) * BoxesRunTime.unboxToLong(b.valueAt(boff));
                    ++aoff;
                    ++boff;
                }
                return result;
            }

            public long bigVectors(SparseVector a, SparseVector b) {
                int asize = a.activeSize();
                int bsize = b.activeSize();
                long result = 0L;
                int aoff = 0;
                int boff = 0;
                while (aoff < asize) {
                    int aind = a.indexAt(aoff);
                    int bMax = package$.MODULE$.min(bsize, aind + 1);
                    boff = ArrayUtil$.MODULE$.gallopSearch(b.index(), boff, bMax, aind);
                    if (boff < 0) {
                        if ((boff ^= 0xFFFFFFFF) == bsize) {
                            aoff = asize;
                            continue;
                        }
                        int bind = b.indexAt(boff);
                        int aMax = package$.MODULE$.min(asize, bind + 1);
                        int newAoff = ArrayUtil$.MODULE$.gallopSearch(a.index(), aoff, aMax, bind);
                        if (newAoff < 0) {
                            newAoff ^= 0xFFFFFFFF;
                            ++boff;
                        }
                        aoff = newAoff;
                        continue;
                    }
                    result += BoxesRunTime.unboxToLong(a.valueAt(aoff)) * BoxesRunTime.unboxToLong(b.valueAt(boff));
                    ++aoff;
                    ++boff;
                }
                return result;
            }
        });
        $this.breeze$linalg$operators$SparseVectorExpandOps$_setter_$implScaleAdd_SV_S_SV_InPlace_Int_$eq(new UFunc.InPlaceImpl3<scaleAdd$, SparseVector<Object>, Object, SparseVector<Object>>($this){
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                ((TernaryUpdateRegistry)Predef$.MODULE$.implicitly($outer.impl_scaleAdd_InPlace_V_S_V_Int())).register(this, ClassTag$.MODULE$.apply(SparseVector.class), ClassTag$.MODULE$.apply(Integer.TYPE), ClassTag$.MODULE$.apply(SparseVector.class));
            }

            public void apply(SparseVector y, int a, SparseVector x) {
                if (x.length() != y.length()) {
                    throw new IllegalArgumentException(StringOps$.MODULE$.format$extension("requirement failed: %s", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{new StringBuilder(55).append("Vectors must be the same length!").append(": ").append("x.length.==(y.length)").toString()})));
                }
                int asize = y.activeSize();
                int bsize = x.activeSize();
                if (a != 0) {
                    int[] resultI = new int[asize + bsize];
                    int[] resultV = new int[asize + bsize];
                    int resultOff = 0;
                    int boff = 0;
                    for (int aoff = 0; aoff < asize; ++aoff) {
                        int n;
                        while (boff < bsize && x.indexAt(boff) < y.indexAt(aoff)) {
                            resultI[resultOff] = x.indexAt(boff);
                            resultV[resultOff] = a * BoxesRunTime.unboxToInt(x.valueAt(boff));
                            ++resultOff;
                            ++boff;
                        }
                        if (boff < bsize && x.indexAt(boff) == y.indexAt(aoff)) {
                            int bv = a * BoxesRunTime.unboxToInt(x.valueAt(boff));
                            ++boff;
                            n = bv;
                        } else {
                            n = 0;
                        }
                        int bvalue = n;
                        resultI[resultOff] = y.indexAt(aoff);
                        resultV[resultOff] = BoxesRunTime.unboxToInt(y.valueAt(aoff)) + bvalue;
                        ++resultOff;
                    }
                    while (boff < bsize) {
                        resultI[resultOff] = x.indexAt(boff);
                        resultV[resultOff] = a * BoxesRunTime.unboxToInt(x.valueAt(boff));
                        ++resultOff;
                        ++boff;
                    }
                    if (resultOff != resultI.length) {
                        y.use(Arrays.copyOf(resultI, resultOff), Arrays.copyOf(resultV, resultOff), resultOff);
                    } else {
                        y.use(resultI, resultV, resultOff);
                    }
                }
            }
        });
        $this.breeze$linalg$operators$SparseVectorExpandOps$_setter_$implScaleAdd_SV_S_SV_InPlace_Double_$eq(new UFunc.InPlaceImpl3<scaleAdd$, SparseVector<Object>, Object, SparseVector<Object>>($this){
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                ((TernaryUpdateRegistry)Predef$.MODULE$.implicitly($outer.impl_scaleAdd_InPlace_V_S_V_Double())).register(this, ClassTag$.MODULE$.apply(SparseVector.class), ClassTag$.MODULE$.apply(Double.TYPE), ClassTag$.MODULE$.apply(SparseVector.class));
            }

            public void apply(SparseVector y, double a, SparseVector x) {
                if (x.length() != y.length()) {
                    throw new IllegalArgumentException(StringOps$.MODULE$.format$extension("requirement failed: %s", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{new StringBuilder(55).append("Vectors must be the same length!").append(": ").append("x.length.==(y.length)").toString()})));
                }
                int asize = y.activeSize();
                int bsize = x.activeSize();
                if (a != 0.0) {
                    int[] resultI = new int[asize + bsize];
                    double[] resultV = new double[asize + bsize];
                    int resultOff = 0;
                    int boff = 0;
                    for (int aoff = 0; aoff < asize; ++aoff) {
                        double d;
                        while (boff < bsize && x.indexAt(boff) < y.indexAt(aoff)) {
                            resultI[resultOff] = x.indexAt(boff);
                            resultV[resultOff] = a * BoxesRunTime.unboxToDouble(x.valueAt(boff));
                            ++resultOff;
                            ++boff;
                        }
                        if (boff < bsize && x.indexAt(boff) == y.indexAt(aoff)) {
                            double bv = a * BoxesRunTime.unboxToDouble(x.valueAt(boff));
                            ++boff;
                            d = bv;
                        } else {
                            d = 0.0;
                        }
                        double bvalue = d;
                        resultI[resultOff] = y.indexAt(aoff);
                        resultV[resultOff] = BoxesRunTime.unboxToDouble(y.valueAt(aoff)) + bvalue;
                        ++resultOff;
                    }
                    while (boff < bsize) {
                        resultI[resultOff] = x.indexAt(boff);
                        resultV[resultOff] = a * BoxesRunTime.unboxToDouble(x.valueAt(boff));
                        ++resultOff;
                        ++boff;
                    }
                    if (resultOff != resultI.length) {
                        y.use(Arrays.copyOf(resultI, resultOff), Arrays.copyOf(resultV, resultOff), resultOff);
                    } else {
                        y.use(resultI, resultV, resultOff);
                    }
                }
            }
        });
        $this.breeze$linalg$operators$SparseVectorExpandOps$_setter_$implScaleAdd_SV_S_SV_InPlace_Float_$eq(new UFunc.InPlaceImpl3<scaleAdd$, SparseVector<Object>, Object, SparseVector<Object>>($this){
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                ((TernaryUpdateRegistry)Predef$.MODULE$.implicitly($outer.impl_scaleAdd_InPlace_V_S_V_Float())).register(this, ClassTag$.MODULE$.apply(SparseVector.class), ClassTag$.MODULE$.apply(Float.TYPE), ClassTag$.MODULE$.apply(SparseVector.class));
            }

            public void apply(SparseVector y, float a, SparseVector x) {
                if (x.length() != y.length()) {
                    throw new IllegalArgumentException(StringOps$.MODULE$.format$extension("requirement failed: %s", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{new StringBuilder(55).append("Vectors must be the same length!").append(": ").append("x.length.==(y.length)").toString()})));
                }
                int asize = y.activeSize();
                int bsize = x.activeSize();
                if (a != 0.0f) {
                    int[] resultI = new int[asize + bsize];
                    float[] resultV = new float[asize + bsize];
                    int resultOff = 0;
                    int boff = 0;
                    for (int aoff = 0; aoff < asize; ++aoff) {
                        float f;
                        while (boff < bsize && x.indexAt(boff) < y.indexAt(aoff)) {
                            resultI[resultOff] = x.indexAt(boff);
                            resultV[resultOff] = a * BoxesRunTime.unboxToFloat(x.valueAt(boff));
                            ++resultOff;
                            ++boff;
                        }
                        if (boff < bsize && x.indexAt(boff) == y.indexAt(aoff)) {
                            float bv = a * BoxesRunTime.unboxToFloat(x.valueAt(boff));
                            ++boff;
                            f = bv;
                        } else {
                            f = 0.0f;
                        }
                        float bvalue = f;
                        resultI[resultOff] = y.indexAt(aoff);
                        resultV[resultOff] = BoxesRunTime.unboxToFloat(y.valueAt(aoff)) + bvalue;
                        ++resultOff;
                    }
                    while (boff < bsize) {
                        resultI[resultOff] = x.indexAt(boff);
                        resultV[resultOff] = a * BoxesRunTime.unboxToFloat(x.valueAt(boff));
                        ++resultOff;
                        ++boff;
                    }
                    if (resultOff != resultI.length) {
                        y.use(Arrays.copyOf(resultI, resultOff), Arrays.copyOf(resultV, resultOff), resultOff);
                    } else {
                        y.use(resultI, resultV, resultOff);
                    }
                }
            }
        });
        $this.breeze$linalg$operators$SparseVectorExpandOps$_setter_$implScaleAdd_SV_S_SV_InPlace_Long_$eq(new UFunc.InPlaceImpl3<scaleAdd$, SparseVector<Object>, Object, SparseVector<Object>>($this){
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                ((TernaryUpdateRegistry)Predef$.MODULE$.implicitly($outer.impl_scaleAdd_InPlace_V_S_V_Long())).register(this, ClassTag$.MODULE$.apply(SparseVector.class), ClassTag$.MODULE$.apply(Long.TYPE), ClassTag$.MODULE$.apply(SparseVector.class));
            }

            public void apply(SparseVector y, long a, SparseVector x) {
                if (x.length() != y.length()) {
                    throw new IllegalArgumentException(StringOps$.MODULE$.format$extension("requirement failed: %s", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{new StringBuilder(55).append("Vectors must be the same length!").append(": ").append("x.length.==(y.length)").toString()})));
                }
                int asize = y.activeSize();
                int bsize = x.activeSize();
                if (a != 0L) {
                    int[] resultI = new int[asize + bsize];
                    long[] resultV = new long[asize + bsize];
                    int resultOff = 0;
                    int boff = 0;
                    for (int aoff = 0; aoff < asize; ++aoff) {
                        long l;
                        while (boff < bsize && x.indexAt(boff) < y.indexAt(aoff)) {
                            resultI[resultOff] = x.indexAt(boff);
                            resultV[resultOff] = a * BoxesRunTime.unboxToLong(x.valueAt(boff));
                            ++resultOff;
                            ++boff;
                        }
                        if (boff < bsize && x.indexAt(boff) == y.indexAt(aoff)) {
                            long bv = a * BoxesRunTime.unboxToLong(x.valueAt(boff));
                            ++boff;
                            l = bv;
                        } else {
                            l = 0L;
                        }
                        long bvalue = l;
                        resultI[resultOff] = y.indexAt(aoff);
                        resultV[resultOff] = BoxesRunTime.unboxToLong(y.valueAt(aoff)) + bvalue;
                        ++resultOff;
                    }
                    while (boff < bsize) {
                        resultI[resultOff] = x.indexAt(boff);
                        resultV[resultOff] = a * BoxesRunTime.unboxToLong(x.valueAt(boff));
                        ++resultOff;
                        ++boff;
                    }
                    if (resultOff != resultI.length) {
                        y.use(Arrays.copyOf(resultI, resultOff), Arrays.copyOf(resultV, resultOff), resultOff);
                    } else {
                        y.use(resultI, resultV, resultOff);
                    }
                }
            }
        });
        $this.breeze$linalg$operators$SparseVectorExpandOps$_setter_$zipMap_d_$eq(new CanZipMapValuesSparseVector($this, ClassTag$.MODULE$.apply(Double.TYPE), Zero$.MODULE$.DoubleZero(), Semiring$.MODULE$.semiringD()));
        $this.breeze$linalg$operators$SparseVectorExpandOps$_setter_$zipMap_f_$eq(new CanZipMapValuesSparseVector($this, ClassTag$.MODULE$.apply(Float.TYPE), Zero$.MODULE$.FloatZero(), Semiring$.MODULE$.semiringFloat()));
        $this.breeze$linalg$operators$SparseVectorExpandOps$_setter_$zipMap_i_$eq(new CanZipMapValuesSparseVector($this, ClassTag$.MODULE$.apply(Integer.TYPE), Zero$.MODULE$.IntZero(), Semiring$.MODULE$.semiringInt()));
    }

    public static UFunc.UImpl2 liftCSCOpToSVransposeOp$(SparseVectorExpandOps $this, UFunc.UImpl2 op, Zero zero, ClassTag ct) {
        return $this.liftCSCOpToSVransposeOp(op, zero, ct);
    }

    default public <Tag, V, LHS, R> UFunc.UImpl2<Tag, LHS, Transpose<SparseVector<V>>, R> liftCSCOpToSVransposeOp(UFunc.UImpl2<Tag, LHS, CSCMatrix<V>, R> op, Zero<V> zero, ClassTag<V> ct) {
        return new UFunc.UImpl2<Tag, LHS, Transpose<SparseVector<V>>, R>(op, ct){
            private final UFunc.UImpl2 op$1;
            private final ClassTag ct$1;
            {
                this.op$1 = op$2;
                this.ct$1 = ct$2;
            }

            public Object apply(Object v, Transpose v2) {
                return this.op$1.apply(v, ((SparseVector)v2.inner()).asCscRow(this.ct$1));
            }
        };
    }

    public UFunc.UImpl2<OpAdd$, SparseVector<Object>, SparseVector<Object>, SparseVector<Object>> impl_Op_SV_SV_eq_SV_Int_OpAdd();

    public void breeze$linalg$operators$SparseVectorExpandOps$_setter_$impl_Op_SV_SV_eq_SV_Int_OpAdd_$eq(UFunc.UImpl2 var1);

    public UFunc.UImpl2<OpAdd$, SparseVector<Object>, SparseVector<Object>, SparseVector<Object>> impl_Op_SV_SV_eq_SV_Double_OpAdd();

    public void breeze$linalg$operators$SparseVectorExpandOps$_setter_$impl_Op_SV_SV_eq_SV_Double_OpAdd_$eq(UFunc.UImpl2 var1);

    public UFunc.UImpl2<OpAdd$, SparseVector<Object>, SparseVector<Object>, SparseVector<Object>> impl_Op_SV_SV_eq_SV_Float_OpAdd();

    public void breeze$linalg$operators$SparseVectorExpandOps$_setter_$impl_Op_SV_SV_eq_SV_Float_OpAdd_$eq(UFunc.UImpl2 var1);

    public UFunc.UImpl2<OpAdd$, SparseVector<Object>, SparseVector<Object>, SparseVector<Object>> impl_Op_SV_SV_eq_SV_Long_OpAdd();

    public void breeze$linalg$operators$SparseVectorExpandOps$_setter_$impl_Op_SV_SV_eq_SV_Long_OpAdd_$eq(UFunc.UImpl2 var1);

    public UFunc.UImpl2<OpSub$, SparseVector<Object>, SparseVector<Object>, SparseVector<Object>> impl_Op_SV_SV_eq_SV_Int_OpSub();

    public void breeze$linalg$operators$SparseVectorExpandOps$_setter_$impl_Op_SV_SV_eq_SV_Int_OpSub_$eq(UFunc.UImpl2 var1);

    public UFunc.UImpl2<OpSub$, SparseVector<Object>, SparseVector<Object>, SparseVector<Object>> impl_Op_SV_SV_eq_SV_Double_OpSub();

    public void breeze$linalg$operators$SparseVectorExpandOps$_setter_$impl_Op_SV_SV_eq_SV_Double_OpSub_$eq(UFunc.UImpl2 var1);

    public UFunc.UImpl2<OpSub$, SparseVector<Object>, SparseVector<Object>, SparseVector<Object>> impl_Op_SV_SV_eq_SV_Float_OpSub();

    public void breeze$linalg$operators$SparseVectorExpandOps$_setter_$impl_Op_SV_SV_eq_SV_Float_OpSub_$eq(UFunc.UImpl2 var1);

    public UFunc.UImpl2<OpSub$, SparseVector<Object>, SparseVector<Object>, SparseVector<Object>> impl_Op_SV_SV_eq_SV_Long_OpSub();

    public void breeze$linalg$operators$SparseVectorExpandOps$_setter_$impl_Op_SV_SV_eq_SV_Long_OpSub_$eq(UFunc.UImpl2 var1);

    public static UFunc.UImpl2 implSubOp_SV_SV_eq_SV$(SparseVectorExpandOps $this, Ring evidence$1, ClassTag evidence$2) {
        return $this.implSubOp_SV_SV_eq_SV(evidence$1, evidence$2);
    }

    default public <T> UFunc.UImpl2<OpSub$, SparseVector<T>, SparseVector<T>, SparseVector<T>> implSubOp_SV_SV_eq_SV(Ring<T> evidence$1, ClassTag<T> evidence$2) {
        return new UFunc.UImpl2<OpSub$, SparseVector<T>, SparseVector<T>, SparseVector<T>>(evidence$1, evidence$2){
            private final Ring evidence$1$2;
            private final ClassTag evidence$2$2;
            private final Ring r;
            {
                this.evidence$1$2 = evidence$1$1;
                this.evidence$2$2 = evidence$2$1;
                this.r = (Ring)Predef$.MODULE$.implicitly((Object)evidence$1$1);
            }

            public Ring r() {
                return this.r;
            }

            public SparseVector apply(SparseVector a, SparseVector b) {
                SparseVector<T> sparseVector;
                if (b.length() != a.length()) {
                    throw new IllegalArgumentException(StringOps$.MODULE$.format$extension("requirement failed: %s", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{new StringBuilder(55).append("Vectors must be the same length!").append(": ").append("b.length.==(a.length)").toString()})));
                }
                int asize = a.activeSize();
                int bsize = b.activeSize();
                V q = this.r().zero();
                int[] resultI = new int[asize + bsize];
                Object resultV = Arrays$.MODULE$.newGenericArray(asize + bsize, this.evidence$2$2);
                int resultOff = 0;
                int boff = 0;
                for (int aoff = 0; aoff < asize; ++aoff) {
                    V v;
                    while (boff < bsize && b.indexAt(boff) < a.indexAt(aoff)) {
                        resultI[resultOff] = b.indexAt(boff);
                        ScalaRunTime$.MODULE$.array_update(resultV, resultOff, this.r().$minus(q, b.valueAt(boff)));
                        ++resultOff;
                        ++boff;
                    }
                    if (boff < bsize && b.indexAt(boff) == a.indexAt(aoff)) {
                        V bv = b.valueAt(boff);
                        ++boff;
                        v = bv;
                    } else {
                        v = q;
                    }
                    V bvalue = v;
                    resultI[resultOff] = a.indexAt(aoff);
                    ScalaRunTime$.MODULE$.array_update(resultV, resultOff, this.r().$minus(a.valueAt(aoff), bvalue));
                    ++resultOff;
                }
                while (boff < bsize) {
                    resultI[resultOff] = b.indexAt(boff);
                    ScalaRunTime$.MODULE$.array_update(resultV, resultOff, this.r().$minus(q, b.valueAt(boff)));
                    ++resultOff;
                    ++boff;
                }
                if (resultOff != resultI.length) {
                    Object dat = Arrays$.MODULE$.newGenericArray(resultOff, this.evidence$2$2);
                    Array$.MODULE$.copy(resultV, 0, dat, 0, resultOff);
                    sparseVector = new SparseVector<T>(Arrays.copyOf(resultI, resultOff), dat, resultOff, a.length(), Zero$.MODULE$.zeroFromSemiring(this.evidence$1$2));
                } else {
                    sparseVector = new SparseVector<T>(resultI, resultV, resultOff, a.length(), Zero$.MODULE$.zeroFromSemiring(this.evidence$1$2));
                }
                return sparseVector;
            }
        };
    }

    public static UFunc.UImpl2 implAddOp_SV_SV_eq_SV$(SparseVectorExpandOps $this, Semiring evidence$3, ClassTag evidence$4) {
        return $this.implAddOp_SV_SV_eq_SV(evidence$3, evidence$4);
    }

    default public <T> UFunc.UImpl2<OpAdd$, SparseVector<T>, SparseVector<T>, SparseVector<T>> implAddOp_SV_SV_eq_SV(Semiring<T> evidence$3, ClassTag<T> evidence$4) {
        return new UFunc.UImpl2<OpAdd$, SparseVector<T>, SparseVector<T>, SparseVector<T>>(evidence$3, evidence$4){
            private final Semiring evidence$3$2;
            private final ClassTag evidence$4$2;
            private final Semiring r;
            {
                this.evidence$3$2 = evidence$3$1;
                this.evidence$4$2 = evidence$4$1;
                this.r = (Semiring)Predef$.MODULE$.implicitly((Object)evidence$3$1);
            }

            public Semiring r() {
                return this.r;
            }

            public SparseVector apply(SparseVector a, SparseVector b) {
                SparseVector<T> sparseVector;
                if (b.length() != a.length()) {
                    throw new IllegalArgumentException(StringOps$.MODULE$.format$extension("requirement failed: %s", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{new StringBuilder(55).append("Vectors must be the same length!").append(": ").append("b.length.==(a.length)").toString()})));
                }
                int asize = a.activeSize();
                int bsize = b.activeSize();
                V q = this.r().zero();
                int[] resultI = new int[asize + bsize];
                Object resultV = Arrays$.MODULE$.newGenericArray(asize + bsize, this.evidence$4$2);
                int resultOff = 0;
                int boff = 0;
                for (int aoff = 0; aoff < asize; ++aoff) {
                    V v;
                    while (boff < bsize && b.indexAt(boff) < a.indexAt(aoff)) {
                        resultI[resultOff] = b.indexAt(boff);
                        ScalaRunTime$.MODULE$.array_update(resultV, resultOff, this.r().$plus(q, b.valueAt(boff)));
                        ++resultOff;
                        ++boff;
                    }
                    if (boff < bsize && b.indexAt(boff) == a.indexAt(aoff)) {
                        V bv = b.valueAt(boff);
                        ++boff;
                        v = bv;
                    } else {
                        v = q;
                    }
                    V bvalue = v;
                    resultI[resultOff] = a.indexAt(aoff);
                    ScalaRunTime$.MODULE$.array_update(resultV, resultOff, this.r().$plus(a.valueAt(aoff), bvalue));
                    ++resultOff;
                }
                while (boff < bsize) {
                    resultI[resultOff] = b.indexAt(boff);
                    ScalaRunTime$.MODULE$.array_update(resultV, resultOff, this.r().$plus(q, b.valueAt(boff)));
                    ++resultOff;
                    ++boff;
                }
                if (resultOff != resultI.length) {
                    Object dat = Arrays$.MODULE$.newGenericArray(resultOff, this.evidence$4$2);
                    Array$.MODULE$.copy(resultV, 0, dat, 0, resultOff);
                    sparseVector = new SparseVector<T>(Arrays.copyOf(resultI, resultOff), dat, resultOff, a.length(), Zero$.MODULE$.zeroFromSemiring(this.evidence$3$2));
                } else {
                    sparseVector = new SparseVector<T>(resultI, resultV, resultOff, a.length(), Zero$.MODULE$.zeroFromSemiring(this.evidence$3$2));
                }
                return sparseVector;
            }
        };
    }

    public UFunc.UImpl2<OpMulScalar$, SparseVector<Object>, SparseVector<Object>, SparseVector<Object>> impl_OpMulScalar_SV_SV_eq_SV_Int();

    public void breeze$linalg$operators$SparseVectorExpandOps$_setter_$impl_OpMulScalar_SV_SV_eq_SV_Int_$eq(UFunc.UImpl2 var1);

    public UFunc.UImpl2<OpMulScalar$, SparseVector<Object>, SparseVector<Object>, SparseVector<Object>> impl_OpMulScalar_SV_SV_eq_SV_Double();

    public void breeze$linalg$operators$SparseVectorExpandOps$_setter_$impl_OpMulScalar_SV_SV_eq_SV_Double_$eq(UFunc.UImpl2 var1);

    public UFunc.UImpl2<OpMulScalar$, SparseVector<Object>, SparseVector<Object>, SparseVector<Object>> impl_OpMulScalar_SV_SV_eq_SV_Float();

    public void breeze$linalg$operators$SparseVectorExpandOps$_setter_$impl_OpMulScalar_SV_SV_eq_SV_Float_$eq(UFunc.UImpl2 var1);

    public UFunc.UImpl2<OpMulScalar$, SparseVector<Object>, SparseVector<Object>, SparseVector<Object>> impl_OpMulScalar_SV_SV_eq_SV_Long();

    public void breeze$linalg$operators$SparseVectorExpandOps$_setter_$impl_OpMulScalar_SV_SV_eq_SV_Long_$eq(UFunc.UImpl2 var1);

    public UFunc.UImpl2<OpDiv$, SparseVector<Object>, SparseVector<Object>, SparseVector<Object>> impl_Op_SV_SV_eq_SV_Int_OpDiv();

    public void breeze$linalg$operators$SparseVectorExpandOps$_setter_$impl_Op_SV_SV_eq_SV_Int_OpDiv_$eq(UFunc.UImpl2 var1);

    public UFunc.UImpl2<OpDiv$, SparseVector<Object>, SparseVector<Object>, SparseVector<Object>> impl_Op_SV_SV_eq_SV_Double_OpDiv();

    public void breeze$linalg$operators$SparseVectorExpandOps$_setter_$impl_Op_SV_SV_eq_SV_Double_OpDiv_$eq(UFunc.UImpl2 var1);

    public UFunc.UImpl2<OpDiv$, SparseVector<Object>, SparseVector<Object>, SparseVector<Object>> impl_Op_SV_SV_eq_SV_Float_OpDiv();

    public void breeze$linalg$operators$SparseVectorExpandOps$_setter_$impl_Op_SV_SV_eq_SV_Float_OpDiv_$eq(UFunc.UImpl2 var1);

    public UFunc.UImpl2<OpDiv$, SparseVector<Object>, SparseVector<Object>, SparseVector<Object>> impl_Op_SV_SV_eq_SV_Long_OpDiv();

    public void breeze$linalg$operators$SparseVectorExpandOps$_setter_$impl_Op_SV_SV_eq_SV_Long_OpDiv_$eq(UFunc.UImpl2 var1);

    public UFunc.UImpl2<OpSet$, SparseVector<Object>, SparseVector<Object>, SparseVector<Object>> impl_Op_SV_SV_eq_SV_Int_OpSet();

    public void breeze$linalg$operators$SparseVectorExpandOps$_setter_$impl_Op_SV_SV_eq_SV_Int_OpSet_$eq(UFunc.UImpl2 var1);

    public UFunc.UImpl2<OpSet$, SparseVector<Object>, SparseVector<Object>, SparseVector<Object>> impl_Op_SV_SV_eq_SV_Double_OpSet();

    public void breeze$linalg$operators$SparseVectorExpandOps$_setter_$impl_Op_SV_SV_eq_SV_Double_OpSet_$eq(UFunc.UImpl2 var1);

    public UFunc.UImpl2<OpSet$, SparseVector<Object>, SparseVector<Object>, SparseVector<Object>> impl_Op_SV_SV_eq_SV_Float_OpSet();

    public void breeze$linalg$operators$SparseVectorExpandOps$_setter_$impl_Op_SV_SV_eq_SV_Float_OpSet_$eq(UFunc.UImpl2 var1);

    public UFunc.UImpl2<OpSet$, SparseVector<Object>, SparseVector<Object>, SparseVector<Object>> impl_Op_SV_SV_eq_SV_Long_OpSet();

    public void breeze$linalg$operators$SparseVectorExpandOps$_setter_$impl_Op_SV_SV_eq_SV_Long_OpSet_$eq(UFunc.UImpl2 var1);

    public UFunc.UImpl2<OpMod$, SparseVector<Object>, SparseVector<Object>, SparseVector<Object>> impl_Op_SV_SV_eq_SV_Int_OpMod();

    public void breeze$linalg$operators$SparseVectorExpandOps$_setter_$impl_Op_SV_SV_eq_SV_Int_OpMod_$eq(UFunc.UImpl2 var1);

    public UFunc.UImpl2<OpMod$, SparseVector<Object>, SparseVector<Object>, SparseVector<Object>> impl_Op_SV_SV_eq_SV_Double_OpMod();

    public void breeze$linalg$operators$SparseVectorExpandOps$_setter_$impl_Op_SV_SV_eq_SV_Double_OpMod_$eq(UFunc.UImpl2 var1);

    public UFunc.UImpl2<OpMod$, SparseVector<Object>, SparseVector<Object>, SparseVector<Object>> impl_Op_SV_SV_eq_SV_Float_OpMod();

    public void breeze$linalg$operators$SparseVectorExpandOps$_setter_$impl_Op_SV_SV_eq_SV_Float_OpMod_$eq(UFunc.UImpl2 var1);

    public UFunc.UImpl2<OpMod$, SparseVector<Object>, SparseVector<Object>, SparseVector<Object>> impl_Op_SV_SV_eq_SV_Long_OpMod();

    public void breeze$linalg$operators$SparseVectorExpandOps$_setter_$impl_Op_SV_SV_eq_SV_Long_OpMod_$eq(UFunc.UImpl2 var1);

    public UFunc.UImpl2<OpPow$, SparseVector<Object>, SparseVector<Object>, SparseVector<Object>> impl_Op_SV_SV_eq_SV_Int_OpPow();

    public void breeze$linalg$operators$SparseVectorExpandOps$_setter_$impl_Op_SV_SV_eq_SV_Int_OpPow_$eq(UFunc.UImpl2 var1);

    public UFunc.UImpl2<OpPow$, SparseVector<Object>, SparseVector<Object>, SparseVector<Object>> impl_Op_SV_SV_eq_SV_Double_OpPow();

    public void breeze$linalg$operators$SparseVectorExpandOps$_setter_$impl_Op_SV_SV_eq_SV_Double_OpPow_$eq(UFunc.UImpl2 var1);

    public UFunc.UImpl2<OpPow$, SparseVector<Object>, SparseVector<Object>, SparseVector<Object>> impl_Op_SV_SV_eq_SV_Float_OpPow();

    public void breeze$linalg$operators$SparseVectorExpandOps$_setter_$impl_Op_SV_SV_eq_SV_Float_OpPow_$eq(UFunc.UImpl2 var1);

    public UFunc.UImpl2<OpPow$, SparseVector<Object>, SparseVector<Object>, SparseVector<Object>> impl_Op_SV_SV_eq_SV_Long_OpPow();

    public void breeze$linalg$operators$SparseVectorExpandOps$_setter_$impl_Op_SV_SV_eq_SV_Long_OpPow_$eq(UFunc.UImpl2 var1);

    public UFunc.UImpl2<OpDiv$, SparseVector<Object>, Vector<Object>, SparseVector<Object>> impl_Op_SV_V_eq_SV_Int_OpDiv();

    public void breeze$linalg$operators$SparseVectorExpandOps$_setter_$impl_Op_SV_V_eq_SV_Int_OpDiv_$eq(UFunc.UImpl2 var1);

    public UFunc.UImpl2<OpDiv$, SparseVector<Object>, Vector<Object>, SparseVector<Object>> impl_Op_SV_V_eq_SV_Double_OpDiv();

    public void breeze$linalg$operators$SparseVectorExpandOps$_setter_$impl_Op_SV_V_eq_SV_Double_OpDiv_$eq(UFunc.UImpl2 var1);

    public UFunc.UImpl2<OpDiv$, SparseVector<Object>, Vector<Object>, SparseVector<Object>> impl_Op_SV_V_eq_SV_Float_OpDiv();

    public void breeze$linalg$operators$SparseVectorExpandOps$_setter_$impl_Op_SV_V_eq_SV_Float_OpDiv_$eq(UFunc.UImpl2 var1);

    public UFunc.UImpl2<OpDiv$, SparseVector<Object>, Vector<Object>, SparseVector<Object>> impl_Op_SV_V_eq_SV_Long_OpDiv();

    public void breeze$linalg$operators$SparseVectorExpandOps$_setter_$impl_Op_SV_V_eq_SV_Long_OpDiv_$eq(UFunc.UImpl2 var1);

    public UFunc.UImpl2<OpSet$, SparseVector<Object>, Vector<Object>, SparseVector<Object>> impl_Op_SV_V_eq_SV_Int_OpSet();

    public void breeze$linalg$operators$SparseVectorExpandOps$_setter_$impl_Op_SV_V_eq_SV_Int_OpSet_$eq(UFunc.UImpl2 var1);

    public UFunc.UImpl2<OpSet$, SparseVector<Object>, Vector<Object>, SparseVector<Object>> impl_Op_SV_V_eq_SV_Double_OpSet();

    public void breeze$linalg$operators$SparseVectorExpandOps$_setter_$impl_Op_SV_V_eq_SV_Double_OpSet_$eq(UFunc.UImpl2 var1);

    public UFunc.UImpl2<OpSet$, SparseVector<Object>, Vector<Object>, SparseVector<Object>> impl_Op_SV_V_eq_SV_Float_OpSet();

    public void breeze$linalg$operators$SparseVectorExpandOps$_setter_$impl_Op_SV_V_eq_SV_Float_OpSet_$eq(UFunc.UImpl2 var1);

    public UFunc.UImpl2<OpSet$, SparseVector<Object>, Vector<Object>, SparseVector<Object>> impl_Op_SV_V_eq_SV_Long_OpSet();

    public void breeze$linalg$operators$SparseVectorExpandOps$_setter_$impl_Op_SV_V_eq_SV_Long_OpSet_$eq(UFunc.UImpl2 var1);

    public UFunc.UImpl2<OpMod$, SparseVector<Object>, Vector<Object>, SparseVector<Object>> impl_Op_SV_V_eq_SV_Int_OpMod();

    public void breeze$linalg$operators$SparseVectorExpandOps$_setter_$impl_Op_SV_V_eq_SV_Int_OpMod_$eq(UFunc.UImpl2 var1);

    public UFunc.UImpl2<OpMod$, SparseVector<Object>, Vector<Object>, SparseVector<Object>> impl_Op_SV_V_eq_SV_Double_OpMod();

    public void breeze$linalg$operators$SparseVectorExpandOps$_setter_$impl_Op_SV_V_eq_SV_Double_OpMod_$eq(UFunc.UImpl2 var1);

    public UFunc.UImpl2<OpMod$, SparseVector<Object>, Vector<Object>, SparseVector<Object>> impl_Op_SV_V_eq_SV_Float_OpMod();

    public void breeze$linalg$operators$SparseVectorExpandOps$_setter_$impl_Op_SV_V_eq_SV_Float_OpMod_$eq(UFunc.UImpl2 var1);

    public UFunc.UImpl2<OpMod$, SparseVector<Object>, Vector<Object>, SparseVector<Object>> impl_Op_SV_V_eq_SV_Long_OpMod();

    public void breeze$linalg$operators$SparseVectorExpandOps$_setter_$impl_Op_SV_V_eq_SV_Long_OpMod_$eq(UFunc.UImpl2 var1);

    public UFunc.UImpl2<OpPow$, SparseVector<Object>, Vector<Object>, SparseVector<Object>> impl_Op_SV_V_eq_SV_Int_OpPow();

    public void breeze$linalg$operators$SparseVectorExpandOps$_setter_$impl_Op_SV_V_eq_SV_Int_OpPow_$eq(UFunc.UImpl2 var1);

    public UFunc.UImpl2<OpPow$, SparseVector<Object>, Vector<Object>, SparseVector<Object>> impl_Op_SV_V_eq_SV_Double_OpPow();

    public void breeze$linalg$operators$SparseVectorExpandOps$_setter_$impl_Op_SV_V_eq_SV_Double_OpPow_$eq(UFunc.UImpl2 var1);

    public UFunc.UImpl2<OpPow$, SparseVector<Object>, Vector<Object>, SparseVector<Object>> impl_Op_SV_V_eq_SV_Float_OpPow();

    public void breeze$linalg$operators$SparseVectorExpandOps$_setter_$impl_Op_SV_V_eq_SV_Float_OpPow_$eq(UFunc.UImpl2 var1);

    public UFunc.UImpl2<OpPow$, SparseVector<Object>, Vector<Object>, SparseVector<Object>> impl_Op_SV_V_eq_SV_Long_OpPow();

    public void breeze$linalg$operators$SparseVectorExpandOps$_setter_$impl_Op_SV_V_eq_SV_Long_OpPow_$eq(UFunc.UImpl2 var1);

    public UFunc.UImpl2<OpAdd$, SparseVector<Object>, Object, SparseVector<Object>> impl_Op_SV_S_eq_SV_Int_OpAdd();

    public void breeze$linalg$operators$SparseVectorExpandOps$_setter_$impl_Op_SV_S_eq_SV_Int_OpAdd_$eq(UFunc.UImpl2 var1);

    public UFunc.UImpl2<OpAdd$, SparseVector<Object>, Object, SparseVector<Object>> impl_Op_SV_S_eq_SV_Double_OpAdd();

    public void breeze$linalg$operators$SparseVectorExpandOps$_setter_$impl_Op_SV_S_eq_SV_Double_OpAdd_$eq(UFunc.UImpl2 var1);

    public UFunc.UImpl2<OpAdd$, SparseVector<Object>, Object, SparseVector<Object>> impl_Op_SV_S_eq_SV_Float_OpAdd();

    public void breeze$linalg$operators$SparseVectorExpandOps$_setter_$impl_Op_SV_S_eq_SV_Float_OpAdd_$eq(UFunc.UImpl2 var1);

    public UFunc.UImpl2<OpAdd$, SparseVector<Object>, Object, SparseVector<Object>> impl_Op_SV_S_eq_SV_Long_OpAdd();

    public void breeze$linalg$operators$SparseVectorExpandOps$_setter_$impl_Op_SV_S_eq_SV_Long_OpAdd_$eq(UFunc.UImpl2 var1);

    public UFunc.UImpl2<OpSub$, SparseVector<Object>, Object, SparseVector<Object>> impl_Op_SV_S_eq_SV_Int_OpSub();

    public void breeze$linalg$operators$SparseVectorExpandOps$_setter_$impl_Op_SV_S_eq_SV_Int_OpSub_$eq(UFunc.UImpl2 var1);

    public UFunc.UImpl2<OpSub$, SparseVector<Object>, Object, SparseVector<Object>> impl_Op_SV_S_eq_SV_Double_OpSub();

    public void breeze$linalg$operators$SparseVectorExpandOps$_setter_$impl_Op_SV_S_eq_SV_Double_OpSub_$eq(UFunc.UImpl2 var1);

    public UFunc.UImpl2<OpSub$, SparseVector<Object>, Object, SparseVector<Object>> impl_Op_SV_S_eq_SV_Float_OpSub();

    public void breeze$linalg$operators$SparseVectorExpandOps$_setter_$impl_Op_SV_S_eq_SV_Float_OpSub_$eq(UFunc.UImpl2 var1);

    public UFunc.UImpl2<OpSub$, SparseVector<Object>, Object, SparseVector<Object>> impl_Op_SV_S_eq_SV_Long_OpSub();

    public void breeze$linalg$operators$SparseVectorExpandOps$_setter_$impl_Op_SV_S_eq_SV_Long_OpSub_$eq(UFunc.UImpl2 var1);

    public UFunc.UImpl2<OpSet$, SparseVector<Object>, Object, SparseVector<Object>> impl_Op_SV_S_eq_SV_Int_OpSet();

    public void breeze$linalg$operators$SparseVectorExpandOps$_setter_$impl_Op_SV_S_eq_SV_Int_OpSet_$eq(UFunc.UImpl2 var1);

    public UFunc.UImpl2<OpSet$, SparseVector<Object>, Object, SparseVector<Object>> impl_Op_SV_S_eq_SV_Double_OpSet();

    public void breeze$linalg$operators$SparseVectorExpandOps$_setter_$impl_Op_SV_S_eq_SV_Double_OpSet_$eq(UFunc.UImpl2 var1);

    public UFunc.UImpl2<OpSet$, SparseVector<Object>, Object, SparseVector<Object>> impl_Op_SV_S_eq_SV_Float_OpSet();

    public void breeze$linalg$operators$SparseVectorExpandOps$_setter_$impl_Op_SV_S_eq_SV_Float_OpSet_$eq(UFunc.UImpl2 var1);

    public UFunc.UImpl2<OpSet$, SparseVector<Object>, Object, SparseVector<Object>> impl_Op_SV_S_eq_SV_Long_OpSet();

    public void breeze$linalg$operators$SparseVectorExpandOps$_setter_$impl_Op_SV_S_eq_SV_Long_OpSet_$eq(UFunc.UImpl2 var1);

    public UFunc.UImpl2<OpPow$, SparseVector<Object>, Object, SparseVector<Object>> impl_Op_SV_S_eq_SV_Int_OpPow();

    public void breeze$linalg$operators$SparseVectorExpandOps$_setter_$impl_Op_SV_S_eq_SV_Int_OpPow_$eq(UFunc.UImpl2 var1);

    public UFunc.UImpl2<OpPow$, SparseVector<Object>, Object, SparseVector<Object>> impl_Op_SV_S_eq_SV_Double_OpPow();

    public void breeze$linalg$operators$SparseVectorExpandOps$_setter_$impl_Op_SV_S_eq_SV_Double_OpPow_$eq(UFunc.UImpl2 var1);

    public UFunc.UImpl2<OpPow$, SparseVector<Object>, Object, SparseVector<Object>> impl_Op_SV_S_eq_SV_Float_OpPow();

    public void breeze$linalg$operators$SparseVectorExpandOps$_setter_$impl_Op_SV_S_eq_SV_Float_OpPow_$eq(UFunc.UImpl2 var1);

    public UFunc.UImpl2<OpPow$, SparseVector<Object>, Object, SparseVector<Object>> impl_Op_SV_S_eq_SV_Long_OpPow();

    public void breeze$linalg$operators$SparseVectorExpandOps$_setter_$impl_Op_SV_S_eq_SV_Long_OpPow_$eq(UFunc.UImpl2 var1);

    public UFunc.UImpl2<OpDiv$, SparseVector<Object>, Object, SparseVector<Object>> impl_Op_SV_S_eq_SV_Int_OpDiv();

    public void breeze$linalg$operators$SparseVectorExpandOps$_setter_$impl_Op_SV_S_eq_SV_Int_OpDiv_$eq(UFunc.UImpl2 var1);

    public UFunc.UImpl2<OpDiv$, SparseVector<Object>, Object, SparseVector<Object>> impl_Op_SV_S_eq_SV_Double_OpDiv();

    public void breeze$linalg$operators$SparseVectorExpandOps$_setter_$impl_Op_SV_S_eq_SV_Double_OpDiv_$eq(UFunc.UImpl2 var1);

    public UFunc.UImpl2<OpDiv$, SparseVector<Object>, Object, SparseVector<Object>> impl_Op_SV_S_eq_SV_Float_OpDiv();

    public void breeze$linalg$operators$SparseVectorExpandOps$_setter_$impl_Op_SV_S_eq_SV_Float_OpDiv_$eq(UFunc.UImpl2 var1);

    public UFunc.UImpl2<OpDiv$, SparseVector<Object>, Object, SparseVector<Object>> impl_Op_SV_S_eq_SV_Long_OpDiv();

    public void breeze$linalg$operators$SparseVectorExpandOps$_setter_$impl_Op_SV_S_eq_SV_Long_OpDiv_$eq(UFunc.UImpl2 var1);

    public UFunc.UImpl2<OpMod$, SparseVector<Object>, Object, SparseVector<Object>> impl_Op_SV_S_eq_SV_Int_OpMod();

    public void breeze$linalg$operators$SparseVectorExpandOps$_setter_$impl_Op_SV_S_eq_SV_Int_OpMod_$eq(UFunc.UImpl2 var1);

    public UFunc.UImpl2<OpMod$, SparseVector<Object>, Object, SparseVector<Object>> impl_Op_SV_S_eq_SV_Double_OpMod();

    public void breeze$linalg$operators$SparseVectorExpandOps$_setter_$impl_Op_SV_S_eq_SV_Double_OpMod_$eq(UFunc.UImpl2 var1);

    public UFunc.UImpl2<OpMod$, SparseVector<Object>, Object, SparseVector<Object>> impl_Op_SV_S_eq_SV_Float_OpMod();

    public void breeze$linalg$operators$SparseVectorExpandOps$_setter_$impl_Op_SV_S_eq_SV_Float_OpMod_$eq(UFunc.UImpl2 var1);

    public UFunc.UImpl2<OpMod$, SparseVector<Object>, Object, SparseVector<Object>> impl_Op_SV_S_eq_SV_Long_OpMod();

    public void breeze$linalg$operators$SparseVectorExpandOps$_setter_$impl_Op_SV_S_eq_SV_Long_OpMod_$eq(UFunc.UImpl2 var1);

    public UFunc.UImpl2<OpMulScalar$, SparseVector<Object>, Object, SparseVector<Object>> impl_Op_SV_S_eq_SV_Int_OpMulScalar();

    public void breeze$linalg$operators$SparseVectorExpandOps$_setter_$impl_Op_SV_S_eq_SV_Int_OpMulScalar_$eq(UFunc.UImpl2 var1);

    public UFunc.UImpl2<OpMulScalar$, SparseVector<Object>, Object, SparseVector<Object>> impl_Op_SV_S_eq_SV_Double_OpMulScalar();

    public void breeze$linalg$operators$SparseVectorExpandOps$_setter_$impl_Op_SV_S_eq_SV_Double_OpMulScalar_$eq(UFunc.UImpl2 var1);

    public UFunc.UImpl2<OpMulScalar$, SparseVector<Object>, Object, SparseVector<Object>> impl_Op_SV_S_eq_SV_Float_OpMulScalar();

    public void breeze$linalg$operators$SparseVectorExpandOps$_setter_$impl_Op_SV_S_eq_SV_Float_OpMulScalar_$eq(UFunc.UImpl2 var1);

    public UFunc.UImpl2<OpMulScalar$, SparseVector<Object>, Object, SparseVector<Object>> impl_Op_SV_S_eq_SV_Long_OpMulScalar();

    public void breeze$linalg$operators$SparseVectorExpandOps$_setter_$impl_Op_SV_S_eq_SV_Long_OpMulScalar_$eq(UFunc.UImpl2 var1);

    public UFunc.UImpl2<OpMulMatrix$, SparseVector<Object>, Object, SparseVector<Object>> impl_Op_SV_S_eq_SV_Int_OpMulMatrix();

    public void breeze$linalg$operators$SparseVectorExpandOps$_setter_$impl_Op_SV_S_eq_SV_Int_OpMulMatrix_$eq(UFunc.UImpl2 var1);

    public UFunc.UImpl2<OpMulMatrix$, SparseVector<Object>, Object, SparseVector<Object>> impl_Op_SV_S_eq_SV_Double_OpMulMatrix();

    public void breeze$linalg$operators$SparseVectorExpandOps$_setter_$impl_Op_SV_S_eq_SV_Double_OpMulMatrix_$eq(UFunc.UImpl2 var1);

    public UFunc.UImpl2<OpMulMatrix$, SparseVector<Object>, Object, SparseVector<Object>> impl_Op_SV_S_eq_SV_Float_OpMulMatrix();

    public void breeze$linalg$operators$SparseVectorExpandOps$_setter_$impl_Op_SV_S_eq_SV_Float_OpMulMatrix_$eq(UFunc.UImpl2 var1);

    public UFunc.UImpl2<OpMulMatrix$, SparseVector<Object>, Object, SparseVector<Object>> impl_Op_SV_S_eq_SV_Long_OpMulMatrix();

    public void breeze$linalg$operators$SparseVectorExpandOps$_setter_$impl_Op_SV_S_eq_SV_Long_OpMulMatrix_$eq(UFunc.UImpl2 var1);

    public UFunc.UImpl2<OpMulInner$, SparseVector<Object>, SparseVector<Object>, Object> impl_OpMulInner_SV_SV_eq_T_Int();

    public void breeze$linalg$operators$SparseVectorExpandOps$_setter_$impl_OpMulInner_SV_SV_eq_T_Int_$eq(UFunc.UImpl2 var1);

    public UFunc.UImpl2<OpMulInner$, SparseVector<Object>, SparseVector<Object>, Object> impl_OpMulInner_SV_SV_eq_T_Double();

    public void breeze$linalg$operators$SparseVectorExpandOps$_setter_$impl_OpMulInner_SV_SV_eq_T_Double_$eq(UFunc.UImpl2 var1);

    public UFunc.UImpl2<OpMulInner$, SparseVector<Object>, SparseVector<Object>, Object> impl_OpMulInner_SV_SV_eq_T_Float();

    public void breeze$linalg$operators$SparseVectorExpandOps$_setter_$impl_OpMulInner_SV_SV_eq_T_Float_$eq(UFunc.UImpl2 var1);

    public UFunc.UImpl2<OpMulInner$, SparseVector<Object>, SparseVector<Object>, Object> impl_OpMulInner_SV_SV_eq_T_Long();

    public void breeze$linalg$operators$SparseVectorExpandOps$_setter_$impl_OpMulInner_SV_SV_eq_T_Long_$eq(UFunc.UImpl2 var1);

    public static UFunc.UImpl2 impl_OpMulInner_SV_SV_eq_T$(SparseVectorExpandOps $this, ClassTag evidence$5, Zero evidence$6, Semiring evidence$7) {
        return $this.impl_OpMulInner_SV_SV_eq_T(evidence$5, evidence$6, evidence$7);
    }

    default public <T> UFunc.UImpl2<OpMulInner$, SparseVector<T>, SparseVector<T>, T> impl_OpMulInner_SV_SV_eq_T(ClassTag<T> evidence$5, Zero<T> evidence$6, Semiring<T> evidence$7) {
        return new UFunc.UImpl2<OpMulInner$, SparseVector<T>, SparseVector<T>, T>(evidence$7){
            private final Semiring s;
            {
                this.s = (Semiring)Predef$.MODULE$.implicitly((Object)evidence$7$1);
            }

            public Semiring s() {
                return this.s;
            }

            public Object apply(SparseVector a, SparseVector b) {
                $anon$210 var3_3 = this;
                SparseVector sparseVector = b;
                SparseVector sparseVector2 = a;
                while (sparseVector.activeSize() < sparseVector2.activeSize()) {
                    $anon$210 var6_6 = var3_3;
                    SparseVector sparseVector3 = sparseVector;
                    SparseVector sparseVector4 = sparseVector2;
                    var3_3 = var6_6;
                    sparseVector2 = sparseVector3;
                    sparseVector = sparseVector4;
                }
                if (sparseVector.length() != sparseVector2.length()) {
                    throw new IllegalArgumentException(StringOps$.MODULE$.format$extension("requirement failed: %s", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{new StringBuilder(55).append("Vectors must be the same length!").append(": ").append("b.length.==(a.length)").toString()})));
                }
                int asize = sparseVector2.activeSize();
                int bsize = sparseVector.activeSize();
                V result = var3_3.s().zero();
                int aoff = 0;
                int boff = 0;
                while (aoff < asize) {
                    int aind = sparseVector2.indexAt(aoff);
                    boff = Arrays.binarySearch(sparseVector.index(), boff, package$.MODULE$.min(bsize, aind + 1), aind);
                    if (boff < 0) {
                        if ((boff ^= 0xFFFFFFFF) == bsize) {
                            aoff = asize;
                            continue;
                        }
                        int bind = sparseVector.indexAt(boff);
                        int newAoff = Arrays.binarySearch(sparseVector2.index(), aoff, package$.MODULE$.min(asize, bind + 1), bind);
                        if (newAoff < 0) {
                            newAoff ^= 0xFFFFFFFF;
                            ++boff;
                        }
                        if (newAoff <= aoff) {
                            throw new AssertionError((Object)StringOps$.MODULE$.format$extension("assertion failed: %s", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{new StringBuilder(17).append(new StringBuilder(1).append(aoff).append(" ").append(newAoff).toString()).append(": ").append("newAoff.>(aoff)").toString()})));
                        }
                        aoff = newAoff;
                        continue;
                    }
                    result = var3_3.s().$plus(result, var3_3.s().$times(sparseVector2.valueAt(aoff), sparseVector.valueAt(boff)));
                    ++aoff;
                    ++boff;
                }
                return result;
            }
        };
    }

    public UFunc.InPlaceImpl3<scaleAdd$, SparseVector<Object>, Object, SparseVector<Object>> implScaleAdd_SV_S_SV_InPlace_Int();

    public void breeze$linalg$operators$SparseVectorExpandOps$_setter_$implScaleAdd_SV_S_SV_InPlace_Int_$eq(UFunc.InPlaceImpl3 var1);

    public UFunc.InPlaceImpl3<scaleAdd$, SparseVector<Object>, Object, SparseVector<Object>> implScaleAdd_SV_S_SV_InPlace_Double();

    public void breeze$linalg$operators$SparseVectorExpandOps$_setter_$implScaleAdd_SV_S_SV_InPlace_Double_$eq(UFunc.InPlaceImpl3 var1);

    public UFunc.InPlaceImpl3<scaleAdd$, SparseVector<Object>, Object, SparseVector<Object>> implScaleAdd_SV_S_SV_InPlace_Float();

    public void breeze$linalg$operators$SparseVectorExpandOps$_setter_$implScaleAdd_SV_S_SV_InPlace_Float_$eq(UFunc.InPlaceImpl3 var1);

    public UFunc.InPlaceImpl3<scaleAdd$, SparseVector<Object>, Object, SparseVector<Object>> implScaleAdd_SV_S_SV_InPlace_Long();

    public void breeze$linalg$operators$SparseVectorExpandOps$_setter_$implScaleAdd_SV_S_SV_InPlace_Long_$eq(UFunc.InPlaceImpl3 var1);

    public static CanZipMapValuesSparseVector zipMap$(SparseVectorExpandOps $this, ClassTag evidence$11, Zero evidence$12, Semiring evidence$13) {
        return $this.zipMap(evidence$11, evidence$12, evidence$13);
    }

    default public <V, R> CanZipMapValuesSparseVector<V, R> zipMap(ClassTag<R> evidence$11, Zero<R> evidence$12, Semiring<R> evidence$13) {
        return new CanZipMapValuesSparseVector(this, evidence$11, evidence$12, evidence$13);
    }

    public CanZipMapValuesSparseVector<Object, Object> zipMap_d();

    public void breeze$linalg$operators$SparseVectorExpandOps$_setter_$zipMap_d_$eq(CanZipMapValuesSparseVector var1);

    public CanZipMapValuesSparseVector<Object, Object> zipMap_f();

    public void breeze$linalg$operators$SparseVectorExpandOps$_setter_$zipMap_f_$eq(CanZipMapValuesSparseVector var1);

    public CanZipMapValuesSparseVector<Object, Object> zipMap_i();

    public void breeze$linalg$operators$SparseVectorExpandOps$_setter_$zipMap_i_$eq(CanZipMapValuesSparseVector var1);

    public static CanZipMapKeyValuesSparseVector zipMapKV$(SparseVectorExpandOps $this, ClassTag evidence$17, Zero evidence$18, Semiring evidence$19) {
        return $this.zipMapKV(evidence$17, evidence$18, evidence$19);
    }

    default public <V, R> CanZipMapKeyValuesSparseVector<V, R> zipMapKV(ClassTag<R> evidence$17, Zero<R> evidence$18, Semiring<R> evidence$19) {
        return new CanZipMapKeyValuesSparseVector(this, evidence$17, evidence$18, evidence$19);
    }

    public class CanZipMapKeyValuesSparseVector<V, RV>
    implements CanZipMapKeyValues<SparseVector<V>, Object, V, RV, SparseVector<RV>> {
        private final ClassTag<RV> evidence$14;
        private final Zero<RV> evidence$15;
        private final Semiring<RV> evidence$16;
        private final /* synthetic */ SparseVectorExpandOps $outer;

        public CanZipMapKeyValuesSparseVector(SparseVectorExpandOps $outer, ClassTag<RV> evidence$14, Zero<RV> evidence$15, Semiring<RV> evidence$16) {
            this.evidence$14 = evidence$14;
            this.evidence$15 = evidence$15;
            this.evidence$16 = evidence$16;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }

        public SparseVector<RV> create(int length) {
            return SparseVector$.MODULE$.zeros(length, this.evidence$14, this.evidence$15);
        }

        @Override
        public SparseVector<RV> map(SparseVector<V> from, SparseVector<V> from2, Function3<Object, V, V, RV> fn) {
            if (from.length() != from2.length()) {
                throw new IllegalArgumentException(StringOps$.MODULE$.format$extension("requirement failed: %s", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{new StringBuilder(56).append("Vector lengths must match!").append(": ").append("from.length.==(from2.length)").toString()})));
            }
            SparseVector<RV> result = this.create(from.length());
            int i = 0;
            int yy = from.length();
            while (i < from.length()) {
                int n = i++;
                result.update(n, fn.apply((Object)BoxesRunTime.boxToInteger((int)n), from.apply(n), from2.apply(n)));
            }
            return result;
        }

        @Override
        public SparseVector<RV> mapActive(SparseVector<V> from, SparseVector<V> from2, Function3<Object, V, V, RV> fn) {
            if (from.length() != from2.length()) {
                throw new IllegalArgumentException(StringOps$.MODULE$.format$extension("requirement failed: %s", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{new StringBuilder(56).append("Vector lengths must match!").append(": ").append("from.length.==(from2.length)").toString()})));
            }
            VectorBuilder<RV> vb = new VectorBuilder<RV>(from.length(), VectorBuilder$.MODULE$.$lessinit$greater$default$2(), this.evidence$16, this.evidence$14);
            int off2 = 0;
            for (int off1 = 0; off1 < from.activeSize(); ++off1) {
                while (off2 < from2.activeSize() && from2.indexAt(off2) < from.indexAt(off1)) {
                    int index = from2.indexAt(off2);
                    vb.add(index, fn.apply((Object)BoxesRunTime.boxToInteger((int)index), from.default(), from2.valueAt(off2)));
                    ++off2;
                }
                if (off2 < from2.activeSize() && from.indexAt(off1) == from2.indexAt(off2)) {
                    int index = from2.indexAt(off2);
                    vb.add(index, fn.apply((Object)BoxesRunTime.boxToInteger((int)index), from.valueAt(off1), from2.valueAt(off2)));
                    ++off2;
                    continue;
                }
                int index = from.indexAt(off1);
                vb.add(index, fn.apply((Object)BoxesRunTime.boxToInteger((int)index), from.valueAt(off1), from2.default()));
            }
            while (off2 < from2.activeSize()) {
                int index = from2.indexAt(off2);
                vb.add(index, fn.apply((Object)BoxesRunTime.boxToInteger((int)index), from.default(), from2.valueAt(off2)));
                ++off2;
            }
            return vb.toSparseVector(true, true);
        }

        public final /* synthetic */ SparseVectorExpandOps breeze$linalg$operators$SparseVectorExpandOps$CanZipMapKeyValuesSparseVector$$$outer() {
            return this.$outer;
        }
    }

    public class CanZipMapValuesSparseVector<V, RV>
    implements CanZipMapValues<SparseVector<V>, V, RV, SparseVector<RV>> {
        private final ClassTag<RV> evidence$8;
        private final Zero<RV> evidence$9;
        private final Semiring<RV> evidence$10;
        private final /* synthetic */ SparseVectorExpandOps $outer;

        public CanZipMapValuesSparseVector(SparseVectorExpandOps $outer, ClassTag<RV> evidence$8, Zero<RV> evidence$9, Semiring<RV> evidence$10) {
            this.evidence$8 = evidence$8;
            this.evidence$9 = evidence$9;
            this.evidence$10 = evidence$10;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }

        public SparseVector<RV> create(int length) {
            return SparseVector$.MODULE$.zeros(length, this.evidence$8, this.evidence$9);
        }

        @Override
        public SparseVector<RV> map(SparseVector<V> from, SparseVector<V> from2, Function2<V, V, RV> fn) {
            SparseVector<RV> sparseVector;
            if (from.length() != from2.length()) {
                throw new IllegalArgumentException(StringOps$.MODULE$.format$extension("requirement failed: %s", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{new StringBuilder(56).append("Vector lengths must match!").append(": ").append("from.length.==(from2.length)").toString()})));
            }
            Object zz = fn.apply(from.default(), from2.default());
            if (!BoxesRunTime.equals((Object)zz, ((Zero)Predef$.MODULE$.implicitly(this.evidence$9)).zero())) {
                SparseVector<RV> result = this.create(from.length());
                for (int i = 0; i < from.length(); ++i) {
                    result.update(i, fn.apply(from.apply(i), from2.apply(i)));
                }
                sparseVector = result;
            } else {
                VectorBuilder<RV> vb = new VectorBuilder<RV>(from.length(), VectorBuilder$.MODULE$.$lessinit$greater$default$2(), this.evidence$10, this.evidence$8);
                int off2 = 0;
                for (int off1 = 0; off1 < from.activeSize(); ++off1) {
                    while (off2 < from2.activeSize() && from2.indexAt(off2) < from.indexAt(off1)) {
                        int index = from2.indexAt(off2);
                        vb.add(index, fn.apply(from.default(), from2.valueAt(off2)));
                        ++off2;
                    }
                    if (off2 < from2.activeSize() && from.indexAt(off1) == from2.indexAt(off2)) {
                        int index = from2.indexAt(off2);
                        vb.add(index, fn.apply(from.valueAt(off1), from2.valueAt(off2)));
                        ++off2;
                        continue;
                    }
                    int index = from.indexAt(off1);
                    vb.add(index, fn.apply(from.valueAt(off1), from2.default()));
                }
                while (off2 < from2.activeSize()) {
                    int index = from2.indexAt(off2);
                    vb.add(index, fn.apply(from.default(), from2.valueAt(off2)));
                    ++off2;
                }
                sparseVector = vb.toSparseVector(true, true);
            }
            return sparseVector;
        }

        public final /* synthetic */ SparseVectorExpandOps breeze$linalg$operators$SparseVectorExpandOps$CanZipMapValuesSparseVector$$$outer() {
            return this.$outer;
        }
    }
}

