/*
 * Decompiled with CFR 0.152.
 */
package breeze.linalg.operators;

import breeze.generic.UFunc;
import breeze.linalg.SparseVector;
import breeze.linalg.Vector;
import breeze.linalg.VectorBuilder;
import breeze.linalg.VectorBuilder$;
import breeze.linalg.operators.GenericOps;
import breeze.linalg.operators.OpAdd$;
import breeze.linalg.operators.OpMulMatrix$;
import breeze.linalg.operators.OpMulScalar$;
import breeze.linalg.operators.OpSet$;
import breeze.linalg.operators.OpSub$;
import breeze.linalg.operators.OpType;
import breeze.linalg.operators.SparseVector_GenericOps$;
import breeze.linalg.scaleAdd$;
import breeze.math.Ring;
import breeze.math.Semiring;
import breeze.storage.Zero;
import breeze.storage.Zero$;
import breeze.util.ArrayUtil$;
import breeze.util.ReflectionUtil$;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.Arrays;
import scala.Array$;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.math.package$;
import scala.reflect.ClassTag;
import scala.runtime.Arrays$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;

public interface SparseVector_GenericOps
extends GenericOps {
    public static UFunc.InPlaceImpl2 impl_OpSet_InPlace_SV_SV_Generic$(SparseVector_GenericOps $this) {
        return $this.impl_OpSet_InPlace_SV_SV_Generic();
    }

    default public <T> UFunc.InPlaceImpl2<OpSet$, SparseVector<T>, SparseVector<T>> impl_OpSet_InPlace_SV_SV_Generic() {
        return new UFunc.InPlaceImpl2<OpSet$, SparseVector<T>, SparseVector<T>>(){

            public void apply(SparseVector a, SparseVector b) {
                Vector result = b.copy();
                a.use(((SparseVector)result).index(), ((SparseVector)result).data(), ((SparseVector)result).activeSize());
            }
        };
    }

    public static UFunc.InPlaceImpl2 impl_OpSet_InPlace_SV_S_Generic$(SparseVector_GenericOps $this, Zero evidence$5) {
        return $this.impl_OpSet_InPlace_SV_S_Generic(evidence$5);
    }

    default public <T> UFunc.InPlaceImpl2<OpSet$, SparseVector<T>, T> impl_OpSet_InPlace_SV_S_Generic(Zero<T> evidence$5) {
        Object zero = ((Zero)Predef$.MODULE$.implicitly(evidence$5)).zero();
        return new UFunc.InPlaceImpl2<OpSet$, SparseVector<T>, T>(zero){
            private final Object zero$2;
            {
                this.zero$2 = zero$4;
            }

            public void apply(SparseVector a, Object b) {
                ClassTag<T> ct = ReflectionUtil$.MODULE$.elemClassTagFromArray(a.data());
                if (BoxesRunTime.equals((Object)b, (Object)this.zero$2)) {
                    a.use(new int[2], Arrays$.MODULE$.newGenericArray(2, ct), 0);
                } else {
                    Object data = Array$.MODULE$.fill(a.length(), () -> SparseVector_GenericOps.breeze$linalg$operators$SparseVector_GenericOps$$anon$15$$_$_$$anonfun$1(b), ct);
                    int[] index = Array$.MODULE$.range(0, a.length());
                    a.use(index, data, a.length());
                }
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{breeze$linalg$operators$SparseVector_GenericOps$$anon$15$$_$_$$anonfun$1(java.lang.Object )}, serializedLambda);
            }
        };
    }

    public static UFunc.UImpl2 impl_Op_SV_S_eq_SV_Generic$(SparseVector_GenericOps $this, Semiring evidence$6, UFunc.UImpl2 op) {
        return $this.impl_Op_SV_S_eq_SV_Generic(evidence$6, op);
    }

    default public <Op extends OpType, T> UFunc.UImpl2<Op, SparseVector<T>, T, SparseVector<T>> impl_Op_SV_S_eq_SV_Generic(Semiring<T> evidence$6, UFunc.UImpl2<Op, T, T, T> op) {
        return (a, b) -> {
            ClassTag ct = ReflectionUtil$.MODULE$.elemClassTagFromArray(a.data());
            VectorBuilder result = new VectorBuilder(a.length(), VectorBuilder$.MODULE$.$lessinit$greater$default$2(), evidence$6, ct);
            Semiring f = (Semiring)Predef$.MODULE$.implicitly((Object)evidence$6);
            int yy = a.length();
            for (int i = 0; i < a.length(); ++i) {
                int n = i;
                Object r = op.apply(a.apply(n), b);
                if (BoxesRunTime.equals(r, f.zero())) continue;
                result.add(n, r);
            }
            return result.toSparseVector(true, true);
        };
    }

    public static UFunc.UImpl2 impl_OpAdd_SV_S_eq_SV_Generic$(SparseVector_GenericOps $this, Semiring evidence$7) {
        return $this.impl_OpAdd_SV_S_eq_SV_Generic(evidence$7);
    }

    default public <T> UFunc.UImpl2<OpAdd$, SparseVector<T>, T, SparseVector<T>> impl_OpAdd_SV_S_eq_SV_Generic(Semiring<T> evidence$7) {
        return (a, b) -> {
            SparseVector sparseVector;
            Semiring f = (Semiring)Predef$.MODULE$.implicitly((Object)evidence$7);
            if (BoxesRunTime.equals((Object)b, f.zero())) {
                sparseVector = a.copy();
            } else {
                ClassTag ct = ReflectionUtil$.MODULE$.elemClassTagFromArray(a.data());
                VectorBuilder result = new VectorBuilder(a.length(), VectorBuilder$.MODULE$.$lessinit$greater$default$2(), evidence$7, ct);
                int yy = a.length();
                for (int i = 0; i < a.length(); ++i) {
                    int n = i;
                    Object r = f.$plus(a.apply(n), b);
                    if (BoxesRunTime.equals((Object)r, f.zero())) continue;
                    result.add(n, r);
                }
                sparseVector = result.toSparseVector(true, true);
            }
            return sparseVector;
        };
    }

    public static UFunc.UImpl2 impl_OpSub_SV_S_eq_SV_Generic$(SparseVector_GenericOps $this, Ring evidence$8) {
        return $this.impl_OpSub_SV_S_eq_SV_Generic(evidence$8);
    }

    default public <T> UFunc.UImpl2<OpSub$, SparseVector<T>, T, SparseVector<T>> impl_OpSub_SV_S_eq_SV_Generic(Ring<T> evidence$8) {
        return (a, b) -> {
            SparseVector sparseVector;
            Ring f = (Ring)Predef$.MODULE$.implicitly((Object)evidence$8);
            if (BoxesRunTime.equals((Object)b, f.zero())) {
                sparseVector = a.copy();
            } else {
                ClassTag ct = ReflectionUtil$.MODULE$.elemClassTagFromArray(a.data());
                VectorBuilder result = new VectorBuilder(a.length(), VectorBuilder$.MODULE$.$lessinit$greater$default$2(), evidence$8, ct);
                int yy = a.length();
                for (int i = 0; i < a.length(); ++i) {
                    int n = i;
                    Object r = f.$minus(a.apply(n), b);
                    if (BoxesRunTime.equals((Object)r, f.zero())) continue;
                    result.add(n, r);
                }
                sparseVector = result.toSparseVector(true, true);
            }
            return sparseVector;
        };
    }

    public static UFunc.UImpl2 impl_OpMulScalar_SV_S_eq_SV_Generic$(SparseVector_GenericOps $this, Semiring evidence$9, ClassTag evidence$10) {
        return $this.impl_OpMulScalar_SV_S_eq_SV_Generic(evidence$9, evidence$10);
    }

    default public <T> UFunc.UImpl2<OpMulScalar$, SparseVector<T>, T, SparseVector<T>> impl_OpMulScalar_SV_S_eq_SV_Generic(Semiring<T> evidence$9, ClassTag<T> evidence$10) {
        return (a, b) -> {
            Semiring f = (Semiring)Predef$.MODULE$.implicitly((Object)evidence$9);
            VectorBuilder<Object> result = new VectorBuilder<Object>(a.length(), VectorBuilder$.MODULE$.$lessinit$greater$default$2(), evidence$9, evidence$10);
            if (!BoxesRunTime.equals((Object)b, f.zero())) {
                int i = 0;
                int yy = a.activeSize();
                while (i < a.activeSize()) {
                    int n = i++;
                    result.add(a.indexAt(n), f.$times(a.valueAt(n), b));
                }
            }
            return result.toSparseVector(true, true);
        };
    }

    public static UFunc.UImpl2 impl_Op_SV_S_eq_SV_Generic_OpMulMatrix$(SparseVector_GenericOps $this, Semiring evidence$11, ClassTag evidence$12) {
        return $this.impl_Op_SV_S_eq_SV_Generic_OpMulMatrix(evidence$11, evidence$12);
    }

    default public <T> UFunc.UImpl2<OpMulMatrix$, SparseVector<T>, T, SparseVector<T>> impl_Op_SV_S_eq_SV_Generic_OpMulMatrix(Semiring<T> evidence$11, ClassTag<T> evidence$12) {
        return (a, b) -> {
            Semiring f = (Semiring)Predef$.MODULE$.implicitly((Object)evidence$11);
            VectorBuilder<Object> result = new VectorBuilder<Object>(a.length(), VectorBuilder$.MODULE$.$lessinit$greater$default$2(), evidence$11, evidence$12);
            if (!BoxesRunTime.equals((Object)b, f.zero())) {
                int i = 0;
                int yy = a.activeSize();
                while (i < a.activeSize()) {
                    int n = i++;
                    result.add(a.indexAt(n), f.$times(a.valueAt(n), b));
                }
            }
            return result.toSparseVector(true, true);
        };
    }

    public static UFunc.UImpl2 impl_Op_SV_SV_eq_SV_Generic_OpMulScalar$(SparseVector_GenericOps $this, Semiring ring) {
        return $this.impl_Op_SV_SV_eq_SV_Generic_OpMulScalar(ring);
    }

    default public <T> UFunc.UImpl2<OpMulScalar$, SparseVector<T>, SparseVector<T>, SparseVector<T>> impl_Op_SV_SV_eq_SV_Generic_OpMulScalar(Semiring<T> ring) {
        return new UFunc.UImpl2<OpMulScalar$, SparseVector<T>, SparseVector<T>, SparseVector<T>>(ring){
            private final Semiring ring$1;
            {
                this.ring$1 = ring$3;
            }

            public SparseVector apply(SparseVector a, SparseVector b) {
                ClassTag<T> ct;
                $anon$16 var3_3 = this;
                SparseVector sparseVector = b;
                SparseVector sparseVector2 = a;
                while (true) {
                    ct = ReflectionUtil$.MODULE$.elemClassTagFromArray(sparseVector2.data());
                    if (sparseVector.activeSize() >= sparseVector2.activeSize()) break;
                    $anon$16 var7_7 = var3_3;
                    SparseVector sparseVector3 = sparseVector;
                    SparseVector sparseVector4 = sparseVector2;
                    var3_3 = var7_7;
                    sparseVector2 = sparseVector3;
                    sparseVector = sparseVector4;
                }
                if (sparseVector.length() != sparseVector2.length()) {
                    throw new IllegalArgumentException(StringOps$.MODULE$.format$extension("requirement failed: %s", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{new StringBuilder(55).append("Vectors must be the same length!").append(": ").append("b.length.==(a.length)").toString()})));
                }
                int asize = sparseVector2.activeSize();
                int bsize = sparseVector.activeSize();
                int[] resultI = new int[package$.MODULE$.min(asize, bsize)];
                Object resultV = Arrays$.MODULE$.newGenericArray(package$.MODULE$.min(asize, bsize), ct);
                int resultOff = 0;
                int aoff = 0;
                int boff = 0;
                while (aoff < asize) {
                    int aind = sparseVector2.indexAt(aoff);
                    boff = Arrays.binarySearch(sparseVector.index(), boff, package$.MODULE$.min(bsize, aind + 1), aind);
                    if (boff < 0) {
                        if ((boff ^= 0xFFFFFFFF) == bsize) {
                            aoff = asize;
                            continue;
                        }
                        int bind = sparseVector.indexAt(boff);
                        int newAoff = Arrays.binarySearch(sparseVector2.index(), aoff, package$.MODULE$.min(asize, bind + 1), bind);
                        if (newAoff < 0) {
                            newAoff ^= 0xFFFFFFFF;
                            ++boff;
                        }
                        if (newAoff <= aoff) {
                            throw new AssertionError((Object)StringOps$.MODULE$.format$extension("assertion failed: %s", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{new StringBuilder(17).append(new StringBuilder(6).append(bind).append(" ").append(aoff).append(" ").append(newAoff).append(" ").append(sparseVector2.index()[aoff]).append(" ").append(sparseVector2.index()[newAoff]).append(" ").append(sparseVector2).append(" ").append(sparseVector).toString()).append(": ").append("newAoff.>(aoff)").toString()})));
                        }
                        aoff = newAoff;
                        continue;
                    }
                    resultI[resultOff] = aind;
                    ScalaRunTime$.MODULE$.array_update(resultV, resultOff, this.ring$1.$times(sparseVector2.valueAt(aoff), sparseVector.valueAt(boff)));
                    ++aoff;
                    ++boff;
                    ++resultOff;
                }
                return resultOff != resultI.length ? new SparseVector<T>(Arrays.copyOf(resultI, resultOff), ArrayUtil$.MODULE$.copyOf(resultV, resultOff), resultOff, sparseVector2.length(), Zero$.MODULE$.zeroFromSemiring(this.ring$1)) : new SparseVector<T>(resultI, resultV, resultOff, sparseVector2.length(), Zero$.MODULE$.zeroFromSemiring(this.ring$1));
            }
        };
    }

    public static UFunc.InPlaceImpl3 impl_scaleAdd_SV_S_SV_InPlace_Generic$(SparseVector_GenericOps $this, Semiring evidence$13, ClassTag evidence$14) {
        return $this.impl_scaleAdd_SV_S_SV_InPlace_Generic(evidence$13, evidence$14);
    }

    default public <T> UFunc.InPlaceImpl3<scaleAdd$, SparseVector<T>, T, SparseVector<T>> impl_scaleAdd_SV_S_SV_InPlace_Generic(Semiring<T> evidence$13, ClassTag<T> evidence$14) {
        return (dest, scale, source) -> {
            Semiring f = (Semiring)Predef$.MODULE$.implicitly((Object)evidence$13);
            if (source.length() != dest.length()) {
                throw new IllegalArgumentException(StringOps$.MODULE$.format$extension("requirement failed: %s", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{new StringBuilder(63).append("Vectors must be the same length!").append(": ").append("source.length.==(dest.length)").toString()})));
            }
            int asize = dest.activeSize();
            int bsize = source.activeSize();
            if (!BoxesRunTime.equals((Object)scale, f.zero()) && bsize != 0) {
                int[] resultI = new int[asize + bsize];
                Object resultV = Arrays$.MODULE$.newGenericArray(asize + bsize, evidence$14);
                int resultOff = 0;
                int boff = 0;
                for (int aoff = 0; aoff < asize; ++aoff) {
                    Object object;
                    while (boff < bsize && source.indexAt(boff) < dest.indexAt(aoff)) {
                        resultI[resultOff] = source.indexAt(boff);
                        ScalaRunTime$.MODULE$.array_update(resultV, resultOff, f.$times(scale, source.valueAt(boff)));
                        ++resultOff;
                        ++boff;
                    }
                    if (boff < bsize && source.indexAt(boff) == dest.indexAt(aoff)) {
                        Object bv = f.$times(scale, source.valueAt(boff));
                        ++boff;
                        object = bv;
                    } else {
                        object = f.zero();
                    }
                    Object bvalue = object;
                    resultI[resultOff] = dest.indexAt(aoff);
                    ScalaRunTime$.MODULE$.array_update(resultV, resultOff, f.$plus(dest.valueAt(aoff), bvalue));
                    ++resultOff;
                }
                while (boff < bsize) {
                    resultI[resultOff] = source.indexAt(boff);
                    ScalaRunTime$.MODULE$.array_update(resultV, resultOff, f.$times(scale, source.valueAt(boff)));
                    ++resultOff;
                    ++boff;
                }
                if (resultOff != resultI.length) {
                    dest.use(Arrays.copyOf(resultI, resultOff), ArrayUtil$.MODULE$.copyOf(resultV, resultOff), resultOff);
                } else {
                    dest.use(resultI, resultV, resultOff);
                }
            }
        };
    }

    public static UFunc.UImpl2 impl_Op_SV_SV_eq_SV_Generic$(SparseVector_GenericOps $this, UFunc.UImpl2 op, Semiring semiring) {
        return $this.impl_Op_SV_SV_eq_SV_Generic(op, semiring);
    }

    default public <T, Op extends OpType> UFunc.UImpl2<Op, SparseVector<T>, SparseVector<T>, SparseVector<T>> impl_Op_SV_SV_eq_SV_Generic(UFunc.UImpl2<Op, T, T, T> op, Semiring<T> semiring) {
        return (a, b) -> {
            if (b.length() != a.length()) {
                throw new IllegalArgumentException(StringOps$.MODULE$.format$extension("requirement failed: %s", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{new StringBuilder(55).append("Vectors must be the same length!").append(": ").append("b.length.==(a.length)").toString()})));
            }
            ClassTag ct = ReflectionUtil$.MODULE$.elemClassTagFromArray(a.data());
            Object zero = ((Semiring)Predef$.MODULE$.implicitly((Object)semiring)).zero();
            VectorBuilder result = new VectorBuilder(a.length(), VectorBuilder$.MODULE$.$lessinit$greater$default$2(), semiring, ct);
            for (int i = 0; i < a.length(); ++i) {
                Object r = op.apply(a.apply(i), b.apply(i));
                if (BoxesRunTime.equals(r, zero)) continue;
                result.add(i, r);
            }
            return result.toSparseVector(true, true);
        };
    }

    public static Object breeze$linalg$operators$SparseVector_GenericOps$$anon$15$$_$_$$anonfun$1(Object b$1) {
        return b$1;
    }
}

