/*
 * Decompiled with CFR 0.152.
 */
package breeze.linalg.operators;

import breeze.generic.UFunc;
import breeze.linalg.HashVector;
import breeze.linalg.SparseVector;
import breeze.linalg.VectorBuilder;
import breeze.linalg.VectorBuilder$;
import breeze.linalg.operators.BinaryRegistry;
import breeze.linalg.operators.HashVector_SparseVector_Ops;
import breeze.linalg.operators.OpAdd$;
import breeze.linalg.operators.OpDiv$;
import breeze.linalg.operators.OpMod$;
import breeze.linalg.operators.OpMulInner$;
import breeze.linalg.operators.OpMulScalar$;
import breeze.linalg.operators.OpPow$;
import breeze.linalg.operators.OpSet$;
import breeze.linalg.operators.OpSub$;
import breeze.math.PowImplicits$;
import breeze.math.Semiring$;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;

public interface SparseVector_HashVector_Ops
extends HashVector_SparseVector_Ops {
    public static void $init$(SparseVector_HashVector_Ops $this) {
        $this.breeze$linalg$operators$SparseVector_HashVector_Ops$_setter_$impl_Op_SV_HV_eq_SV_lhs_nilpotent_Int_OpDiv_$eq(new UFunc.UImpl2<OpDiv$, SparseVector<Object>, HashVector<Object>, SparseVector<Object>>($this){
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                ((BinaryRegistry)Predef$.MODULE$.implicitly($outer.impl_Op_V_V_eq_V_Int_OpDiv())).register(this, ClassTag$.MODULE$.apply(SparseVector.class), ClassTag$.MODULE$.apply(HashVector.class));
            }

            public SparseVector apply(SparseVector a, HashVector b) {
                if (b.length() != a.length()) {
                    throw new IllegalArgumentException(StringOps$.MODULE$.format$extension("requirement failed: %s", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{new StringBuilder(55).append("Vectors must be the same length!").append(": ").append("b.length.==(a.length)").toString()})));
                }
                VectorBuilder<Object> builder = new VectorBuilder<Object>(a.length(), VectorBuilder$.MODULE$.$lessinit$greater$default$2(), Semiring$.MODULE$.semiringInt(), ClassTag$.MODULE$.apply(Integer.TYPE));
                if (OpDiv$.MODULE$.equals(OpSet$.MODULE$) || b.activeSize() != b.length()) {
                    int yy = a.length();
                    for (int i = 0; i < a.length(); ++i) {
                        int n = i;
                        int r = BoxesRunTime.unboxToInt(a.otherApply(n)) / BoxesRunTime.unboxToInt(b.apply(n));
                        if (r == 0) continue;
                        builder.add(n, BoxesRunTime.boxToInteger((int)r));
                    }
                } else {
                    int yy = a.activeSize();
                    for (int i = 0; i < a.activeSize(); ++i) {
                        int n = i;
                        int k = a.indexAt(n);
                        int v = BoxesRunTime.unboxToInt(a.valueAt(n));
                        int r = v / BoxesRunTime.unboxToInt(b.apply(k));
                        if (r == 0) continue;
                        builder.add(k, BoxesRunTime.boxToInteger((int)r));
                    }
                }
                return builder.toSparseVector(true, true);
            }
        });
        $this.breeze$linalg$operators$SparseVector_HashVector_Ops$_setter_$impl_Op_SV_HV_eq_SV_lhs_nilpotent_Double_OpDiv_$eq(new UFunc.UImpl2<OpDiv$, SparseVector<Object>, HashVector<Object>, SparseVector<Object>>($this){
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                ((BinaryRegistry)Predef$.MODULE$.implicitly($outer.impl_Op_V_V_eq_V_Double_OpDiv())).register(this, ClassTag$.MODULE$.apply(SparseVector.class), ClassTag$.MODULE$.apply(HashVector.class));
            }

            public SparseVector apply(SparseVector a, HashVector b) {
                if (b.length() != a.length()) {
                    throw new IllegalArgumentException(StringOps$.MODULE$.format$extension("requirement failed: %s", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{new StringBuilder(55).append("Vectors must be the same length!").append(": ").append("b.length.==(a.length)").toString()})));
                }
                VectorBuilder<Object> builder = new VectorBuilder<Object>(a.length(), VectorBuilder$.MODULE$.$lessinit$greater$default$2(), Semiring$.MODULE$.semiringD(), ClassTag$.MODULE$.apply(Double.TYPE));
                if (OpDiv$.MODULE$.equals(OpSet$.MODULE$) || b.activeSize() != b.length()) {
                    int yy = a.length();
                    for (int i = 0; i < a.length(); ++i) {
                        int n = i;
                        double r = BoxesRunTime.unboxToDouble(a.otherApply(n)) / BoxesRunTime.unboxToDouble(b.apply(n));
                        if (r == 0.0) continue;
                        builder.add(n, BoxesRunTime.boxToDouble((double)r));
                    }
                } else {
                    int yy = a.activeSize();
                    for (int i = 0; i < a.activeSize(); ++i) {
                        int n = i;
                        int k = a.indexAt(n);
                        double v = BoxesRunTime.unboxToDouble(a.valueAt(n));
                        double r = v / BoxesRunTime.unboxToDouble(b.apply(k));
                        if (r == 0.0) continue;
                        builder.add(k, BoxesRunTime.boxToDouble((double)r));
                    }
                }
                return builder.toSparseVector(true, true);
            }
        });
        $this.breeze$linalg$operators$SparseVector_HashVector_Ops$_setter_$impl_Op_SV_HV_eq_SV_lhs_nilpotent_Float_OpDiv_$eq(new UFunc.UImpl2<OpDiv$, SparseVector<Object>, HashVector<Object>, SparseVector<Object>>($this){
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                ((BinaryRegistry)Predef$.MODULE$.implicitly($outer.impl_Op_V_V_eq_V_Float_OpDiv())).register(this, ClassTag$.MODULE$.apply(SparseVector.class), ClassTag$.MODULE$.apply(HashVector.class));
            }

            public SparseVector apply(SparseVector a, HashVector b) {
                if (b.length() != a.length()) {
                    throw new IllegalArgumentException(StringOps$.MODULE$.format$extension("requirement failed: %s", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{new StringBuilder(55).append("Vectors must be the same length!").append(": ").append("b.length.==(a.length)").toString()})));
                }
                VectorBuilder<Object> builder = new VectorBuilder<Object>(a.length(), VectorBuilder$.MODULE$.$lessinit$greater$default$2(), Semiring$.MODULE$.semiringFloat(), ClassTag$.MODULE$.apply(Float.TYPE));
                if (OpDiv$.MODULE$.equals(OpSet$.MODULE$) || b.activeSize() != b.length()) {
                    int yy = a.length();
                    for (int i = 0; i < a.length(); ++i) {
                        int n = i;
                        float r = BoxesRunTime.unboxToFloat(a.otherApply(n)) / BoxesRunTime.unboxToFloat(b.apply(n));
                        if (r == 0.0f) continue;
                        builder.add(n, BoxesRunTime.boxToFloat((float)r));
                    }
                } else {
                    int yy = a.activeSize();
                    for (int i = 0; i < a.activeSize(); ++i) {
                        int n = i;
                        int k = a.indexAt(n);
                        float v = BoxesRunTime.unboxToFloat(a.valueAt(n));
                        float r = v / BoxesRunTime.unboxToFloat(b.apply(k));
                        if (r == 0.0f) continue;
                        builder.add(k, BoxesRunTime.boxToFloat((float)r));
                    }
                }
                return builder.toSparseVector(true, true);
            }
        });
        $this.breeze$linalg$operators$SparseVector_HashVector_Ops$_setter_$impl_Op_SV_HV_eq_SV_lhs_nilpotent_Long_OpDiv_$eq(new UFunc.UImpl2<OpDiv$, SparseVector<Object>, HashVector<Object>, SparseVector<Object>>($this){
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                ((BinaryRegistry)Predef$.MODULE$.implicitly($outer.impl_Op_V_V_eq_V_Long_OpDiv())).register(this, ClassTag$.MODULE$.apply(SparseVector.class), ClassTag$.MODULE$.apply(HashVector.class));
            }

            public SparseVector apply(SparseVector a, HashVector b) {
                if (b.length() != a.length()) {
                    throw new IllegalArgumentException(StringOps$.MODULE$.format$extension("requirement failed: %s", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{new StringBuilder(55).append("Vectors must be the same length!").append(": ").append("b.length.==(a.length)").toString()})));
                }
                VectorBuilder<Object> builder = new VectorBuilder<Object>(a.length(), VectorBuilder$.MODULE$.$lessinit$greater$default$2(), Semiring$.MODULE$.semiringLong(), ClassTag$.MODULE$.apply(Long.TYPE));
                if (OpDiv$.MODULE$.equals(OpSet$.MODULE$) || b.activeSize() != b.length()) {
                    int yy = a.length();
                    for (int i = 0; i < a.length(); ++i) {
                        int n = i;
                        long r = BoxesRunTime.unboxToLong(a.otherApply(n)) / BoxesRunTime.unboxToLong(b.apply(n));
                        if (r == 0L) continue;
                        builder.add(n, BoxesRunTime.boxToLong((long)r));
                    }
                } else {
                    int yy = a.activeSize();
                    for (int i = 0; i < a.activeSize(); ++i) {
                        int n = i;
                        int k = a.indexAt(n);
                        long v = BoxesRunTime.unboxToLong(a.valueAt(n));
                        long r = v / BoxesRunTime.unboxToLong(b.apply(k));
                        if (r == 0L) continue;
                        builder.add(k, BoxesRunTime.boxToLong((long)r));
                    }
                }
                return builder.toSparseVector(true, true);
            }
        });
        $this.breeze$linalg$operators$SparseVector_HashVector_Ops$_setter_$impl_Op_SV_HV_eq_SV_lhs_nilpotent_Int_OpSet_$eq(new UFunc.UImpl2<OpSet$, SparseVector<Object>, HashVector<Object>, SparseVector<Object>>($this){
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                ((BinaryRegistry)Predef$.MODULE$.implicitly($outer.impl_Op_V_V_eq_V_Int_OpSet())).register(this, ClassTag$.MODULE$.apply(SparseVector.class), ClassTag$.MODULE$.apply(HashVector.class));
            }

            public SparseVector apply(SparseVector a, HashVector b) {
                if (b.length() != a.length()) {
                    throw new IllegalArgumentException(StringOps$.MODULE$.format$extension("requirement failed: %s", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{new StringBuilder(55).append("Vectors must be the same length!").append(": ").append("b.length.==(a.length)").toString()})));
                }
                VectorBuilder<Object> builder = new VectorBuilder<Object>(a.length(), VectorBuilder$.MODULE$.$lessinit$greater$default$2(), Semiring$.MODULE$.semiringInt(), ClassTag$.MODULE$.apply(Integer.TYPE));
                if (OpSet$.MODULE$.equals(OpSet$.MODULE$) || b.activeSize() != b.length()) {
                    int yy = a.length();
                    for (int i = 0; i < a.length(); ++i) {
                        int n = i;
                        int r = BoxesRunTime.unboxToInt(b.apply(n));
                        if (r == 0) continue;
                        builder.add(n, BoxesRunTime.boxToInteger((int)r));
                    }
                } else {
                    int yy = a.activeSize();
                    for (int i = 0; i < a.activeSize(); ++i) {
                        int n = i;
                        int k = a.indexAt(n);
                        int v = BoxesRunTime.unboxToInt(a.valueAt(n));
                        int r = BoxesRunTime.unboxToInt(b.apply(k));
                        if (r == 0) continue;
                        builder.add(k, BoxesRunTime.boxToInteger((int)r));
                    }
                }
                return builder.toSparseVector(true, true);
            }
        });
        $this.breeze$linalg$operators$SparseVector_HashVector_Ops$_setter_$impl_Op_SV_HV_eq_SV_lhs_nilpotent_Double_OpSet_$eq(new UFunc.UImpl2<OpSet$, SparseVector<Object>, HashVector<Object>, SparseVector<Object>>($this){
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                ((BinaryRegistry)Predef$.MODULE$.implicitly($outer.impl_Op_V_V_eq_V_Double_OpSet())).register(this, ClassTag$.MODULE$.apply(SparseVector.class), ClassTag$.MODULE$.apply(HashVector.class));
            }

            public SparseVector apply(SparseVector a, HashVector b) {
                if (b.length() != a.length()) {
                    throw new IllegalArgumentException(StringOps$.MODULE$.format$extension("requirement failed: %s", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{new StringBuilder(55).append("Vectors must be the same length!").append(": ").append("b.length.==(a.length)").toString()})));
                }
                VectorBuilder<Object> builder = new VectorBuilder<Object>(a.length(), VectorBuilder$.MODULE$.$lessinit$greater$default$2(), Semiring$.MODULE$.semiringD(), ClassTag$.MODULE$.apply(Double.TYPE));
                if (OpSet$.MODULE$.equals(OpSet$.MODULE$) || b.activeSize() != b.length()) {
                    int yy = a.length();
                    for (int i = 0; i < a.length(); ++i) {
                        int n = i;
                        double r = BoxesRunTime.unboxToDouble(b.apply(n));
                        if (r == 0.0) continue;
                        builder.add(n, BoxesRunTime.boxToDouble((double)r));
                    }
                } else {
                    int yy = a.activeSize();
                    for (int i = 0; i < a.activeSize(); ++i) {
                        int n = i;
                        int k = a.indexAt(n);
                        double v = BoxesRunTime.unboxToDouble(a.valueAt(n));
                        double r = BoxesRunTime.unboxToDouble(b.apply(k));
                        if (r == 0.0) continue;
                        builder.add(k, BoxesRunTime.boxToDouble((double)r));
                    }
                }
                return builder.toSparseVector(true, true);
            }
        });
        $this.breeze$linalg$operators$SparseVector_HashVector_Ops$_setter_$impl_Op_SV_HV_eq_SV_lhs_nilpotent_Float_OpSet_$eq(new UFunc.UImpl2<OpSet$, SparseVector<Object>, HashVector<Object>, SparseVector<Object>>($this){
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                ((BinaryRegistry)Predef$.MODULE$.implicitly($outer.impl_Op_V_V_eq_V_Float_OpSet())).register(this, ClassTag$.MODULE$.apply(SparseVector.class), ClassTag$.MODULE$.apply(HashVector.class));
            }

            public SparseVector apply(SparseVector a, HashVector b) {
                if (b.length() != a.length()) {
                    throw new IllegalArgumentException(StringOps$.MODULE$.format$extension("requirement failed: %s", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{new StringBuilder(55).append("Vectors must be the same length!").append(": ").append("b.length.==(a.length)").toString()})));
                }
                VectorBuilder<Object> builder = new VectorBuilder<Object>(a.length(), VectorBuilder$.MODULE$.$lessinit$greater$default$2(), Semiring$.MODULE$.semiringFloat(), ClassTag$.MODULE$.apply(Float.TYPE));
                if (OpSet$.MODULE$.equals(OpSet$.MODULE$) || b.activeSize() != b.length()) {
                    int yy = a.length();
                    for (int i = 0; i < a.length(); ++i) {
                        int n = i;
                        float r = BoxesRunTime.unboxToFloat(b.apply(n));
                        if (r == 0.0f) continue;
                        builder.add(n, BoxesRunTime.boxToFloat((float)r));
                    }
                } else {
                    int yy = a.activeSize();
                    for (int i = 0; i < a.activeSize(); ++i) {
                        int n = i;
                        int k = a.indexAt(n);
                        float v = BoxesRunTime.unboxToFloat(a.valueAt(n));
                        float r = BoxesRunTime.unboxToFloat(b.apply(k));
                        if (r == 0.0f) continue;
                        builder.add(k, BoxesRunTime.boxToFloat((float)r));
                    }
                }
                return builder.toSparseVector(true, true);
            }
        });
        $this.breeze$linalg$operators$SparseVector_HashVector_Ops$_setter_$impl_Op_SV_HV_eq_SV_lhs_nilpotent_Long_OpSet_$eq(new UFunc.UImpl2<OpSet$, SparseVector<Object>, HashVector<Object>, SparseVector<Object>>($this){
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                ((BinaryRegistry)Predef$.MODULE$.implicitly($outer.impl_Op_V_V_eq_V_Long_OpSet())).register(this, ClassTag$.MODULE$.apply(SparseVector.class), ClassTag$.MODULE$.apply(HashVector.class));
            }

            public SparseVector apply(SparseVector a, HashVector b) {
                if (b.length() != a.length()) {
                    throw new IllegalArgumentException(StringOps$.MODULE$.format$extension("requirement failed: %s", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{new StringBuilder(55).append("Vectors must be the same length!").append(": ").append("b.length.==(a.length)").toString()})));
                }
                VectorBuilder<Object> builder = new VectorBuilder<Object>(a.length(), VectorBuilder$.MODULE$.$lessinit$greater$default$2(), Semiring$.MODULE$.semiringLong(), ClassTag$.MODULE$.apply(Long.TYPE));
                if (OpSet$.MODULE$.equals(OpSet$.MODULE$) || b.activeSize() != b.length()) {
                    int yy = a.length();
                    for (int i = 0; i < a.length(); ++i) {
                        int n = i;
                        long r = BoxesRunTime.unboxToLong(b.apply(n));
                        if (r == 0L) continue;
                        builder.add(n, BoxesRunTime.boxToLong((long)r));
                    }
                } else {
                    int yy = a.activeSize();
                    for (int i = 0; i < a.activeSize(); ++i) {
                        int n = i;
                        int k = a.indexAt(n);
                        long v = BoxesRunTime.unboxToLong(a.valueAt(n));
                        long r = BoxesRunTime.unboxToLong(b.apply(k));
                        if (r == 0L) continue;
                        builder.add(k, BoxesRunTime.boxToLong((long)r));
                    }
                }
                return builder.toSparseVector(true, true);
            }
        });
        $this.breeze$linalg$operators$SparseVector_HashVector_Ops$_setter_$impl_Op_SV_HV_eq_SV_lhs_nilpotent_Int_OpMod_$eq(new UFunc.UImpl2<OpMod$, SparseVector<Object>, HashVector<Object>, SparseVector<Object>>($this){
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                ((BinaryRegistry)Predef$.MODULE$.implicitly($outer.impl_Op_V_V_eq_V_Int_OpMod())).register(this, ClassTag$.MODULE$.apply(SparseVector.class), ClassTag$.MODULE$.apply(HashVector.class));
            }

            public SparseVector apply(SparseVector a, HashVector b) {
                if (b.length() != a.length()) {
                    throw new IllegalArgumentException(StringOps$.MODULE$.format$extension("requirement failed: %s", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{new StringBuilder(55).append("Vectors must be the same length!").append(": ").append("b.length.==(a.length)").toString()})));
                }
                VectorBuilder<Object> builder = new VectorBuilder<Object>(a.length(), VectorBuilder$.MODULE$.$lessinit$greater$default$2(), Semiring$.MODULE$.semiringInt(), ClassTag$.MODULE$.apply(Integer.TYPE));
                if (OpMod$.MODULE$.equals(OpSet$.MODULE$) || b.activeSize() != b.length()) {
                    int yy = a.length();
                    for (int i = 0; i < a.length(); ++i) {
                        int n = i;
                        int r = BoxesRunTime.unboxToInt(a.otherApply(n)) % BoxesRunTime.unboxToInt(b.apply(n));
                        if (r == 0) continue;
                        builder.add(n, BoxesRunTime.boxToInteger((int)r));
                    }
                } else {
                    int yy = a.activeSize();
                    for (int i = 0; i < a.activeSize(); ++i) {
                        int n = i;
                        int k = a.indexAt(n);
                        int v = BoxesRunTime.unboxToInt(a.valueAt(n));
                        int r = v % BoxesRunTime.unboxToInt(b.apply(k));
                        if (r == 0) continue;
                        builder.add(k, BoxesRunTime.boxToInteger((int)r));
                    }
                }
                return builder.toSparseVector(true, true);
            }
        });
        $this.breeze$linalg$operators$SparseVector_HashVector_Ops$_setter_$impl_Op_SV_HV_eq_SV_lhs_nilpotent_Double_OpMod_$eq(new UFunc.UImpl2<OpMod$, SparseVector<Object>, HashVector<Object>, SparseVector<Object>>($this){
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                ((BinaryRegistry)Predef$.MODULE$.implicitly($outer.impl_Op_V_V_eq_V_Double_OpMod())).register(this, ClassTag$.MODULE$.apply(SparseVector.class), ClassTag$.MODULE$.apply(HashVector.class));
            }

            public SparseVector apply(SparseVector a, HashVector b) {
                if (b.length() != a.length()) {
                    throw new IllegalArgumentException(StringOps$.MODULE$.format$extension("requirement failed: %s", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{new StringBuilder(55).append("Vectors must be the same length!").append(": ").append("b.length.==(a.length)").toString()})));
                }
                VectorBuilder<Object> builder = new VectorBuilder<Object>(a.length(), VectorBuilder$.MODULE$.$lessinit$greater$default$2(), Semiring$.MODULE$.semiringD(), ClassTag$.MODULE$.apply(Double.TYPE));
                if (OpMod$.MODULE$.equals(OpSet$.MODULE$) || b.activeSize() != b.length()) {
                    int yy = a.length();
                    for (int i = 0; i < a.length(); ++i) {
                        int n = i;
                        double r = BoxesRunTime.unboxToDouble(a.otherApply(n)) % BoxesRunTime.unboxToDouble(b.apply(n));
                        if (r == 0.0) continue;
                        builder.add(n, BoxesRunTime.boxToDouble((double)r));
                    }
                } else {
                    int yy = a.activeSize();
                    for (int i = 0; i < a.activeSize(); ++i) {
                        int n = i;
                        int k = a.indexAt(n);
                        double v = BoxesRunTime.unboxToDouble(a.valueAt(n));
                        double r = v % BoxesRunTime.unboxToDouble(b.apply(k));
                        if (r == 0.0) continue;
                        builder.add(k, BoxesRunTime.boxToDouble((double)r));
                    }
                }
                return builder.toSparseVector(true, true);
            }
        });
        $this.breeze$linalg$operators$SparseVector_HashVector_Ops$_setter_$impl_Op_SV_HV_eq_SV_lhs_nilpotent_Float_OpMod_$eq(new UFunc.UImpl2<OpMod$, SparseVector<Object>, HashVector<Object>, SparseVector<Object>>($this){
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                ((BinaryRegistry)Predef$.MODULE$.implicitly($outer.impl_Op_V_V_eq_V_Float_OpMod())).register(this, ClassTag$.MODULE$.apply(SparseVector.class), ClassTag$.MODULE$.apply(HashVector.class));
            }

            public SparseVector apply(SparseVector a, HashVector b) {
                if (b.length() != a.length()) {
                    throw new IllegalArgumentException(StringOps$.MODULE$.format$extension("requirement failed: %s", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{new StringBuilder(55).append("Vectors must be the same length!").append(": ").append("b.length.==(a.length)").toString()})));
                }
                VectorBuilder<Object> builder = new VectorBuilder<Object>(a.length(), VectorBuilder$.MODULE$.$lessinit$greater$default$2(), Semiring$.MODULE$.semiringFloat(), ClassTag$.MODULE$.apply(Float.TYPE));
                if (OpMod$.MODULE$.equals(OpSet$.MODULE$) || b.activeSize() != b.length()) {
                    int yy = a.length();
                    for (int i = 0; i < a.length(); ++i) {
                        int n = i;
                        float r = BoxesRunTime.unboxToFloat(a.otherApply(n)) % BoxesRunTime.unboxToFloat(b.apply(n));
                        if (r == 0.0f) continue;
                        builder.add(n, BoxesRunTime.boxToFloat((float)r));
                    }
                } else {
                    int yy = a.activeSize();
                    for (int i = 0; i < a.activeSize(); ++i) {
                        int n = i;
                        int k = a.indexAt(n);
                        float v = BoxesRunTime.unboxToFloat(a.valueAt(n));
                        float r = v % BoxesRunTime.unboxToFloat(b.apply(k));
                        if (r == 0.0f) continue;
                        builder.add(k, BoxesRunTime.boxToFloat((float)r));
                    }
                }
                return builder.toSparseVector(true, true);
            }
        });
        $this.breeze$linalg$operators$SparseVector_HashVector_Ops$_setter_$impl_Op_SV_HV_eq_SV_lhs_nilpotent_Long_OpMod_$eq(new UFunc.UImpl2<OpMod$, SparseVector<Object>, HashVector<Object>, SparseVector<Object>>($this){
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                ((BinaryRegistry)Predef$.MODULE$.implicitly($outer.impl_Op_V_V_eq_V_Long_OpMod())).register(this, ClassTag$.MODULE$.apply(SparseVector.class), ClassTag$.MODULE$.apply(HashVector.class));
            }

            public SparseVector apply(SparseVector a, HashVector b) {
                if (b.length() != a.length()) {
                    throw new IllegalArgumentException(StringOps$.MODULE$.format$extension("requirement failed: %s", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{new StringBuilder(55).append("Vectors must be the same length!").append(": ").append("b.length.==(a.length)").toString()})));
                }
                VectorBuilder<Object> builder = new VectorBuilder<Object>(a.length(), VectorBuilder$.MODULE$.$lessinit$greater$default$2(), Semiring$.MODULE$.semiringLong(), ClassTag$.MODULE$.apply(Long.TYPE));
                if (OpMod$.MODULE$.equals(OpSet$.MODULE$) || b.activeSize() != b.length()) {
                    int yy = a.length();
                    for (int i = 0; i < a.length(); ++i) {
                        int n = i;
                        long r = BoxesRunTime.unboxToLong(a.otherApply(n)) % BoxesRunTime.unboxToLong(b.apply(n));
                        if (r == 0L) continue;
                        builder.add(n, BoxesRunTime.boxToLong((long)r));
                    }
                } else {
                    int yy = a.activeSize();
                    for (int i = 0; i < a.activeSize(); ++i) {
                        int n = i;
                        int k = a.indexAt(n);
                        long v = BoxesRunTime.unboxToLong(a.valueAt(n));
                        long r = v % BoxesRunTime.unboxToLong(b.apply(k));
                        if (r == 0L) continue;
                        builder.add(k, BoxesRunTime.boxToLong((long)r));
                    }
                }
                return builder.toSparseVector(true, true);
            }
        });
        $this.breeze$linalg$operators$SparseVector_HashVector_Ops$_setter_$impl_Op_SV_HV_eq_SV_lhs_nilpotent_Int_OpPow_$eq(new UFunc.UImpl2<OpPow$, SparseVector<Object>, HashVector<Object>, SparseVector<Object>>($this){
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                ((BinaryRegistry)Predef$.MODULE$.implicitly($outer.impl_Op_V_V_eq_V_Int_OpPow())).register(this, ClassTag$.MODULE$.apply(SparseVector.class), ClassTag$.MODULE$.apply(HashVector.class));
            }

            public SparseVector apply(SparseVector a, HashVector b) {
                if (b.length() != a.length()) {
                    throw new IllegalArgumentException(StringOps$.MODULE$.format$extension("requirement failed: %s", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{new StringBuilder(55).append("Vectors must be the same length!").append(": ").append("b.length.==(a.length)").toString()})));
                }
                VectorBuilder<Object> builder = new VectorBuilder<Object>(a.length(), VectorBuilder$.MODULE$.$lessinit$greater$default$2(), Semiring$.MODULE$.semiringInt(), ClassTag$.MODULE$.apply(Integer.TYPE));
                if (OpPow$.MODULE$.equals(OpSet$.MODULE$) || b.activeSize() != b.length()) {
                    int yy = a.length();
                    for (int i = 0; i < a.length(); ++i) {
                        int n = i;
                        int r = PowImplicits$.MODULE$.IntPow(BoxesRunTime.unboxToInt(a.otherApply(n))).pow(BoxesRunTime.unboxToInt(b.apply(n)));
                        if (r == 0) continue;
                        builder.add(n, BoxesRunTime.boxToInteger((int)r));
                    }
                } else {
                    int yy = a.activeSize();
                    for (int i = 0; i < a.activeSize(); ++i) {
                        int n = i;
                        int k = a.indexAt(n);
                        int v = BoxesRunTime.unboxToInt(a.valueAt(n));
                        int r = PowImplicits$.MODULE$.IntPow(v).pow(BoxesRunTime.unboxToInt(b.apply(k)));
                        if (r == 0) continue;
                        builder.add(k, BoxesRunTime.boxToInteger((int)r));
                    }
                }
                return builder.toSparseVector(true, true);
            }
        });
        $this.breeze$linalg$operators$SparseVector_HashVector_Ops$_setter_$impl_Op_SV_HV_eq_SV_lhs_nilpotent_Double_OpPow_$eq(new UFunc.UImpl2<OpPow$, SparseVector<Object>, HashVector<Object>, SparseVector<Object>>($this){
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                ((BinaryRegistry)Predef$.MODULE$.implicitly($outer.impl_Op_V_V_eq_V_Double_OpPow())).register(this, ClassTag$.MODULE$.apply(SparseVector.class), ClassTag$.MODULE$.apply(HashVector.class));
            }

            public SparseVector apply(SparseVector a, HashVector b) {
                if (b.length() != a.length()) {
                    throw new IllegalArgumentException(StringOps$.MODULE$.format$extension("requirement failed: %s", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{new StringBuilder(55).append("Vectors must be the same length!").append(": ").append("b.length.==(a.length)").toString()})));
                }
                VectorBuilder<Object> builder = new VectorBuilder<Object>(a.length(), VectorBuilder$.MODULE$.$lessinit$greater$default$2(), Semiring$.MODULE$.semiringD(), ClassTag$.MODULE$.apply(Double.TYPE));
                if (OpPow$.MODULE$.equals(OpSet$.MODULE$) || b.activeSize() != b.length()) {
                    int yy = a.length();
                    for (int i = 0; i < a.length(); ++i) {
                        int n = i;
                        double r = PowImplicits$.MODULE$.DoublePow(BoxesRunTime.unboxToDouble(a.otherApply(n))).pow(BoxesRunTime.unboxToDouble(b.apply(n)));
                        if (r == 0.0) continue;
                        builder.add(n, BoxesRunTime.boxToDouble((double)r));
                    }
                } else {
                    int yy = a.activeSize();
                    for (int i = 0; i < a.activeSize(); ++i) {
                        int n = i;
                        int k = a.indexAt(n);
                        double v = BoxesRunTime.unboxToDouble(a.valueAt(n));
                        double r = PowImplicits$.MODULE$.DoublePow(v).pow(BoxesRunTime.unboxToDouble(b.apply(k)));
                        if (r == 0.0) continue;
                        builder.add(k, BoxesRunTime.boxToDouble((double)r));
                    }
                }
                return builder.toSparseVector(true, true);
            }
        });
        $this.breeze$linalg$operators$SparseVector_HashVector_Ops$_setter_$impl_Op_SV_HV_eq_SV_lhs_nilpotent_Float_OpPow_$eq(new UFunc.UImpl2<OpPow$, SparseVector<Object>, HashVector<Object>, SparseVector<Object>>($this){
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                ((BinaryRegistry)Predef$.MODULE$.implicitly($outer.impl_Op_V_V_eq_V_Float_OpPow())).register(this, ClassTag$.MODULE$.apply(SparseVector.class), ClassTag$.MODULE$.apply(HashVector.class));
            }

            public SparseVector apply(SparseVector a, HashVector b) {
                if (b.length() != a.length()) {
                    throw new IllegalArgumentException(StringOps$.MODULE$.format$extension("requirement failed: %s", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{new StringBuilder(55).append("Vectors must be the same length!").append(": ").append("b.length.==(a.length)").toString()})));
                }
                VectorBuilder<Object> builder = new VectorBuilder<Object>(a.length(), VectorBuilder$.MODULE$.$lessinit$greater$default$2(), Semiring$.MODULE$.semiringFloat(), ClassTag$.MODULE$.apply(Float.TYPE));
                if (OpPow$.MODULE$.equals(OpSet$.MODULE$) || b.activeSize() != b.length()) {
                    int yy = a.length();
                    for (int i = 0; i < a.length(); ++i) {
                        int n = i;
                        float r = PowImplicits$.MODULE$.FloatPow(BoxesRunTime.unboxToFloat(a.otherApply(n))).pow(BoxesRunTime.unboxToFloat(b.apply(n)));
                        if (r == 0.0f) continue;
                        builder.add(n, BoxesRunTime.boxToFloat((float)r));
                    }
                } else {
                    int yy = a.activeSize();
                    for (int i = 0; i < a.activeSize(); ++i) {
                        int n = i;
                        int k = a.indexAt(n);
                        float v = BoxesRunTime.unboxToFloat(a.valueAt(n));
                        float r = PowImplicits$.MODULE$.FloatPow(v).pow(BoxesRunTime.unboxToFloat(b.apply(k)));
                        if (r == 0.0f) continue;
                        builder.add(k, BoxesRunTime.boxToFloat((float)r));
                    }
                }
                return builder.toSparseVector(true, true);
            }
        });
        $this.breeze$linalg$operators$SparseVector_HashVector_Ops$_setter_$impl_Op_SV_HV_eq_SV_lhs_nilpotent_Long_OpPow_$eq(new UFunc.UImpl2<OpPow$, SparseVector<Object>, HashVector<Object>, SparseVector<Object>>($this){
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                ((BinaryRegistry)Predef$.MODULE$.implicitly($outer.impl_Op_V_V_eq_V_Long_OpPow())).register(this, ClassTag$.MODULE$.apply(SparseVector.class), ClassTag$.MODULE$.apply(HashVector.class));
            }

            public SparseVector apply(SparseVector a, HashVector b) {
                if (b.length() != a.length()) {
                    throw new IllegalArgumentException(StringOps$.MODULE$.format$extension("requirement failed: %s", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{new StringBuilder(55).append("Vectors must be the same length!").append(": ").append("b.length.==(a.length)").toString()})));
                }
                VectorBuilder<Object> builder = new VectorBuilder<Object>(a.length(), VectorBuilder$.MODULE$.$lessinit$greater$default$2(), Semiring$.MODULE$.semiringLong(), ClassTag$.MODULE$.apply(Long.TYPE));
                if (OpPow$.MODULE$.equals(OpSet$.MODULE$) || b.activeSize() != b.length()) {
                    int yy = a.length();
                    for (int i = 0; i < a.length(); ++i) {
                        int n = i;
                        long r = PowImplicits$.MODULE$.LongPow(BoxesRunTime.unboxToLong(a.otherApply(n))).pow(BoxesRunTime.unboxToLong(b.apply(n)));
                        if (r == 0L) continue;
                        builder.add(n, BoxesRunTime.boxToLong((long)r));
                    }
                } else {
                    int yy = a.activeSize();
                    for (int i = 0; i < a.activeSize(); ++i) {
                        int n = i;
                        int k = a.indexAt(n);
                        long v = BoxesRunTime.unboxToLong(a.valueAt(n));
                        long r = PowImplicits$.MODULE$.LongPow(v).pow(BoxesRunTime.unboxToLong(b.apply(k)));
                        if (r == 0L) continue;
                        builder.add(k, BoxesRunTime.boxToLong((long)r));
                    }
                }
                return builder.toSparseVector(true, true);
            }
        });
        $this.breeze$linalg$operators$SparseVector_HashVector_Ops$_setter_$impl_OpMulScalar_SV_HV_eq_SV_Int_$eq(new UFunc.UImpl2<OpMulScalar$, SparseVector<Object>, HashVector<Object>, SparseVector<Object>>($this){
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                ((BinaryRegistry)Predef$.MODULE$.implicitly($outer.impl_Op_V_V_eq_V_nilpotent_Int())).register(this, ClassTag$.MODULE$.apply(SparseVector.class), ClassTag$.MODULE$.apply(HashVector.class));
            }

            public SparseVector apply(SparseVector a, HashVector b) {
                if (b.length() != a.length()) {
                    throw new IllegalArgumentException(StringOps$.MODULE$.format$extension("requirement failed: %s", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{new StringBuilder(55).append("Vectors must be the same length!").append(": ").append("b.length.==(a.length)").toString()})));
                }
                VectorBuilder<Object> builder = new VectorBuilder<Object>(a.length(), VectorBuilder$.MODULE$.$lessinit$greater$default$2(), Semiring$.MODULE$.semiringInt(), ClassTag$.MODULE$.apply(Integer.TYPE));
                int yy = a.activeSize();
                for (int i = 0; i < a.activeSize(); ++i) {
                    int n = i;
                    int k = a.indexAt(n);
                    int v = BoxesRunTime.unboxToInt(a.valueAt(n));
                    int r = v * BoxesRunTime.unboxToInt(b.apply(k));
                    if (r == 0) continue;
                    builder.add(k, BoxesRunTime.boxToInteger((int)r));
                }
                return builder.toSparseVector(true, true);
            }
        });
        $this.breeze$linalg$operators$SparseVector_HashVector_Ops$_setter_$impl_OpMulScalar_SV_HV_eq_SV_Double_$eq(new UFunc.UImpl2<OpMulScalar$, SparseVector<Object>, HashVector<Object>, SparseVector<Object>>($this){
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                ((BinaryRegistry)Predef$.MODULE$.implicitly($outer.impl_Op_V_V_eq_V_nilpotent_Double())).register(this, ClassTag$.MODULE$.apply(SparseVector.class), ClassTag$.MODULE$.apply(HashVector.class));
            }

            public SparseVector apply(SparseVector a, HashVector b) {
                if (b.length() != a.length()) {
                    throw new IllegalArgumentException(StringOps$.MODULE$.format$extension("requirement failed: %s", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{new StringBuilder(55).append("Vectors must be the same length!").append(": ").append("b.length.==(a.length)").toString()})));
                }
                VectorBuilder<Object> builder = new VectorBuilder<Object>(a.length(), VectorBuilder$.MODULE$.$lessinit$greater$default$2(), Semiring$.MODULE$.semiringD(), ClassTag$.MODULE$.apply(Double.TYPE));
                int yy = a.activeSize();
                for (int i = 0; i < a.activeSize(); ++i) {
                    int n = i;
                    int k = a.indexAt(n);
                    double v = BoxesRunTime.unboxToDouble(a.valueAt(n));
                    double r = v * BoxesRunTime.unboxToDouble(b.apply(k));
                    if (r == 0.0) continue;
                    builder.add(k, BoxesRunTime.boxToDouble((double)r));
                }
                return builder.toSparseVector(true, true);
            }
        });
        $this.breeze$linalg$operators$SparseVector_HashVector_Ops$_setter_$impl_OpMulScalar_SV_HV_eq_SV_Float_$eq(new UFunc.UImpl2<OpMulScalar$, SparseVector<Object>, HashVector<Object>, SparseVector<Object>>($this){
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                ((BinaryRegistry)Predef$.MODULE$.implicitly($outer.impl_Op_V_V_eq_V_nilpotent_Float())).register(this, ClassTag$.MODULE$.apply(SparseVector.class), ClassTag$.MODULE$.apply(HashVector.class));
            }

            public SparseVector apply(SparseVector a, HashVector b) {
                if (b.length() != a.length()) {
                    throw new IllegalArgumentException(StringOps$.MODULE$.format$extension("requirement failed: %s", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{new StringBuilder(55).append("Vectors must be the same length!").append(": ").append("b.length.==(a.length)").toString()})));
                }
                VectorBuilder<Object> builder = new VectorBuilder<Object>(a.length(), VectorBuilder$.MODULE$.$lessinit$greater$default$2(), Semiring$.MODULE$.semiringFloat(), ClassTag$.MODULE$.apply(Float.TYPE));
                int yy = a.activeSize();
                for (int i = 0; i < a.activeSize(); ++i) {
                    int n = i;
                    int k = a.indexAt(n);
                    float v = BoxesRunTime.unboxToFloat(a.valueAt(n));
                    float r = v * BoxesRunTime.unboxToFloat(b.apply(k));
                    if (r == 0.0f) continue;
                    builder.add(k, BoxesRunTime.boxToFloat((float)r));
                }
                return builder.toSparseVector(true, true);
            }
        });
        $this.breeze$linalg$operators$SparseVector_HashVector_Ops$_setter_$impl_OpMulScalar_SV_HV_eq_SV_Long_$eq(new UFunc.UImpl2<OpMulScalar$, SparseVector<Object>, HashVector<Object>, SparseVector<Object>>($this){
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                ((BinaryRegistry)Predef$.MODULE$.implicitly($outer.impl_Op_V_V_eq_V_nilpotent_Long())).register(this, ClassTag$.MODULE$.apply(SparseVector.class), ClassTag$.MODULE$.apply(HashVector.class));
            }

            public SparseVector apply(SparseVector a, HashVector b) {
                if (b.length() != a.length()) {
                    throw new IllegalArgumentException(StringOps$.MODULE$.format$extension("requirement failed: %s", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{new StringBuilder(55).append("Vectors must be the same length!").append(": ").append("b.length.==(a.length)").toString()})));
                }
                VectorBuilder<Object> builder = new VectorBuilder<Object>(a.length(), VectorBuilder$.MODULE$.$lessinit$greater$default$2(), Semiring$.MODULE$.semiringLong(), ClassTag$.MODULE$.apply(Long.TYPE));
                int yy = a.activeSize();
                for (int i = 0; i < a.activeSize(); ++i) {
                    int n = i;
                    int k = a.indexAt(n);
                    long v = BoxesRunTime.unboxToLong(a.valueAt(n));
                    long r = v * BoxesRunTime.unboxToLong(b.apply(k));
                    if (r == 0L) continue;
                    builder.add(k, BoxesRunTime.boxToLong((long)r));
                }
                return builder.toSparseVector(true, true);
            }
        });
        $this.breeze$linalg$operators$SparseVector_HashVector_Ops$_setter_$impl_Op_SV_HV_eq_SV_Int_OpAdd_$eq(new UFunc.UImpl2<OpAdd$, SparseVector<Object>, HashVector<Object>, SparseVector<Object>>($this){
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                ((BinaryRegistry)Predef$.MODULE$.implicitly($outer.impl_Op_V_V_eq_V_idempotent_Int_OpAdd())).register(this, ClassTag$.MODULE$.apply(SparseVector.class), ClassTag$.MODULE$.apply(HashVector.class));
            }

            public SparseVector apply(SparseVector a, HashVector b) {
                if (b.length() != a.length()) {
                    throw new IllegalArgumentException(StringOps$.MODULE$.format$extension("requirement failed: %s", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{new StringBuilder(55).append("Vectors must be the same length!").append(": ").append("b.length.==(a.length)").toString()})));
                }
                VectorBuilder<Object> builder = new VectorBuilder<Object>(a.length(), VectorBuilder$.MODULE$.$lessinit$greater$default$2(), Semiring$.MODULE$.semiringInt(), ClassTag$.MODULE$.apply(Integer.TYPE));
                for (int aoff = 0; aoff < a.activeSize(); ++aoff) {
                    int k = a.indexAt(aoff);
                    int v = BoxesRunTime.unboxToInt(a.valueAt(aoff));
                    builder.add(k, BoxesRunTime.boxToInteger((int)v));
                }
                b.activeIterator().withFilter(SparseVector_HashVector_Ops::breeze$linalg$operators$SparseVector_HashVector_Ops$$anon$242$$_$apply$$anonfun$209).foreach((Function1)((JProcedure1 & Serializable)arg_0 -> SparseVector_HashVector_Ops.breeze$linalg$operators$SparseVector_HashVector_Ops$$anon$242$$_$apply$$anonfun$210(builder, arg_0)));
                return builder.toSparseVector();
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{breeze$linalg$operators$SparseVector_HashVector_Ops$$anon$242$$_$apply$$anonfun$209(scala.Tuple2 ), breeze$linalg$operators$SparseVector_HashVector_Ops$$anon$242$$_$apply$$anonfun$210(breeze.linalg.VectorBuilder scala.Tuple2 )}, serializedLambda);
            }
        });
        $this.breeze$linalg$operators$SparseVector_HashVector_Ops$_setter_$impl_Op_SV_HV_eq_SV_Double_OpAdd_$eq(new UFunc.UImpl2<OpAdd$, SparseVector<Object>, HashVector<Object>, SparseVector<Object>>($this){
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                ((BinaryRegistry)Predef$.MODULE$.implicitly($outer.impl_Op_V_V_eq_V_idempotent_Double_OpAdd())).register(this, ClassTag$.MODULE$.apply(SparseVector.class), ClassTag$.MODULE$.apply(HashVector.class));
            }

            public SparseVector apply(SparseVector a, HashVector b) {
                if (b.length() != a.length()) {
                    throw new IllegalArgumentException(StringOps$.MODULE$.format$extension("requirement failed: %s", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{new StringBuilder(55).append("Vectors must be the same length!").append(": ").append("b.length.==(a.length)").toString()})));
                }
                VectorBuilder<Object> builder = new VectorBuilder<Object>(a.length(), VectorBuilder$.MODULE$.$lessinit$greater$default$2(), Semiring$.MODULE$.semiringD(), ClassTag$.MODULE$.apply(Double.TYPE));
                for (int aoff = 0; aoff < a.activeSize(); ++aoff) {
                    int k = a.indexAt(aoff);
                    double v = BoxesRunTime.unboxToDouble(a.valueAt(aoff));
                    builder.add(k, BoxesRunTime.boxToDouble((double)v));
                }
                b.activeIterator().withFilter(SparseVector_HashVector_Ops::breeze$linalg$operators$SparseVector_HashVector_Ops$$anon$243$$_$apply$$anonfun$211).foreach((Function1)((JProcedure1 & Serializable)arg_0 -> SparseVector_HashVector_Ops.breeze$linalg$operators$SparseVector_HashVector_Ops$$anon$243$$_$apply$$anonfun$212(builder, arg_0)));
                return builder.toSparseVector();
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{breeze$linalg$operators$SparseVector_HashVector_Ops$$anon$243$$_$apply$$anonfun$211(scala.Tuple2 ), breeze$linalg$operators$SparseVector_HashVector_Ops$$anon$243$$_$apply$$anonfun$212(breeze.linalg.VectorBuilder scala.Tuple2 )}, serializedLambda);
            }
        });
        $this.breeze$linalg$operators$SparseVector_HashVector_Ops$_setter_$impl_Op_SV_HV_eq_SV_Float_OpAdd_$eq(new UFunc.UImpl2<OpAdd$, SparseVector<Object>, HashVector<Object>, SparseVector<Object>>($this){
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                ((BinaryRegistry)Predef$.MODULE$.implicitly($outer.impl_Op_V_V_eq_V_idempotent_Float_OpAdd())).register(this, ClassTag$.MODULE$.apply(SparseVector.class), ClassTag$.MODULE$.apply(HashVector.class));
            }

            public SparseVector apply(SparseVector a, HashVector b) {
                if (b.length() != a.length()) {
                    throw new IllegalArgumentException(StringOps$.MODULE$.format$extension("requirement failed: %s", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{new StringBuilder(55).append("Vectors must be the same length!").append(": ").append("b.length.==(a.length)").toString()})));
                }
                VectorBuilder<Object> builder = new VectorBuilder<Object>(a.length(), VectorBuilder$.MODULE$.$lessinit$greater$default$2(), Semiring$.MODULE$.semiringFloat(), ClassTag$.MODULE$.apply(Float.TYPE));
                for (int aoff = 0; aoff < a.activeSize(); ++aoff) {
                    int k = a.indexAt(aoff);
                    float v = BoxesRunTime.unboxToFloat(a.valueAt(aoff));
                    builder.add(k, BoxesRunTime.boxToFloat((float)v));
                }
                b.activeIterator().withFilter(SparseVector_HashVector_Ops::breeze$linalg$operators$SparseVector_HashVector_Ops$$anon$244$$_$apply$$anonfun$213).foreach((Function1)((JProcedure1 & Serializable)arg_0 -> SparseVector_HashVector_Ops.breeze$linalg$operators$SparseVector_HashVector_Ops$$anon$244$$_$apply$$anonfun$214(builder, arg_0)));
                return builder.toSparseVector();
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{breeze$linalg$operators$SparseVector_HashVector_Ops$$anon$244$$_$apply$$anonfun$213(scala.Tuple2 ), breeze$linalg$operators$SparseVector_HashVector_Ops$$anon$244$$_$apply$$anonfun$214(breeze.linalg.VectorBuilder scala.Tuple2 )}, serializedLambda);
            }
        });
        $this.breeze$linalg$operators$SparseVector_HashVector_Ops$_setter_$impl_Op_SV_HV_eq_SV_Long_OpAdd_$eq(new UFunc.UImpl2<OpAdd$, SparseVector<Object>, HashVector<Object>, SparseVector<Object>>($this){
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                ((BinaryRegistry)Predef$.MODULE$.implicitly($outer.impl_Op_V_V_eq_V_idempotent_Long_OpAdd())).register(this, ClassTag$.MODULE$.apply(SparseVector.class), ClassTag$.MODULE$.apply(HashVector.class));
            }

            public SparseVector apply(SparseVector a, HashVector b) {
                if (b.length() != a.length()) {
                    throw new IllegalArgumentException(StringOps$.MODULE$.format$extension("requirement failed: %s", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{new StringBuilder(55).append("Vectors must be the same length!").append(": ").append("b.length.==(a.length)").toString()})));
                }
                VectorBuilder<Object> builder = new VectorBuilder<Object>(a.length(), VectorBuilder$.MODULE$.$lessinit$greater$default$2(), Semiring$.MODULE$.semiringLong(), ClassTag$.MODULE$.apply(Long.TYPE));
                for (int aoff = 0; aoff < a.activeSize(); ++aoff) {
                    int k = a.indexAt(aoff);
                    long v = BoxesRunTime.unboxToLong(a.valueAt(aoff));
                    builder.add(k, BoxesRunTime.boxToLong((long)v));
                }
                b.activeIterator().withFilter(SparseVector_HashVector_Ops::breeze$linalg$operators$SparseVector_HashVector_Ops$$anon$245$$_$apply$$anonfun$215).foreach((Function1)((JProcedure1 & Serializable)arg_0 -> SparseVector_HashVector_Ops.breeze$linalg$operators$SparseVector_HashVector_Ops$$anon$245$$_$apply$$anonfun$216(builder, arg_0)));
                return builder.toSparseVector();
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{breeze$linalg$operators$SparseVector_HashVector_Ops$$anon$245$$_$apply$$anonfun$215(scala.Tuple2 ), breeze$linalg$operators$SparseVector_HashVector_Ops$$anon$245$$_$apply$$anonfun$216(breeze.linalg.VectorBuilder scala.Tuple2 )}, serializedLambda);
            }
        });
        $this.breeze$linalg$operators$SparseVector_HashVector_Ops$_setter_$impl_Op_SV_HV_eq_SV_Int_OpSub_$eq(new UFunc.UImpl2<OpSub$, SparseVector<Object>, HashVector<Object>, SparseVector<Object>>($this){
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                ((BinaryRegistry)Predef$.MODULE$.implicitly($outer.impl_Op_V_V_eq_V_idempotent_Int_OpSub())).register(this, ClassTag$.MODULE$.apply(SparseVector.class), ClassTag$.MODULE$.apply(HashVector.class));
            }

            public SparseVector apply(SparseVector a, HashVector b) {
                if (b.length() != a.length()) {
                    throw new IllegalArgumentException(StringOps$.MODULE$.format$extension("requirement failed: %s", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{new StringBuilder(55).append("Vectors must be the same length!").append(": ").append("b.length.==(a.length)").toString()})));
                }
                VectorBuilder<Object> builder = new VectorBuilder<Object>(a.length(), VectorBuilder$.MODULE$.$lessinit$greater$default$2(), Semiring$.MODULE$.semiringInt(), ClassTag$.MODULE$.apply(Integer.TYPE));
                for (int aoff = 0; aoff < a.activeSize(); ++aoff) {
                    int k = a.indexAt(aoff);
                    int v = BoxesRunTime.unboxToInt(a.valueAt(aoff));
                    builder.add(k, BoxesRunTime.boxToInteger((int)v));
                }
                b.activeIterator().withFilter(SparseVector_HashVector_Ops::breeze$linalg$operators$SparseVector_HashVector_Ops$$anon$246$$_$apply$$anonfun$217).foreach((Function1)((JProcedure1 & Serializable)arg_0 -> SparseVector_HashVector_Ops.breeze$linalg$operators$SparseVector_HashVector_Ops$$anon$246$$_$apply$$anonfun$218(builder, arg_0)));
                return builder.toSparseVector();
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{breeze$linalg$operators$SparseVector_HashVector_Ops$$anon$246$$_$apply$$anonfun$217(scala.Tuple2 ), breeze$linalg$operators$SparseVector_HashVector_Ops$$anon$246$$_$apply$$anonfun$218(breeze.linalg.VectorBuilder scala.Tuple2 )}, serializedLambda);
            }
        });
        $this.breeze$linalg$operators$SparseVector_HashVector_Ops$_setter_$impl_Op_SV_HV_eq_SV_Double_OpSub_$eq(new UFunc.UImpl2<OpSub$, SparseVector<Object>, HashVector<Object>, SparseVector<Object>>($this){
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                ((BinaryRegistry)Predef$.MODULE$.implicitly($outer.impl_Op_V_V_eq_V_idempotent_Double_OpSub())).register(this, ClassTag$.MODULE$.apply(SparseVector.class), ClassTag$.MODULE$.apply(HashVector.class));
            }

            public SparseVector apply(SparseVector a, HashVector b) {
                if (b.length() != a.length()) {
                    throw new IllegalArgumentException(StringOps$.MODULE$.format$extension("requirement failed: %s", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{new StringBuilder(55).append("Vectors must be the same length!").append(": ").append("b.length.==(a.length)").toString()})));
                }
                VectorBuilder<Object> builder = new VectorBuilder<Object>(a.length(), VectorBuilder$.MODULE$.$lessinit$greater$default$2(), Semiring$.MODULE$.semiringD(), ClassTag$.MODULE$.apply(Double.TYPE));
                for (int aoff = 0; aoff < a.activeSize(); ++aoff) {
                    int k = a.indexAt(aoff);
                    double v = BoxesRunTime.unboxToDouble(a.valueAt(aoff));
                    builder.add(k, BoxesRunTime.boxToDouble((double)v));
                }
                b.activeIterator().withFilter(SparseVector_HashVector_Ops::breeze$linalg$operators$SparseVector_HashVector_Ops$$anon$247$$_$apply$$anonfun$219).foreach((Function1)((JProcedure1 & Serializable)arg_0 -> SparseVector_HashVector_Ops.breeze$linalg$operators$SparseVector_HashVector_Ops$$anon$247$$_$apply$$anonfun$220(builder, arg_0)));
                return builder.toSparseVector();
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{breeze$linalg$operators$SparseVector_HashVector_Ops$$anon$247$$_$apply$$anonfun$219(scala.Tuple2 ), breeze$linalg$operators$SparseVector_HashVector_Ops$$anon$247$$_$apply$$anonfun$220(breeze.linalg.VectorBuilder scala.Tuple2 )}, serializedLambda);
            }
        });
        $this.breeze$linalg$operators$SparseVector_HashVector_Ops$_setter_$impl_Op_SV_HV_eq_SV_Float_OpSub_$eq(new UFunc.UImpl2<OpSub$, SparseVector<Object>, HashVector<Object>, SparseVector<Object>>($this){
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                ((BinaryRegistry)Predef$.MODULE$.implicitly($outer.impl_Op_V_V_eq_V_idempotent_Float_OpSub())).register(this, ClassTag$.MODULE$.apply(SparseVector.class), ClassTag$.MODULE$.apply(HashVector.class));
            }

            public SparseVector apply(SparseVector a, HashVector b) {
                if (b.length() != a.length()) {
                    throw new IllegalArgumentException(StringOps$.MODULE$.format$extension("requirement failed: %s", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{new StringBuilder(55).append("Vectors must be the same length!").append(": ").append("b.length.==(a.length)").toString()})));
                }
                VectorBuilder<Object> builder = new VectorBuilder<Object>(a.length(), VectorBuilder$.MODULE$.$lessinit$greater$default$2(), Semiring$.MODULE$.semiringFloat(), ClassTag$.MODULE$.apply(Float.TYPE));
                for (int aoff = 0; aoff < a.activeSize(); ++aoff) {
                    int k = a.indexAt(aoff);
                    float v = BoxesRunTime.unboxToFloat(a.valueAt(aoff));
                    builder.add(k, BoxesRunTime.boxToFloat((float)v));
                }
                b.activeIterator().withFilter(SparseVector_HashVector_Ops::breeze$linalg$operators$SparseVector_HashVector_Ops$$anon$248$$_$apply$$anonfun$221).foreach((Function1)((JProcedure1 & Serializable)arg_0 -> SparseVector_HashVector_Ops.breeze$linalg$operators$SparseVector_HashVector_Ops$$anon$248$$_$apply$$anonfun$222(builder, arg_0)));
                return builder.toSparseVector();
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{breeze$linalg$operators$SparseVector_HashVector_Ops$$anon$248$$_$apply$$anonfun$221(scala.Tuple2 ), breeze$linalg$operators$SparseVector_HashVector_Ops$$anon$248$$_$apply$$anonfun$222(breeze.linalg.VectorBuilder scala.Tuple2 )}, serializedLambda);
            }
        });
        $this.breeze$linalg$operators$SparseVector_HashVector_Ops$_setter_$impl_Op_SV_HV_eq_SV_Long_OpSub_$eq(new UFunc.UImpl2<OpSub$, SparseVector<Object>, HashVector<Object>, SparseVector<Object>>($this){
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                ((BinaryRegistry)Predef$.MODULE$.implicitly($outer.impl_Op_V_V_eq_V_idempotent_Long_OpSub())).register(this, ClassTag$.MODULE$.apply(SparseVector.class), ClassTag$.MODULE$.apply(HashVector.class));
            }

            public SparseVector apply(SparseVector a, HashVector b) {
                if (b.length() != a.length()) {
                    throw new IllegalArgumentException(StringOps$.MODULE$.format$extension("requirement failed: %s", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{new StringBuilder(55).append("Vectors must be the same length!").append(": ").append("b.length.==(a.length)").toString()})));
                }
                VectorBuilder<Object> builder = new VectorBuilder<Object>(a.length(), VectorBuilder$.MODULE$.$lessinit$greater$default$2(), Semiring$.MODULE$.semiringLong(), ClassTag$.MODULE$.apply(Long.TYPE));
                for (int aoff = 0; aoff < a.activeSize(); ++aoff) {
                    int k = a.indexAt(aoff);
                    long v = BoxesRunTime.unboxToLong(a.valueAt(aoff));
                    builder.add(k, BoxesRunTime.boxToLong((long)v));
                }
                b.activeIterator().withFilter(SparseVector_HashVector_Ops::breeze$linalg$operators$SparseVector_HashVector_Ops$$anon$249$$_$apply$$anonfun$223).foreach((Function1)((JProcedure1 & Serializable)arg_0 -> SparseVector_HashVector_Ops.breeze$linalg$operators$SparseVector_HashVector_Ops$$anon$249$$_$apply$$anonfun$224(builder, arg_0)));
                return builder.toSparseVector();
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{breeze$linalg$operators$SparseVector_HashVector_Ops$$anon$249$$_$apply$$anonfun$223(scala.Tuple2 ), breeze$linalg$operators$SparseVector_HashVector_Ops$$anon$249$$_$apply$$anonfun$224(breeze.linalg.VectorBuilder scala.Tuple2 )}, serializedLambda);
            }
        });
    }

    public UFunc.UImpl2<OpDiv$, SparseVector<Object>, HashVector<Object>, SparseVector<Object>> impl_Op_SV_HV_eq_SV_lhs_nilpotent_Int_OpDiv();

    public void breeze$linalg$operators$SparseVector_HashVector_Ops$_setter_$impl_Op_SV_HV_eq_SV_lhs_nilpotent_Int_OpDiv_$eq(UFunc.UImpl2 var1);

    public UFunc.UImpl2<OpDiv$, SparseVector<Object>, HashVector<Object>, SparseVector<Object>> impl_Op_SV_HV_eq_SV_lhs_nilpotent_Double_OpDiv();

    public void breeze$linalg$operators$SparseVector_HashVector_Ops$_setter_$impl_Op_SV_HV_eq_SV_lhs_nilpotent_Double_OpDiv_$eq(UFunc.UImpl2 var1);

    public UFunc.UImpl2<OpDiv$, SparseVector<Object>, HashVector<Object>, SparseVector<Object>> impl_Op_SV_HV_eq_SV_lhs_nilpotent_Float_OpDiv();

    public void breeze$linalg$operators$SparseVector_HashVector_Ops$_setter_$impl_Op_SV_HV_eq_SV_lhs_nilpotent_Float_OpDiv_$eq(UFunc.UImpl2 var1);

    public UFunc.UImpl2<OpDiv$, SparseVector<Object>, HashVector<Object>, SparseVector<Object>> impl_Op_SV_HV_eq_SV_lhs_nilpotent_Long_OpDiv();

    public void breeze$linalg$operators$SparseVector_HashVector_Ops$_setter_$impl_Op_SV_HV_eq_SV_lhs_nilpotent_Long_OpDiv_$eq(UFunc.UImpl2 var1);

    public UFunc.UImpl2<OpSet$, SparseVector<Object>, HashVector<Object>, SparseVector<Object>> impl_Op_SV_HV_eq_SV_lhs_nilpotent_Int_OpSet();

    public void breeze$linalg$operators$SparseVector_HashVector_Ops$_setter_$impl_Op_SV_HV_eq_SV_lhs_nilpotent_Int_OpSet_$eq(UFunc.UImpl2 var1);

    public UFunc.UImpl2<OpSet$, SparseVector<Object>, HashVector<Object>, SparseVector<Object>> impl_Op_SV_HV_eq_SV_lhs_nilpotent_Double_OpSet();

    public void breeze$linalg$operators$SparseVector_HashVector_Ops$_setter_$impl_Op_SV_HV_eq_SV_lhs_nilpotent_Double_OpSet_$eq(UFunc.UImpl2 var1);

    public UFunc.UImpl2<OpSet$, SparseVector<Object>, HashVector<Object>, SparseVector<Object>> impl_Op_SV_HV_eq_SV_lhs_nilpotent_Float_OpSet();

    public void breeze$linalg$operators$SparseVector_HashVector_Ops$_setter_$impl_Op_SV_HV_eq_SV_lhs_nilpotent_Float_OpSet_$eq(UFunc.UImpl2 var1);

    public UFunc.UImpl2<OpSet$, SparseVector<Object>, HashVector<Object>, SparseVector<Object>> impl_Op_SV_HV_eq_SV_lhs_nilpotent_Long_OpSet();

    public void breeze$linalg$operators$SparseVector_HashVector_Ops$_setter_$impl_Op_SV_HV_eq_SV_lhs_nilpotent_Long_OpSet_$eq(UFunc.UImpl2 var1);

    public UFunc.UImpl2<OpMod$, SparseVector<Object>, HashVector<Object>, SparseVector<Object>> impl_Op_SV_HV_eq_SV_lhs_nilpotent_Int_OpMod();

    public void breeze$linalg$operators$SparseVector_HashVector_Ops$_setter_$impl_Op_SV_HV_eq_SV_lhs_nilpotent_Int_OpMod_$eq(UFunc.UImpl2 var1);

    public UFunc.UImpl2<OpMod$, SparseVector<Object>, HashVector<Object>, SparseVector<Object>> impl_Op_SV_HV_eq_SV_lhs_nilpotent_Double_OpMod();

    public void breeze$linalg$operators$SparseVector_HashVector_Ops$_setter_$impl_Op_SV_HV_eq_SV_lhs_nilpotent_Double_OpMod_$eq(UFunc.UImpl2 var1);

    public UFunc.UImpl2<OpMod$, SparseVector<Object>, HashVector<Object>, SparseVector<Object>> impl_Op_SV_HV_eq_SV_lhs_nilpotent_Float_OpMod();

    public void breeze$linalg$operators$SparseVector_HashVector_Ops$_setter_$impl_Op_SV_HV_eq_SV_lhs_nilpotent_Float_OpMod_$eq(UFunc.UImpl2 var1);

    public UFunc.UImpl2<OpMod$, SparseVector<Object>, HashVector<Object>, SparseVector<Object>> impl_Op_SV_HV_eq_SV_lhs_nilpotent_Long_OpMod();

    public void breeze$linalg$operators$SparseVector_HashVector_Ops$_setter_$impl_Op_SV_HV_eq_SV_lhs_nilpotent_Long_OpMod_$eq(UFunc.UImpl2 var1);

    public UFunc.UImpl2<OpPow$, SparseVector<Object>, HashVector<Object>, SparseVector<Object>> impl_Op_SV_HV_eq_SV_lhs_nilpotent_Int_OpPow();

    public void breeze$linalg$operators$SparseVector_HashVector_Ops$_setter_$impl_Op_SV_HV_eq_SV_lhs_nilpotent_Int_OpPow_$eq(UFunc.UImpl2 var1);

    public UFunc.UImpl2<OpPow$, SparseVector<Object>, HashVector<Object>, SparseVector<Object>> impl_Op_SV_HV_eq_SV_lhs_nilpotent_Double_OpPow();

    public void breeze$linalg$operators$SparseVector_HashVector_Ops$_setter_$impl_Op_SV_HV_eq_SV_lhs_nilpotent_Double_OpPow_$eq(UFunc.UImpl2 var1);

    public UFunc.UImpl2<OpPow$, SparseVector<Object>, HashVector<Object>, SparseVector<Object>> impl_Op_SV_HV_eq_SV_lhs_nilpotent_Float_OpPow();

    public void breeze$linalg$operators$SparseVector_HashVector_Ops$_setter_$impl_Op_SV_HV_eq_SV_lhs_nilpotent_Float_OpPow_$eq(UFunc.UImpl2 var1);

    public UFunc.UImpl2<OpPow$, SparseVector<Object>, HashVector<Object>, SparseVector<Object>> impl_Op_SV_HV_eq_SV_lhs_nilpotent_Long_OpPow();

    public void breeze$linalg$operators$SparseVector_HashVector_Ops$_setter_$impl_Op_SV_HV_eq_SV_lhs_nilpotent_Long_OpPow_$eq(UFunc.UImpl2 var1);

    public UFunc.UImpl2<OpMulScalar$, SparseVector<Object>, HashVector<Object>, SparseVector<Object>> impl_OpMulScalar_SV_HV_eq_SV_Int();

    public void breeze$linalg$operators$SparseVector_HashVector_Ops$_setter_$impl_OpMulScalar_SV_HV_eq_SV_Int_$eq(UFunc.UImpl2 var1);

    public UFunc.UImpl2<OpMulScalar$, SparseVector<Object>, HashVector<Object>, SparseVector<Object>> impl_OpMulScalar_SV_HV_eq_SV_Double();

    public void breeze$linalg$operators$SparseVector_HashVector_Ops$_setter_$impl_OpMulScalar_SV_HV_eq_SV_Double_$eq(UFunc.UImpl2 var1);

    public UFunc.UImpl2<OpMulScalar$, SparseVector<Object>, HashVector<Object>, SparseVector<Object>> impl_OpMulScalar_SV_HV_eq_SV_Float();

    public void breeze$linalg$operators$SparseVector_HashVector_Ops$_setter_$impl_OpMulScalar_SV_HV_eq_SV_Float_$eq(UFunc.UImpl2 var1);

    public UFunc.UImpl2<OpMulScalar$, SparseVector<Object>, HashVector<Object>, SparseVector<Object>> impl_OpMulScalar_SV_HV_eq_SV_Long();

    public void breeze$linalg$operators$SparseVector_HashVector_Ops$_setter_$impl_OpMulScalar_SV_HV_eq_SV_Long_$eq(UFunc.UImpl2 var1);

    public UFunc.UImpl2<OpAdd$, SparseVector<Object>, HashVector<Object>, SparseVector<Object>> impl_Op_SV_HV_eq_SV_Int_OpAdd();

    public void breeze$linalg$operators$SparseVector_HashVector_Ops$_setter_$impl_Op_SV_HV_eq_SV_Int_OpAdd_$eq(UFunc.UImpl2 var1);

    public UFunc.UImpl2<OpAdd$, SparseVector<Object>, HashVector<Object>, SparseVector<Object>> impl_Op_SV_HV_eq_SV_Double_OpAdd();

    public void breeze$linalg$operators$SparseVector_HashVector_Ops$_setter_$impl_Op_SV_HV_eq_SV_Double_OpAdd_$eq(UFunc.UImpl2 var1);

    public UFunc.UImpl2<OpAdd$, SparseVector<Object>, HashVector<Object>, SparseVector<Object>> impl_Op_SV_HV_eq_SV_Float_OpAdd();

    public void breeze$linalg$operators$SparseVector_HashVector_Ops$_setter_$impl_Op_SV_HV_eq_SV_Float_OpAdd_$eq(UFunc.UImpl2 var1);

    public UFunc.UImpl2<OpAdd$, SparseVector<Object>, HashVector<Object>, SparseVector<Object>> impl_Op_SV_HV_eq_SV_Long_OpAdd();

    public void breeze$linalg$operators$SparseVector_HashVector_Ops$_setter_$impl_Op_SV_HV_eq_SV_Long_OpAdd_$eq(UFunc.UImpl2 var1);

    public UFunc.UImpl2<OpSub$, SparseVector<Object>, HashVector<Object>, SparseVector<Object>> impl_Op_SV_HV_eq_SV_Int_OpSub();

    public void breeze$linalg$operators$SparseVector_HashVector_Ops$_setter_$impl_Op_SV_HV_eq_SV_Int_OpSub_$eq(UFunc.UImpl2 var1);

    public UFunc.UImpl2<OpSub$, SparseVector<Object>, HashVector<Object>, SparseVector<Object>> impl_Op_SV_HV_eq_SV_Double_OpSub();

    public void breeze$linalg$operators$SparseVector_HashVector_Ops$_setter_$impl_Op_SV_HV_eq_SV_Double_OpSub_$eq(UFunc.UImpl2 var1);

    public UFunc.UImpl2<OpSub$, SparseVector<Object>, HashVector<Object>, SparseVector<Object>> impl_Op_SV_HV_eq_SV_Float_OpSub();

    public void breeze$linalg$operators$SparseVector_HashVector_Ops$_setter_$impl_Op_SV_HV_eq_SV_Float_OpSub_$eq(UFunc.UImpl2 var1);

    public UFunc.UImpl2<OpSub$, SparseVector<Object>, HashVector<Object>, SparseVector<Object>> impl_Op_SV_HV_eq_SV_Long_OpSub();

    public void breeze$linalg$operators$SparseVector_HashVector_Ops$_setter_$impl_Op_SV_HV_eq_SV_Long_OpSub_$eq(UFunc.UImpl2 var1);

    public static UFunc.UImpl2 impl_OpMulInner_SV_HV_eq_T$(SparseVector_HashVector_Ops $this, UFunc.UImpl2 op) {
        return $this.impl_OpMulInner_SV_HV_eq_T(op);
    }

    default public <T> UFunc.UImpl2<OpMulInner$, SparseVector<T>, HashVector<T>, T> impl_OpMulInner_SV_HV_eq_T(UFunc.UImpl2<OpMulInner$, HashVector<T>, SparseVector<T>, T> op) {
        return (a, b) -> b.dot(a, op);
    }

    public static /* synthetic */ boolean breeze$linalg$operators$SparseVector_HashVector_Ops$$anon$242$$_$apply$$anonfun$209(Tuple2 x$1) {
        boolean bl;
        Tuple2 tuple2 = x$1;
        if (tuple2 != null) {
            int k = BoxesRunTime.unboxToInt((Object)tuple2._1());
            int v = BoxesRunTime.unboxToInt((Object)tuple2._2());
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    public static /* synthetic */ void breeze$linalg$operators$SparseVector_HashVector_Ops$$anon$242$$_$apply$$anonfun$210(VectorBuilder builder$21, Tuple2 x$1) {
        Tuple2 tuple2 = x$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        int k = BoxesRunTime.unboxToInt((Object)tuple2._1());
        int v = BoxesRunTime.unboxToInt((Object)tuple2._2());
        builder$21.add(k, BoxesRunTime.boxToInteger((int)v));
    }

    public static /* synthetic */ boolean breeze$linalg$operators$SparseVector_HashVector_Ops$$anon$243$$_$apply$$anonfun$211(Tuple2 x$1) {
        boolean bl;
        Tuple2 tuple2 = x$1;
        if (tuple2 != null) {
            int k = BoxesRunTime.unboxToInt((Object)tuple2._1());
            double v = BoxesRunTime.unboxToDouble((Object)tuple2._2());
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    public static /* synthetic */ void breeze$linalg$operators$SparseVector_HashVector_Ops$$anon$243$$_$apply$$anonfun$212(VectorBuilder builder$22, Tuple2 x$1) {
        Tuple2 tuple2 = x$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        int k = BoxesRunTime.unboxToInt((Object)tuple2._1());
        double v = BoxesRunTime.unboxToDouble((Object)tuple2._2());
        builder$22.add(k, BoxesRunTime.boxToDouble((double)v));
    }

    public static /* synthetic */ boolean breeze$linalg$operators$SparseVector_HashVector_Ops$$anon$244$$_$apply$$anonfun$213(Tuple2 x$1) {
        boolean bl;
        Tuple2 tuple2 = x$1;
        if (tuple2 != null) {
            int k = BoxesRunTime.unboxToInt((Object)tuple2._1());
            float v = BoxesRunTime.unboxToFloat((Object)tuple2._2());
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    public static /* synthetic */ void breeze$linalg$operators$SparseVector_HashVector_Ops$$anon$244$$_$apply$$anonfun$214(VectorBuilder builder$23, Tuple2 x$1) {
        Tuple2 tuple2 = x$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        int k = BoxesRunTime.unboxToInt((Object)tuple2._1());
        float v = BoxesRunTime.unboxToFloat((Object)tuple2._2());
        builder$23.add(k, BoxesRunTime.boxToFloat((float)v));
    }

    public static /* synthetic */ boolean breeze$linalg$operators$SparseVector_HashVector_Ops$$anon$245$$_$apply$$anonfun$215(Tuple2 x$1) {
        boolean bl;
        Tuple2 tuple2 = x$1;
        if (tuple2 != null) {
            int k = BoxesRunTime.unboxToInt((Object)tuple2._1());
            long v = BoxesRunTime.unboxToLong((Object)tuple2._2());
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    public static /* synthetic */ void breeze$linalg$operators$SparseVector_HashVector_Ops$$anon$245$$_$apply$$anonfun$216(VectorBuilder builder$24, Tuple2 x$1) {
        Tuple2 tuple2 = x$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        int k = BoxesRunTime.unboxToInt((Object)tuple2._1());
        long v = BoxesRunTime.unboxToLong((Object)tuple2._2());
        builder$24.add(k, BoxesRunTime.boxToLong((long)v));
    }

    public static /* synthetic */ boolean breeze$linalg$operators$SparseVector_HashVector_Ops$$anon$246$$_$apply$$anonfun$217(Tuple2 x$1) {
        boolean bl;
        Tuple2 tuple2 = x$1;
        if (tuple2 != null) {
            int k = BoxesRunTime.unboxToInt((Object)tuple2._1());
            int v = BoxesRunTime.unboxToInt((Object)tuple2._2());
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    public static /* synthetic */ void breeze$linalg$operators$SparseVector_HashVector_Ops$$anon$246$$_$apply$$anonfun$218(VectorBuilder builder$25, Tuple2 x$1) {
        Tuple2 tuple2 = x$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        int k = BoxesRunTime.unboxToInt((Object)tuple2._1());
        int v = BoxesRunTime.unboxToInt((Object)tuple2._2());
        builder$25.add(k, BoxesRunTime.boxToInteger((int)v));
    }

    public static /* synthetic */ boolean breeze$linalg$operators$SparseVector_HashVector_Ops$$anon$247$$_$apply$$anonfun$219(Tuple2 x$1) {
        boolean bl;
        Tuple2 tuple2 = x$1;
        if (tuple2 != null) {
            int k = BoxesRunTime.unboxToInt((Object)tuple2._1());
            double v = BoxesRunTime.unboxToDouble((Object)tuple2._2());
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    public static /* synthetic */ void breeze$linalg$operators$SparseVector_HashVector_Ops$$anon$247$$_$apply$$anonfun$220(VectorBuilder builder$26, Tuple2 x$1) {
        Tuple2 tuple2 = x$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        int k = BoxesRunTime.unboxToInt((Object)tuple2._1());
        double v = BoxesRunTime.unboxToDouble((Object)tuple2._2());
        builder$26.add(k, BoxesRunTime.boxToDouble((double)v));
    }

    public static /* synthetic */ boolean breeze$linalg$operators$SparseVector_HashVector_Ops$$anon$248$$_$apply$$anonfun$221(Tuple2 x$1) {
        boolean bl;
        Tuple2 tuple2 = x$1;
        if (tuple2 != null) {
            int k = BoxesRunTime.unboxToInt((Object)tuple2._1());
            float v = BoxesRunTime.unboxToFloat((Object)tuple2._2());
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    public static /* synthetic */ void breeze$linalg$operators$SparseVector_HashVector_Ops$$anon$248$$_$apply$$anonfun$222(VectorBuilder builder$27, Tuple2 x$1) {
        Tuple2 tuple2 = x$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        int k = BoxesRunTime.unboxToInt((Object)tuple2._1());
        float v = BoxesRunTime.unboxToFloat((Object)tuple2._2());
        builder$27.add(k, BoxesRunTime.boxToFloat((float)v));
    }

    public static /* synthetic */ boolean breeze$linalg$operators$SparseVector_HashVector_Ops$$anon$249$$_$apply$$anonfun$223(Tuple2 x$1) {
        boolean bl;
        Tuple2 tuple2 = x$1;
        if (tuple2 != null) {
            int k = BoxesRunTime.unboxToInt((Object)tuple2._1());
            long v = BoxesRunTime.unboxToLong((Object)tuple2._2());
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    public static /* synthetic */ void breeze$linalg$operators$SparseVector_HashVector_Ops$$anon$249$$_$apply$$anonfun$224(VectorBuilder builder$28, Tuple2 x$1) {
        Tuple2 tuple2 = x$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        int k = BoxesRunTime.unboxToInt((Object)tuple2._1());
        long v = BoxesRunTime.unboxToLong((Object)tuple2._2());
        builder$28.add(k, BoxesRunTime.boxToLong((long)v));
    }
}

