/*
 * Decompiled with CFR 0.152.
 */
package breeze.math;

import breeze.generic.UFunc;
import breeze.linalg.norm$;
import breeze.math.Complex$;
import breeze.math.Complex$ComplexIsFractional$;
import breeze.numerics.package$floor$;
import breeze.numerics.package$floor$floorDoubleImpl$;
import breeze.storage.Zero;
import java.io.Serializable;
import scala.Float$;
import scala.Int$;
import scala.Predef$;
import scala.Product;
import scala.math.Fractional;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.math.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals$;
import scala.runtime.Statics;

public class Complex
implements Product,
Serializable {
    private final double real;
    private final double imag;

    public static Zero<Complex> ComplexZero() {
        return Complex$.MODULE$.ComplexZero();
    }

    public static Complex apply(double d, double d2) {
        return Complex$.MODULE$.apply(d, d2);
    }

    public static UFunc.UImpl<norm$, Complex, Object> complexNorm() {
        return Complex$.MODULE$.complexNorm();
    }

    public static Complex fromProduct(Product product2) {
        return Complex$.MODULE$.fromProduct(product2);
    }

    public static Complex i() {
        return Complex$.MODULE$.i();
    }

    public static Complex nan() {
        return Complex$.MODULE$.nan();
    }

    public static Complex one() {
        return Complex$.MODULE$.one();
    }

    public static Complex unapply(Complex complex) {
        return Complex$.MODULE$.unapply(complex);
    }

    public static Complex zero() {
        return Complex$.MODULE$.zero();
    }

    public Complex(double real, double imag) {
        this.real = real;
        this.imag = imag;
    }

    public boolean canEqual(Object that) {
        return that instanceof Complex;
    }

    public int productArity() {
        return 2;
    }

    public String productPrefix() {
        return "Complex";
    }

    public Object productElement(int n) {
        double d;
        int n2 = n;
        if (0 == n2) {
            d = this._1();
        } else if (1 == n2) {
            d = this._2();
        } else {
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }
        return BoxesRunTime.boxToDouble((double)d);
    }

    public String productElementName(int n) {
        String string;
        int n2 = n;
        if (0 == n2) {
            string = "real";
        } else if (1 == n2) {
            string = "imag";
        } else {
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }
        return string;
    }

    public double real() {
        return this.real;
    }

    public double imag() {
        return this.imag;
    }

    public String toString() {
        return new StringBuilder(4).append(this.real()).append(" + ").append(this.imag()).append("i").toString();
    }

    public double re() {
        return this.real();
    }

    public double im() {
        return this.imag();
    }

    public Complex $plus(Complex that) {
        return Complex$.MODULE$.apply(this.real() + that.real(), this.imag() + that.imag());
    }

    public Complex $plus(int that) {
        return Complex$.MODULE$.apply(this.real() + (double)that, this.imag());
    }

    public Complex $plus(float that) {
        return Complex$.MODULE$.apply(this.real() + (double)that, this.imag());
    }

    public Complex $plus(double that) {
        return Complex$.MODULE$.apply(this.real() + that, this.imag());
    }

    public Complex $minus(Complex that) {
        return Complex$.MODULE$.apply(this.real() - that.real(), this.imag() - that.imag());
    }

    public Complex $minus(int that) {
        return Complex$.MODULE$.apply(this.real() - (double)that, this.imag());
    }

    public Complex $minus(float that) {
        return Complex$.MODULE$.apply(this.real() - (double)that, this.imag());
    }

    public Complex $minus(double that) {
        return Complex$.MODULE$.apply(this.real() - that, this.imag());
    }

    public Complex $times(Complex that) {
        return Complex$.MODULE$.apply(this.real() * that.real() - this.imag() * that.imag(), this.real() * that.imag() + this.imag() * that.real());
    }

    public Complex $times(int that) {
        return Complex$.MODULE$.apply(this.real() * (double)that, this.imag() * (double)that);
    }

    public Complex $times(float that) {
        return Complex$.MODULE$.apply(this.real() * (double)that, this.imag() * (double)that);
    }

    public Complex $times(double that) {
        return Complex$.MODULE$.apply(this.real() * that, this.imag() * that);
    }

    public Complex $div(Complex that) {
        double denom = that.real() * that.real() + that.imag() * that.imag();
        return Complex$.MODULE$.apply((this.real() * that.real() + this.imag() * that.imag()) / denom, (this.imag() * that.real() - this.real() * that.imag()) / denom);
    }

    public Complex $div(int that) {
        return Complex$.MODULE$.apply(this.real() / (double)that, this.imag() / (double)that);
    }

    public Complex $div(float that) {
        return Complex$.MODULE$.apply(this.real() / (double)that, this.imag() / (double)that);
    }

    public Complex $div(double that) {
        return Complex$.MODULE$.apply(this.real() / that, this.imag() / that);
    }

    public Complex $percent(Complex that) {
        Complex div = this.$div(that);
        return this.$minus(Complex$.MODULE$.apply(BoxesRunTime.unboxToDouble((Object)package$floor$.MODULE$.apply(BoxesRunTime.boxToDouble((double)div.re()), (UFunc.UImpl)package$floor$floorDoubleImpl$.MODULE$)), BoxesRunTime.unboxToDouble((Object)package$floor$.MODULE$.apply(BoxesRunTime.boxToDouble((double)div.im()), (UFunc.UImpl)package$floor$floorDoubleImpl$.MODULE$))).$times(div));
    }

    public Complex $percent(int that) {
        return this.$percent(Complex$.MODULE$.apply(Int$.MODULE$.int2double(that), 0.0));
    }

    public Complex $percent(float that) {
        return this.$percent(Complex$.MODULE$.apply(Float$.MODULE$.float2double(that), 0.0));
    }

    public Complex $percent(double that) {
        return this.$percent(Complex$.MODULE$.apply(that, 0.0));
    }

    public Complex unary_$minus() {
        return Complex$.MODULE$.apply(-this.real(), -this.imag());
    }

    public double abs() {
        return package$.MODULE$.sqrt(this.real() * this.real() + this.imag() * this.imag());
    }

    public Complex conjugate() {
        return Complex$.MODULE$.apply(this.real(), -this.imag());
    }

    public Complex log() {
        return Complex$.MODULE$.apply(package$.MODULE$.log(this.abs()), package$.MODULE$.atan2(this.imag(), this.real()));
    }

    public Complex exp() {
        double expreal = package$.MODULE$.exp(this.real());
        return Complex$.MODULE$.apply(expreal * package$.MODULE$.cos(this.imag()), expreal * package$.MODULE$.sin(this.imag()));
    }

    public Complex pow(double b) {
        return this.pow(Complex$.MODULE$.apply(b, 0.0));
    }

    public Complex pow(Complex b) {
        Complex complex;
        Complex complex2 = b;
        Complex complex3 = Complex$.MODULE$.zero();
        if (!(complex2 != null ? !((Object)complex2).equals(complex3) : complex3 != null)) {
            complex = Complex$.MODULE$.one();
        } else {
            Complex complex4 = this;
            Complex complex5 = Complex$.MODULE$.zero();
            if (!(complex4 != null ? !((Object)complex4).equals(complex5) : complex5 != null)) {
                complex = b.imag() != 0.0 || b.real() < 0.0 ? Complex$.MODULE$.nan() : Complex$.MODULE$.zero();
            } else {
                Complex c = this.log().$times(b);
                double expReal = package$.MODULE$.exp(c.real());
                complex = Complex$.MODULE$.apply(expReal * package$.MODULE$.cos(c.imag()), expReal * package$.MODULE$.sin(c.imag()));
            }
        }
        return complex;
    }

    public boolean equals(Object that) {
        boolean bl;
        Object object = that;
        if (object instanceof Complex) {
            Complex that2 = (Complex)object;
            bl = this.real() == that2.real() && this.imag() == that2.imag();
        } else if (object instanceof Double) {
            double real = BoxesRunTime.unboxToDouble((Object)object);
            bl = this.real() == real && this.imag() == 0.0;
        } else if (object instanceof Integer) {
            int real = BoxesRunTime.unboxToInt((Object)object);
            bl = this.real() == (double)real && this.imag() == 0.0;
        } else if (object instanceof Short) {
            short real = BoxesRunTime.unboxToShort((Object)object);
            bl = this.real() == (double)real && this.imag() == 0.0;
        } else if (object instanceof Long) {
            long real = BoxesRunTime.unboxToLong((Object)object);
            bl = this.real() == (double)real && this.imag() == 0.0;
        } else if (object instanceof Float) {
            float real = BoxesRunTime.unboxToFloat((Object)object);
            bl = this.real() == (double)real && this.imag() == 0.0;
        } else {
            bl = false;
        }
        return bl;
    }

    public int hashCode() {
        return Statics.doubleHash((double)this.real()) ^ Statics.doubleHash((double)this.imag());
    }

    public Complex copy(double real, double imag) {
        return new Complex(real, imag);
    }

    public double copy$default$1() {
        return this.real();
    }

    public double copy$default$2() {
        return this.imag();
    }

    public double _1() {
        return this.real();
    }

    public double _2() {
        return this.imag();
    }

    public static interface ComplexIsConflicted
    extends Numeric<Complex> {
        public static Complex plus$(ComplexIsConflicted $this, Complex x, Complex y) {
            return $this.plus(x, y);
        }

        default public Complex plus(Complex x, Complex y) {
            return x.$plus(y);
        }

        public static Complex minus$(ComplexIsConflicted $this, Complex x, Complex y) {
            return $this.minus(x, y);
        }

        default public Complex minus(Complex x, Complex y) {
            return x.$minus(y);
        }

        public static Complex times$(ComplexIsConflicted $this, Complex x, Complex y) {
            return $this.times(x, y);
        }

        default public Complex times(Complex x, Complex y) {
            return x.$times(y);
        }

        public static Complex negate$(ComplexIsConflicted $this, Complex x) {
            return $this.negate(x);
        }

        default public Complex negate(Complex x) {
            return x.unary_$minus();
        }

        public static Complex fromInt$(ComplexIsConflicted $this, int x) {
            return $this.fromInt(x);
        }

        default public Complex fromInt(int x) {
            return Complex$.MODULE$.apply(Int$.MODULE$.int2double(x), 0.0);
        }

        public static int toInt$(ComplexIsConflicted $this, Complex x) {
            return $this.toInt(x);
        }

        default public int toInt(Complex x) {
            return (int)this.strictlyReal(x);
        }

        public static long toLong$(ComplexIsConflicted $this, Complex x) {
            return $this.toLong(x);
        }

        default public long toLong(Complex x) {
            return (long)this.strictlyReal(x);
        }

        public static float toFloat$(ComplexIsConflicted $this, Complex x) {
            return $this.toFloat(x);
        }

        default public float toFloat(Complex x) {
            return (float)this.strictlyReal(x);
        }

        public static double toDouble$(ComplexIsConflicted $this, Complex x) {
            return $this.toDouble(x);
        }

        default public double toDouble(Complex x) {
            return this.strictlyReal(x);
        }

        private double strictlyReal(Complex x) {
            Predef$.MODULE$.require(x.imag() == 0.0);
            return x.real();
        }
    }

    public static interface ComplexIsFractional
    extends ComplexIsConflicted,
    Fractional<Complex> {
        public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffset(Complex$ComplexIsFractional$.class, "0bitmap$1");

        public static Complex div$(ComplexIsFractional $this, Complex x, Complex y) {
            return $this.div(x, y);
        }

        default public Complex div(Complex x, Complex y) {
            return x.$div(y);
        }
    }

    public static interface ComplexOrdering
    extends Ordering<Complex> {
        public static int compare$(ComplexOrdering $this, Complex a, Complex b) {
            return $this.compare(a, b);
        }

        default public int compare(Complex a, Complex b) {
            return a.real() < b.real() ? -1 : (a.real() > b.real() ? 1 : (a.imag() < b.imag() ? -1 : (a.imag() > b.imag() ? 1 : 0)));
        }
    }
}

