/*
 * Decompiled with CFR 0.152.
 */
package breeze.optimize;

import breeze.generic.UFunc;
import breeze.linalg.ImmutableNumericOps;
import breeze.linalg.NumericOps;
import breeze.linalg.norm$;
import breeze.linalg.operators.OpMulMatrix$;
import breeze.linalg.package$;
import breeze.math.MutableInnerProductModule;
import breeze.optimize.DiffFunction;
import breeze.optimize.FirstOrderMinimizer;
import breeze.optimize.FirstOrderMinimizer$;
import breeze.optimize.LBFGS$;
import breeze.optimize.LBFGS$ApproximateInverseHessian$;
import breeze.optimize.LineSearch$;
import breeze.optimize.NaNHistory;
import breeze.optimize.StepSizeUnderflow;
import breeze.optimize.StrongWolfeLineSearch;
import java.io.Serializable;
import scala.Conversion;
import scala.Function1;
import scala.Predef$;
import scala.Product;
import scala.collection.IndexedSeqOps;
import scala.collection.immutable.IndexedSeq;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction1;

public class LBFGS<T>
extends FirstOrderMinimizer<T, DiffFunction<T>> {
    private final int m;
    private final MutableInnerProductModule<T, Object> space;

    public static <T> UFunc.UImpl2<OpMulMatrix$, ApproximateInverseHessian<T>, T, T> multiplyInverseHessian(MutableInnerProductModule<T, Object> mutableInnerProductModule) {
        return LBFGS$.MODULE$.multiplyInverseHessian(mutableInnerProductModule);
    }

    public static <T> int $lessinit$greater$default$1() {
        return LBFGS$.MODULE$.$lessinit$greater$default$1();
    }

    public static <T> int $lessinit$greater$default$2() {
        return LBFGS$.MODULE$.$lessinit$greater$default$2();
    }

    public static <T> double $lessinit$greater$default$3() {
        return LBFGS$.MODULE$.$lessinit$greater$default$3();
    }

    public LBFGS(FirstOrderMinimizer.ConvergenceCheck<T> convergenceCheck, int m, MutableInnerProductModule<T, Object> space) {
        this.m = m;
        this.space = space;
        super(convergenceCheck, space);
        Predef$.MODULE$.require(m > 0);
    }

    public LBFGS(int maxIter, int m, double tolerance, MutableInnerProductModule<T, Object> space) {
        this(FirstOrderMinimizer$.MODULE$.defaultConvergenceCheck(maxIter, tolerance, FirstOrderMinimizer$.MODULE$.defaultConvergenceCheck$default$3(), FirstOrderMinimizer$.MODULE$.defaultConvergenceCheck$default$4(), space), m, space);
    }

    @Override
    public DiffFunction<T> adjustFunction(DiffFunction<T> f) {
        return f.cached(this.space.copy());
    }

    @Override
    public T takeStep(FirstOrderMinimizer.State<T, Object, ApproximateInverseHessian<T>> state, T dir, double stepSize) {
        Object newX = ((ImmutableNumericOps)((Conversion)this.space.hasOps()).apply(dir)).$times(BoxesRunTime.boxToDouble((double)stepSize), this.space.mulVS_M());
        ((NumericOps)((Conversion)this.space.hasOps()).apply(newX)).$colon$plus$eq(state.x(), this.space.addIntoVV());
        return (T)newX;
    }

    public ApproximateInverseHessian<T> initialHistory(DiffFunction<T> f, T x) {
        return new ApproximateInverseHessian<Nothing$>(this.m, LBFGS$ApproximateInverseHessian$.MODULE$.$lessinit$greater$default$2(), LBFGS$ApproximateInverseHessian$.MODULE$.$lessinit$greater$default$3(), this.space);
    }

    @Override
    public T chooseDescentDirection(FirstOrderMinimizer.State<T, Object, ApproximateInverseHessian<T>> state, DiffFunction<T> fn) {
        return state.history().$times(state.grad());
    }

    public ApproximateInverseHessian<T> updateHistory(T newX, T newGrad, double newVal, DiffFunction<T> f, FirstOrderMinimizer.State<T, Object, ApproximateInverseHessian<T>> oldState) {
        return oldState.history().updated(((ImmutableNumericOps)((Conversion)this.space.hasOps()).apply(newX)).$minus(oldState.x(), this.space.subVV()), ((ImmutableNumericOps)((Conversion)this.space.hasOps()).apply(newGrad)).$minus$colon$minus(oldState.grad(), this.space.subVV()));
    }

    @Override
    public double determineStepSize(FirstOrderMinimizer.State<T, Object, ApproximateInverseHessian<T>> state, DiffFunction<T> f, T dir) {
        T x = state.x();
        T grad = state.grad();
        StrongWolfeLineSearch search = new StrongWolfeLineSearch(10, 10);
        DiffFunction<Object> ff = LineSearch$.MODULE$.functionFromSearchDirection(f, x, dir, this.space);
        double alpha = search.minimize(ff, (double)state.iter() == 0.0 ? 1.0 / BoxesRunTime.unboxToDouble((Object)norm$.MODULE$.apply(dir, this.space.normImpl())) : 1.0);
        if (alpha * BoxesRunTime.unboxToDouble((Object)norm$.MODULE$.apply(grad, this.space.normImpl())) < 1.0E-10) {
            throw new StepSizeUnderflow();
        }
        return alpha;
    }

    public static class ApproximateInverseHessian<T>
    implements NumericOps<ApproximateInverseHessian<T>>,
    Product,
    Serializable {
        private final int m;
        private final IndexedSeq memStep;
        private final IndexedSeq memGradDelta;
        private final MutableInnerProductModule<T, Object> space;

        public static <T> ApproximateInverseHessian<T> apply(int n, IndexedSeq<T> indexedSeq, IndexedSeq<T> indexedSeq2, MutableInnerProductModule<T, Object> mutableInnerProductModule) {
            return LBFGS$ApproximateInverseHessian$.MODULE$.apply(n, indexedSeq, indexedSeq2, mutableInnerProductModule);
        }

        public static <T> ApproximateInverseHessian<T> unapply(ApproximateInverseHessian<T> approximateInverseHessian) {
            return LBFGS$ApproximateInverseHessian$.MODULE$.unapply(approximateInverseHessian);
        }

        public static <T> IndexedSeq<Nothing$> $lessinit$greater$default$2() {
            return LBFGS$ApproximateInverseHessian$.MODULE$.$lessinit$greater$default$2();
        }

        public static <T> IndexedSeq<Nothing$> $lessinit$greater$default$3() {
            return LBFGS$ApproximateInverseHessian$.MODULE$.$lessinit$greater$default$3();
        }

        public ApproximateInverseHessian(int m, IndexedSeq<T> memStep, IndexedSeq<T> memGradDelta, MutableInnerProductModule<T, Object> space) {
            this.m = m;
            this.memStep = memStep;
            this.memGradDelta = memGradDelta;
            this.space = space;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)this.m());
            n = Statics.mix((int)n, (int)Statics.anyHash(this.memStep()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.memGradDelta()));
            return Statics.finalizeHash((int)n, (int)3);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof ApproximateInverseHessian)) return false;
            ApproximateInverseHessian approximateInverseHessian = (ApproximateInverseHessian)object;
            if (this.m() != approximateInverseHessian.m()) return false;
            IndexedSeq<T> indexedSeq = this.memStep();
            IndexedSeq<T> indexedSeq2 = approximateInverseHessian.memStep();
            if (indexedSeq == null) {
                if (indexedSeq2 != null) {
                    return false;
                }
            } else if (!indexedSeq.equals(indexedSeq2)) return false;
            IndexedSeq<T> indexedSeq3 = this.memGradDelta();
            IndexedSeq<T> indexedSeq4 = approximateInverseHessian.memGradDelta();
            if (indexedSeq3 == null) {
                if (indexedSeq4 != null) {
                    return false;
                }
            } else if (!indexedSeq3.equals(indexedSeq4)) return false;
            if (!approximateInverseHessian.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof ApproximateInverseHessian;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "ApproximateInverseHessian";
        }

        public Object productElement(int n) {
            Object object;
            int n2 = n;
            switch (n2) {
                case 0: {
                    object = BoxesRunTime.boxToInteger((int)this._1());
                    break;
                }
                case 1: {
                    object = this._2();
                    break;
                }
                case 2: {
                    object = this._3();
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
                }
            }
            return object;
        }

        public String productElementName(int n) {
            String string;
            int n2 = n;
            switch (n2) {
                case 0: {
                    string = "m";
                    break;
                }
                case 1: {
                    string = "memStep";
                    break;
                }
                case 2: {
                    string = "memGradDelta";
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
                }
            }
            return string;
        }

        public int m() {
            return this.m;
        }

        public IndexedSeq<T> memStep() {
            return this.memStep;
        }

        public IndexedSeq<T> memGradDelta() {
            return this.memGradDelta;
        }

        @Override
        public ApproximateInverseHessian<T> repr() {
            return this;
        }

        public ApproximateInverseHessian<T> updated(T step, T gradDelta) {
            IndexedSeq memStep = (IndexedSeq)((IndexedSeqOps)this.memStep().$plus$colon(step)).take(this.m());
            IndexedSeq memGradDelta = (IndexedSeq)((IndexedSeqOps)this.memGradDelta().$plus$colon(gradDelta)).take(this.m());
            return new ApproximateInverseHessian<T>(this.m(), memStep, memGradDelta, this.space);
        }

        public int historyLength() {
            return this.memStep().length();
        }

        public T $times(T grad) {
            double d;
            if (this.historyLength() > 0) {
                Object prevStep = this.memStep().head();
                Object prevGradStep = this.memGradDelta().head();
                double sy = BoxesRunTime.unboxToDouble(((ImmutableNumericOps)((Conversion)this.space.hasOps()).apply(prevStep)).dot(prevGradStep, this.space.dotVV()));
                double yy = BoxesRunTime.unboxToDouble(((ImmutableNumericOps)((Conversion)this.space.hasOps()).apply(prevGradStep)).dot(prevGradStep, this.space.dotVV()));
                if (sy < 0.0 || Predef$.MODULE$.double2Double(sy).isNaN()) {
                    throw new NaNHistory();
                }
                d = sy / yy;
            } else {
                d = 1.0;
            }
            double diag2 = d;
            Object dir = this.space.copy().apply(grad);
            double[] as = new double[this.m()];
            double[] rho = new double[this.m()];
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.historyLength()).foreach((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
                rho$1[i] = BoxesRunTime.unboxToDouble(((ImmutableNumericOps)((Conversion)this.space.hasOps()).apply(this.memStep().apply(i))).dot(this.memGradDelta().apply(i), this.space.dotVV()));
                as$1[i] = BoxesRunTime.unboxToDouble(((ImmutableNumericOps)((Conversion)this.space.hasOps()).apply(this.memStep().apply(i))).dot(dir, this.space.dotVV())) / rho[i];
                if (Predef$.MODULE$.double2Double(as[i]).isNaN()) {
                    throw new NaNHistory();
                }
                package$.MODULE$.axpy(BoxesRunTime.boxToDouble((double)(-as[i])), this.memGradDelta().apply(i), dir, this.space.scaleAddVV());
            });
            ((NumericOps)((Conversion)this.space.hasOps()).apply(dir)).$times$eq(BoxesRunTime.boxToDouble((double)diag2), this.space.mulIntoVS());
            RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(this.historyLength() - 1), 0).by(-1).foreach((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
                double beta = BoxesRunTime.unboxToDouble(((ImmutableNumericOps)((Conversion)this.space.hasOps()).apply(this.memGradDelta().apply(i))).dot(dir, this.space.dotVV())) / rho[i];
                package$.MODULE$.axpy(BoxesRunTime.boxToDouble((double)(as[i] - beta)), this.memStep().apply(i), dir, this.space.scaleAddVV());
            });
            ((NumericOps)((Conversion)this.space.hasOps()).apply(dir)).$times$eq(BoxesRunTime.boxToDouble((double)-1.0), this.space.mulIntoVS());
            return (T)dir;
        }

        public <T> ApproximateInverseHessian<T> copy(int m, IndexedSeq<T> memStep, IndexedSeq<T> memGradDelta, MutableInnerProductModule<T, Object> space) {
            return new ApproximateInverseHessian<T>(m, memStep, memGradDelta, space);
        }

        public int copy$default$1() {
            return this.m();
        }

        public <T> IndexedSeq<T> copy$default$2() {
            return this.memStep();
        }

        public <T> IndexedSeq<T> copy$default$3() {
            return this.memGradDelta();
        }

        public int _1() {
            return this.m();
        }

        public IndexedSeq<T> _2() {
            return this.memStep();
        }

        public IndexedSeq<T> _3() {
            return this.memGradDelta();
        }
    }
}

