/*
 * Decompiled with CFR 0.152.
 */
package breeze.optimize;

import breeze.generic.UFunc;
import breeze.linalg.DenseMatrix;
import breeze.linalg.DenseMatrix$;
import breeze.linalg.DenseVector;
import breeze.linalg.DenseVector$;
import breeze.linalg.ImmutableNumericOps;
import breeze.linalg.LU$primitive$LU_DM_Impl_Double$;
import breeze.linalg.Matrix;
import breeze.linalg.NumericOps;
import breeze.linalg.SliceVector;
import breeze.linalg.SliceVector$;
import breeze.linalg.Vector;
import breeze.linalg.Vector$;
import breeze.linalg.diag$;
import breeze.linalg.inv$;
import breeze.linalg.norm$;
import breeze.linalg.operators.HasOps$;
import breeze.math.Semiring$;
import breeze.optimize.DiffFunction;
import breeze.optimize.FirstOrderMinimizer;
import breeze.optimize.LBFGSB$;
import breeze.optimize.LBFGSB$History$;
import breeze.optimize.StrongWolfeLineSearch;
import breeze.storage.Zero$;
import java.io.Serializable;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.ArrayOps$;
import scala.collection.IterableOps;
import scala.collection.StringOps$;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction1;
import scala.runtime.java8.JFunction2;
import scala.util.NotGiven$;

public class LBFGSB
extends FirstOrderMinimizer<DenseVector<Object>, DiffFunction<DenseVector<Object>>> {
    public final DenseVector<Object> breeze$optimize$LBFGSB$$lowerBounds;
    public final DenseVector<Object> breeze$optimize$LBFGSB$$upperBounds;
    private final int m;
    private final int maxZoomIter;
    private final int maxLineSearchIter;
    private final double EPS;
    public final LBFGSB$History$ History$lzy1;

    public static FirstOrderMinimizer.ConvergenceCheck<DenseVector<Object>> defaultConvergenceCheck(DenseVector<Object> denseVector, DenseVector<Object> denseVector2, double d, int n) {
        return LBFGSB$.MODULE$.defaultConvergenceCheck(denseVector, denseVector2, d, n);
    }

    public static int $lessinit$greater$default$3() {
        return LBFGSB$.MODULE$.$lessinit$greater$default$3();
    }

    public static int $lessinit$greater$default$4() {
        return LBFGSB$.MODULE$.$lessinit$greater$default$4();
    }

    public static double $lessinit$greater$default$5() {
        return LBFGSB$.MODULE$.$lessinit$greater$default$5();
    }

    public static int $lessinit$greater$default$6() {
        return LBFGSB$.MODULE$.$lessinit$greater$default$6();
    }

    public static int $lessinit$greater$default$7() {
        return LBFGSB$.MODULE$.$lessinit$greater$default$7();
    }

    public LBFGSB(DenseVector<Object> lowerBounds, DenseVector<Object> upperBounds, int maxIter, int m, double tolerance, int maxZoomIter, int maxLineSearchIter) {
        this.breeze$optimize$LBFGSB$$lowerBounds = lowerBounds;
        this.breeze$optimize$LBFGSB$$upperBounds = upperBounds;
        this.m = m;
        this.maxZoomIter = maxZoomIter;
        this.maxLineSearchIter = maxLineSearchIter;
        super(LBFGSB$.MODULE$.defaultConvergenceCheck(lowerBounds, upperBounds, tolerance, maxIter), DenseVector$.MODULE$.space_Double());
        this.History$lzy1 = new LBFGSB$History$(this);
        this.EPS = 2.2E-16;
    }

    public double EPS() {
        return this.EPS;
    }

    public final LBFGSB$History$ History() {
        return this.History$lzy1;
    }

    public History initialHistory(DiffFunction<DenseVector<Object>> f, DenseVector<Object> init) {
        return this.initialize(f, init);
    }

    public History updateHistory(DenseVector<Object> newX, DenseVector<Object> newGrad, double newVal, DiffFunction<DenseVector<Object>> f, FirstOrderMinimizer.State<DenseVector<Object>, Object, History> oldState) {
        return this.updateSkYkHessianApproxMat(oldState.history(), (DenseVector)newX.$minus(oldState.x(), HasOps$.MODULE$.impl_OpSub_DV_DV_eq_DV_Double()), (DenseVector)newGrad.$minus$colon$minus(oldState.grad(), HasOps$.MODULE$.impl_OpSub_DV_DV_eq_DV_Double()));
    }

    @Override
    public DenseVector<Object> chooseDescentDirection(FirstOrderMinimizer.State<DenseVector<Object>, Object, History> state, DiffFunction<DenseVector<Object>> f) {
        DenseVector denseVector;
        DenseVector<Object> x = state.x();
        DenseVector<Object> g = state.grad();
        Tuple2<DenseVector<Object>, DenseVector<Object>> tuple2 = this.getGeneralizedCauchyPoint(state.history(), x, g);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        DenseVector cauchyPoint = (DenseVector)tuple2._1();
        DenseVector c = (DenseVector)tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)cauchyPoint, (Object)c);
        DenseVector cauchyPoint2 = (DenseVector)tuple22._1();
        DenseVector c2 = (DenseVector)tuple22._2();
        this.adjustWithinBound(cauchyPoint2);
        if (0 == state.iter()) {
            denseVector = (DenseVector)cauchyPoint2.$minus(x, HasOps$.MODULE$.impl_OpSub_DV_DV_eq_DV_Double());
        } else {
            DenseVector<Object> subspaceMin = this.subspaceMinimization(state.history(), cauchyPoint2, x, c2, g);
            this.adjustWithinBound(subspaceMin);
            denseVector = (DenseVector)subspaceMin.$minus(x, HasOps$.MODULE$.impl_OpSub_DV_DV_eq_DV_Double());
        }
        DenseVector dirk = denseVector;
        return dirk;
    }

    @Override
    public double determineStepSize(FirstOrderMinimizer.State<DenseVector<Object>, Object, History> state, DiffFunction<DenseVector<Object>> f, DenseVector<Object> direction) {
        DiffFunction<Object> ff = new DiffFunction<Object>(state, f, direction, this){
            private final FirstOrderMinimizer.State state$1;
            private final DiffFunction f$1;
            private final DenseVector direction$1;
            private final /* synthetic */ LBFGSB $outer;
            {
                this.state$1 = state$2;
                this.f$1 = f$2;
                this.direction$1 = direction$2;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public Tuple2 calculate(double alpha) {
                DenseVector<Object> newX = this.$outer.takeStep((FirstOrderMinimizer.State<DenseVector<Object>, Object, History>)this.state$1, this.direction$1, alpha);
                Tuple2<Object, DenseVector<Object>> tuple2 = this.f$1.calculate(newX);
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                double ff = BoxesRunTime.unboxToDouble((Object)tuple2._1());
                DenseVector grad = (DenseVector)tuple2._2();
                Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)ff), (Object)grad);
                double ff2 = BoxesRunTime.unboxToDouble((Object)tuple22._1());
                DenseVector grad2 = (DenseVector)tuple22._2();
                Double d = (Double)Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToDouble((double)ff2));
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)d, grad2.dot(this.direction$1, (UFunc.UImpl2)HasOps$.MODULE$.canDotD()));
            }
        };
        StrongWolfeLineSearch wolfeRuleSearch = new StrongWolfeLineSearch(this.maxZoomIter, this.maxLineSearchIter);
        double minStepBound = Double.POSITIVE_INFINITY;
        for (int i = 0; i < this.breeze$optimize$LBFGSB$$lowerBounds.length(); ++i) {
            double dir = BoxesRunTime.unboxToDouble((Object)direction.apply(i));
            if (dir == 0.0) continue;
            double bound = dir < 0.0 ? BoxesRunTime.unboxToDouble((Object)this.breeze$optimize$LBFGSB$$lowerBounds.apply(i)) : BoxesRunTime.unboxToDouble((Object)this.breeze$optimize$LBFGSB$$upperBounds.apply(i));
            double stepBound = (bound - BoxesRunTime.unboxToDouble((Object)state.x().apply(i))) / dir;
            if (!(stepBound > 0.0)) {
                throw new AssertionError((Object)StringOps$.MODULE$.format$extension("assertion failed: %s", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"stepBound.>(0.0)"})));
            }
            if (!(stepBound < minStepBound)) continue;
            minStepBound = stepBound;
        }
        return wolfeRuleSearch.minimizeWithBound(ff, 1.0, minStepBound);
    }

    @Override
    public DenseVector<Object> takeStep(FirstOrderMinimizer.State<DenseVector<Object>, Object, History> state, DenseVector<Object> dir, double stepSize) {
        DenseVector newX = (DenseVector)((NumericOps)state.x()).$plus(dir.$times$colon$times(BoxesRunTime.boxToDouble((double)stepSize), HasOps$.MODULE$.impl_Op_DV_S_eq_DV_Double_OpMulScalar()), HasOps$.MODULE$.impl_OpAdd_DV_DV_eq_DV_Double());
        this.adjustWithinBound(newX);
        return newX;
    }

    public void adjustWithinBound(DenseVector<Object> point) {
        int yy = point.length();
        for (int i = 0; i < point.length(); ++i) {
            int n = i;
            if (BoxesRunTime.unboxToDouble((Object)point.apply(n)) > BoxesRunTime.unboxToDouble((Object)this.breeze$optimize$LBFGSB$$upperBounds.apply(n))) {
                point.update(n, this.breeze$optimize$LBFGSB$$upperBounds.apply(n));
            }
            if (!(BoxesRunTime.unboxToDouble((Object)point.apply(n)) < BoxesRunTime.unboxToDouble((Object)this.breeze$optimize$LBFGSB$$lowerBounds.apply(n)))) continue;
            point.update(n, this.breeze$optimize$LBFGSB$$lowerBounds.apply(n));
        }
    }

    private History initialize(DiffFunction<DenseVector<Object>> f, DenseVector<Object> x0) {
        int DIM = x0.length();
        if (this.breeze$optimize$LBFGSB$$lowerBounds.length() != x0.length()) {
            throw new IllegalArgumentException(StringOps$.MODULE$.format$extension("requirement failed: %s", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{new StringBuilder(46).append(new StringBuilder(53).append("Mismatch between x0 length (").append(x0.length()).append(") and lowerBounds length ").append(this.breeze$optimize$LBFGSB$$lowerBounds.length()).toString()).append(": ").append("LBFGSB.this.lowerBounds.length.==(x0.length)").toString()})));
        }
        if (this.breeze$optimize$LBFGSB$$upperBounds.length() != x0.length()) {
            throw new IllegalArgumentException(StringOps$.MODULE$.format$extension("requirement failed: %s", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{new StringBuilder(46).append(new StringBuilder(53).append("Mismatch between x0 length (").append(x0.length()).append(") and upperBounds length ").append(this.breeze$optimize$LBFGSB$$upperBounds.length()).toString()).append(": ").append("LBFGSB.this.upperBounds.length.==(x0.length)").toString()})));
        }
        if (!x0.forall((Function2)(JFunction2.mcZID.sp & Serializable)(i, v) -> BoxesRunTime.unboxToDouble((Object)this.breeze$optimize$LBFGSB$$lowerBounds.apply(i)) <= v && v <= BoxesRunTime.unboxToDouble((Object)this.breeze$optimize$LBFGSB$$upperBounds.apply(i)))) {
            throw new IllegalArgumentException(StringOps$.MODULE$.format$extension("requirement failed: %s", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{new StringBuilder(189).append("seed is not feasible (violates lower bound or upperBounds)").append(": ").append("x0.forall(((i: scala.Int, v: scala.Double) => LBFGSB.this.lowerBounds.apply(i).<=(v).&&(v.<=(LBFGSB.this.upperBounds.apply(i)))))").toString()})));
        }
        return this.History().apply(1.0, (DenseMatrix<Object>)DenseMatrix$.MODULE$.zeros(DIM, 2 * this.m, ClassTag$.MODULE$.apply(Double.TYPE), Zero$.MODULE$.DoubleZero()), (DenseMatrix<Object>)DenseMatrix$.MODULE$.zeros(2 * this.m, 2 * this.m, ClassTag$.MODULE$.apply(Double.TYPE), Zero$.MODULE$.DoubleZero()), (DenseMatrix<Object>)DenseMatrix$.MODULE$.zeros(0, 0, ClassTag$.MODULE$.apply(Double.TYPE), Zero$.MODULE$.DoubleZero()), (DenseMatrix<Object>)DenseMatrix$.MODULE$.zeros(0, 0, ClassTag$.MODULE$.apply(Double.TYPE), Zero$.MODULE$.DoubleZero()));
    }

    public Tuple2<DenseVector<Object>, DenseVector<Object>> getGeneralizedCauchyPoint(History history, DenseVector<Object> x2, DenseVector<Object> g) {
        double d;
        int n = x2.length();
        Vector d2 = DenseVector$.MODULE$.zeros(n, ClassTag$.MODULE$.apply(Double.TYPE), Zero$.MODULE$.DoubleZero());
        DenseVector t = (DenseVector)g.mapPairs((arg_0, arg_1) -> this.$anonfun$adapted$1(x2, (DenseVector)d2, arg_0, arg_1), HasOps$.MODULE$.canMapPairs(ClassTag$.MODULE$.apply(Tuple2.class)));
        Vector xCauchy = x2.copy();
        DenseVector<Object> p = ((ImmutableNumericOps)history.W().t(HasOps$.MODULE$.canTranspose_DM())).$times(d2, HasOps$.MODULE$.impl_OpMulMatrix_DMD_DVD_eq_DVD());
        Vector c = DenseVector$.MODULE$.zeros(history.M().rows(), ClassTag$.MODULE$.apply(Double.TYPE), Zero$.MODULE$.DoubleZero());
        double fDerivative = BoxesRunTime.unboxToDouble((Object)g.dot(d2, (UFunc.UImpl2)HasOps$.MODULE$.canDotD()));
        double fSecondDerivative = -1.0 * history.theta() * fDerivative - BoxesRunTime.unboxToDouble((Object)p.dot(history.M().$times(p, (UFunc.UImpl2)HasOps$.MODULE$.impl_OpMulMatrix_DMD_DVD_eq_DVD()), (UFunc.UImpl2)HasOps$.MODULE$.canDotD()));
        double dtMin = -(fDerivative / fSecondDerivative);
        DoubleRef oldT = DoubleRef.create((double)0.0);
        Object object = Predef$.MODULE$.intArrayOps((int[])((DenseVector)t.map((Function1 & Serializable)x -> BoxesRunTime.unboxToInt((Object)x._1()), DenseVector$.MODULE$.DV_canMapValues(ClassTag$.MODULE$.apply(Integer.TYPE)))).toArray(ClassTag$.MODULE$.apply(Integer.TYPE)));
        int[] sortedIndeces = (int[])ArrayOps$.MODULE$.sortWith$extension(object, (Function2)(JFunction2.mcZII.sp & Serializable)(ia, ib) -> BoxesRunTime.unboxToDouble((Object)((Tuple2)t.apply(ia))._2()) < BoxesRunTime.unboxToDouble((Object)((Tuple2)t.apply(ib))._2()));
        Object object2 = Predef$.MODULE$.intArrayOps(sortedIndeces);
        int i = ArrayOps$.MODULE$.indexWhere$extension(object2, (Function1)(JFunction1.mcZI.sp & Serializable)idx -> 0.0 != BoxesRunTime.unboxToDouble((Object)((Tuple2)t.apply(idx))._2()), ArrayOps$.MODULE$.indexWhere$default$2$extension(object2));
        int b = sortedIndeces[i];
        double minT = BoxesRunTime.unboxToDouble((Object)((Tuple2)t.apply(b))._2());
        double deltaT = minT - oldT.elem;
        while (deltaT <= dtMin && i < n) {
            double d3;
            ((DenseVector)xCauchy).update(b, 0.0 < BoxesRunTime.unboxToDouble(((DenseVector)d2).apply(b)) ? this.breeze$optimize$LBFGSB$$upperBounds.apply(b) : this.breeze$optimize$LBFGSB$$lowerBounds.apply(b));
            double zb = BoxesRunTime.unboxToDouble(((DenseVector)xCauchy).apply(b)) - BoxesRunTime.unboxToDouble((Object)x2.apply(b));
            c = (DenseVector)((DenseVector)c).$plus(p.$times$colon$times(BoxesRunTime.boxToDouble((double)deltaT), HasOps$.MODULE$.impl_Op_DV_S_eq_DV_Double_OpMulScalar()), HasOps$.MODULE$.impl_OpAdd_DV_DV_eq_DV_Double());
            DenseVector bRowOfW = (DenseVector)((ImmutableNumericOps)history.W().apply(BoxesRunTime.boxToInteger((int)b), package$.MODULE$.$colon$colon(), HasOps$.MODULE$.canSliceRow())).t(HasOps$.MODULE$.canUntranspose());
            p.$plus$eq(bRowOfW.$times$colon$times(g.apply(b), HasOps$.MODULE$.impl_Op_DV_S_eq_DV_Double_OpMulScalar()), HasOps$.MODULE$.impl_OpAdd_InPlace_DV_DV_Double());
            ((DenseVector)d2).update(b, BoxesRunTime.boxToDouble((double)0.0));
            dtMin = -(fDerivative += deltaT * fSecondDerivative + BoxesRunTime.unboxToDouble((Object)g.apply(b)) * BoxesRunTime.unboxToDouble((Object)g.apply(b)) + history.theta() * BoxesRunTime.unboxToDouble((Object)g.apply(b)) * zb - BoxesRunTime.unboxToDouble(((ImmutableNumericOps)((ImmutableNumericOps)bRowOfW.t(HasOps$.MODULE$.transposeTensor((.less.colon.less)$less$colon$less$.MODULE$.refl()))).$times$colon$times(g.apply(b), HasOps$.MODULE$.impl_Op_Tt_S_eq_RT_from_T_S(DenseVector$.MODULE$.DV_scalarOf(), HasOps$.MODULE$.impl_Op_DV_S_eq_DV_Double_OpMulScalar(), HasOps$.MODULE$.transposeTensor((.less.colon.less)$less$colon$less$.MODULE$.refl())))).$times(history.M().$times(c, (UFunc.UImpl2)HasOps$.MODULE$.impl_OpMulMatrix_DMD_DVD_eq_DVD()), HasOps$.MODULE$.transTimesNormalFromDot((UFunc.UImpl2)HasOps$.MODULE$.canDotD())))) / (fSecondDerivative += -1.0 * history.theta() * BoxesRunTime.unboxToDouble((Object)g.apply(b)) * BoxesRunTime.unboxToDouble((Object)g.apply(b)) - 2.0 * (BoxesRunTime.unboxToDouble((Object)g.apply(b)) * BoxesRunTime.unboxToDouble((Object)bRowOfW.dot(history.M().$times(p, (UFunc.UImpl2)HasOps$.MODULE$.impl_OpMulMatrix_DMD_DVD_eq_DVD()), (UFunc.UImpl2)HasOps$.MODULE$.canDotD()))) - BoxesRunTime.unboxToDouble((Object)g.apply(b)) * BoxesRunTime.unboxToDouble((Object)g.apply(b)) * BoxesRunTime.unboxToDouble(((ImmutableNumericOps)bRowOfW.t(HasOps$.MODULE$.transposeTensor((.less.colon.less)$less$colon$less$.MODULE$.refl()))).$times(history.M().$times(bRowOfW, (UFunc.UImpl2)HasOps$.MODULE$.impl_OpMulMatrix_DMD_DVD_eq_DVD()), HasOps$.MODULE$.transTimesNormalFromDot((UFunc.UImpl2)HasOps$.MODULE$.canDotD()))));
            oldT.elem = d3 = minT;
            if (++i >= n) continue;
            b = sortedIndeces[i];
            minT = BoxesRunTime.unboxToDouble((Object)((Tuple2)t.apply(b))._2());
            deltaT = minT - oldT.elem;
        }
        dtMin = scala.math.package$.MODULE$.max(dtMin, 0.0);
        oldT.elem = d = oldT.elem + dtMin;
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(i), n).foreach((Function1)((JFunction1.mcVI.sp & Serializable)arg_0 -> LBFGSB.getGeneralizedCauchyPoint$$anonfun$1(x2, (DenseVector)d2, (DenseVector)xCauchy, oldT, sortedIndeces, arg_0)));
        ((DenseVector)c).$plus$eq(p.$times$colon$times(BoxesRunTime.boxToDouble((double)dtMin), HasOps$.MODULE$.impl_Op_DV_S_eq_DV_Double_OpMulScalar()), HasOps$.MODULE$.impl_OpAdd_InPlace_DV_DV_Double());
        return Tuple2$.MODULE$.apply((Object)xCauchy, (Object)c);
    }

    public double findAlpha(DenseVector<Object> xCauchy, Vector<Object> du, int[] freeVarIndex) {
        DoubleRef starAlpha = DoubleRef.create((double)1.0);
        Object object = Predef$.MODULE$.intArrayOps(freeVarIndex);
        Object object2 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zipWithIndex$extension(object));
        ArrayOps$.MODULE$.withFilter$extension(object2, (Function1 & Serializable)x$1 -> {
            boolean bl;
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                int vIdx = BoxesRunTime.unboxToInt((Object)tuple2._1());
                int i = BoxesRunTime.unboxToInt((Object)tuple2._2());
                bl = true;
            } else {
                bl = false;
            }
            return bl;
        }).foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                int vIdx = BoxesRunTime.unboxToInt((Object)tuple2._1());
                int i = BoxesRunTime.unboxToInt((Object)tuple2._2());
                if (0.0 < BoxesRunTime.unboxToDouble(du.apply(BoxesRunTime.boxToInteger((int)i)))) {
                    double d;
                    starAlpha$1.elem = d = scala.math.package$.MODULE$.min(starAlpha$1.elem, (BoxesRunTime.unboxToDouble((Object)this.breeze$optimize$LBFGSB$$upperBounds.apply(vIdx)) - BoxesRunTime.unboxToDouble(xCauchy.apply(vIdx))) / BoxesRunTime.unboxToDouble(du.apply(BoxesRunTime.boxToInteger((int)i))));
                } else if (0.0 > BoxesRunTime.unboxToDouble(du.apply(BoxesRunTime.boxToInteger((int)i)))) {
                    double d;
                    starAlpha$1.elem = d = scala.math.package$.MODULE$.min(starAlpha$1.elem, (BoxesRunTime.unboxToDouble((Object)this.breeze$optimize$LBFGSB$$lowerBounds.apply(vIdx)) - BoxesRunTime.unboxToDouble(xCauchy.apply(vIdx))) / BoxesRunTime.unboxToDouble(du.apply(BoxesRunTime.boxToInteger((int)i))));
                }
            } else {
                throw new MatchError((Object)tuple2);
            }
        });
        if (!(starAlpha.elem >= 0.0) || !(starAlpha.elem <= 1.0)) {
            throw new AssertionError((Object)StringOps$.MODULE$.format$extension("assertion failed: %s", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"starAlpha.>=(0.0).&&(starAlpha.<=(1.0))"})));
        }
        return starAlpha.elem;
    }

    public DenseVector<Object> subspaceMinimization(History history, DenseVector<Object> xCauchy, DenseVector<Object> x, DenseVector<Object> c, DenseVector<Object> g) {
        double invTheta = 1.0 / history.theta();
        IndexedSeq freeVariableIndexes = xCauchy.iterator().collect((PartialFunction)new Serializable(this){
            private final /* synthetic */ LBFGSB $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean isDefinedAt(Tuple2 x) {
                Tuple2 tuple2 = x;
                if (tuple2 == null) return false;
                int i = BoxesRunTime.unboxToInt((Object)tuple2._1());
                double v = BoxesRunTime.unboxToDouble((Object)tuple2._2());
                if (v == BoxesRunTime.unboxToDouble((Object)this.$outer.breeze$optimize$LBFGSB$$upperBounds.apply(i))) return false;
                if (v == BoxesRunTime.unboxToDouble((Object)this.$outer.breeze$optimize$LBFGSB$$lowerBounds.apply(i))) return false;
                return true;
            }

            /*
             * Enabled aggressive block sorting
             */
            public final Object applyOrElse(Tuple2 x, Function1 function1) {
                Object object;
                Tuple2 tuple2 = x;
                if (tuple2 != null) {
                    int i = BoxesRunTime.unboxToInt((Object)tuple2._1());
                    double v = BoxesRunTime.unboxToDouble((Object)tuple2._2());
                    if (v != BoxesRunTime.unboxToDouble((Object)this.$outer.breeze$optimize$LBFGSB$$upperBounds.apply(i)) && v != BoxesRunTime.unboxToDouble((Object)this.$outer.breeze$optimize$LBFGSB$$lowerBounds.apply(i))) {
                        object = BoxesRunTime.boxToInteger((int)i);
                        return object;
                    }
                }
                object = function1.apply((Object)x);
                return object;
            }
        }).toIndexedSeq();
        int freeVarCount = freeVariableIndexes.length();
        Matrix WZ = DenseMatrix$.MODULE$.zeros(history.W().cols(), freeVarCount, ClassTag$.MODULE$.apply(Double.TYPE), Zero$.MODULE$.DoubleZero());
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), freeVarCount).foreach(arg_0 -> LBFGSB.subspaceMinimization$$anonfun$adapted$1(history, freeVariableIndexes, (DenseMatrix)WZ, arg_0));
        DenseVector dirTheta = (DenseVector)((ImmutableNumericOps)xCauchy.$minus(x, HasOps$.MODULE$.impl_OpSub_DV_DV_eq_DV_Double())).$times$colon$times(BoxesRunTime.boxToDouble((double)history.theta()), HasOps$.MODULE$.impl_Op_DV_S_eq_DV_Double_OpMulScalar());
        DenseVector fullR = (DenseVector)((ImmutableNumericOps)g.$plus(dirTheta, HasOps$.MODULE$.impl_OpAdd_DV_DV_eq_DV_Double())).$minus(history.W().$times(history.M().$times(c, (UFunc.UImpl2)HasOps$.MODULE$.impl_OpMulMatrix_DMD_DVD_eq_DVD()), (UFunc.UImpl2)HasOps$.MODULE$.impl_OpMulMatrix_DMD_DVD_eq_DVD()), HasOps$.MODULE$.impl_OpSub_DV_DV_eq_DV_Double());
        SliceVector rc = (SliceVector)fullR.apply(freeVariableIndexes, HasOps$.MODULE$.canSliceTensor(ClassTag$.MODULE$.apply(Double.TYPE)));
        DenseVector v = (DenseVector)history.M().$times(((DenseMatrix)WZ).$times(rc, HasOps$.MODULE$.castOps_M_V((.less.colon.less)$less$colon$less$.MODULE$.refl(), (.less.colon.less)$less$colon$less$.MODULE$.refl(), NotGiven$.MODULE$.value(), (UFunc.UImpl2)HasOps$.MODULE$.op_M_V_Double())), (UFunc.UImpl2)HasOps$.MODULE$.impl_OpMulMatrix_DM_V_eq_DV_Double());
        DenseMatrix N = (DenseMatrix)((DenseMatrix)WZ).$times(((DenseMatrix)WZ).t(HasOps$.MODULE$.canTranspose_DM()), (UFunc.UImpl2)HasOps$.MODULE$.impl_OpMulMatrix_DMD_DMD_eq_DMD());
        N = (DenseMatrix)N.$times$colon$times(BoxesRunTime.boxToDouble((double)invTheta), HasOps$.MODULE$.op_DM_S_Double_OpMulScalar());
        N = (DenseMatrix)DenseMatrix$.MODULE$.eye(N.rows(), ClassTag$.MODULE$.apply(Double.TYPE), Zero$.MODULE$.DoubleZero(), Semiring$.MODULE$.semiringD()).$minus(history.M().$times(N, (UFunc.UImpl2)HasOps$.MODULE$.impl_OpMulMatrix_DMD_DMD_eq_DMD()), HasOps$.MODULE$.op_DM_DM_Double_OpSub());
        DenseMatrix invN = (DenseMatrix)inv$.MODULE$.apply(N, inv$.MODULE$.canInvUsingLU_Double(LU$primitive$LU_DM_Impl_Double$.MODULE$));
        DenseVector invNv = (DenseVector)invN.$times(v, (UFunc.UImpl2)HasOps$.MODULE$.impl_OpMulMatrix_DMD_DVD_eq_DVD());
        v = (DenseVector)N.$bslash(v, (UFunc.UImpl2)HasOps$.MODULE$.impl_OpSolveMatrixBy_DMD_DVD_eq_DVD());
        DenseVector wzv = (DenseVector)((ImmutableNumericOps)((ImmutableNumericOps)((DenseMatrix)WZ).t(HasOps$.MODULE$.canTranspose_DM())).$times(v, HasOps$.MODULE$.impl_OpMulMatrix_DMD_DVD_eq_DVD())).$times$colon$times(BoxesRunTime.boxToDouble((double)(invTheta * invTheta)), HasOps$.MODULE$.impl_Op_DV_S_eq_DV_Double_OpMulScalar());
        Vector thetaRC = (Vector)rc.$times$colon$times(BoxesRunTime.boxToDouble((double)invTheta), HasOps$.MODULE$.castOps_V_S(SliceVector$.MODULE$.scalarOf(), (.less.colon.less)$less$colon$less$.MODULE$.refl(), NotGiven$.MODULE$.value(), (UFunc.UImpl2)HasOps$.MODULE$.impl_Op_V_S_eq_V_Double_OpMulScalar()));
        Vector du = (Vector)((ImmutableNumericOps)thetaRC.$plus(wzv, HasOps$.MODULE$.pureFromUpdate(HasOps$.MODULE$.castUpdateOps_V_V((.less.colon.less)$less$colon$less$.MODULE$.refl(), (.less.colon.less)$less$colon$less$.MODULE$.refl(), NotGiven$.MODULE$.value(), (UFunc.InPlaceImpl2)HasOps$.MODULE$.impl_Op_InPlace_V_V_Idempotent_Double_OpAdd()), Vector$.MODULE$.canCopy()))).$times$colon$times(BoxesRunTime.boxToDouble((double)-1.0), HasOps$.MODULE$.impl_Op_V_S_eq_V_Double_OpMulScalar());
        double starAlpha = this.findAlpha(xCauchy, du, (int[])freeVariableIndexes.toArray(ClassTag$.MODULE$.apply(Integer.TYPE)));
        Vector dStar = (Vector)du.$times$colon$times(BoxesRunTime.boxToDouble((double)starAlpha), HasOps$.MODULE$.impl_Op_V_S_eq_V_Double_OpMulScalar());
        Vector subspaceMinX = xCauchy.copy();
        ((IterableOps)freeVariableIndexes.zipWithIndex()).withFilter((Function1 & Serializable)x$1 -> {
            boolean bl;
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                int freeVarIdx = BoxesRunTime.unboxToInt((Object)tuple2._1());
                int i = BoxesRunTime.unboxToInt((Object)tuple2._2());
                bl = true;
            } else {
                bl = false;
            }
            return bl;
        }).foreach((Function1)((JProcedure1 & Serializable)arg_0 -> LBFGSB.subspaceMinimization$$anonfun$3(dStar, (DenseVector)subspaceMinX, arg_0)));
        return subspaceMinX;
    }

    public History updateSkYkHessianApproxMat(History history, DenseVector<Object> newS, DenseVector<Object> newY) {
        History history2;
        History history3;
        if (0 == history.yHistory().cols()) {
            DenseMatrix denseMatrix = (DenseMatrix)newY.toDenseMatrix().t(HasOps$.MODULE$.canTranspose_DM());
            DenseMatrix denseMatrix2 = (DenseMatrix)newS.toDenseMatrix().t(HasOps$.MODULE$.canTranspose_DM());
            double d = history.copy$default$1();
            DenseMatrix<Object> denseMatrix3 = history.copy$default$2();
            DenseMatrix<Object> denseMatrix4 = history.copy$default$3();
            history3 = history.copy(d, denseMatrix3, denseMatrix4, denseMatrix, denseMatrix2);
        } else if (history.yHistory().cols() < this.m) {
            DenseMatrix<Object> denseMatrix = DenseMatrix$.MODULE$.horzcat(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new DenseMatrix[]{history.yHistory(), (DenseMatrix)newY.toDenseMatrix().t(HasOps$.MODULE$.canTranspose_DM())}), $less$colon$less$.MODULE$.refl(), HasOps$.MODULE$.dm_dm_UpdateOp_Double_OpSet(), ClassTag$.MODULE$.apply(Double.TYPE), Zero$.MODULE$.DoubleZero());
            DenseMatrix<Object> denseMatrix5 = DenseMatrix$.MODULE$.horzcat(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new DenseMatrix[]{history.sHistory(), (DenseMatrix)newS.toDenseMatrix().t(HasOps$.MODULE$.canTranspose_DM())}), $less$colon$less$.MODULE$.refl(), HasOps$.MODULE$.dm_dm_UpdateOp_Double_OpSet(), ClassTag$.MODULE$.apply(Double.TYPE), Zero$.MODULE$.DoubleZero());
            double d = history.copy$default$1();
            DenseMatrix<Object> denseMatrix6 = history.copy$default$2();
            DenseMatrix<Object> denseMatrix7 = history.copy$default$3();
            history3 = history.copy(d, denseMatrix6, denseMatrix7, denseMatrix, denseMatrix5);
        } else {
            DenseMatrix<Object> denseMatrix = DenseMatrix$.MODULE$.horzcat(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new DenseMatrix[]{(DenseMatrix)history.yHistory().apply(package$.MODULE$.$colon$colon(), RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(1), this.m), HasOps$.MODULE$.canSliceCols()), (DenseMatrix)newY.toDenseMatrix().t(HasOps$.MODULE$.canTranspose_DM())}), $less$colon$less$.MODULE$.refl(), HasOps$.MODULE$.dm_dm_UpdateOp_Double_OpSet(), ClassTag$.MODULE$.apply(Double.TYPE), Zero$.MODULE$.DoubleZero());
            DenseMatrix<Object> denseMatrix8 = DenseMatrix$.MODULE$.horzcat(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new DenseMatrix[]{(DenseMatrix)history.sHistory().apply(package$.MODULE$.$colon$colon(), RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(1), this.m), HasOps$.MODULE$.canSliceCols()), (DenseMatrix)newS.toDenseMatrix().t(HasOps$.MODULE$.canTranspose_DM())}), $less$colon$less$.MODULE$.refl(), HasOps$.MODULE$.dm_dm_UpdateOp_Double_OpSet(), ClassTag$.MODULE$.apply(Double.TYPE), Zero$.MODULE$.DoubleZero());
            double d = history.copy$default$1();
            DenseMatrix<Object> denseMatrix9 = history.copy$default$2();
            DenseMatrix<Object> denseMatrix10 = history.copy$default$3();
            history3 = history.copy(d, denseMatrix9, denseMatrix10, denseMatrix, denseMatrix8);
        }
        History newHistory = history3;
        double curvatureTest = scala.math.package$.MODULE$.abs(BoxesRunTime.unboxToDouble((Object)newS.dot(newY, (UFunc.UImpl2)HasOps$.MODULE$.canDotD())));
        if (this.EPS() * BoxesRunTime.unboxToDouble((Object)norm$.MODULE$.apply(newY, BoxesRunTime.boxToInteger((int)2), norm$.MODULE$.fromCanNormInt(norm$.MODULE$.canNorm(HasOps$.MODULE$.DV_canIterateValues(), norm$.MODULE$.scalarNorm_Double())))) < curvatureTest) {
            double newTheta = BoxesRunTime.unboxToDouble(((ImmutableNumericOps)newY.t(HasOps$.MODULE$.transposeTensor((.less.colon.less)$less$colon$less$.MODULE$.refl()))).$times(newY, HasOps$.MODULE$.transTimesNormalFromDot((UFunc.UImpl2)HasOps$.MODULE$.canDotD()))) / BoxesRunTime.unboxToDouble(((ImmutableNumericOps)newY.t(HasOps$.MODULE$.transposeTensor((.less.colon.less)$less$colon$less$.MODULE$.refl()))).$times(newS, HasOps$.MODULE$.transTimesNormalFromDot((UFunc.UImpl2)HasOps$.MODULE$.canDotD())));
            DenseMatrix<Object> newW = DenseMatrix$.MODULE$.horzcat(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new DenseMatrix[]{newHistory.yHistory(), (DenseMatrix)newHistory.sHistory().$times$colon$times(BoxesRunTime.boxToDouble((double)newTheta), HasOps$.MODULE$.op_DM_S_Double_OpMulScalar())}), $less$colon$less$.MODULE$.refl(), HasOps$.MODULE$.dm_dm_UpdateOp_Double_OpSet(), ClassTag$.MODULE$.apply(Double.TYPE), Zero$.MODULE$.DoubleZero());
            DenseMatrix<Object> A = ((ImmutableNumericOps)newHistory.sHistory().t(HasOps$.MODULE$.canTranspose_DM())).$times(newHistory.yHistory(), HasOps$.MODULE$.impl_OpMulMatrix_DMD_DMD_eq_DMD());
            DenseMatrix<Object> L = breeze.linalg.package$.MODULE$.strictlyLowerTriangular(A, Semiring$.MODULE$.semiringD(), ClassTag$.MODULE$.apply(Double.TYPE), Zero$.MODULE$.DoubleZero());
            DenseMatrix D = (DenseMatrix)((ImmutableNumericOps)diag$.MODULE$.apply(diag$.MODULE$.apply(A, diag$.MODULE$.diagDMDVImpl()), diag$.MODULE$.diagDVDMImpl(ClassTag$.MODULE$.apply(Double.TYPE), Zero$.MODULE$.DoubleZero()))).$times$colon$times(BoxesRunTime.boxToDouble((double)-1.0), HasOps$.MODULE$.op_DM_S_Double_OpMulScalar());
            DenseMatrix<Object> STS = ((ImmutableNumericOps)newHistory.sHistory().t(HasOps$.MODULE$.canTranspose_DM())).$times(newHistory.sHistory(), HasOps$.MODULE$.impl_OpMulMatrix_DMD_DMD_eq_DMD());
            DenseMatrix<Object> MM = DenseMatrix$.MODULE$.vertcat(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new DenseMatrix[]{DenseMatrix$.MODULE$.horzcat(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new DenseMatrix[]{D, (DenseMatrix)L.t(HasOps$.MODULE$.canTranspose_DM())}), $less$colon$less$.MODULE$.refl(), HasOps$.MODULE$.dm_dm_UpdateOp_Double_OpSet(), ClassTag$.MODULE$.apply(Double.TYPE), Zero$.MODULE$.DoubleZero()), DenseMatrix$.MODULE$.horzcat(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new DenseMatrix[]{L, (DenseMatrix)STS.$times$colon$times(BoxesRunTime.boxToDouble((double)newTheta), HasOps$.MODULE$.op_DM_S_Double_OpMulScalar())}), $less$colon$less$.MODULE$.refl(), HasOps$.MODULE$.dm_dm_UpdateOp_Double_OpSet(), ClassTag$.MODULE$.apply(Double.TYPE), Zero$.MODULE$.DoubleZero())}), HasOps$.MODULE$.dm_dm_UpdateOp_Double_OpSet(), ClassTag$.MODULE$.apply(Double.TYPE), Zero$.MODULE$.DoubleZero());
            DenseMatrix newM = (DenseMatrix)inv$.MODULE$.apply(MM, inv$.MODULE$.canInvUsingLU_Double(LU$primitive$LU_DM_Impl_Double$.MODULE$));
            history2 = newHistory.copy(newTheta, newW, newM, newHistory.copy$default$4(), newHistory.copy$default$5());
        } else {
            history2 = history;
        }
        return history2;
    }

    private final /* synthetic */ Tuple2 $anonfun$1(DenseVector x$1, DenseVector d$1, int i, double gi) {
        Tuple2 tuple2;
        if (0.0 == gi) {
            tuple2 = Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)i), (Object)BoxesRunTime.boxToDouble((double)Double.MAX_VALUE));
        } else {
            double ti = gi < 0.0 ? (BoxesRunTime.unboxToDouble(x$1.apply(i)) - BoxesRunTime.unboxToDouble((Object)this.breeze$optimize$LBFGSB$$upperBounds.apply(i))) / gi : (BoxesRunTime.unboxToDouble(x$1.apply(i)) - BoxesRunTime.unboxToDouble((Object)this.breeze$optimize$LBFGSB$$lowerBounds.apply(i))) / gi;
            d$1.update(i, 0.0 == ti ? BoxesRunTime.boxToDouble((double)0.0) : BoxesRunTime.boxToDouble((double)(-gi)));
            tuple2 = Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)i), (Object)BoxesRunTime.boxToDouble((double)ti));
        }
        return tuple2;
    }

    private static final /* synthetic */ void getGeneralizedCauchyPoint$$anonfun$1(DenseVector x$2, DenseVector d$2, DenseVector xCauchy$1, DoubleRef oldT$1, int[] sortedIndeces$1, int sortIdx) {
        xCauchy$1.update(sortedIndeces$1[sortIdx], BoxesRunTime.boxToDouble((double)(BoxesRunTime.unboxToDouble(x$2.apply(sortedIndeces$1[sortIdx])) + oldT$1.elem * BoxesRunTime.unboxToDouble(d$2.apply(sortedIndeces$1[sortIdx])))));
    }

    private static final /* synthetic */ DenseVector subspaceMinimization$$anonfun$1(History history$1, IndexedSeq freeVariableIndexes$1, DenseMatrix WZ$1, int i) {
        return (DenseVector)((NumericOps)WZ$1.apply(package$.MODULE$.$colon$colon(), BoxesRunTime.boxToInteger((int)i), HasOps$.MODULE$.canSliceCol())).$colon$eq(((ImmutableNumericOps)history$1.W().apply(freeVariableIndexes$1.apply(i), package$.MODULE$.$colon$colon(), HasOps$.MODULE$.canSliceRow())).t(HasOps$.MODULE$.canUntranspose()), HasOps$.MODULE$.impl_Op_InPlace_DV_DV_Double_OpSet());
    }

    private static /* bridge */ /* synthetic */ DenseVector subspaceMinimization$$anonfun$adapted$1(History history$2, IndexedSeq freeVariableIndexes$2, DenseMatrix WZ$2, Object i) {
        return LBFGSB.subspaceMinimization$$anonfun$1(history$2, freeVariableIndexes$2, WZ$2, BoxesRunTime.unboxToInt((Object)i));
    }

    private static final /* synthetic */ void subspaceMinimization$$anonfun$3(Vector dStar$1, DenseVector subspaceMinX$1, Tuple2 x$1) {
        Tuple2 tuple2 = x$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        int freeVarIdx = BoxesRunTime.unboxToInt((Object)tuple2._1());
        int i = BoxesRunTime.unboxToInt((Object)tuple2._2());
        subspaceMinX$1.update(freeVarIdx, BoxesRunTime.boxToDouble((double)(BoxesRunTime.unboxToDouble(subspaceMinX$1.apply(freeVarIdx)) + BoxesRunTime.unboxToDouble(dStar$1.apply(BoxesRunTime.boxToInteger((int)i))))));
    }

    public class History
    implements Product,
    Serializable {
        private final double theta;
        private final DenseMatrix W;
        private final DenseMatrix M;
        private final DenseMatrix yHistory;
        private final DenseMatrix sHistory;
        private final /* synthetic */ LBFGSB $outer;

        public History(LBFGSB $outer, double theta, DenseMatrix<Object> W, DenseMatrix<Object> M, DenseMatrix<Object> yHistory, DenseMatrix<Object> sHistory) {
            this.theta = theta;
            this.W = W;
            this.M = M;
            this.yHistory = yHistory;
            this.sHistory = sHistory;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.theta()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.W()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.M()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.yHistory()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.sHistory()));
            return Statics.finalizeHash((int)n, (int)5);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof History)) return false;
            if (((History)object).breeze$optimize$LBFGSB$History$$$outer() != this.$outer) return false;
            History history = (History)object;
            if (this.theta() != history.theta()) return false;
            DenseMatrix<Object> denseMatrix = this.W();
            DenseMatrix<Object> denseMatrix2 = history.W();
            if (denseMatrix == null) {
                if (denseMatrix2 != null) {
                    return false;
                }
            } else if (!((Object)denseMatrix).equals(denseMatrix2)) return false;
            DenseMatrix<Object> denseMatrix3 = this.M();
            DenseMatrix<Object> denseMatrix4 = history.M();
            if (denseMatrix3 == null) {
                if (denseMatrix4 != null) {
                    return false;
                }
            } else if (!((Object)denseMatrix3).equals(denseMatrix4)) return false;
            DenseMatrix<Object> denseMatrix5 = this.yHistory();
            DenseMatrix<Object> denseMatrix6 = history.yHistory();
            if (denseMatrix5 == null) {
                if (denseMatrix6 != null) {
                    return false;
                }
            } else if (!((Object)denseMatrix5).equals(denseMatrix6)) return false;
            DenseMatrix<Object> denseMatrix7 = this.sHistory();
            DenseMatrix<Object> denseMatrix8 = history.sHistory();
            if (denseMatrix7 == null) {
                if (denseMatrix8 != null) {
                    return false;
                }
            } else if (!((Object)denseMatrix7).equals(denseMatrix8)) return false;
            if (!history.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof History;
        }

        public int productArity() {
            return 5;
        }

        public String productPrefix() {
            return "History";
        }

        public Object productElement(int n) {
            Serializable serializable;
            int n2 = n;
            switch (n2) {
                case 0: {
                    serializable = BoxesRunTime.boxToDouble((double)this._1());
                    break;
                }
                case 1: {
                    serializable = this._2();
                    break;
                }
                case 2: {
                    serializable = this._3();
                    break;
                }
                case 3: {
                    serializable = this._4();
                    break;
                }
                case 4: {
                    serializable = this._5();
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
                }
            }
            return serializable;
        }

        public String productElementName(int n) {
            String string;
            int n2 = n;
            switch (n2) {
                case 0: {
                    string = "theta";
                    break;
                }
                case 1: {
                    string = "W";
                    break;
                }
                case 2: {
                    string = "M";
                    break;
                }
                case 3: {
                    string = "yHistory";
                    break;
                }
                case 4: {
                    string = "sHistory";
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
                }
            }
            return string;
        }

        public double theta() {
            return this.theta;
        }

        public DenseMatrix<Object> W() {
            return this.W;
        }

        public DenseMatrix<Object> M() {
            return this.M;
        }

        public DenseMatrix<Object> yHistory() {
            return this.yHistory;
        }

        public DenseMatrix<Object> sHistory() {
            return this.sHistory;
        }

        public History copy(double theta, DenseMatrix<Object> W, DenseMatrix<Object> M, DenseMatrix<Object> yHistory, DenseMatrix<Object> sHistory) {
            return new History(this.$outer, theta, W, M, yHistory, sHistory);
        }

        public double copy$default$1() {
            return this.theta();
        }

        public DenseMatrix<Object> copy$default$2() {
            return this.W();
        }

        public DenseMatrix<Object> copy$default$3() {
            return this.M();
        }

        public DenseMatrix<Object> copy$default$4() {
            return this.yHistory();
        }

        public DenseMatrix<Object> copy$default$5() {
            return this.sHistory();
        }

        public double _1() {
            return this.theta();
        }

        public DenseMatrix<Object> _2() {
            return this.W();
        }

        public DenseMatrix<Object> _3() {
            return this.M();
        }

        public DenseMatrix<Object> _4() {
            return this.yHistory();
        }

        public DenseMatrix<Object> _5() {
            return this.sHistory();
        }

        public final /* synthetic */ LBFGSB breeze$optimize$LBFGSB$History$$$outer() {
            return this.$outer;
        }
    }
}

