/*
 * Decompiled with CFR 0.152.
 */
package breeze.optimize;

import breeze.generic.UFunc;
import breeze.linalg.operators.OpMulMatrix$;
import breeze.linalg.support.CanMapValues;
import breeze.linalg.support.CanTraverseValues;
import breeze.linalg.support.CanZipMapValues;
import breeze.math.CoordinateField;
import breeze.math.MutableFiniteCoordinateField;
import breeze.optimize.BatchDiffFunction;
import breeze.optimize.CachedBatchDiffFunction;
import breeze.optimize.DiffFunction;
import breeze.optimize.FirstOrderMinimizer;
import breeze.optimize.FirstOrderMinimizer$OptParams$;
import breeze.optimize.IterableOptimizationPackage;
import breeze.optimize.OptimizationOption;
import breeze.optimize.OptimizationPackage$;
import breeze.optimize.OptimizationPackageLowPriority;
import breeze.optimize.OptimizationPackageLowPriority2;
import breeze.optimize.SecondOrderFunction;
import breeze.optimize.StochasticDiffFunction;
import breeze.optimize.TruncatedNewtonMinimizer;
import breeze.optimize.TruncatedNewtonMinimizer$;
import breeze.util.Implicits$;
import java.io.Serializable;
import scala.;
import scala.Function2;
import scala.collection.Iterator;
import scala.collection.immutable.Seq;

public interface OptimizationPackage<Function, Vector> {
    public static <Vector> FirstOrderBatchOptimizationPackage<Vector> firstOrderBatchPackage(MutableFiniteCoordinateField<Vector, ?, Object> mutableFiniteCoordinateField) {
        return OptimizationPackage$.MODULE$.firstOrderBatchPackage(mutableFiniteCoordinateField);
    }

    public static <Vector> FirstOrderStochasticOptimizationPackage<Vector> firstOrderStochasticPackage(MutableFiniteCoordinateField<Vector, ?, Object> mutableFiniteCoordinateField) {
        return OptimizationPackage$.MODULE$.firstOrderStochasticPackage(mutableFiniteCoordinateField);
    }

    public static <DF, Vector> OptimizationPackageLowPriority2.ImmutableFirstOrderOptimizationPackage<DF, Vector> imFirstOrderPackage(CoordinateField<Vector, Object> coordinateField, CanTraverseValues<Vector, Object> canTraverseValues, CanMapValues<Vector, Object, Object, Vector> canMapValues, CanZipMapValues<Vector, Object, Object, Vector> canZipMapValues, .less.colon.less<DF, DiffFunction<Vector>> less2) {
        return OptimizationPackage$.MODULE$.imFirstOrderPackage((CoordinateField)coordinateField, (CanTraverseValues)canTraverseValues, (CanMapValues)canMapValues, (CanZipMapValues)canZipMapValues, (.less.colon.less)less2);
    }

    public static <DF, I, Vector> OptimizationPackageLowPriority.LBFGSMinimizationPackage<DF, Vector, I> lbfgsMinimizationPackage(MutableFiniteCoordinateField<Vector, I, Object> mutableFiniteCoordinateField, .less.colon.less<DF, DiffFunction<Vector>> less2) {
        return OptimizationPackage$.MODULE$.lbfgsMinimizationPackage((MutableFiniteCoordinateField)mutableFiniteCoordinateField, (.less.colon.less)less2);
    }

    public static <Vector, Hessian> SecondOrderOptimizationPackage<Vector, Hessian> secondOrderPackage(MutableFiniteCoordinateField<Vector, ?, Object> mutableFiniteCoordinateField, UFunc.UImpl2<OpMulMatrix$, Hessian, Vector, Vector> uImpl2) {
        return OptimizationPackage$.MODULE$.secondOrderPackage(mutableFiniteCoordinateField, uImpl2);
    }

    public Vector minimize(Function var1, Vector var2, Seq<OptimizationOption> var3);

    public static class FirstOrderBatchOptimizationPackage<Vector>
    implements IterableOptimizationPackage<BatchDiffFunction<Vector>, Vector, FirstOrderMinimizer.State<Vector, Object, Object>> {
        private final MutableFiniteCoordinateField<Vector, ?, Object> space;

        public FirstOrderBatchOptimizationPackage(MutableFiniteCoordinateField<Vector, ?, Object> space) {
            this.space = space;
        }

        @Override
        public Vector minimize(BatchDiffFunction<Vector> fn, Vector init, Seq<OptimizationOption> options) {
            return (Vector)((FirstOrderMinimizer.State)Implicits$.MODULE$.scEnrichIterator((Iterator)this.iterations(fn, init, options)).last()).x();
        }

        @Override
        public Iterator<FirstOrderMinimizer.State<Vector, Object, Object>> iterations(BatchDiffFunction<Vector> fn, Vector init, Seq<OptimizationOption> options) {
            return ((FirstOrderMinimizer.OptParams)options.foldLeft((Object)FirstOrderMinimizer$OptParams$.MODULE$.apply(FirstOrderMinimizer$OptParams$.MODULE$.$lessinit$greater$default$1(), FirstOrderMinimizer$OptParams$.MODULE$.$lessinit$greater$default$2(), FirstOrderMinimizer$OptParams$.MODULE$.$lessinit$greater$default$3(), FirstOrderMinimizer$OptParams$.MODULE$.$lessinit$greater$default$4(), FirstOrderMinimizer$OptParams$.MODULE$.$lessinit$greater$default$5(), FirstOrderMinimizer$OptParams$.MODULE$.$lessinit$greater$default$6(), FirstOrderMinimizer$OptParams$.MODULE$.$lessinit$greater$default$7(), FirstOrderMinimizer$OptParams$.MODULE$.$lessinit$greater$default$8()), (Function2 & Serializable)(a, b) -> (FirstOrderMinimizer.OptParams)b.apply(a))).iterations(new CachedBatchDiffFunction<Vector>(fn, this.space.copy()), init, this.space);
        }
    }

    public static class FirstOrderStochasticOptimizationPackage<Vector>
    implements IterableOptimizationPackage<StochasticDiffFunction<Vector>, Vector, FirstOrderMinimizer.State<Vector, ?, ?>> {
        private final MutableFiniteCoordinateField<Vector, ?, Object> space;

        public FirstOrderStochasticOptimizationPackage(MutableFiniteCoordinateField<Vector, ?, Object> space) {
            this.space = space;
        }

        @Override
        public Vector minimize(StochasticDiffFunction<Vector> fn, Vector init, Seq<OptimizationOption> options) {
            return (Vector)((FirstOrderMinimizer.State)Implicits$.MODULE$.scEnrichIterator((Iterator)this.iterations(fn, init, options)).last()).x();
        }

        @Override
        public Iterator<FirstOrderMinimizer.State<Vector, ?, ?>> iterations(StochasticDiffFunction<Vector> fn, Vector init, Seq<OptimizationOption> options) {
            return ((FirstOrderMinimizer.OptParams)options.foldLeft((Object)FirstOrderMinimizer$OptParams$.MODULE$.apply(FirstOrderMinimizer$OptParams$.MODULE$.$lessinit$greater$default$1(), FirstOrderMinimizer$OptParams$.MODULE$.$lessinit$greater$default$2(), FirstOrderMinimizer$OptParams$.MODULE$.$lessinit$greater$default$3(), FirstOrderMinimizer$OptParams$.MODULE$.$lessinit$greater$default$4(), FirstOrderMinimizer$OptParams$.MODULE$.$lessinit$greater$default$5(), FirstOrderMinimizer$OptParams$.MODULE$.$lessinit$greater$default$6(), FirstOrderMinimizer$OptParams$.MODULE$.$lessinit$greater$default$7(), FirstOrderMinimizer$OptParams$.MODULE$.$lessinit$greater$default$8()), (Function2 & Serializable)(a, b) -> (FirstOrderMinimizer.OptParams)b.apply(a))).iterations(fn, init, this.space);
        }
    }

    public static class SecondOrderOptimizationPackage<Vector, Hessian>
    implements IterableOptimizationPackage<SecondOrderFunction<Vector, Hessian>, Vector, TruncatedNewtonMinimizer.State> {
        private final MutableFiniteCoordinateField<Vector, ?, Object> space;
        private final UFunc.UImpl2<OpMulMatrix$, Hessian, Vector, Vector> mult;

        public SecondOrderOptimizationPackage(MutableFiniteCoordinateField<Vector, ?, Object> space, UFunc.UImpl2<OpMulMatrix$, Hessian, Vector, Vector> mult) {
            this.space = space;
            this.mult = mult;
        }

        @Override
        public Vector minimize(SecondOrderFunction<Vector, Hessian> fn, Vector init, Seq<OptimizationOption> options) {
            return (Vector)((TruncatedNewtonMinimizer.State)Implicits$.MODULE$.scEnrichIterator((Iterator)this.iterations(fn, init, options)).last()).x();
        }

        @Override
        public Iterator<TruncatedNewtonMinimizer.State> iterations(SecondOrderFunction<Vector, Hessian> fn, Vector init, Seq<OptimizationOption> options) {
            FirstOrderMinimizer.OptParams params = (FirstOrderMinimizer.OptParams)options.foldLeft((Object)FirstOrderMinimizer$OptParams$.MODULE$.apply(FirstOrderMinimizer$OptParams$.MODULE$.$lessinit$greater$default$1(), FirstOrderMinimizer$OptParams$.MODULE$.$lessinit$greater$default$2(), FirstOrderMinimizer$OptParams$.MODULE$.$lessinit$greater$default$3(), FirstOrderMinimizer$OptParams$.MODULE$.$lessinit$greater$default$4(), FirstOrderMinimizer$OptParams$.MODULE$.$lessinit$greater$default$5(), FirstOrderMinimizer$OptParams$.MODULE$.$lessinit$greater$default$6(), FirstOrderMinimizer$OptParams$.MODULE$.$lessinit$greater$default$7(), FirstOrderMinimizer$OptParams$.MODULE$.$lessinit$greater$default$8()), (Function2 & Serializable)(a, b) -> (FirstOrderMinimizer.OptParams)b.apply(a));
            if (params.useL1()) {
                throw new UnsupportedOperationException("Can't use L1 with second order optimizer right now");
            }
            TruncatedNewtonMinimizer<Vector, Hessian> minimizer = new TruncatedNewtonMinimizer<Vector, Hessian>(params.maxIterations(), params.tolerance(), params.regularization(), TruncatedNewtonMinimizer$.MODULE$.$lessinit$greater$default$4(), this.space, this.mult);
            return minimizer.iterations(fn, init);
        }
    }
}

