/*
 * Decompiled with CFR 0.152.
 */
package breeze.optimize.linear;

import breeze.generic.UFunc;
import breeze.linalg.DenseMatrix;
import breeze.linalg.DenseVector;
import breeze.linalg.DenseVector$;
import breeze.linalg.ImmutableNumericOps;
import breeze.linalg.operators.HasOps$;
import breeze.optimize.linear.NNLS;
import breeze.optimize.proximal.QpGenerator$;
import breeze.stats.distributions.Rand;
import breeze.stats.distributions.Rand$;
import java.io.Serializable;
import scala.;
import scala.$less$colon$less$;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.sys.package$;

public final class NNLS$
implements Serializable {
    public static final NNLS$ MODULE$ = new NNLS$();

    private NNLS$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(NNLS$.class);
    }

    public int $lessinit$greater$default$1() {
        return -1;
    }

    public double computeObjectiveValue(DenseMatrix<Object> ata, DenseVector<Object> atb, DenseVector<Object> x) {
        double res = BoxesRunTime.unboxToDouble(((ImmutableNumericOps)((ImmutableNumericOps)x.t(HasOps$.MODULE$.transposeTensor((.less.colon.less)$less$colon$less$.MODULE$.refl()))).$times(ata, HasOps$.MODULE$.impl_OpMulMatrix_DVTt_DMT_eq_DMT((UFunc.UImpl2)HasOps$.MODULE$.impl_OpMulMatrix_DMD_DMD_eq_DMD()))).$times(x, HasOps$.MODULE$.transTimesNormalFromDot((UFunc.UImpl2)HasOps$.MODULE$.canDotD()))) * 0.5 - BoxesRunTime.unboxToDouble((Object)atb.dot(x, (UFunc.UImpl2)HasOps$.MODULE$.canDotD()));
        return res;
    }

    public NNLS apply(int iters) {
        return new NNLS(iters);
    }

    public void main(String[] args) {
        if (args.length < 2) {
            Predef$.MODULE$.println((Object)"Usage: NNLS n s");
            Predef$.MODULE$.println((Object)"Test NNLS with quadratic function of dimension n for s consecutive solves");
            throw package$.MODULE$.exit(1);
        }
        int problemSize = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(args[0]));
        int numSolves = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(args[1]));
        NNLS nnls = new NNLS(this.$lessinit$greater$default$1());
        long nnlsTime = 0L;
        for (int i = 0; i < numSolves; ++i) {
            DenseMatrix<Object> ata = QpGenerator$.MODULE$.getGram(problemSize);
            DenseVector atb = (DenseVector)DenseVector$.MODULE$.rand(problemSize, (Rand)Rand$.MODULE$.gaussian(0.0, 1.0), ClassTag$.MODULE$.apply(Double.TYPE));
            long startTime = System.nanoTime();
            nnls.minimize(ata, atb);
            nnlsTime += System.nanoTime() - startTime;
        }
        Predef$.MODULE$.println((Object)new StringBuilder(29).append("NNLS problemSize ").append(problemSize).append(" solves ").append(numSolves).append(" ").append((double)nnlsTime / 1000000.0).append(" ms").toString());
    }
}

