/*
 * Decompiled with CFR 0.152.
 */
package breeze.optimize.proximal;

import breeze.generic.UFunc;
import breeze.linalg.DenseMatrix;
import breeze.linalg.DenseVector;
import breeze.linalg.Tensor;
import breeze.linalg.operators.HasOps$;
import breeze.linalg.pinv$;
import breeze.optimize.proximal.ProjectEquality$;
import breeze.optimize.proximal.Proximal;
import java.io.Serializable;
import scala.Product;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public class ProjectEquality
implements Proximal,
Product,
Serializable {
    private final DenseMatrix Aeq;
    private final DenseVector beq;
    private final DenseMatrix invAeq;

    public static ProjectEquality apply(DenseMatrix<Object> denseMatrix, DenseVector<Object> denseVector) {
        return ProjectEquality$.MODULE$.apply(denseMatrix, denseVector);
    }

    public static ProjectEquality fromProduct(Product product2) {
        return ProjectEquality$.MODULE$.fromProduct(product2);
    }

    public static ProjectEquality unapply(ProjectEquality projectEquality) {
        return ProjectEquality$.MODULE$.unapply(projectEquality);
    }

    public ProjectEquality(DenseMatrix<Object> Aeq, DenseVector<Object> beq) {
        this.Aeq = Aeq;
        this.beq = beq;
        this.invAeq = (DenseMatrix)pinv$.MODULE$.apply(Aeq, pinv$.MODULE$.pinvFromSVD_Double());
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof ProjectEquality)) return false;
        ProjectEquality projectEquality = (ProjectEquality)object;
        DenseMatrix<Object> denseMatrix = this.Aeq();
        DenseMatrix<Object> denseMatrix2 = projectEquality.Aeq();
        if (denseMatrix == null) {
            if (denseMatrix2 != null) {
                return false;
            }
        } else if (!((Object)denseMatrix).equals(denseMatrix2)) return false;
        DenseVector<Object> denseVector = this.beq();
        DenseVector<Object> denseVector2 = projectEquality.beq();
        if (denseVector == null) {
            if (denseVector2 != null) {
                return false;
            }
        } else if (!((Object)denseVector).equals(denseVector2)) return false;
        if (!projectEquality.canEqual(this)) return false;
        return true;
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof ProjectEquality;
    }

    public int productArity() {
        return 2;
    }

    public String productPrefix() {
        return "ProjectEquality";
    }

    public Object productElement(int n) {
        Tensor tensor;
        int n2 = n;
        if (0 == n2) {
            tensor = this._1();
        } else if (1 == n2) {
            tensor = this._2();
        } else {
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }
        return tensor;
    }

    public String productElementName(int n) {
        String string;
        int n2 = n;
        if (0 == n2) {
            string = "Aeq";
        } else if (1 == n2) {
            string = "beq";
        } else {
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }
        return string;
    }

    public DenseMatrix<Object> Aeq() {
        return this.Aeq;
    }

    public DenseVector<Object> beq() {
        return this.beq;
    }

    public DenseMatrix<Object> invAeq() {
        return this.invAeq;
    }

    @Override
    public void prox(DenseVector<Object> x, double rho) {
        DenseVector Av = (DenseVector)this.Aeq().$times(x, (UFunc.UImpl2)HasOps$.MODULE$.impl_OpMulMatrix_DMD_DVD_eq_DVD());
        Av.$minus$eq(this.beq(), HasOps$.MODULE$.impl_OpSub_InPlace_DV_DV_Double());
        x.$plus$eq(this.invAeq().$times(Av, (UFunc.UImpl2)HasOps$.MODULE$.impl_OpMulMatrix_DMD_DVD_eq_DVD()), HasOps$.MODULE$.impl_OpAdd_InPlace_DV_DV_Double());
    }

    @Override
    public double prox$default$2() {
        return 0.0;
    }

    public ProjectEquality copy(DenseMatrix<Object> Aeq, DenseVector<Object> beq) {
        return new ProjectEquality(Aeq, beq);
    }

    public DenseMatrix<Object> copy$default$1() {
        return this.Aeq();
    }

    public DenseVector<Object> copy$default$2() {
        return this.beq();
    }

    public DenseMatrix<Object> _1() {
        return this.Aeq();
    }

    public DenseVector<Object> _2() {
        return this.beq();
    }
}

