/*
 * Decompiled with CFR 0.152.
 */
package breeze.optimize.proximal;

import breeze.generic.UFunc;
import breeze.linalg.DenseVector;
import breeze.linalg.Transpose;
import breeze.linalg.norm$;
import breeze.linalg.operators.HasOps$;
import breeze.optimize.proximal.ProjectHyperPlane$;
import breeze.optimize.proximal.Proximal;
import java.io.Serializable;
import scala.;
import scala.$less$colon$less$;
import scala.Product;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

public class ProjectHyperPlane
implements Proximal,
Product,
Serializable {
    private final DenseVector a;
    private final double b;
    private final Transpose at;

    public static ProjectHyperPlane apply(DenseVector<Object> denseVector, double d) {
        return ProjectHyperPlane$.MODULE$.apply(denseVector, d);
    }

    public static ProjectHyperPlane fromProduct(Product product2) {
        return ProjectHyperPlane$.MODULE$.fromProduct(product2);
    }

    public static ProjectHyperPlane unapply(ProjectHyperPlane projectHyperPlane) {
        return ProjectHyperPlane$.MODULE$.unapply(projectHyperPlane);
    }

    public ProjectHyperPlane(DenseVector<Object> a, double b) {
        this.a = a;
        this.b = b;
        this.at = (Transpose)a.t(HasOps$.MODULE$.transposeTensor((.less.colon.less)$less$colon$less$.MODULE$.refl()));
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
        n = Statics.mix((int)n, (int)Statics.anyHash(this.a()));
        n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.b()));
        return Statics.finalizeHash((int)n, (int)2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof ProjectHyperPlane)) return false;
        ProjectHyperPlane projectHyperPlane = (ProjectHyperPlane)object;
        if (this.b() != projectHyperPlane.b()) return false;
        DenseVector<Object> denseVector = this.a();
        DenseVector<Object> denseVector2 = projectHyperPlane.a();
        if (denseVector == null) {
            if (denseVector2 != null) {
                return false;
            }
        } else if (!((Object)denseVector).equals(denseVector2)) return false;
        if (!projectHyperPlane.canEqual(this)) return false;
        return true;
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof ProjectHyperPlane;
    }

    public int productArity() {
        return 2;
    }

    public String productPrefix() {
        return "ProjectHyperPlane";
    }

    public Object productElement(int n) {
        Serializable serializable;
        int n2 = n;
        if (0 == n2) {
            serializable = this._1();
        } else if (1 == n2) {
            serializable = BoxesRunTime.boxToDouble((double)this._2());
        } else {
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }
        return serializable;
    }

    public String productElementName(int n) {
        String string;
        int n2 = n;
        if (0 == n2) {
            string = "a";
        } else if (1 == n2) {
            string = "b";
        } else {
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }
        return string;
    }

    public DenseVector<Object> a() {
        return this.a;
    }

    public double b() {
        return this.b;
    }

    public Transpose<DenseVector<Object>> at() {
        return this.at;
    }

    @Override
    public void prox(DenseVector<Object> x, double rho) {
        double atx = BoxesRunTime.unboxToDouble((Object)this.at().$times(x, HasOps$.MODULE$.transTimesNormalFromDot((UFunc.UImpl2)HasOps$.MODULE$.canDotD())));
        double anorm = BoxesRunTime.unboxToDouble((Object)norm$.MODULE$.apply(this.a(), BoxesRunTime.boxToInteger((int)2), norm$.MODULE$.fromCanNormInt(norm$.MODULE$.canNorm(HasOps$.MODULE$.DV_canIterateValues(), norm$.MODULE$.scalarNorm_Double()))));
        double scale = (this.b() - atx) / (anorm * anorm);
        DenseVector ascaled = (DenseVector)this.a().$times(BoxesRunTime.boxToDouble((double)scale), HasOps$.MODULE$.impl_Op_DV_S_eq_DV_Double_OpMulMatrix());
        x.$plus$eq(ascaled, HasOps$.MODULE$.impl_OpAdd_InPlace_DV_DV_Double());
    }

    @Override
    public double prox$default$2() {
        return 0.0;
    }

    public ProjectHyperPlane copy(DenseVector<Object> a, double b) {
        return new ProjectHyperPlane(a, b);
    }

    public DenseVector<Object> copy$default$1() {
        return this.a();
    }

    public double copy$default$2() {
        return this.b();
    }

    public DenseVector<Object> _1() {
        return this.a();
    }

    public double _2() {
        return this.b();
    }
}

