/*
 * Decompiled with CFR 0.152.
 */
package breeze.optimize.proximal;

import breeze.linalg.DenseVector;
import breeze.linalg.DenseVector$;
import breeze.linalg.Vector;
import breeze.linalg.operators.HasOps$;
import breeze.optimize.proximal.ProjectProbabilitySimplex$;
import breeze.optimize.proximal.Proximal;
import java.io.Serializable;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.Product;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction1;
import scala.runtime.java8.JFunction2;

public class ProjectProbabilitySimplex
implements Proximal,
Product,
Serializable {
    private final double s;

    public static ProjectProbabilitySimplex apply(double d) {
        return ProjectProbabilitySimplex$.MODULE$.apply(d);
    }

    public static ProjectProbabilitySimplex fromProduct(Product product2) {
        return ProjectProbabilitySimplex$.MODULE$.fromProduct(product2);
    }

    public static ProjectProbabilitySimplex unapply(ProjectProbabilitySimplex projectProbabilitySimplex) {
        return ProjectProbabilitySimplex$.MODULE$.unapply(projectProbabilitySimplex);
    }

    public ProjectProbabilitySimplex(double s) {
        this.s = s;
        if (!(s > 0.0)) {
            throw new IllegalArgumentException(StringOps$.MODULE$.format$extension("requirement failed: %s", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{new StringBuilder(108).append("Proximal:ProjectProbabilitySimplex Radius s must be strictly positive").append(": ").append("ProjectProbabilitySimplex.this.s.>(0)").toString()})));
        }
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
        n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.s()));
        return Statics.finalizeHash((int)n, (int)1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof ProjectProbabilitySimplex)) return false;
        ProjectProbabilitySimplex projectProbabilitySimplex = (ProjectProbabilitySimplex)object;
        if (this.s() != projectProbabilitySimplex.s()) return false;
        if (!projectProbabilitySimplex.canEqual(this)) return false;
        return true;
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof ProjectProbabilitySimplex;
    }

    public int productArity() {
        return 1;
    }

    public String productPrefix() {
        return "ProjectProbabilitySimplex";
    }

    public Object productElement(int n) {
        int n2 = n;
        if (0 != n2) {
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }
        return BoxesRunTime.boxToDouble((double)this._1());
    }

    public String productElementName(int n) {
        int n2 = n;
        if (0 != n2) {
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }
        return "s";
    }

    public double s() {
        return this.s;
    }

    @Override
    public void prox(DenseVector<Object> x, double rho) {
        Object object = Predef$.MODULE$.doubleArrayOps((double[])x.data());
        double[] sorted = (double[])ArrayOps$.MODULE$.sorted$extension(object, scala.package$.MODULE$.Ordering().apply((Ordering)Ordering.DeprecatedDoubleOrdering$.MODULE$).reverse());
        Object object2 = Predef$.MODULE$.doubleArrayOps(sorted);
        Object object3 = Predef$.MODULE$.doubleArrayOps((double[])ArrayOps$.MODULE$.scanLeft$extension(object2, (Object)BoxesRunTime.boxToDouble((double)0.0), (Function2)(JFunction2.mcDDD.sp & Serializable)(_$1, _$2) -> _$1 + _$2, ClassTag$.MODULE$.apply(Double.TYPE)));
        double[] cum = (double[])ArrayOps$.MODULE$.slice$extension(object3, 1, x.length() + 1);
        Object object4 = Predef$.MODULE$.doubleArrayOps(cum);
        Object object5 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zipWithIndex$extension(object4));
        Vector cs = DenseVector$.MODULE$.apply(ArrayOps$.MODULE$.map$extension(object5, (Function1 & Serializable)elem -> (BoxesRunTime.unboxToDouble((Object)elem._1()) - this.s()) / (double)(BoxesRunTime.unboxToInt((Object)elem._2()) + 1), ClassTag$.MODULE$.apply(Double.TYPE)));
        Object object6 = Predef$.MODULE$.doubleArrayOps((double[])((DenseVector)((DenseVector)DenseVector$.MODULE$.apply(sorted)).$minus(cs, HasOps$.MODULE$.impl_OpSub_DV_DV_eq_DV_Double())).data());
        int ndx = ArrayOps$.MODULE$.count$extension(object6, (Function1)(JFunction1.mcZD.sp & Serializable)_$3 -> _$3 >= 0.0) - 1;
        int i = 0;
        int yy = x.length();
        while (i < x.length()) {
            int n = i++;
            x.update(n, (Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.max(BoxesRunTime.unboxToDouble((Object)x.apply(n)) - BoxesRunTime.unboxToDouble(((DenseVector)cs).apply(ndx)), 0.0)));
        }
    }

    @Override
    public double prox$default$2() {
        return 1.0;
    }

    public ProjectProbabilitySimplex copy(double s) {
        return new ProjectProbabilitySimplex(s);
    }

    public double copy$default$1() {
        return this.s();
    }

    public double _1() {
        return this.s();
    }
}

