/*
 * Decompiled with CFR 0.152.
 */
package breeze.stats.distributions;

import breeze.generic.UFunc;
import breeze.numerics.package$digamma$;
import breeze.numerics.package$digamma$digammaImplDouble$;
import breeze.numerics.package$lgamma$;
import breeze.numerics.package$lgamma$lgammaImplDouble$;
import breeze.numerics.package$log$;
import breeze.numerics.package$log$logDoubleImpl$;
import breeze.optimize.DiffFunction;
import breeze.stats.distributions.ContinuousDistr;
import breeze.stats.distributions.ContinuousDistributionUFuncProvider;
import breeze.stats.distributions.ContinuousDistributionUFuncProvider$basicImpl$;
import breeze.stats.distributions.Gamma$;
import breeze.stats.distributions.Gamma$SufficientStatistic$;
import breeze.stats.distributions.HasCdf;
import breeze.stats.distributions.HasInverseCdf;
import breeze.stats.distributions.Moments;
import breeze.stats.distributions.RandBasis;
import java.io.Serializable;
import org.apache.commons.math3.distribution.GammaDistribution;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.math.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Gamma
implements ContinuousDistr<Object>,
Moments<Object, Object>,
HasCdf,
HasInverseCdf,
Product {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffset(Gamma.class, "0bitmap$1");
    public double normalizer$lzy1;
    public long 0bitmap$1;
    private final double shape;
    private final double scale;
    private final RandBasis rand;
    public double logNormalizer$lzy1;
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffset(Gamma$.class, "0bitmap$2");

    public static ContinuousDistributionUFuncProvider.ContinuousDistrUFuncWrapper ContinuousDistrUFuncWrapper(ContinuousDistr continuousDistr) {
        return Gamma$.MODULE$.ContinuousDistrUFuncWrapper(continuousDistr);
    }

    public static double approx_k(double d) {
        return Gamma$.MODULE$.approx_k(d);
    }

    public static ContinuousDistributionUFuncProvider$basicImpl$ basicImpl() {
        return Gamma$.MODULE$.basicImpl();
    }

    public static Gamma distribution(Tuple2<Object, Object> tuple2, RandBasis randBasis) {
        return Gamma$.MODULE$.distribution(tuple2, randBasis);
    }

    public static SufficientStatistic emptySufficientStatistic() {
        return Gamma$.MODULE$.emptySufficientStatistic();
    }

    public static <V> V inPlace(V v, UFunc.InPlaceImpl<Gamma$, V> inPlaceImpl) {
        return (V)Gamma$.MODULE$.inPlace((Object)v, inPlaceImpl);
    }

    public static <V, V2> V inPlace(V v, V2 V2, UFunc.InPlaceImpl2<Gamma$, V, V2> inPlaceImpl2) {
        return (V)Gamma$.MODULE$.inPlace((Object)v, (Object)V2, inPlaceImpl2);
    }

    public static <V, V2, V3> V inPlace(V v, V2 V2, V3 V3, UFunc.InPlaceImpl3<Gamma$, V, V2, V3> inPlaceImpl3) {
        return (V)Gamma$.MODULE$.inPlace((Object)v, (Object)V2, (Object)V3, inPlaceImpl3);
    }

    public static DiffFunction<Tuple2<Object, Object>> likelihoodFunction(SufficientStatistic sufficientStatistic) {
        return Gamma$.MODULE$.likelihoodFunction(sufficientStatistic);
    }

    public static Tuple2<Object, Object> mle(SufficientStatistic sufficientStatistic) {
        return Gamma$.MODULE$.mle(sufficientStatistic);
    }

    public static SufficientStatistic sufficientStatisticFor(double d) {
        return Gamma$.MODULE$.sufficientStatisticFor(d);
    }

    public static Gamma unapply(Gamma gamma) {
        return Gamma$.MODULE$.unapply(gamma);
    }

    public static <S> Object withSink(S s) {
        return Gamma$.MODULE$.withSink((Object)s);
    }

    public Gamma(double shape, double scale, RandBasis rand) {
        this.shape = shape;
        this.scale = scale;
        this.rand = rand;
        ContinuousDistr.$init$(this);
        if (shape <= 0.0 || scale <= 0.0) {
            throw new IllegalArgumentException("Shape and scale must be positive");
        }
    }

    @Override
    public double normalizer() {
        long l;
        long l2;
        while ((l2 = LazyVals$.MODULE$.STATE(l = LazyVals$.MODULE$.get((Object)this, OFFSET$0), 1)) != 3L) {
            if (l2 == 0L) {
                if (!LazyVals$.MODULE$.CAS((Object)this, OFFSET$0, l, 1, 1)) continue;
                try {
                    double d;
                    this.normalizer$lzy1 = d = ContinuousDistr.normalizer$(this);
                    LazyVals$.MODULE$.setFlag((Object)this, OFFSET$0, 3, 1);
                    return d;
                }
                catch (Throwable throwable) {
                    LazyVals$.MODULE$.setFlag((Object)this, OFFSET$0, 0, 1);
                    throw throwable;
                }
            }
            LazyVals$.MODULE$.wait4Notification((Object)this, OFFSET$0, l, 1);
        }
        return this.normalizer$lzy1;
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
        n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.shape()));
        n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.scale()));
        return Statics.finalizeHash((int)n, (int)2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof Gamma)) return false;
        Gamma gamma = (Gamma)object;
        if (this.shape() != gamma.shape()) return false;
        if (this.scale() != gamma.scale()) return false;
        if (!gamma.canEqual(this)) return false;
        return true;
    }

    public boolean canEqual(Object that) {
        return that instanceof Gamma;
    }

    public int productArity() {
        return 2;
    }

    public String productPrefix() {
        return "Gamma";
    }

    public Object productElement(int n) {
        double d;
        int n2 = n;
        if (0 == n2) {
            d = this._1();
        } else if (1 == n2) {
            d = this._2();
        } else {
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }
        return BoxesRunTime.boxToDouble((double)d);
    }

    public String productElementName(int n) {
        String string;
        int n2 = n;
        if (0 == n2) {
            string = "shape";
        } else if (1 == n2) {
            string = "scale";
        } else {
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }
        return string;
    }

    public double shape() {
        return this.shape;
    }

    public double scale() {
        return this.scale;
    }

    @Override
    public double pdf(double x) {
        return x < 0.0 ? 0.0 : (x > 0.0 ? package$.MODULE$.exp(this.logPdf(BoxesRunTime.boxToDouble((double)x))) : (this.shape() > 1.0 ? 0.0 : (this.shape() == 1.0 ? this.normalizer() : Double.POSITIVE_INFINITY)));
    }

    @Override
    public double logNormalizer() {
        long l;
        long l2;
        while ((l2 = LazyVals$.MODULE$.STATE(l = LazyVals$.MODULE$.get((Object)this, OFFSET$0), 0)) != 3L) {
            if (l2 == 0L) {
                if (!LazyVals$.MODULE$.CAS((Object)this, OFFSET$0, l, 1, 0)) continue;
                try {
                    double d;
                    this.logNormalizer$lzy1 = d = BoxesRunTime.unboxToDouble((Object)package$lgamma$.MODULE$.apply(BoxesRunTime.boxToDouble((double)this.shape()), (UFunc.UImpl)package$lgamma$lgammaImplDouble$.MODULE$)) + this.shape() * BoxesRunTime.unboxToDouble((Object)package$log$.MODULE$.apply(BoxesRunTime.boxToDouble((double)this.scale()), (UFunc.UImpl)package$log$logDoubleImpl$.MODULE$));
                    LazyVals$.MODULE$.setFlag((Object)this, OFFSET$0, 3, 0);
                    return d;
                }
                catch (Throwable throwable) {
                    LazyVals$.MODULE$.setFlag((Object)this, OFFSET$0, 0, 0);
                    throw throwable;
                }
            }
            LazyVals$.MODULE$.wait4Notification((Object)this, OFFSET$0, l, 0);
        }
        return this.logNormalizer$lzy1;
    }

    @Override
    public double unnormalizedLogPdf(double x) {
        return (this.shape() - 1.0) * BoxesRunTime.unboxToDouble((Object)package$log$.MODULE$.apply(BoxesRunTime.boxToDouble((double)x), (UFunc.UImpl)package$log$logDoubleImpl$.MODULE$)) - x / this.scale();
    }

    public String toString() {
        return new StringBuilder(8).append("Gamma(").append(this.shape()).append(",").append(this.scale()).append(")").toString();
    }

    public double logDraw() {
        return this.shape() < 1.0 ? this.rec$1() + package$.MODULE$.log(this.scale()) : package$.MODULE$.log(this.draw());
    }

    @Override
    public double draw() {
        double d;
        if (this.shape() == 1.0) {
            d = this.scale() * -package$.MODULE$.log(BoxesRunTime.unboxToDouble((Object)this.rand.uniform().draw()));
        } else if (this.shape() < 1.0) {
            d = this.scale() * this.rec$2();
        } else {
            double d2 = this.shape() - 0.3333333333333333;
            double c = 1.0 / package$.MODULE$.sqrt(9.0 * d2);
            double r = 0.0;
            boolean ok = false;
            while (!ok) {
                double v = 0.0;
                double x = 0.0;
                boolean bl = true;
                while (bl) {
                    x = this.rand.generator().nextGaussian();
                    v = 1.0 + c * x;
                    bl = v <= 0.0;
                }
                v = v * v * v;
                double x2 = x * x;
                double u = BoxesRunTime.unboxToDouble((Object)this.rand.uniform().draw());
                if (!(u < 1.0 - 0.0331 * (x2 * x2)) && !(BoxesRunTime.unboxToDouble((Object)package$log$.MODULE$.apply(BoxesRunTime.boxToDouble((double)u), (UFunc.UImpl)package$log$logDoubleImpl$.MODULE$)) < 0.5 * x2 + d2 * (1.0 - v + BoxesRunTime.unboxToDouble((Object)package$log$.MODULE$.apply(BoxesRunTime.boxToDouble((double)v), (UFunc.UImpl)package$log$logDoubleImpl$.MODULE$))))) continue;
                r = this.scale() * d2 * v;
                ok = true;
            }
            d = r;
        }
        return d;
    }

    @Override
    public double mean() {
        return this.shape() * this.scale();
    }

    @Override
    public double variance() {
        return this.mean() * this.scale();
    }

    @Override
    public double mode() {
        Predef$.MODULE$.require(this.shape() >= 1.0);
        return this.mean() - this.scale();
    }

    @Override
    public double entropy() {
        return this.logNormalizer() - (this.shape() - 1.0) * BoxesRunTime.unboxToDouble((Object)package$digamma$.MODULE$.apply(BoxesRunTime.boxToDouble((double)this.shape()), (UFunc.UImpl)package$digamma$digammaImplDouble$.MODULE$)) + this.shape();
    }

    @Override
    public double probability(double x, double y) {
        return new GammaDistribution(this.shape(), this.scale()).probability(x, y);
    }

    @Override
    public double inverseCdf(double p) {
        return new GammaDistribution(this.shape(), this.scale()).inverseCumulativeProbability(p);
    }

    @Override
    public double cdf(double x) {
        return new GammaDistribution(this.shape(), this.scale()).cumulativeProbability(x);
    }

    public Gamma copy(double shape, double scale, RandBasis rand) {
        return new Gamma(shape, scale, rand);
    }

    public double copy$default$1() {
        return this.shape();
    }

    public double copy$default$2() {
        return this.scale();
    }

    public double _1() {
        return this.shape();
    }

    public double _2() {
        return this.scale();
    }

    private final double rec$1() {
        double d;
        block2: {
            double logX;
            while (true) {
                double u = BoxesRunTime.unboxToDouble((Object)this.rand.uniform().draw());
                double v = -package$.MODULE$.log(BoxesRunTime.unboxToDouble((Object)this.rand.uniform().draw()));
                double logU = BoxesRunTime.unboxToDouble((Object)package$log$.MODULE$.apply(BoxesRunTime.boxToDouble((double)u), (UFunc.UImpl)package$log$logDoubleImpl$.MODULE$));
                if (logU <= package$.MODULE$.log1p(-this.shape())) {
                    double logV = BoxesRunTime.unboxToDouble((Object)package$log$.MODULE$.apply(BoxesRunTime.boxToDouble((double)v), (UFunc.UImpl)package$log$logDoubleImpl$.MODULE$));
                    double logX2 = logU / this.shape();
                    if (!(logX2 <= logV)) continue;
                    d = logX2;
                    break block2;
                }
                double y = -BoxesRunTime.unboxToDouble((Object)package$log$.MODULE$.apply(BoxesRunTime.boxToDouble((double)((1.0 - u) / this.shape())), (UFunc.UImpl)package$log$logDoubleImpl$.MODULE$));
                logX = package$.MODULE$.log(1.0 - this.shape() + this.shape() * y) / this.shape();
                if (logX <= package$.MODULE$.log(v + y)) break;
            }
            d = logX;
        }
        return d;
    }

    private final double rec$2() {
        double d;
        block2: {
            double x;
            while (true) {
                double u = BoxesRunTime.unboxToDouble((Object)this.rand.uniform().draw());
                double v = -package$.MODULE$.log(BoxesRunTime.unboxToDouble((Object)this.rand.uniform().draw()));
                if (u <= 1.0 - this.shape()) {
                    double x2 = package$.MODULE$.pow(u, 1.0 / this.shape());
                    if (!(x2 <= v)) continue;
                    d = x2;
                    break block2;
                }
                double y = -BoxesRunTime.unboxToDouble((Object)package$log$.MODULE$.apply(BoxesRunTime.boxToDouble((double)((1.0 - u) / this.shape())), (UFunc.UImpl)package$log$logDoubleImpl$.MODULE$));
                x = package$.MODULE$.pow(1.0 - this.shape() + this.shape() * y, 1.0 / this.shape());
                if (x <= v + y) break;
            }
            d = x;
        }
        return d;
    }

    public static class SufficientStatistic
    implements breeze.stats.distributions.SufficientStatistic<SufficientStatistic>,
    Product,
    Serializable {
        private final double n;
        private final double meanOfLogs;
        private final double mean;

        public static SufficientStatistic apply(double d, double d2, double d3) {
            return Gamma$SufficientStatistic$.MODULE$.apply(d, d2, d3);
        }

        public static SufficientStatistic fromProduct(Product product2) {
            return Gamma$SufficientStatistic$.MODULE$.fromProduct(product2);
        }

        public static SufficientStatistic unapply(SufficientStatistic sufficientStatistic) {
            return Gamma$SufficientStatistic$.MODULE$.unapply(sufficientStatistic);
        }

        public SufficientStatistic(double n, double meanOfLogs, double mean2) {
            this.n = n;
            this.meanOfLogs = meanOfLogs;
            this.mean = mean2;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.n()));
            n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.meanOfLogs()));
            n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.mean()));
            return Statics.finalizeHash((int)n, (int)3);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof SufficientStatistic)) return false;
            SufficientStatistic sufficientStatistic = (SufficientStatistic)object;
            if (this.n() != sufficientStatistic.n()) return false;
            if (this.meanOfLogs() != sufficientStatistic.meanOfLogs()) return false;
            if (this.mean() != sufficientStatistic.mean()) return false;
            if (!sufficientStatistic.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof SufficientStatistic;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "SufficientStatistic";
        }

        public Object productElement(int n) {
            double d;
            int n2 = n;
            switch (n2) {
                case 0: {
                    d = this._1();
                    break;
                }
                case 1: {
                    d = this._2();
                    break;
                }
                case 2: {
                    d = this._3();
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
                }
            }
            return BoxesRunTime.boxToDouble((double)d);
        }

        public String productElementName(int n) {
            String string;
            int n2 = n;
            switch (n2) {
                case 0: {
                    string = "n";
                    break;
                }
                case 1: {
                    string = "meanOfLogs";
                    break;
                }
                case 2: {
                    string = "mean";
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
                }
            }
            return string;
        }

        public double n() {
            return this.n;
        }

        public double meanOfLogs() {
            return this.meanOfLogs;
        }

        public double mean() {
            return this.mean;
        }

        @Override
        public SufficientStatistic $times(double weight) {
            return Gamma$SufficientStatistic$.MODULE$.apply(this.n() * weight, this.meanOfLogs(), this.mean());
        }

        @Override
        public SufficientStatistic $plus(SufficientStatistic t) {
            double delta = t.mean() - this.mean();
            double newMean = this.mean() + delta * (t.n() / (t.n() + this.n()));
            double logDelta = t.meanOfLogs() - this.meanOfLogs();
            double newMeanLogs = this.meanOfLogs() + logDelta * (t.n() / (t.n() + this.n()));
            return Gamma$SufficientStatistic$.MODULE$.apply(t.n() + this.n(), newMeanLogs, newMean);
        }

        public SufficientStatistic copy(double n, double meanOfLogs, double mean2) {
            return new SufficientStatistic(n, meanOfLogs, mean2);
        }

        public double copy$default$1() {
            return this.n();
        }

        public double copy$default$2() {
            return this.meanOfLogs();
        }

        public double copy$default$3() {
            return this.mean();
        }

        public double _1() {
            return this.n();
        }

        public double _2() {
            return this.meanOfLogs();
        }

        public double _3() {
            return this.mean();
        }
    }
}

