/*
 * Decompiled with CFR 0.152.
 */
package breeze.stats.random;

import breeze.linalg.DenseVector;
import breeze.stats.distributions.Rand;
import java.io.Serializable;
import java.math.BigInteger;
import scala.Array$;
import scala.Function1;
import scala.Int$;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

public class HaltonSequence
implements Rand<DenseVector<Object>> {
    private int count;
    private final long[] primes;

    public HaltonSequence(int dim2) {
        Predef$.MODULE$.require(dim2 > 0, HaltonSequence::$init$$$anonfun$1);
        this.count = 0;
        this.primes = (long[])Array$.MODULE$.iterate((Object)BoxesRunTime.boxToLong((long)2L), dim2, (Function1)(JFunction1.mcJJ.sp & Serializable)last -> new BigInteger(BoxesRunTime.boxToLong((long)last).toString()).nextProbablePrime().longValue(), ClassTag$.MODULE$.apply(Long.TYPE));
    }

    public long[] primes() {
        return this.primes;
    }

    @Override
    public DenseVector<Object> draw() {
        ++this.count;
        Object object = Predef$.MODULE$.longArrayOps(this.primes());
        double[] arr = (double[])ArrayOps$.MODULE$.map$extension(object, (Function1)(JFunction1.mcDJ.sp & Serializable)prime -> {
            double h = 0.0;
            double f = 1.0;
            for (long k = Int$.MODULE$.int2long(this.count); k > 0L; k /= prime) {
                h += (double)(k % prime) * (f /= (double)prime);
            }
            return h % 1.0;
        }, ClassTag$.MODULE$.apply(Double.TYPE));
        return new DenseVector<Object>(arr);
    }

    private static final String $init$$$anonfun$1() {
        return "dim must be positive!";
    }
}

