/*
 * Decompiled with CFR 0.152.
 */
package breeze.stats.regression;

import breeze.linalg.DenseMatrix;
import breeze.linalg.DenseVector;
import breeze.stats.regression.LeastSquaresRegressionResult;
import breeze.stats.regression.LeastSquaresRegressionResult$;
import dev.ludovic.netlib.lapack.LAPACK;
import java.io.Serializable;
import java.util.Arrays;
import org.netlib.util.intW;
import scala.Function1;
import scala.Predef$;
import scala.math.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

public final class leastSquaresImplementation$
implements Serializable {
    public static final leastSquaresImplementation$ MODULE$ = new leastSquaresImplementation$();

    private leastSquaresImplementation$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(leastSquaresImplementation$.class);
    }

    public LeastSquaresRegressionResult doLeastSquares(DenseMatrix<Object> data, DenseVector<Object> outputs, double[] workArray) {
        Predef$.MODULE$.require(data.rows() == outputs.size());
        Predef$.MODULE$.require(data.rows() > data.cols() + 1);
        Predef$.MODULE$.require(workArray.length >= 2 * data.rows() * data.cols());
        intW info = new intW(0);
        LAPACK.getInstance().dgels("N", data.rows(), data.cols(), 1, (double[])data.data(), data.rows(), (double[])outputs.data(), data.rows(), workArray, workArray.length, info);
        if (info.val < 0) {
            throw new ArithmeticException("Least squares did not converge.");
        }
        DenseVector<Object> coefficients = new DenseVector<Object>(Arrays.copyOf((double[])outputs.data(), data.cols()));
        DoubleRef r2 = DoubleRef.create((double)0.0);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), data.rows() - data.cols()).foreach((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            double d;
            r2$1.elem = d = r2$1.elem + package$.MODULE$.pow(BoxesRunTime.unboxToDouble((Object)ScalaRunTime$.MODULE$.array_apply(outputs.data(), data.cols() + i)), 2.0);
        });
        return LeastSquaresRegressionResult$.MODULE$.apply(coefficients, r2.elem);
    }
}

