/*
 * Decompiled with CFR 0.152.
 */
package breeze.util;

import breeze.util.ReflectionUtil$;
import java.io.Serializable;
import java.util.Arrays;
import scala.MatchError;
import scala.math.package$;
import scala.reflect.ClassTag;
import scala.runtime.Arrays$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.hashing.MurmurHash3$;

public final class ArrayUtil$
implements Serializable {
    public static final ArrayUtil$ MODULE$ = new ArrayUtil$();

    private ArrayUtil$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(ArrayUtil$.class);
    }

    public <V> void fill(Object a, int offset, int length, V v) {
        Object object = a;
        if (object instanceof double[]) {
            double[] x = (double[])object;
            Arrays.fill(x, offset, offset + length, BoxesRunTime.unboxToDouble(v));
        } else if (object instanceof int[]) {
            int[] x = (int[])object;
            Arrays.fill(x, offset, offset + length, BoxesRunTime.unboxToInt(v));
        } else if (object instanceof float[]) {
            float[] x = (float[])object;
            Arrays.fill(x, offset, offset + length, BoxesRunTime.unboxToFloat(v));
        } else if (object instanceof long[]) {
            long[] x = (long[])object;
            Arrays.fill(x, offset, offset + length, BoxesRunTime.unboxToLong(v));
        } else if (object instanceof short[]) {
            short[] x = (short[])object;
            Arrays.fill(x, offset, offset + length, BoxesRunTime.unboxToShort(v));
        } else if (object instanceof char[]) {
            char[] x = (char[])object;
            Arrays.fill(x, offset, offset + length, BoxesRunTime.unboxToChar(v));
        } else if (object instanceof byte[]) {
            byte[] x = (byte[])object;
            Arrays.fill(x, offset, offset + length, BoxesRunTime.unboxToByte(v));
        } else if (object instanceof boolean[]) {
            boolean[] x = (boolean[])object;
            Arrays.fill(x, offset, offset + length, BoxesRunTime.unboxToBoolean(v));
        } else if (ScalaRunTime$.MODULE$.isArray(object, 1)) {
            Object x = object;
            Arrays.fill((Object[])x, offset, offset + length, v);
        } else {
            throw new MatchError(object);
        }
    }

    public <V> Object copyOf(Object a, int length) {
        Object[] objectArray;
        Object object = a;
        if (object instanceof double[]) {
            double[] x = (double[])object;
            objectArray = Arrays.copyOf(x, length);
        } else if (object instanceof int[]) {
            int[] x = (int[])object;
            objectArray = Arrays.copyOf(x, length);
        } else if (object instanceof float[]) {
            float[] x = (float[])object;
            objectArray = Arrays.copyOf(x, length);
        } else if (object instanceof long[]) {
            long[] x = (long[])object;
            objectArray = Arrays.copyOf(x, length);
        } else if (object instanceof short[]) {
            short[] x = (short[])object;
            objectArray = Arrays.copyOf(x, length);
        } else if (object instanceof char[]) {
            char[] x = (char[])object;
            objectArray = Arrays.copyOf(x, length);
        } else if (object instanceof byte[]) {
            byte[] x = (byte[])object;
            objectArray = Arrays.copyOf(x, length);
        } else if (object instanceof boolean[]) {
            boolean[] x = (boolean[])object;
            objectArray = Arrays.copyOf(x, length);
        } else if (ScalaRunTime$.MODULE$.isArray(object, 1)) {
            Object x = object;
            objectArray = Arrays.copyOf((Object[])x, length);
        } else {
            throw new MatchError(object);
        }
        return objectArray;
    }

    public <V, VU> Object copyOfRange(Object a, int from, int to) {
        Object[] objectArray;
        Object object = a;
        if (object instanceof double[]) {
            double[] x = (double[])object;
            objectArray = Arrays.copyOfRange(x, from, to);
        } else if (object instanceof int[]) {
            int[] x = (int[])object;
            objectArray = Arrays.copyOfRange(x, from, to);
        } else if (object instanceof float[]) {
            float[] x = (float[])object;
            objectArray = Arrays.copyOfRange(x, from, to);
        } else if (object instanceof long[]) {
            long[] x = (long[])object;
            objectArray = Arrays.copyOfRange(x, from, to);
        } else if (object instanceof short[]) {
            short[] x = (short[])object;
            objectArray = Arrays.copyOfRange(x, from, to);
        } else if (object instanceof char[]) {
            char[] x = (char[])object;
            objectArray = Arrays.copyOfRange(x, from, to);
        } else if (object instanceof byte[]) {
            byte[] x = (byte[])object;
            objectArray = Arrays.copyOfRange(x, from, to);
        } else if (object instanceof boolean[]) {
            boolean[] x = (boolean[])object;
            objectArray = Arrays.copyOfRange(x, from, to);
        } else if (ScalaRunTime$.MODULE$.isArray(object, 1)) {
            Object x = object;
            objectArray = Arrays.copyOfRange((Object[])x, from, to);
        } else {
            throw new MatchError(object);
        }
        return objectArray;
    }

    public <V> Object newArrayLike(Object a, int length) {
        Object object;
        Object object2 = a;
        if (object2 instanceof double[]) {
            double[] x = (double[])object2;
            object = new double[length];
        } else if (object2 instanceof int[]) {
            int[] x = (int[])object2;
            object = new int[length];
        } else if (object2 instanceof float[]) {
            float[] x = (float[])object2;
            object = new float[length];
        } else if (object2 instanceof long[]) {
            long[] x = (long[])object2;
            object = new long[length];
        } else if (object2 instanceof short[]) {
            short[] x = (short[])object2;
            object = new short[length];
        } else if (object2 instanceof char[]) {
            char[] x = (char[])object2;
            object = new char[length];
        } else if (object2 instanceof byte[]) {
            byte[] x = (byte[])object2;
            object = new byte[length];
        } else if (object2 instanceof boolean[]) {
            boolean[] x = (boolean[])object2;
            object = new boolean[length];
        } else if (ScalaRunTime$.MODULE$.isArray(object2, 1)) {
            Object x = object2;
            ClassTag man = ReflectionUtil$.MODULE$.elemClassTagFromArray(a);
            object = Arrays$.MODULE$.newGenericArray(length, man);
        } else {
            throw new MatchError(object2);
        }
        return object;
    }

    public <V> Object fillNewArrayLike(Object a, int length, V fill) {
        Object arr = this.newArrayLike(a, length);
        this.fill(arr, 0, length, fill);
        return arr;
    }

    public <V> Object fillNewArray(int length, V fill, ClassTag<V> evidence$1) {
        Object arr = Arrays$.MODULE$.newGenericArray(length, evidence$1);
        this.fill(arr, 0, length, fill);
        return arr;
    }

    public <V> void sort(Object a) {
        Object object = a;
        if (object instanceof double[]) {
            double[] x = (double[])object;
            Arrays.sort(x);
        } else if (object instanceof int[]) {
            int[] x = (int[])object;
            Arrays.sort(x);
        } else if (object instanceof float[]) {
            float[] x = (float[])object;
            Arrays.sort(x);
        } else if (object instanceof long[]) {
            long[] x = (long[])object;
            Arrays.sort(x);
        } else if (object instanceof short[]) {
            short[] x = (short[])object;
            Arrays.sort(x);
        } else if (object instanceof char[]) {
            char[] x = (char[])object;
            Arrays.sort(x);
        } else if (object instanceof byte[]) {
            byte[] x = (byte[])object;
            Arrays.sort(x);
        } else if (ScalaRunTime$.MODULE$.isArray(object, 1)) {
            Object x = object;
            Arrays.sort((Object[])x);
        } else {
            throw new MatchError(object);
        }
    }

    public boolean nonstupidEquals(Object a, int aoffset, int astride, int alength, Object b, int boffset, int bstride, int blength) {
        boolean bl;
        Class<?> ac = a.getClass();
        Class<?> bc = b.getClass();
        Class<?> clazz = ac;
        Class<?> clazz2 = bc;
        if ((clazz != null ? !clazz.equals(clazz2) : clazz2 != null) || alength != blength) {
            bl = false;
        } else {
            Object object = a;
            if (object instanceof double[]) {
                double[] x = (double[])object;
                bl = this.nonstupidEquals_Double(x, aoffset, astride, alength, (double[])b, boffset, bstride);
            } else if (object instanceof float[]) {
                float[] x = (float[])object;
                bl = this.nonstupidEquals_Float(x, aoffset, astride, alength, (float[])b, boffset, bstride);
            } else {
                bl = this.equals(a, aoffset, astride, alength, b, boffset, bstride, blength);
            }
        }
        return bl;
    }

    private boolean nonstupidEquals_Double(double[] a, int aoffset, int astride, int alength, double[] b, int boffset, int bstride) {
        int ai = aoffset;
        int bi = boffset;
        int i = 0;
        int yy = alength;
        while (i < alength) {
            int n = i++;
            if (a[ai] != b[bi]) {
                return false;
            }
            ai += astride;
            bi += bstride;
        }
        return true;
    }

    private boolean nonstupidEquals_Float(float[] a, int aoffset, int astride, int alength, float[] b, int boffset, int bstride) {
        int ai = aoffset;
        int bi = boffset;
        int i = 0;
        int yy = alength;
        while (i < alength) {
            int n = i++;
            if (a[ai] != b[bi]) {
                return false;
            }
            ai += astride;
            bi += bstride;
        }
        return true;
    }

    public boolean equals(Object a, Object b) {
        boolean bl;
        Class<?> ac = a.getClass();
        Class<?> bc = b.getClass();
        Class<?> clazz = ac;
        Class<?> clazz2 = bc;
        if (clazz == null ? clazz2 != null : !clazz.equals(clazz2)) {
            bl = false;
        } else {
            Object object = a;
            if (object instanceof double[]) {
                double[] x = (double[])object;
                bl = Arrays.equals((double[])a, (double[])b);
            } else if (object instanceof int[]) {
                int[] x = (int[])object;
                bl = Arrays.equals((int[])a, (int[])b);
            } else if (object instanceof float[]) {
                float[] x = (float[])object;
                bl = Arrays.equals((float[])a, (float[])b);
            } else if (object instanceof boolean[]) {
                boolean[] x = (boolean[])object;
                bl = Arrays.equals((boolean[])a, (boolean[])b);
            } else if (object instanceof long[]) {
                long[] x = (long[])object;
                bl = Arrays.equals((long[])a, (long[])b);
            } else if (object instanceof short[]) {
                short[] x = (short[])object;
                bl = Arrays.equals((short[])a, (short[])b);
            } else if (object instanceof char[]) {
                char[] x = (char[])object;
                bl = Arrays.equals((char[])a, (char[])b);
            } else if (object instanceof byte[]) {
                byte[] x = (byte[])object;
                bl = Arrays.equals((byte[])a, (byte[])b);
            } else if (ScalaRunTime$.MODULE$.isArray(object, 1)) {
                Object x = object;
                bl = Arrays.equals((Object[])a, (Object[])b);
            } else {
                throw new MatchError(object);
            }
        }
        return bl;
    }

    public boolean equals(Object a, int aoffset, int astride, int alength, Object b, int boffset, int bstride, int blength) {
        boolean bl;
        Class<?> ac = a.getClass();
        Class<?> bc = b.getClass();
        Class<?> clazz = ac;
        Class<?> clazz2 = bc;
        if ((clazz != null ? !clazz.equals(clazz2) : clazz2 != null) || alength != blength) {
            bl = false;
        } else if (aoffset == 0 && astride == 1 && alength == ScalaRunTime$.MODULE$.array_length(a) && boffset == 0 && bstride == 1 && blength == ScalaRunTime$.MODULE$.array_length(b)) {
            bl = this.equals(a, b);
        } else {
            Object object = a;
            if (object instanceof double[]) {
                double[] x = (double[])object;
                double[] y = (double[])b;
                int ai = aoffset;
                int bi = boffset;
                for (int i = 0; i < alength; ++i) {
                    if (x[ai] != y[bi]) {
                        return false;
                    }
                    ai += astride;
                    bi += bstride;
                }
                bl = true;
            } else if (object instanceof int[]) {
                int[] x = (int[])object;
                int[] y = (int[])b;
                int ai = aoffset;
                int bi = boffset;
                for (int i = 0; i < alength; ++i) {
                    if (x[ai] != y[bi]) {
                        return false;
                    }
                    ai += astride;
                    bi += bstride;
                }
                bl = true;
            } else if (object instanceof float[]) {
                float[] x = (float[])object;
                float[] y = (float[])b;
                int ai = aoffset;
                int bi = boffset;
                for (int i = 0; i < alength; ++i) {
                    if (x[ai] != y[bi]) {
                        return false;
                    }
                    ai += astride;
                    bi += bstride;
                }
                bl = true;
            } else if (object instanceof long[]) {
                long[] x = (long[])object;
                long[] y = (long[])b;
                int ai = aoffset;
                int bi = boffset;
                for (int i = 0; i < alength; ++i) {
                    if (x[ai] != y[bi]) {
                        return false;
                    }
                    ai += astride;
                    bi += bstride;
                }
                bl = true;
            } else if (object instanceof short[]) {
                short[] x = (short[])object;
                short[] y = (short[])b;
                int ai = aoffset;
                int bi = boffset;
                for (int i = 0; i < alength; ++i) {
                    if (x[ai] != y[bi]) {
                        return false;
                    }
                    ai += astride;
                    bi += bstride;
                }
                bl = true;
            } else if (object instanceof char[]) {
                char[] x = (char[])object;
                char[] y = (char[])b;
                int ai = aoffset;
                int bi = boffset;
                for (int i = 0; i < alength; ++i) {
                    if (x[ai] != y[bi]) {
                        return false;
                    }
                    ai += astride;
                    bi += bstride;
                }
                bl = true;
            } else if (object instanceof byte[]) {
                byte[] x = (byte[])object;
                byte[] y = (byte[])b;
                int ai = aoffset;
                int bi = boffset;
                for (int i = 0; i < alength; ++i) {
                    if (x[ai] != y[bi]) {
                        return false;
                    }
                    ai += astride;
                    bi += bstride;
                }
                bl = true;
            } else if (object instanceof boolean[]) {
                boolean[] x = (boolean[])object;
                boolean[] y = (boolean[])b;
                int ai = aoffset;
                int bi = boffset;
                for (int i = 0; i < alength; ++i) {
                    if (x[ai] != y[bi]) {
                        return false;
                    }
                    ai += astride;
                    bi += bstride;
                }
                bl = true;
            } else if (ScalaRunTime$.MODULE$.isArray(object, 1)) {
                Object x = object;
                Object[] y = (Object[])b;
                int ai = aoffset;
                int bi = boffset;
                for (int i = 0; i < alength; ++i) {
                    if (!BoxesRunTime.equals((Object)ScalaRunTime$.MODULE$.array_apply(x, ai), (Object)y[bi])) {
                        return false;
                    }
                    ai += astride;
                    bi += bstride;
                }
                bl = true;
            } else {
                throw new MatchError(object);
            }
        }
        return bl;
    }

    public int gallopSearch(int[] objs, int fromIndex, int toIndex, int toFind) {
        if (objs.length == 0) {
            return -1;
        }
        int low = fromIndex;
        int step = 1;
        int high = fromIndex + step;
        while (high < toIndex && objs[high] < toFind) {
            low = high;
            high = fromIndex + (step *= 2);
        }
        return high < toIndex && objs[high] == toFind ? high : Arrays.binarySearch(objs, low, package$.MODULE$.min(high, toIndex), toFind);
    }

    public <V> int zeroSkippingHashCode(Object data, int offset, int stride, int length) {
        int n;
        Object object = data;
        if (object instanceof double[]) {
            double[] x = (double[])object;
            n = this.zeroSkippingHashCodeImpl_Double(x, offset, stride, length);
        } else if (object instanceof float[]) {
            float[] x = (float[])object;
            n = this.zeroSkippingHashCodeImpl_Float(x, offset, stride, length);
        } else if (object instanceof int[]) {
            int[] x = (int[])object;
            n = this.zeroSkippingHashCodeImpl_Int(x, offset, stride, length);
        } else if (object instanceof long[]) {
            long[] x = (long[])object;
            n = this.zeroSkippingHashCodeImpl_Long(x, offset, stride, length);
        } else if (object instanceof short[]) {
            short[] x = (short[])object;
            n = this.zeroSkippingHashCodeImpl_Short(x, offset, stride, length);
        } else if (object instanceof byte[]) {
            byte[] x = (byte[])object;
            n = this.zeroSkippingHashCodeImpl_Byte(x, offset, stride, length);
        } else if (object instanceof char[]) {
            char[] x = (char[])object;
            n = this.zeroSkippingHashCodeImpl_Char(x, offset, stride, length);
        } else if (object instanceof boolean[]) {
            boolean[] x = (boolean[])object;
            n = this.zeroSkippingHashCodeImpl_Boolean(x, offset, stride, length);
        } else {
            n = this.zeroSkippingHashCodeImplSlow(data, offset, stride, length);
        }
        return n;
    }

    private int zeroSkippingHashCodeImpl_Int(int[] data, int offset, int stride, int length) {
        int hash = 43;
        int i = offset;
        int yy = length;
        for (int i2 = 0; i2 < length; ++i2) {
            int n = i2;
            int v = data[i];
            int hh = Statics.anyHash((Object)BoxesRunTime.boxToInteger((int)v));
            if (hh != 0) {
                hash = MurmurHash3$.MODULE$.mix(hash, hh);
            }
            i += stride;
        }
        return hash;
    }

    private int zeroSkippingHashCodeImpl_Float(float[] data, int offset, int stride, int length) {
        int hash = 43;
        int i = offset;
        int yy = length;
        for (int i2 = 0; i2 < length; ++i2) {
            int n = i2;
            float v = data[i];
            int hh = Statics.floatHash((float)v);
            if (hh != 0) {
                hash = MurmurHash3$.MODULE$.mix(hash, hh);
            }
            i += stride;
        }
        return hash;
    }

    private int zeroSkippingHashCodeImpl_Double(double[] data, int offset, int stride, int length) {
        int hash = 43;
        int i = offset;
        int yy = length;
        for (int i2 = 0; i2 < length; ++i2) {
            int n = i2;
            double v = data[i];
            int hh = Statics.doubleHash((double)v);
            if (hh != 0) {
                hash = MurmurHash3$.MODULE$.mix(hash, hh);
            }
            i += stride;
        }
        return hash;
    }

    private int zeroSkippingHashCodeImpl_Long(long[] data, int offset, int stride, int length) {
        int hash = 43;
        int i = offset;
        int yy = length;
        for (int i2 = 0; i2 < length; ++i2) {
            int n = i2;
            long v = data[i];
            int hh = Statics.longHash((long)v);
            if (hh != 0) {
                hash = MurmurHash3$.MODULE$.mix(hash, hh);
            }
            i += stride;
        }
        return hash;
    }

    private int zeroSkippingHashCodeImpl_Byte(byte[] data, int offset, int stride, int length) {
        int hash = 43;
        int i = offset;
        int yy = length;
        for (int i2 = 0; i2 < length; ++i2) {
            int n = i2;
            byte v = data[i];
            int hh = Statics.anyHash((Object)BoxesRunTime.boxToByte((byte)v));
            if (hh != 0) {
                hash = MurmurHash3$.MODULE$.mix(hash, hh);
            }
            i += stride;
        }
        return hash;
    }

    private int zeroSkippingHashCodeImpl_Short(short[] data, int offset, int stride, int length) {
        int hash = 43;
        int i = offset;
        int yy = length;
        for (int i2 = 0; i2 < length; ++i2) {
            int n = i2;
            short v = data[i];
            int hh = Statics.anyHash((Object)BoxesRunTime.boxToShort((short)v));
            if (hh != 0) {
                hash = MurmurHash3$.MODULE$.mix(hash, hh);
            }
            i += stride;
        }
        return hash;
    }

    private int zeroSkippingHashCodeImpl_Char(char[] data, int offset, int stride, int length) {
        int hash = 43;
        int i = offset;
        int yy = length;
        for (int i2 = 0; i2 < length; ++i2) {
            int n = i2;
            char v = data[i];
            int hh = Statics.anyHash((Object)BoxesRunTime.boxToCharacter((char)v));
            if (hh != 0) {
                hash = MurmurHash3$.MODULE$.mix(hash, hh);
            }
            i += stride;
        }
        return hash;
    }

    private int zeroSkippingHashCodeImpl_Boolean(boolean[] data, int offset, int stride, int length) {
        int hash = 43;
        int i = offset;
        int yy = length;
        for (int i2 = 0; i2 < length; ++i2) {
            int n = i2;
            boolean v = data[i];
            int hh = Statics.anyHash((Object)BoxesRunTime.boxToBoolean((boolean)v));
            if (hh != 0) {
                hash = MurmurHash3$.MODULE$.mix(hash, hh);
            }
            i += stride;
        }
        return hash;
    }

    private <V> int zeroSkippingHashCodeImplSlow(Object data, int offset, int stride, int length) {
        int hash = 43;
        int i = offset;
        int yy = length;
        for (int i2 = 0; i2 < length; ++i2) {
            int n = i2;
            Object v = ScalaRunTime$.MODULE$.array_apply(data, i);
            int hh = Statics.anyHash((Object)v);
            if (hh != 0) {
                hash = MurmurHash3$.MODULE$.mix(hash, hh);
            }
            i += stride;
        }
        return hash;
    }

    public int[] range(int start, int end, int stride) {
        int length = (end - start + stride - 1) / stride;
        if (length <= 0) {
            return new int[0];
        }
        int[] result = new int[length];
        int x = start;
        int i = 0;
        int yy = length;
        while (i < length) {
            int n = i++;
            result[n] = x;
            x += stride;
        }
        return result;
    }

    public int range$default$3() {
        return 1;
    }
}

