/*
 * Decompiled with CFR 0.152.
 */
package breeze.util;

import breeze.util.BloomFilter$;
import breeze.util.package$;
import breeze.util.package$AwesomeBitSet$;
import java.io.Serializable;
import java.util.BitSet;
import scala.Function1;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.IndexedSeq;
import scala.runtime.RichInt$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction1;

public class BloomFilter<T>
implements Function1<T, Object>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final int numBuckets;
    private final int numHashFunctions;
    private final BitSet bits;

    public static Tuple2<Object, Object> optimalSize(double d, double d2) {
        return BloomFilter$.MODULE$.optimalSize(d, d2);
    }

    public static <T> BloomFilter<T> optimallySized(double d, double d2) {
        return BloomFilter$.MODULE$.optimallySized(d, d2);
    }

    public BloomFilter(int numBuckets, int numHashFunctions, BitSet bits) {
        this.numBuckets = numBuckets;
        this.numHashFunctions = numHashFunctions;
        this.bits = bits;
    }

    public int numBuckets() {
        return this.numBuckets;
    }

    public int numHashFunctions() {
        return this.numHashFunctions;
    }

    public BitSet bits() {
        return this.bits;
    }

    public BloomFilter(int numBuckets, int numHashFunctions) {
        this(numBuckets, numHashFunctions, new BitSet(numBuckets));
    }

    public BloomFilter(int numBuckets) {
        this(numBuckets, 3);
    }

    private IndexedSeq<Object> activeBuckets(T key) {
        int baseHash = Statics.anyHash(key);
        int hash1 = baseHash & 0xFFFF;
        int hash2 = baseHash >> 16;
        return RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), this.numHashFunctions()).map((Function1)(JFunction1.mcII.sp & Serializable)i -> {
            int h = (hash1 + i * hash2) % this.numBuckets();
            return h < 0 ? ~h : h;
        });
    }

    public boolean apply(T o) {
        return this.activeBuckets(o).forall((Function1)(JFunction1.mcZI.sp & Serializable)i -> this.bits().get(i));
    }

    public boolean contains(T o) {
        return this.apply(o);
    }

    public double load() {
        return (double)this.bits().cardinality() / (double)this.numBuckets();
    }

    public int hashCode() {
        return this.bits().hashCode();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object other) {
        Object object = other;
        if (!(object instanceof BloomFilter)) return false;
        BloomFilter that = (BloomFilter)object;
        if (this.numBuckets() != that.numBuckets()) return false;
        if (this.numHashFunctions() != that.numHashFunctions()) return false;
        BitSet bitSet = this.bits();
        BitSet bitSet2 = that.bits();
        if (bitSet != null) {
            if (!((Object)bitSet).equals(bitSet2)) return false;
            return true;
        }
        if (bitSet2 == null) return true;
        return false;
    }

    public BloomFilter $plus$eq(T o) {
        this.activeBuckets(o).foreach((Function1)(JFunction1.mcVI.sp & Serializable)i -> this.bits().set(i));
        return this;
    }

    public BloomFilter<T> $amp(BloomFilter<T> that) {
        this.checkCompatibility(that);
        return new BloomFilter<T>(this.numBuckets(), this.numHashFunctions(), package$AwesomeBitSet$.MODULE$.$amp$extension(package$.MODULE$.AwesomeBitSet(this.bits()), that.bits()));
    }

    private void checkCompatibility(BloomFilter<T> that) {
        Predef$.MODULE$.require(that.numBuckets() == this.numBuckets(), BloomFilter::checkCompatibility$$anonfun$1);
        Predef$.MODULE$.require(that.numHashFunctions() == this.numHashFunctions(), BloomFilter::checkCompatibility$$anonfun$2);
    }

    public BloomFilter<T> $bar(BloomFilter<T> that) {
        this.checkCompatibility(that);
        return new BloomFilter<T>(this.numBuckets(), this.numHashFunctions(), package$AwesomeBitSet$.MODULE$.$bar$extension(package$.MODULE$.AwesomeBitSet(this.bits()), that.bits()));
    }

    public BloomFilter $bar$eq(BloomFilter<T> that) {
        this.checkCompatibility(that);
        package$AwesomeBitSet$.MODULE$.$bar$eq$extension(package$.MODULE$.AwesomeBitSet(this.bits()), that.bits());
        return this;
    }

    public BloomFilter $amp$eq(BloomFilter<T> that) {
        this.checkCompatibility(that);
        package$AwesomeBitSet$.MODULE$.$amp$eq$extension(package$.MODULE$.AwesomeBitSet(this.bits()), that.bits());
        return this;
    }

    public BloomFilter $amp$tilde$eq(BloomFilter<T> that) {
        this.checkCompatibility(that);
        package$AwesomeBitSet$.MODULE$.$amp$tilde$eq$extension(package$.MODULE$.AwesomeBitSet(this.bits()), that.bits());
        return this;
    }

    public BloomFilter<T> $amp$tilde(BloomFilter<T> that) {
        this.checkCompatibility(that);
        return new BloomFilter<T>(this.numBuckets(), this.numHashFunctions(), package$AwesomeBitSet$.MODULE$.$amp$tilde$extension(package$.MODULE$.AwesomeBitSet(this.bits()), that.bits()));
    }

    private static final String checkCompatibility$$anonfun$1() {
        return "Must have the same number of buckets to intersect";
    }

    private static final String checkCompatibility$$anonfun$2() {
        return "Must have the same number of hash functions to intersect";
    }
}

