/*
 * Decompiled with CFR 0.152.
 */
package org.scalatest.enablers;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.scalactic.Every;
import org.scalatest.Entry;
import org.scalatest.enablers.Collecting;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.GenTraversable;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.immutable.StringOps;
import scala.runtime.ScalaRunTime$;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Collecting$ {
    public static final Collecting$ MODULE$;

    static {
        new Collecting$();
    }

    public <E, TRAV extends GenTraversable<Object>> Collecting<E, TRAV> collectingNatureOfGenTraversable() {
        return new Collecting<E, TRAV>(){

            public Option<E> loneElementOf(TRAV trav) {
                return trav.size() == 1 ? new Some(trav.head()) : None$.MODULE$;
            }

            public int sizeOf(TRAV trav) {
                return trav.size();
            }

            public GenTraversable<E> genTraversableFrom(TRAV collection) {
                return collection;
            }
        };
    }

    public <E> Collecting<E, Object> collectingNatureOfArray() {
        return new Collecting<E, Object>(){

            public Option<E> loneElementOf(Object array) {
                return Predef$.MODULE$.genericArrayOps(array).size() == 1 ? new Some(Predef$.MODULE$.genericArrayOps(array).head()) : None$.MODULE$;
            }

            public int sizeOf(Object array) {
                return ScalaRunTime$.MODULE$.array_length(array);
            }

            public GenTraversable<E> genTraversableFrom(Object collection) {
                return Predef$.MODULE$.genericWrapArray(collection);
            }
        };
    }

    public Collecting<Object, String> collectingNatureOfString() {
        return new Collecting<Object, String>(){

            public Option<Object> loneElementOf(String string) {
                return new StringOps(Predef$.MODULE$.augmentString(string)).size() == 1 ? new Some(new StringOps(Predef$.MODULE$.augmentString(string)).head()) : None$.MODULE$;
            }

            public int sizeOf(String string) {
                return string.length();
            }

            public GenTraversable<Object> genTraversableFrom(String collection) {
                return new StringOps(Predef$.MODULE$.augmentString(collection)).toVector();
            }
        };
    }

    public <E, JCOL extends Collection<Object>> Collecting<E, JCOL> collectingNatureOfJavaCollection() {
        return new Collecting<E, JCOL>(){

            public Option<E> loneElementOf(JCOL coll) {
                return coll.size() == 1 ? new Some(coll.iterator().next()) : None$.MODULE$;
            }

            public int sizeOf(JCOL coll) {
                return coll.size();
            }

            public GenTraversable<E> genTraversableFrom(JCOL collection) {
                GenTraversable genTraversable;
                JCOL JCOL = collection;
                if (JCOL instanceof List) {
                    JCOL JCOL2 = JCOL;
                    genTraversable = (GenTraversable)JavaConverters$.MODULE$.asScalaBufferConverter((List)JCOL2).asScala();
                } else if (JCOL instanceof Set) {
                    JCOL JCOL3 = JCOL;
                    genTraversable = (GenTraversable)JavaConverters$.MODULE$.asScalaSetConverter((Set)JCOL3).asScala();
                } else {
                    genTraversable = (GenTraversable)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(collection).asScala();
                }
                return genTraversable;
            }
        };
    }

    public <K, V, JMAP extends Map<Object, Object>> Collecting<Entry<K, V>, JMAP> collectingNatureOfJavaMap() {
        return new Collecting<Entry<K, V>, JMAP>(){

            public Option<Entry<K, V>> loneElementOf(JMAP jmap) {
                None$ none$;
                if (jmap.size() == 1) {
                    Map.Entry<K, V> loneEntry = jmap.entrySet().iterator().next();
                    none$ = new Some(new Entry<K, V>(loneEntry.getKey(), loneEntry.getValue()));
                } else {
                    none$ = None$.MODULE$;
                }
                return none$;
            }

            public int sizeOf(JMAP jmap) {
                return jmap.size();
            }

            public GenTraversable<Entry<K, V>> genTraversableFrom(JMAP collection) {
                return ((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(collection.entrySet().iterator()).asScala()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Entry<K, V> apply(Map.Entry<K, V> entry) {
                        return new Entry<K, V>(entry.getKey(), entry.getValue());
                    }
                }).toList();
            }
        };
    }

    public <E, EVERY extends Every<Object>> Collecting<E, EVERY> collectingNatureOfEvery() {
        return new Collecting<E, EVERY>(){

            public Option<E> loneElementOf(EVERY every) {
                return ((Every)every).size() == 1 ? new Some(((Every)every).head()) : None$.MODULE$;
            }

            public int sizeOf(EVERY every) {
                return ((Every)every).size();
            }

            public GenTraversable<E> genTraversableFrom(EVERY collection) {
                return ((Every)collection).toVector();
            }
        };
    }

    private Collecting$() {
        MODULE$ = this;
    }
}

