/*
 * Decompiled with CFR 0.152.
 */
package org.scalatest;

import java.io.Serializable;
import org.scalatest.Args;
import org.scalatest.Args$;
import org.scalatest.ConfigMap;
import org.scalatest.Distributor;
import org.scalatest.Filter;
import org.scalatest.Reporter;
import org.scalatest.Rerunner;
import org.scalatest.Resources$;
import org.scalatest.Stopper;
import org.scalatest.Suite;
import org.scalatest.Tracker;
import org.scalatest.events.RunAborted;
import org.scalatest.events.RunAborted$;
import org.scalatest.events.RunCompleted;
import org.scalatest.events.RunCompleted$;
import org.scalatest.events.RunStarting;
import org.scalatest.events.RunStarting$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.Set;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001i3Q!\u0001\u0002\u0001\u0005\u0019\u0011A\u0002V3tiJ+'/\u001e8oKJT!a\u0001\u0003\u0002\u0013M\u001c\u0017\r\\1uKN$(\"A\u0003\u0002\u0007=\u0014xm\u0005\u0003\u0001\u000f5\t\u0002C\u0001\u0005\f\u001b\u0005I!\"\u0001\u0006\u0002\u000bM\u001c\u0017\r\\1\n\u00051I!AB!osJ+g\r\u0005\u0002\u000f\u001f5\t!!\u0003\u0002\u0011\u0005\tA!+\u001a:v]:,'\u000f\u0005\u0002\u0013/5\t1C\u0003\u0002\u0015+\u0005\u0011\u0011n\u001c\u0006\u0002-\u0005!!.\u0019<b\u0013\tA2C\u0001\u0007TKJL\u0017\r\\5{C\ndW\r\u0003\u0005\u001b\u0001\t\u0005\t\u0015!\u0003\u001d\u00039\u0019X/\u001b;f\u00072\f7o\u001d(b[\u0016\u001c\u0001\u0001\u0005\u0002\u001eA9\u0011\u0001BH\u0005\u0003?%\ta\u0001\u0015:fI\u00164\u0017BA\u0011#\u0005\u0019\u0019FO]5oO*\u0011q$\u0003\u0005\tI\u0001\u0011\t\u0011)A\u00059\u0005AA/Z:u\u001d\u0006lW\rC\u0003'\u0001\u0011\u0005q%\u0001\u0004=S:LGO\u0010\u000b\u0004Q%R\u0003C\u0001\b\u0001\u0011\u0015QR\u00051\u0001\u001d\u0011\u0015!S\u00051\u0001\u001d\u0011\u0015a\u0003\u0001\"\u0001.\u0003\u0015\t\u0007\u000f\u001d7z)!q\u0013GN\u001eA\u000b6\u0013\u0006C\u0001\u00050\u0013\t\u0001\u0014B\u0001\u0003V]&$\b\"\u0002\u001a,\u0001\u0004\u0019\u0014A\u0002:fa>\u0014H\u000f\u0005\u0002\u000fi%\u0011QG\u0001\u0002\t%\u0016\u0004xN\u001d;fe\")qg\u000ba\u0001q\u000591\u000f^8qa\u0016\u0014\bC\u0001\b:\u0013\tQ$AA\u0004Ti>\u0004\b/\u001a:\t\u000bqZ\u0003\u0019A\u001f\u0002\r\u0019LG\u000e^3s!\tqa(\u0003\u0002@\u0005\t1a)\u001b7uKJDQ!Q\u0016A\u0002\t\u000b\u0011bY8oM&<W*\u00199\u0011\u00059\u0019\u0015B\u0001#\u0003\u0005%\u0019uN\u001c4jO6\u000b\u0007\u000fC\u0003GW\u0001\u0007q)A\u0006eSN$(/\u001b2vi>\u0014\bc\u0001\u0005I\u0015&\u0011\u0011*\u0003\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u00059Y\u0015B\u0001'\u0003\u0005-!\u0015n\u001d;sS\n,Ho\u001c:\t\u000b9[\u0003\u0019A(\u0002\u000fQ\u0014\u0018mY6feB\u0011a\u0002U\u0005\u0003#\n\u0011q\u0001\u0016:bG.,'\u000fC\u0003TW\u0001\u0007A+\u0001\u0004m_\u0006$WM\u001d\t\u0003+bk\u0011A\u0016\u0006\u0003/V\tA\u0001\\1oO&\u0011\u0011L\u0016\u0002\f\u00072\f7o\u001d'pC\u0012,'\u000f")
public class TestRerunner
implements Rerunner,
Serializable {
    private final String suiteClassName;
    private final String testName;

    @Override
    public void apply(Reporter report, Stopper stopper, Filter filter2, ConfigMap configMap, Option<Distributor> distributor, Tracker tracker, ClassLoader loader) {
        long runStartTime = System.currentTimeMillis();
        try {
            Class<?> suiteClass = loader.loadClass(this.suiteClassName);
            Suite suite = (Suite)suiteClass.newInstance();
            report.apply(new RunStarting(tracker.nextOrdinal(), 1, configMap, RunStarting$.MODULE$.apply$default$4(), RunStarting$.MODULE$.apply$default$5(), RunStarting$.MODULE$.apply$default$6(), RunStarting$.MODULE$.apply$default$7(), RunStarting$.MODULE$.apply$default$8()));
            suite.run((Option<String>)new Some((Object)this.testName), new Args(report, stopper, filter2, configMap, distributor, tracker, (Set<String>)Predef$.MODULE$.Set().empty(), Args$.MODULE$.apply$default$8(), Args$.MODULE$.apply$default$9(), Args$.MODULE$.apply$default$10()));
            long duration = System.currentTimeMillis() - runStartTime;
            report.apply(new RunCompleted(tracker.nextOrdinal(), (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)duration)), RunCompleted$.MODULE$.apply$default$3(), RunCompleted$.MODULE$.apply$default$4(), RunCompleted$.MODULE$.apply$default$5(), RunCompleted$.MODULE$.apply$default$6(), RunCompleted$.MODULE$.apply$default$7(), RunCompleted$.MODULE$.apply$default$8()));
        }
        catch (Throwable throwable) {
            long duration = System.currentTimeMillis() - runStartTime;
            report.apply(new RunAborted(tracker.nextOrdinal(), Resources$.MODULE$.bigProblems(throwable), (Option<Throwable>)new Some((Object)throwable), (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)duration)), RunAborted$.MODULE$.apply$default$5(), RunAborted$.MODULE$.apply$default$6(), RunAborted$.MODULE$.apply$default$7(), RunAborted$.MODULE$.apply$default$8(), RunAborted$.MODULE$.apply$default$9(), RunAborted$.MODULE$.apply$default$10()));
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            long duration = System.currentTimeMillis() - runStartTime;
            report.apply(new RunAborted(tracker.nextOrdinal(), Resources$.MODULE$.apply("cannotLoadClass", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{noClassDefFoundError.getMessage()})), (Option<Throwable>)new Some((Object)noClassDefFoundError), (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)duration)), RunAborted$.MODULE$.apply$default$5(), RunAborted$.MODULE$.apply$default$6(), RunAborted$.MODULE$.apply$default$7(), RunAborted$.MODULE$.apply$default$8(), RunAborted$.MODULE$.apply$default$9(), RunAborted$.MODULE$.apply$default$10()));
        }
        catch (SecurityException securityException) {
            long duration = System.currentTimeMillis() - runStartTime;
            report.apply(new RunAborted(tracker.nextOrdinal(), Resources$.MODULE$.apply("securityWhenRerruning", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{securityException.getMessage()})), (Option<Throwable>)new Some((Object)securityException), (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)duration)), RunAborted$.MODULE$.apply$default$5(), RunAborted$.MODULE$.apply$default$6(), RunAborted$.MODULE$.apply$default$7(), RunAborted$.MODULE$.apply$default$8(), RunAborted$.MODULE$.apply$default$9(), RunAborted$.MODULE$.apply$default$10()));
        }
        catch (NoSuchMethodException noSuchMethodException) {
            long duration = System.currentTimeMillis() - runStartTime;
            report.apply(new RunAborted(tracker.nextOrdinal(), Resources$.MODULE$.apply("cannotFindMethod", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{noSuchMethodException.getMessage()})), (Option<Throwable>)new Some((Object)noSuchMethodException), (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)duration)), RunAborted$.MODULE$.apply$default$5(), RunAborted$.MODULE$.apply$default$6(), RunAborted$.MODULE$.apply$default$7(), RunAborted$.MODULE$.apply$default$8(), RunAborted$.MODULE$.apply$default$9(), RunAborted$.MODULE$.apply$default$10()));
        }
        catch (IllegalAccessException illegalAccessException) {
            long duration = System.currentTimeMillis() - runStartTime;
            report.apply(new RunAborted(tracker.nextOrdinal(), Resources$.MODULE$.apply("cannotInstantiateSuite", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{illegalAccessException.getMessage()})), (Option<Throwable>)new Some((Object)illegalAccessException), (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)duration)), RunAborted$.MODULE$.apply$default$5(), RunAborted$.MODULE$.apply$default$6(), RunAborted$.MODULE$.apply$default$7(), RunAborted$.MODULE$.apply$default$8(), RunAborted$.MODULE$.apply$default$9(), RunAborted$.MODULE$.apply$default$10()));
        }
        catch (InstantiationException instantiationException) {
            long duration = System.currentTimeMillis() - runStartTime;
            report.apply(new RunAborted(tracker.nextOrdinal(), Resources$.MODULE$.apply("cannotInstantiateSuite", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{instantiationException.getMessage()})), (Option<Throwable>)new Some((Object)instantiationException), (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)duration)), RunAborted$.MODULE$.apply$default$5(), RunAborted$.MODULE$.apply$default$6(), RunAborted$.MODULE$.apply$default$7(), RunAborted$.MODULE$.apply$default$8(), RunAborted$.MODULE$.apply$default$9(), RunAborted$.MODULE$.apply$default$10()));
        }
        catch (ClassNotFoundException classNotFoundException) {
            long duration = System.currentTimeMillis() - runStartTime;
            report.apply(new RunAborted(tracker.nextOrdinal(), Resources$.MODULE$.apply("cannotLoadSuite", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{classNotFoundException.getMessage()})), (Option<Throwable>)new Some((Object)classNotFoundException), (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)duration)), RunAborted$.MODULE$.apply$default$5(), RunAborted$.MODULE$.apply$default$6(), RunAborted$.MODULE$.apply$default$7(), RunAborted$.MODULE$.apply$default$8(), RunAborted$.MODULE$.apply$default$9(), RunAborted$.MODULE$.apply$default$10()));
        }
    }

    public TestRerunner(String suiteClassName, String testName) {
        this.suiteClassName = suiteClassName;
        this.testName = testName;
        if (suiteClassName == null || testName == null) {
            throw new NullPointerException();
        }
    }
}

