/*
 * Decompiled with CFR 0.152.
 */
package org.scalatest.selenium;

import java.io.File;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.openqa.selenium.Cookie;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.Select;
import org.scalatest.exceptions.ModifiableMessage;
import org.scalatest.exceptions.StackDepthException;
import org.scalatest.exceptions.StackDepthExceptionHelper$;
import org.scalatest.exceptions.TestFailedException;
import org.scalatest.selenium.Page;
import org.scalatest.selenium.WebBrowser;
import org.scalatest.selenium.WebBrowser$Element$class;
import org.scalatest.time.Span;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Serializable;
import scala.Some;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Set;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;

public abstract class WebBrowser$class {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isInputField(WebBrowser $this, WebElement webElement2, String name) {
        String string = webElement2.getTagName().toLowerCase();
        String string2 = "input";
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        String string3 = webElement2.getAttribute("type").toLowerCase();
        String string4 = name;
        if (string3 == null) {
            if (string4 == null) return true;
            return false;
        } else {
            if (!string3.equals(string4)) return false;
            return true;
        }
    }

    public static boolean org$scalatest$selenium$WebBrowser$$isTextField(WebBrowser $this, WebElement webElement2) {
        return WebBrowser$class.isInputField($this, webElement2, "text");
    }

    public static boolean org$scalatest$selenium$WebBrowser$$isPasswordField(WebBrowser $this, WebElement webElement2) {
        return WebBrowser$class.isInputField($this, webElement2, "password");
    }

    public static boolean org$scalatest$selenium$WebBrowser$$isCheckBox(WebBrowser $this, WebElement webElement2) {
        return WebBrowser$class.isInputField($this, webElement2, "checkbox");
    }

    public static boolean org$scalatest$selenium$WebBrowser$$isRadioButton(WebBrowser $this, WebElement webElement2) {
        return WebBrowser$class.isInputField($this, webElement2, "radio");
    }

    public static boolean org$scalatest$selenium$WebBrowser$$isEmailField(WebBrowser $this, WebElement webElement2) {
        return WebBrowser$class.isInputField($this, webElement2, "email") || WebBrowser$class.isInputField($this, webElement2, "text");
    }

    public static boolean org$scalatest$selenium$WebBrowser$$isColorField(WebBrowser $this, WebElement webElement2) {
        return WebBrowser$class.isInputField($this, webElement2, "color") || WebBrowser$class.isInputField($this, webElement2, "text");
    }

    public static boolean org$scalatest$selenium$WebBrowser$$isDateField(WebBrowser $this, WebElement webElement2) {
        return WebBrowser$class.isInputField($this, webElement2, "date") || WebBrowser$class.isInputField($this, webElement2, "text");
    }

    public static boolean org$scalatest$selenium$WebBrowser$$isDateTimeField(WebBrowser $this, WebElement webElement2) {
        return WebBrowser$class.isInputField($this, webElement2, "datetime") || WebBrowser$class.isInputField($this, webElement2, "text");
    }

    public static boolean org$scalatest$selenium$WebBrowser$$isDateTimeLocalField(WebBrowser $this, WebElement webElement2) {
        return WebBrowser$class.isInputField($this, webElement2, "datetime-local") || WebBrowser$class.isInputField($this, webElement2, "text");
    }

    public static boolean org$scalatest$selenium$WebBrowser$$isMonthField(WebBrowser $this, WebElement webElement2) {
        return WebBrowser$class.isInputField($this, webElement2, "month") || WebBrowser$class.isInputField($this, webElement2, "text");
    }

    public static boolean org$scalatest$selenium$WebBrowser$$isNumberField(WebBrowser $this, WebElement webElement2) {
        return WebBrowser$class.isInputField($this, webElement2, "number") || WebBrowser$class.isInputField($this, webElement2, "text");
    }

    public static boolean org$scalatest$selenium$WebBrowser$$isRangeField(WebBrowser $this, WebElement webElement2) {
        return WebBrowser$class.isInputField($this, webElement2, "range") || WebBrowser$class.isInputField($this, webElement2, "text");
    }

    public static boolean org$scalatest$selenium$WebBrowser$$isSearchField(WebBrowser $this, WebElement webElement2) {
        return WebBrowser$class.isInputField($this, webElement2, "search") || WebBrowser$class.isInputField($this, webElement2, "text");
    }

    public static boolean org$scalatest$selenium$WebBrowser$$isTelField(WebBrowser $this, WebElement webElement2) {
        return WebBrowser$class.isInputField($this, webElement2, "tel") || WebBrowser$class.isInputField($this, webElement2, "text");
    }

    public static boolean org$scalatest$selenium$WebBrowser$$isTimeField(WebBrowser $this, WebElement webElement2) {
        return WebBrowser$class.isInputField($this, webElement2, "time") || WebBrowser$class.isInputField($this, webElement2, "text");
    }

    public static boolean org$scalatest$selenium$WebBrowser$$isUrlField(WebBrowser $this, WebElement webElement2) {
        return WebBrowser$class.isInputField($this, webElement2, "url") || WebBrowser$class.isInputField($this, webElement2, "text");
    }

    public static boolean org$scalatest$selenium$WebBrowser$$isWeekField(WebBrowser $this, WebElement webElement2) {
        return WebBrowser$class.isInputField($this, webElement2, "week") || WebBrowser$class.isInputField($this, webElement2, "text");
    }

    public static boolean org$scalatest$selenium$WebBrowser$$isTextArea(WebBrowser $this, WebElement webElement2) {
        String string = webElement2.getTagName().toLowerCase();
        String string2 = "textarea";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static void goTo(WebBrowser $this, String url, WebDriver driver) {
        $this.go().to(url, driver);
    }

    public static void goTo(WebBrowser $this, Page page, WebDriver driver) {
        $this.go().to(page, driver);
    }

    public static void close(WebBrowser $this, WebDriver driver) {
        driver.close();
    }

    public static String pageTitle(WebBrowser $this, WebDriver driver) {
        String t = driver.getTitle();
        return t == null ? "" : t;
    }

    public static String pageSource(WebBrowser $this, WebDriver driver) {
        return driver.getPageSource();
    }

    public static String currentUrl(WebBrowser $this, WebDriver driver) {
        return driver.getCurrentUrl();
    }

    public static WebBrowser.IdQuery id(WebBrowser $this, String elementId) {
        return new WebBrowser.IdQuery($this, elementId);
    }

    public static WebBrowser.NameQuery name(WebBrowser $this, String elementName) {
        return new WebBrowser.NameQuery($this, elementName);
    }

    public static WebBrowser.XPathQuery xpath(WebBrowser $this, String xpath) {
        return new WebBrowser.XPathQuery($this, xpath);
    }

    public static WebBrowser.ClassNameQuery className(WebBrowser $this, String className) {
        return new WebBrowser.ClassNameQuery($this, className);
    }

    public static WebBrowser.CssSelectorQuery cssSelector(WebBrowser $this, String cssSelector) {
        return new WebBrowser.CssSelectorQuery($this, cssSelector);
    }

    public static WebBrowser.LinkTextQuery linkText(WebBrowser $this, String linkText) {
        return new WebBrowser.LinkTextQuery($this, linkText);
    }

    public static WebBrowser.PartialLinkTextQuery partialLinkText(WebBrowser $this, String partialLinkText) {
        return new WebBrowser.PartialLinkTextQuery($this, partialLinkText);
    }

    public static WebBrowser.TagNameQuery tagName(WebBrowser $this, String tagName) {
        return new WebBrowser.TagNameQuery($this, tagName);
    }

    public static WebBrowser.Element org$scalatest$selenium$WebBrowser$$createTypedElement(WebBrowser $this, WebElement element2) {
        WebBrowser.Element element3;
        if (WebBrowser$class.org$scalatest$selenium$WebBrowser$$isTextField($this, element2)) {
            element3 = new WebBrowser.TextField($this, element2);
        } else if (WebBrowser$class.org$scalatest$selenium$WebBrowser$$isTextArea($this, element2)) {
            element3 = new WebBrowser.TextArea($this, element2);
        } else if (WebBrowser$class.org$scalatest$selenium$WebBrowser$$isPasswordField($this, element2)) {
            element3 = new WebBrowser.PasswordField($this, element2);
        } else if (WebBrowser$class.org$scalatest$selenium$WebBrowser$$isEmailField($this, element2)) {
            element3 = new WebBrowser.EmailField($this, element2);
        } else if (WebBrowser$class.org$scalatest$selenium$WebBrowser$$isColorField($this, element2)) {
            element3 = new WebBrowser.ColorField($this, element2);
        } else if (WebBrowser$class.org$scalatest$selenium$WebBrowser$$isDateField($this, element2)) {
            element3 = new WebBrowser.DateField($this, element2);
        } else if (WebBrowser$class.org$scalatest$selenium$WebBrowser$$isDateTimeField($this, element2)) {
            element3 = new WebBrowser.DateTimeField($this, element2);
        } else if (WebBrowser$class.org$scalatest$selenium$WebBrowser$$isDateTimeLocalField($this, element2)) {
            element3 = new WebBrowser.DateTimeLocalField($this, element2);
        } else if (WebBrowser$class.org$scalatest$selenium$WebBrowser$$isMonthField($this, element2)) {
            element3 = new WebBrowser.MonthField($this, element2);
        } else if (WebBrowser$class.org$scalatest$selenium$WebBrowser$$isNumberField($this, element2)) {
            element3 = new WebBrowser.NumberField($this, element2);
        } else if (WebBrowser$class.org$scalatest$selenium$WebBrowser$$isRangeField($this, element2)) {
            element3 = new WebBrowser.RangeField($this, element2);
        } else if (WebBrowser$class.org$scalatest$selenium$WebBrowser$$isSearchField($this, element2)) {
            element3 = new WebBrowser.SearchField($this, element2);
        } else if (WebBrowser$class.org$scalatest$selenium$WebBrowser$$isTelField($this, element2)) {
            element3 = new WebBrowser.TelField($this, element2);
        } else if (WebBrowser$class.org$scalatest$selenium$WebBrowser$$isTimeField($this, element2)) {
            element3 = new WebBrowser.TimeField($this, element2);
        } else if (WebBrowser$class.org$scalatest$selenium$WebBrowser$$isUrlField($this, element2)) {
            element3 = new WebBrowser.UrlField($this, element2);
        } else if (WebBrowser$class.org$scalatest$selenium$WebBrowser$$isWeekField($this, element2)) {
            element3 = new WebBrowser.WeekField($this, element2);
        } else if (WebBrowser$class.org$scalatest$selenium$WebBrowser$$isCheckBox($this, element2)) {
            element3 = new WebBrowser.Checkbox($this, element2);
        } else if (WebBrowser$class.org$scalatest$selenium$WebBrowser$$isRadioButton($this, element2)) {
            element3 = new WebBrowser.RadioButton($this, element2);
        } else {
            Select select;
            String string = element2.getTagName().toLowerCase();
            String string2 = "select";
            element3 = !(string != null ? !string.equals(string2) : string2 != null) ? ((select = new Select(element2)).isMultiple() ? new WebBrowser.MultiSel($this, element2) : new WebBrowser.SingleSel($this, element2)) : new WebBrowser.Element($this, element2){
                private final WebElement underlying;
                private final /* synthetic */ WebBrowser $outer;

                public WebBrowser.Point location() {
                    return WebBrowser$Element$class.location(this);
                }

                public WebBrowser.Dimension size() {
                    return WebBrowser$Element$class.size(this);
                }

                public boolean isDisplayed() {
                    return WebBrowser$Element$class.isDisplayed(this);
                }

                public boolean isEnabled() {
                    return WebBrowser$Element$class.isEnabled(this);
                }

                public boolean isSelected() {
                    return WebBrowser$Element$class.isSelected(this);
                }

                public String tagName() {
                    return WebBrowser$Element$class.tagName(this);
                }

                public Option<String> attribute(String name) {
                    return WebBrowser$Element$class.attribute(this, name);
                }

                public String text() {
                    return WebBrowser$Element$class.text(this);
                }

                public boolean equals(Object other) {
                    return WebBrowser$Element$class.equals(this, other);
                }

                public int hashCode() {
                    return WebBrowser$Element$class.hashCode(this);
                }

                public String toString() {
                    return WebBrowser$Element$class.toString(this);
                }

                public WebElement underlying() {
                    return this.underlying;
                }

                public /* synthetic */ WebBrowser org$scalatest$selenium$WebBrowser$Element$$$outer() {
                    return this.$outer;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    WebBrowser$Element$class.$init$(this);
                    this.underlying = element$1;
                }
            };
        }
        return element3;
    }

    public static Option find(WebBrowser $this, WebBrowser.Query query, WebDriver driver) {
        return query.findElement(driver);
    }

    public static Option find(WebBrowser $this, String queryString, WebDriver driver) {
        Option<WebBrowser.Element> option;
        block4: {
            Option<WebBrowser.Element> option2;
            block7: {
                Some some;
                block3: {
                    None$ none$;
                    block6: {
                        block5: {
                            block2: {
                                option = new WebBrowser.IdQuery($this, queryString).findElement(driver);
                                if (!(option instanceof Some)) break block2;
                                Some some2 = (Some)option;
                                WebBrowser.Element element2 = (WebBrowser.Element)some2.x();
                                some = new Some((Object)element2);
                                break block3;
                            }
                            if (!None$.MODULE$.equals(option)) break block4;
                            option2 = new WebBrowser.NameQuery($this, queryString).findElement(driver);
                            if (!(option2 instanceof Some)) break block5;
                            Some some3 = (Some)option2;
                            WebBrowser.Element element3 = (WebBrowser.Element)some3.x();
                            none$ = new Some((Object)element3);
                            break block6;
                        }
                        if (!None$.MODULE$.equals(option2)) break block7;
                        none$ = None$.MODULE$;
                    }
                    some = none$;
                }
                return some;
            }
            throw new MatchError(option2);
        }
        throw new MatchError(option);
    }

    public static Iterator findAll(WebBrowser $this, WebBrowser.Query query, WebDriver driver) {
        return query.findAllElements(driver);
    }

    public static Iterator findAll(WebBrowser $this, String queryString, WebDriver driver) {
        Iterator<WebBrowser.Element> byIdItr = new WebBrowser.IdQuery($this, queryString).findAllElements(driver);
        return byIdItr.hasNext() ? byIdItr : new WebBrowser.NameQuery($this, queryString).findAllElements(driver);
    }

    public static Object org$scalatest$selenium$WebBrowser$$tryQueries(WebBrowser $this, String queryString, Function1 f, WebDriver driver) {
        Object object;
        try {
            object = f.apply((Object)new WebBrowser.IdQuery($this, queryString));
        }
        catch (Throwable throwable) {
            object = f.apply((Object)new WebBrowser.NameQuery($this, queryString));
        }
        return object;
    }

    public static WebBrowser.TextField textField(WebBrowser $this, WebBrowser.Query query, WebDriver driver) {
        return new WebBrowser.TextField($this, query.webElement(driver));
    }

    public static WebBrowser.TextField textField(WebBrowser $this, String queryString, WebDriver driver) {
        return (WebBrowser.TextField)WebBrowser$class.org$scalatest$selenium$WebBrowser$$tryQueries($this, queryString, (Function1)new Serializable($this, driver){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ WebBrowser $outer;
            private final WebDriver driver$2;

            public final WebBrowser.TextField apply(WebBrowser.Query q) {
                return new WebBrowser.TextField(this.$outer, q.webElement(this.driver$2));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.driver$2 = driver$2;
            }
        }, driver);
    }

    public static WebBrowser.TextArea textArea(WebBrowser $this, WebBrowser.Query query, WebDriver driver) {
        return new WebBrowser.TextArea($this, query.webElement(driver));
    }

    public static WebBrowser.TextArea textArea(WebBrowser $this, String queryString, WebDriver driver) {
        return (WebBrowser.TextArea)WebBrowser$class.org$scalatest$selenium$WebBrowser$$tryQueries($this, queryString, (Function1)new Serializable($this, driver){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ WebBrowser $outer;
            private final WebDriver driver$3;

            public final WebBrowser.TextArea apply(WebBrowser.Query q) {
                return new WebBrowser.TextArea(this.$outer, q.webElement(this.driver$3));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.driver$3 = driver$3;
            }
        }, driver);
    }

    public static WebBrowser.PasswordField pwdField(WebBrowser $this, WebBrowser.Query query, WebDriver driver) {
        return new WebBrowser.PasswordField($this, query.webElement(driver));
    }

    public static WebBrowser.PasswordField pwdField(WebBrowser $this, String queryString, WebDriver driver) {
        return (WebBrowser.PasswordField)WebBrowser$class.org$scalatest$selenium$WebBrowser$$tryQueries($this, queryString, (Function1)new Serializable($this, driver){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ WebBrowser $outer;
            private final WebDriver driver$4;

            public final WebBrowser.PasswordField apply(WebBrowser.Query q) {
                return new WebBrowser.PasswordField(this.$outer, q.webElement(this.driver$4));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.driver$4 = driver$4;
            }
        }, driver);
    }

    public static WebBrowser.EmailField emailField(WebBrowser $this, WebBrowser.Query query, WebDriver driver) {
        return new WebBrowser.EmailField($this, query.webElement(driver));
    }

    public static WebBrowser.EmailField emailField(WebBrowser $this, String queryString, WebDriver driver) {
        return (WebBrowser.EmailField)WebBrowser$class.org$scalatest$selenium$WebBrowser$$tryQueries($this, queryString, (Function1)new Serializable($this, driver){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ WebBrowser $outer;
            private final WebDriver driver$5;

            public final WebBrowser.EmailField apply(WebBrowser.Query q) {
                return new WebBrowser.EmailField(this.$outer, q.webElement(this.driver$5));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.driver$5 = driver$5;
            }
        }, driver);
    }

    public static WebBrowser.ColorField colorField(WebBrowser $this, WebBrowser.Query query, WebDriver driver) {
        return new WebBrowser.ColorField($this, query.webElement(driver));
    }

    public static WebBrowser.ColorField colorField(WebBrowser $this, String queryString, WebDriver driver) {
        return (WebBrowser.ColorField)WebBrowser$class.org$scalatest$selenium$WebBrowser$$tryQueries($this, queryString, (Function1)new Serializable($this, driver){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ WebBrowser $outer;
            private final WebDriver driver$6;

            public final WebBrowser.ColorField apply(WebBrowser.Query q) {
                return new WebBrowser.ColorField(this.$outer, q.webElement(this.driver$6));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.driver$6 = driver$6;
            }
        }, driver);
    }

    public static WebBrowser.DateField dateField(WebBrowser $this, WebBrowser.Query query, WebDriver driver) {
        return new WebBrowser.DateField($this, query.webElement(driver));
    }

    public static WebBrowser.DateField dateField(WebBrowser $this, String queryString, WebDriver driver) {
        return (WebBrowser.DateField)WebBrowser$class.org$scalatest$selenium$WebBrowser$$tryQueries($this, queryString, (Function1)new Serializable($this, driver){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ WebBrowser $outer;
            private final WebDriver driver$7;

            public final WebBrowser.DateField apply(WebBrowser.Query q) {
                return new WebBrowser.DateField(this.$outer, q.webElement(this.driver$7));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.driver$7 = driver$7;
            }
        }, driver);
    }

    public static WebBrowser.DateTimeField dateTimeField(WebBrowser $this, WebBrowser.Query query, WebDriver driver) {
        return new WebBrowser.DateTimeField($this, query.webElement(driver));
    }

    public static WebBrowser.DateTimeField dateTimeField(WebBrowser $this, String queryString, WebDriver driver) {
        return (WebBrowser.DateTimeField)WebBrowser$class.org$scalatest$selenium$WebBrowser$$tryQueries($this, queryString, (Function1)new Serializable($this, driver){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ WebBrowser $outer;
            private final WebDriver driver$8;

            public final WebBrowser.DateTimeField apply(WebBrowser.Query q) {
                return new WebBrowser.DateTimeField(this.$outer, q.webElement(this.driver$8));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.driver$8 = driver$8;
            }
        }, driver);
    }

    public static WebBrowser.DateTimeLocalField dateTimeLocalField(WebBrowser $this, WebBrowser.Query query, WebDriver driver) {
        return new WebBrowser.DateTimeLocalField($this, query.webElement(driver));
    }

    public static WebBrowser.DateTimeLocalField dateTimeLocalField(WebBrowser $this, String queryString, WebDriver driver) {
        return (WebBrowser.DateTimeLocalField)WebBrowser$class.org$scalatest$selenium$WebBrowser$$tryQueries($this, queryString, (Function1)new Serializable($this, driver){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ WebBrowser $outer;
            private final WebDriver driver$9;

            public final WebBrowser.DateTimeLocalField apply(WebBrowser.Query q) {
                return new WebBrowser.DateTimeLocalField(this.$outer, q.webElement(this.driver$9));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.driver$9 = driver$9;
            }
        }, driver);
    }

    public static WebBrowser.MonthField monthField(WebBrowser $this, WebBrowser.Query query, WebDriver driver) {
        return new WebBrowser.MonthField($this, query.webElement(driver));
    }

    public static WebBrowser.MonthField monthField(WebBrowser $this, String queryString, WebDriver driver) {
        return (WebBrowser.MonthField)WebBrowser$class.org$scalatest$selenium$WebBrowser$$tryQueries($this, queryString, (Function1)new Serializable($this, driver){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ WebBrowser $outer;
            private final WebDriver driver$10;

            public final WebBrowser.MonthField apply(WebBrowser.Query q) {
                return new WebBrowser.MonthField(this.$outer, q.webElement(this.driver$10));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.driver$10 = driver$10;
            }
        }, driver);
    }

    public static WebBrowser.NumberField numberField(WebBrowser $this, WebBrowser.Query query, WebDriver driver) {
        return new WebBrowser.NumberField($this, query.webElement(driver));
    }

    public static WebBrowser.NumberField numberField(WebBrowser $this, String queryString, WebDriver driver) {
        return (WebBrowser.NumberField)WebBrowser$class.org$scalatest$selenium$WebBrowser$$tryQueries($this, queryString, (Function1)new Serializable($this, driver){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ WebBrowser $outer;
            private final WebDriver driver$11;

            public final WebBrowser.NumberField apply(WebBrowser.Query q) {
                return new WebBrowser.NumberField(this.$outer, q.webElement(this.driver$11));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.driver$11 = driver$11;
            }
        }, driver);
    }

    public static WebBrowser.RangeField rangeField(WebBrowser $this, WebBrowser.Query query, WebDriver driver) {
        return new WebBrowser.RangeField($this, query.webElement(driver));
    }

    public static WebBrowser.RangeField rangeField(WebBrowser $this, String queryString, WebDriver driver) {
        return (WebBrowser.RangeField)WebBrowser$class.org$scalatest$selenium$WebBrowser$$tryQueries($this, queryString, (Function1)new Serializable($this, driver){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ WebBrowser $outer;
            private final WebDriver driver$12;

            public final WebBrowser.RangeField apply(WebBrowser.Query q) {
                return new WebBrowser.RangeField(this.$outer, q.webElement(this.driver$12));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.driver$12 = driver$12;
            }
        }, driver);
    }

    public static WebBrowser.SearchField searchField(WebBrowser $this, WebBrowser.Query query, WebDriver driver) {
        return new WebBrowser.SearchField($this, query.webElement(driver));
    }

    public static WebBrowser.SearchField searchField(WebBrowser $this, String queryString, WebDriver driver) {
        return (WebBrowser.SearchField)WebBrowser$class.org$scalatest$selenium$WebBrowser$$tryQueries($this, queryString, (Function1)new Serializable($this, driver){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ WebBrowser $outer;
            private final WebDriver driver$13;

            public final WebBrowser.SearchField apply(WebBrowser.Query q) {
                return new WebBrowser.SearchField(this.$outer, q.webElement(this.driver$13));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.driver$13 = driver$13;
            }
        }, driver);
    }

    public static WebBrowser.TelField telField(WebBrowser $this, WebBrowser.Query query, WebDriver driver) {
        return new WebBrowser.TelField($this, query.webElement(driver));
    }

    public static WebBrowser.TelField telField(WebBrowser $this, String queryString, WebDriver driver) {
        return (WebBrowser.TelField)WebBrowser$class.org$scalatest$selenium$WebBrowser$$tryQueries($this, queryString, (Function1)new Serializable($this, driver){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ WebBrowser $outer;
            private final WebDriver driver$14;

            public final WebBrowser.TelField apply(WebBrowser.Query q) {
                return new WebBrowser.TelField(this.$outer, q.webElement(this.driver$14));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.driver$14 = driver$14;
            }
        }, driver);
    }

    public static WebBrowser.TimeField timeField(WebBrowser $this, WebBrowser.Query query, WebDriver driver) {
        return new WebBrowser.TimeField($this, query.webElement(driver));
    }

    public static WebBrowser.TimeField timeField(WebBrowser $this, String queryString, WebDriver driver) {
        return (WebBrowser.TimeField)WebBrowser$class.org$scalatest$selenium$WebBrowser$$tryQueries($this, queryString, (Function1)new Serializable($this, driver){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ WebBrowser $outer;
            private final WebDriver driver$15;

            public final WebBrowser.TimeField apply(WebBrowser.Query q) {
                return new WebBrowser.TimeField(this.$outer, q.webElement(this.driver$15));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.driver$15 = driver$15;
            }
        }, driver);
    }

    public static WebBrowser.UrlField urlField(WebBrowser $this, WebBrowser.Query query, WebDriver driver) {
        return new WebBrowser.UrlField($this, query.webElement(driver));
    }

    public static WebBrowser.UrlField urlField(WebBrowser $this, String queryString, WebDriver driver) {
        return (WebBrowser.UrlField)WebBrowser$class.org$scalatest$selenium$WebBrowser$$tryQueries($this, queryString, (Function1)new Serializable($this, driver){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ WebBrowser $outer;
            private final WebDriver driver$16;

            public final WebBrowser.UrlField apply(WebBrowser.Query q) {
                return new WebBrowser.UrlField(this.$outer, q.webElement(this.driver$16));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.driver$16 = driver$16;
            }
        }, driver);
    }

    public static WebBrowser.WeekField weekField(WebBrowser $this, WebBrowser.Query query, WebDriver driver) {
        return new WebBrowser.WeekField($this, query.webElement(driver));
    }

    public static WebBrowser.WeekField weekField(WebBrowser $this, String queryString, WebDriver driver) {
        return (WebBrowser.WeekField)WebBrowser$class.org$scalatest$selenium$WebBrowser$$tryQueries($this, queryString, (Function1)new Serializable($this, driver){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ WebBrowser $outer;
            private final WebDriver driver$17;

            public final WebBrowser.WeekField apply(WebBrowser.Query q) {
                return new WebBrowser.WeekField(this.$outer, q.webElement(this.driver$17));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.driver$17 = driver$17;
            }
        }, driver);
    }

    public static WebBrowser.RadioButtonGroup radioButtonGroup(WebBrowser $this, String groupName, WebDriver driver) {
        return new WebBrowser.RadioButtonGroup($this, groupName, driver);
    }

    public static WebBrowser.RadioButton radioButton(WebBrowser $this, WebBrowser.Query query, WebDriver driver) {
        return new WebBrowser.RadioButton($this, query.webElement(driver));
    }

    public static WebBrowser.RadioButton radioButton(WebBrowser $this, String queryString, WebDriver driver) {
        return (WebBrowser.RadioButton)WebBrowser$class.org$scalatest$selenium$WebBrowser$$tryQueries($this, queryString, (Function1)new Serializable($this, driver){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ WebBrowser $outer;
            private final WebDriver driver$18;

            public final WebBrowser.RadioButton apply(WebBrowser.Query q) {
                return new WebBrowser.RadioButton(this.$outer, q.webElement(this.driver$18));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.driver$18 = driver$18;
            }
        }, driver);
    }

    public static WebBrowser.Checkbox checkbox(WebBrowser $this, WebBrowser.Query query, WebDriver driver) {
        return new WebBrowser.Checkbox($this, query.webElement(driver));
    }

    public static WebBrowser.Checkbox checkbox(WebBrowser $this, String queryString, WebDriver driver) {
        return (WebBrowser.Checkbox)WebBrowser$class.org$scalatest$selenium$WebBrowser$$tryQueries($this, queryString, (Function1)new Serializable($this, driver){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ WebBrowser $outer;
            private final WebDriver driver$19;

            public final WebBrowser.Checkbox apply(WebBrowser.Query q) {
                return new WebBrowser.Checkbox(this.$outer, q.webElement(this.driver$19));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.driver$19 = driver$19;
            }
        }, driver);
    }

    public static WebBrowser.SingleSel singleSel(WebBrowser $this, WebBrowser.Query query, WebDriver driver) {
        return new WebBrowser.SingleSel($this, query.webElement(driver));
    }

    public static WebBrowser.SingleSel singleSel(WebBrowser $this, String queryString, WebDriver driver) {
        return (WebBrowser.SingleSel)WebBrowser$class.org$scalatest$selenium$WebBrowser$$tryQueries($this, queryString, (Function1)new Serializable($this, driver){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ WebBrowser $outer;
            private final WebDriver driver$20;

            public final WebBrowser.SingleSel apply(WebBrowser.Query q) {
                return new WebBrowser.SingleSel(this.$outer, q.webElement(this.driver$20));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.driver$20 = driver$20;
            }
        }, driver);
    }

    public static WebBrowser.MultiSel multiSel(WebBrowser $this, WebBrowser.Query query, WebDriver driver) {
        return new WebBrowser.MultiSel($this, query.webElement(driver));
    }

    public static WebBrowser.MultiSel multiSel(WebBrowser $this, String queryString, WebDriver driver) {
        return (WebBrowser.MultiSel)WebBrowser$class.org$scalatest$selenium$WebBrowser$$tryQueries($this, queryString, (Function1)new Serializable($this, driver){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ WebBrowser $outer;
            private final WebDriver driver$21;

            public final WebBrowser.MultiSel apply(WebBrowser.Query q) {
                return new WebBrowser.MultiSel(this.$outer, q.webElement(this.driver$21));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.driver$21 = driver$21;
            }
        }, driver);
    }

    public static void clickOn(WebBrowser $this, WebElement element2) {
        $this.click().on(element2);
    }

    public static void clickOn(WebBrowser $this, WebBrowser.Query query, WebDriver driver) {
        $this.click().on(query, driver);
    }

    public static void clickOn(WebBrowser $this, String queryString, WebDriver driver) {
        $this.click().on(queryString, driver);
    }

    public static void clickOn(WebBrowser $this, WebBrowser.Element element2) {
        $this.click().on(element2);
    }

    public static void submit(WebBrowser $this, WebDriver driver) {
        try {
            $this.switch().to($this.activeElement(), driver).underlying().submit();
            return;
        }
        catch (Throwable throwable) {
            throw new TestFailedException((Function1<StackDepthException, Option<String>>)new Serializable($this, throwable){
                public static final long serialVersionUID = 0L;
                private final Throwable e$3;

                public final Some<String> apply(StackDepthException sde) {
                    return new Some((Object)new StringBuilder().append((Object)"WebDriver encountered problem to submit(): ").append((Object)this.e$3.getMessage()).toString());
                }
                {
                    this.e$3 = e$3;
                }
            }, (Option<Throwable>)new Some((Object)throwable), StackDepthExceptionHelper$.MODULE$.getStackDepthFun("WebBrowser.scala", "submit", 0));
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new TestFailedException((Function1<StackDepthException, Option<String>>)new Serializable($this){
                public static final long serialVersionUID = 0L;

                public final Some<String> apply(StackDepthException sde) {
                    return new Some((Object)"Current element is not a form element.");
                }
            }, (Option<Throwable>)new Some((Object)noSuchElementException), StackDepthExceptionHelper$.MODULE$.getStackDepthFun("WebBrowser.scala", "name", 1));
        }
    }

    public static void implicitlyWait(WebBrowser $this, Span timeout, WebDriver driver) {
        driver.manage().timeouts().implicitlyWait(timeout.totalNanos(), TimeUnit.NANOSECONDS);
    }

    public static void quit(WebBrowser $this, WebDriver driver) {
        driver.quit();
    }

    public static String windowHandle(WebBrowser $this, WebDriver driver) {
        return driver.getWindowHandle();
    }

    public static Set windowHandles(WebBrowser $this, WebDriver driver) {
        return ((TraversableOnce)JavaConverters$.MODULE$.asScalaSetConverter(driver.getWindowHandles()).asScala()).toSet();
    }

    public static WebBrowser.FrameIndexTarget frame(WebBrowser $this, int index) {
        return new WebBrowser.FrameIndexTarget($this, index);
    }

    public static WebBrowser.FrameNameOrIdTarget frame(WebBrowser $this, String nameOrId) {
        return new WebBrowser.FrameNameOrIdTarget($this, nameOrId);
    }

    public static WebBrowser.FrameWebElementTarget frame(WebBrowser $this, WebElement element2) {
        return new WebBrowser.FrameWebElementTarget($this, element2);
    }

    public static WebBrowser.FrameElementTarget frame(WebBrowser $this, WebBrowser.Element element2) {
        return new WebBrowser.FrameElementTarget($this, element2);
    }

    public static WebBrowser.FrameWebElementTarget frame(WebBrowser $this, WebBrowser.Query query, WebDriver driver) {
        return new WebBrowser.FrameWebElementTarget($this, query.webElement(driver));
    }

    public static WebBrowser.WindowTarget window(WebBrowser $this, String nameOrHandle) {
        return new WebBrowser.WindowTarget($this, nameOrHandle);
    }

    public static Object switchTo(WebBrowser $this, WebBrowser.SwitchTarget target, WebDriver driver) {
        return $this.switch().to(target, driver);
    }

    public static void goBack(WebBrowser $this, WebDriver driver) {
        driver.navigate().back();
    }

    public static void goForward(WebBrowser $this, WebDriver driver) {
        driver.navigate().forward();
    }

    public static void reloadPage(WebBrowser $this, WebDriver driver) {
        driver.navigate().refresh();
    }

    public static WebBrowser.WrappedCookie cookie(WebBrowser $this, String name, WebDriver driver) {
        return WebBrowser$class.org$scalatest$selenium$WebBrowser$$getCookie($this, name, driver);
    }

    public static WebBrowser.WrappedCookie org$scalatest$selenium$WebBrowser$$getCookie(WebBrowser $this, String name, WebDriver driver) {
        Option option = ((TraversableOnce)JavaConverters$.MODULE$.asScalaSetConverter(driver.manage().getCookies()).asScala()).toList().find((Function1)new Serializable($this, name){
            public static final long serialVersionUID = 0L;
            private final String name$1;

            public final boolean apply(Cookie x$7) {
                String string = x$7.getName();
                String string2 = this.name$1;
                return !(string != null ? !string.equals(string2) : string2 != null);
            }
            {
                this.name$1 = name$1;
            }
        });
        if (option instanceof Some) {
            Some some = (Some)option;
            Cookie cookie = (Cookie)some.x();
            WebBrowser.WrappedCookie wrappedCookie = new WebBrowser.WrappedCookie($this, cookie);
            return wrappedCookie;
        }
        if (None$.MODULE$.equals(option)) {
            throw new TestFailedException((Function1<StackDepthException, Option<String>>)new Serializable($this, name){
                public static final long serialVersionUID = 0L;
                private final String name$1;

                public final Some<String> apply(StackDepthException sde) {
                    return new Some((Object)new StringBuilder().append((Object)"Cookie '").append((Object)this.name$1).append((Object)"' not found.").toString());
                }
                {
                    this.name$1 = name$1;
                }
            }, (Option<Throwable>)None$.MODULE$, StackDepthExceptionHelper$.MODULE$.getStackDepthFun("WebBrowser.scala", "getCookie", 1));
        }
        throw new MatchError((Object)option);
    }

    public static void addCookie(WebBrowser $this, String name, String value2, String path, Date expiry, String domain, boolean secure, WebDriver driver) {
        $this.add().cookie(name, value2, path, expiry, domain, secure, driver);
    }

    public static String addCookie$default$3(WebBrowser $this) {
        return "/";
    }

    public static Date addCookie$default$4(WebBrowser $this) {
        return null;
    }

    public static String addCookie$default$5(WebBrowser $this) {
        return null;
    }

    public static boolean addCookie$default$6(WebBrowser $this) {
        return false;
    }

    public static void deleteCookie(WebBrowser $this, String name, WebDriver driver) {
        $this.delete().cookie(name, driver);
    }

    public static void deleteAllCookies(WebBrowser $this, WebDriver driver) {
        $this.delete().all($this.cookies(), driver);
    }

    public static boolean isScreenshotSupported(WebBrowser $this, WebDriver driver) {
        return driver instanceof TakesScreenshot;
    }

    public static void captureTo(WebBrowser $this, String fileName, WebDriver driver) {
        $this.capture().to(fileName, driver);
    }

    public static void setCaptureDir(WebBrowser $this, String targetDirPath) {
        $this.org$scalatest$selenium$WebBrowser$$targetDir_$eq(targetDirPath.endsWith(File.separator) ? new File(targetDirPath) : new File(new StringBuilder().append((Object)targetDirPath).append((Object)File.separator).toString()));
        if (!$this.org$scalatest$selenium$WebBrowser$$targetDir().exists()) {
            $this.org$scalatest$selenium$WebBrowser$$targetDir().mkdirs();
        }
    }

    public static Object withScreenshot(WebBrowser $this, Function0 fun, WebDriver driver) {
        try {
            return fun.apply();
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable2 instanceof ModifiableMessage) {
                Throwable throwable3 = throwable2;
                throw ((ModifiableMessage)((Object)throwable3)).modifyMessage((Function1<Option<String>, Option<String>>)new Serializable($this, driver){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ WebBrowser $outer;
                    private final WebDriver driver$22;

                    public final Option<String> apply(Option<String> currentMessage) {
                        Option<String> option;
                        block4: {
                            Some some;
                            block3: {
                                File captureFile;
                                block2: {
                                    captureFile = this.$outer.capture().apply(this.driver$22);
                                    option = currentMessage;
                                    if (!(option instanceof Some)) break block2;
                                    Some some2 = (Some)option;
                                    String currentMsg = (String)some2.x();
                                    some = new Some((Object)new StringBuilder().append((Object)currentMsg).append((Object)"; screenshot captured in ").append((Object)captureFile.getAbsolutePath()).toString());
                                    break block3;
                                }
                                if (!None$.MODULE$.equals(option)) break block4;
                                some = new Some((Object)new StringBuilder().append((Object)"screenshot captured in ").append((Object)captureFile.getAbsolutePath()).toString());
                            }
                            return some;
                        }
                        throw new MatchError(option);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.driver$22 = driver$22;
                    }
                });
            }
            throw throwable;
        }
    }

    public static Object executeScript(WebBrowser $this, String script, Seq args, WebDriver driver) {
        WebDriver webDriver = driver;
        if (webDriver instanceof JavascriptExecutor) {
            WebDriver webDriver2 = webDriver;
            Object object = ((JavascriptExecutor)webDriver2).executeScript(script, (Object[])args.toArray(ClassTag$.MODULE$.AnyRef()));
            return object;
        }
        throw new UnsupportedOperationException(new StringBuilder().append((Object)"Web driver ").append((Object)driver.getClass().getName()).append((Object)" does not support javascript execution.").toString());
    }

    public static Object executeAsyncScript(WebBrowser $this, String script, Seq args, WebDriver driver) {
        WebDriver webDriver = driver;
        if (webDriver instanceof JavascriptExecutor) {
            WebDriver webDriver2 = webDriver;
            Object object = ((JavascriptExecutor)webDriver2).executeAsyncScript(script, (Object[])args.toArray(ClassTag$.MODULE$.AnyRef()));
            return object;
        }
        throw new UnsupportedOperationException(new StringBuilder().append((Object)"Web driver ").append((Object)driver.getClass().getName()).append((Object)" does not support javascript execution.").toString());
    }

    public static void setScriptTimeout(WebBrowser $this, Span timeout, WebDriver driver) {
        driver.manage().timeouts().setScriptTimeout(timeout.totalNanos(), TimeUnit.NANOSECONDS);
    }

    public static void enter(WebBrowser $this, String value2, WebDriver driver) {
        block9: {
            block3: {
                WebBrowser.Element element2;
                block8: {
                    block7: {
                        block6: {
                            block5: {
                                block4: {
                                    block2: {
                                        WebBrowser.Element ae = $this.switch().to($this.activeElement(), driver);
                                        element2 = ae;
                                        if (!(element2 instanceof WebBrowser.TextField)) break block2;
                                        WebBrowser.TextField textField2 = (WebBrowser.TextField)element2;
                                        textField2.value_$eq(value2);
                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                        break block3;
                                    }
                                    if (!(element2 instanceof WebBrowser.TextArea)) break block4;
                                    WebBrowser.TextArea textArea2 = (WebBrowser.TextArea)element2;
                                    textArea2.value_$eq(value2);
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                    break block3;
                                }
                                if (!(element2 instanceof WebBrowser.PasswordField)) break block5;
                                WebBrowser.PasswordField passwordField = (WebBrowser.PasswordField)element2;
                                passwordField.value_$eq(value2);
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                break block3;
                            }
                            if (!(element2 instanceof WebBrowser.EmailField)) break block6;
                            WebBrowser.EmailField emailField2 = (WebBrowser.EmailField)element2;
                            emailField2.value_$eq(value2);
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            break block3;
                        }
                        if (!(element2 instanceof WebBrowser.SearchField)) break block7;
                        WebBrowser.SearchField searchField2 = (WebBrowser.SearchField)element2;
                        searchField2.value_$eq(value2);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        break block3;
                    }
                    if (!(element2 instanceof WebBrowser.TelField)) break block8;
                    WebBrowser.TelField telField2 = (WebBrowser.TelField)element2;
                    telField2.value_$eq(value2);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block3;
                }
                if (!(element2 instanceof WebBrowser.UrlField)) break block9;
                WebBrowser.UrlField urlField2 = (WebBrowser.UrlField)element2;
                urlField2.value_$eq(value2);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
        throw new TestFailedException((Function1<StackDepthException, Option<String>>)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final Some<String> apply(StackDepthException sde) {
                return new Some((Object)"Currently selected element is neither a text field, text area, password field, email field, search field, tel field or url field");
            }
        }, (Option<Throwable>)None$.MODULE$, StackDepthExceptionHelper$.MODULE$.getStackDepthFun("WebBrowser.scala", "switch", 1));
    }

    public static void pressKeys(WebBrowser $this, String value2, WebDriver driver) {
        WebElement ae = driver.switchTo().activeElement();
        ae.sendKeys(new CharSequence[]{value2});
    }

    public static void $init$(WebBrowser $this) {
        $this.org$scalatest$selenium$WebBrowser$_setter_$cookies_$eq(new WebBrowser.CookiesNoun($this));
        $this.org$scalatest$selenium$WebBrowser$_setter_$activeElement_$eq(new WebBrowser.ActiveElementTarget($this));
        $this.org$scalatest$selenium$WebBrowser$_setter_$alertBox_$eq(new WebBrowser.AlertTarget($this));
        $this.org$scalatest$selenium$WebBrowser$_setter_$defaultContent_$eq(new WebBrowser.DefaultContentTarget($this));
        $this.org$scalatest$selenium$WebBrowser$$targetDir_$eq(new File(System.getProperty("java.io.tmpdir")));
    }
}

