/*
 * Decompiled with CFR 0.152.
 */
package org.scalatest.junit;

import java.lang.annotation.Annotation;
import org.junit.runner.Description;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunNotifier;
import org.scalatest.Reporter;
import org.scalatest.Resources$;
import org.scalatest.events.Event;
import org.scalatest.events.RunAborted;
import org.scalatest.events.SuiteAborted;
import org.scalatest.events.TestFailed;
import org.scalatest.events.TestIgnored;
import org.scalatest.events.TestPending;
import org.scalatest.events.TestStarting;
import org.scalatest.events.TestSucceeded;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005\u001d4Qa\u0002\u0005\u0001\u00119A\u0001\"\u0007\u0001\u0003\u0002\u0003\u0006Ia\u0007\u0005\u0006I\u0001!\t!\n\u0005\u0006S\u0001!IA\u000b\u0005\u0006\r\u0002!Ia\u0012\u0005\u0006\u0015\u0002!\te\u0013\u0005\u0006/\u0002!\t\u0001\u0017\u0002\u0014%Vtgj\u001c;jM&,'OU3q_J$XM\u001d\u0006\u0003\u0013)\tQA[;oSRT!a\u0003\u0007\u0002\u0013M\u001c\u0017\r\\1uKN$(\"A\u0007\u0002\u0007=\u0014xmE\u0002\u0001\u001fU\u0001\"\u0001E\n\u000e\u0003EQ\u0011AE\u0001\u0006g\u000e\fG.Y\u0005\u0003)E\u0011a!\u00118z%\u00164\u0007C\u0001\f\u0018\u001b\u0005Q\u0011B\u0001\r\u000b\u0005!\u0011V\r]8si\u0016\u0014\u0018a\u0003:v]:{G/\u001b4jKJ\u001c\u0001\u0001\u0005\u0002\u001dE5\tQD\u0003\u0002\u001f?\u0005aan\u001c;jM&\u001c\u0017\r^5p]*\u0011\u0001%I\u0001\u0007eVtg.\u001a:\u000b\u0005%a\u0011BA\u0012\u001e\u0005-\u0011VO\u001c(pi&4\u0017.\u001a:\u0002\rqJg.\u001b;?)\t1\u0003\u0006\u0005\u0002(\u00015\t\u0001\u0002C\u0003\u001a\u0005\u0001\u00071$A\nuKN$H)Z:de&\u0004H/[8o\u001d\u0006lW\r\u0006\u0003,g}\"\u0005C\u0001\u00172\u001b\u0005i#B\u0001\u00180\u0003\u0011a\u0017M\\4\u000b\u0003A\nAA[1wC&\u0011!'\f\u0002\u0007'R\u0014\u0018N\\4\t\u000bQ\u001a\u0001\u0019A\u001b\u0002\u0013M,\u0018\u000e^3OC6,\u0007C\u0001\u001c>\u001d\t94\b\u0005\u00029#5\t\u0011H\u0003\u0002;5\u00051AH]8pizJ!\u0001P\t\u0002\rA\u0013X\rZ3g\u0013\t\u0011dH\u0003\u0002=#!)\u0001i\u0001a\u0001\u0003\u0006q1/^5uK\u000ec\u0017m]:OC6,\u0007c\u0001\tCk%\u00111)\u0005\u0002\u0007\u001fB$\u0018n\u001c8\t\u000b\u0015\u001b\u0001\u0019A\u001b\u0002\u0011Q,7\u000f\u001e(b[\u0016\fAc];ji\u0016$Um]2sSB$\u0018n\u001c8OC6,GcA\u001bI\u0013\")A\u0007\u0002a\u0001k!)\u0001\t\u0002a\u0001\u0003\u0006)\u0011\r\u001d9msR\u0011Aj\u0014\t\u0003!5K!AT\t\u0003\tUs\u0017\u000e\u001e\u0005\u0006!\u0016\u0001\r!U\u0001\u0006KZ,g\u000e\u001e\t\u0003%Vk\u0011a\u0015\u0006\u0003)*\ta!\u001a<f]R\u001c\u0018B\u0001,T\u0005\u0015)e/\u001a8u\u0003\u0001jWm]:bO\u0016|%\u000f\u00165s_^\f'\r\\3t\t\u0016$\u0018-\u001b7NKN\u001c\u0018mZ3\u0015\u0007UJ6\fC\u0003[\r\u0001\u0007Q'A\u0004nKN\u001c\u0018mZ3\t\u000bq3\u0001\u0019A/\u0002\u0013QD'o\\<bE2,\u0007c\u0001\tC=B\u0011q\f\u001a\b\u0003A\nt!\u0001O1\n\u0003II!aY\t\u0002\u000fA\f7m[1hK&\u0011QM\u001a\u0002\n)\"\u0014xn^1cY\u0016T!aY\t")
public class RunNotifierReporter
implements Reporter {
    private final RunNotifier runNotifier;

    private String testDescriptionName(String suiteName, Option<String> suiteClassName, String testName) {
        String string;
        Option<String> option = suiteClassName;
        if (option instanceof Some) {
            Some some = (Some)option;
            String suiteClassName2 = (String)some.value();
            string = new StringBuilder(2).append(testName).append("(").append(suiteClassName2).append(")").toString();
        } else if (None$.MODULE$.equals(option)) {
            string = new StringBuilder(2).append(testName).append("(").append(suiteName).append(")").toString();
        } else {
            throw new MatchError(option);
        }
        return string;
    }

    private String suiteDescriptionName(String suiteName, Option<String> suiteClassName) {
        String string;
        Option<String> option = suiteClassName;
        if (option instanceof Some) {
            String suiteClassName2;
            Some some = (Some)option;
            string = suiteClassName2 = (String)some.value();
        } else if (None$.MODULE$.equals(option)) {
            string = suiteName;
        } else {
            throw new MatchError(option);
        }
        return string;
    }

    @Override
    public void apply(Event event) {
        Event event2 = event;
        if (event2 instanceof TestStarting) {
            TestStarting testStarting = (TestStarting)event2;
            String suiteName = testStarting.suiteName();
            Option<String> suiteClassName = testStarting.suiteClassName();
            String testName = testStarting.testName();
            this.runNotifier.fireTestStarted(Description.createSuiteDescription((String)this.testDescriptionName(suiteName, suiteClassName, testName), (Annotation[])new Annotation[0]));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (event2 instanceof TestFailed) {
            Throwable throwable;
            TestFailed testFailed = (TestFailed)event2;
            String suiteName = testFailed.suiteName();
            Option<String> suiteClassName = testFailed.suiteClassName();
            String testName = testFailed.testName();
            Option<Throwable> throwable2 = testFailed.throwable();
            Option<Throwable> option = throwable2;
            if (option instanceof Some) {
                Throwable t;
                Some some = (Some)option;
                throwable = t = (Throwable)some.value();
            } else if (None$.MODULE$.equals(option)) {
                throwable = null;
            } else {
                throw new MatchError(option);
            }
            Throwable throwableOrNull = throwable;
            Description description = Description.createSuiteDescription((String)this.testDescriptionName(suiteName, suiteClassName, testName), (Annotation[])new Annotation[0]);
            this.runNotifier.fireTestFailure(new Failure(description, throwableOrNull));
            this.runNotifier.fireTestFinished(description);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (event2 instanceof TestSucceeded) {
            TestSucceeded testSucceeded = (TestSucceeded)event2;
            String suiteName = testSucceeded.suiteName();
            Option<String> suiteClassName = testSucceeded.suiteClassName();
            String testName = testSucceeded.testName();
            this.runNotifier.fireTestFinished(Description.createSuiteDescription((String)this.testDescriptionName(suiteName, suiteClassName, testName), (Annotation[])new Annotation[0]));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (event2 instanceof TestIgnored) {
            TestIgnored testIgnored = (TestIgnored)event2;
            String suiteName = testIgnored.suiteName();
            Option<String> suiteClassName = testIgnored.suiteClassName();
            String testName = testIgnored.testName();
            this.runNotifier.fireTestIgnored(Description.createSuiteDescription((String)this.testDescriptionName(suiteName, suiteClassName, testName), (Annotation[])new Annotation[0]));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (event2 instanceof TestPending) {
            TestPending testPending = (TestPending)event2;
            String suiteName = testPending.suiteName();
            Option<String> suiteClassName = testPending.suiteClassName();
            String testName = testPending.testName();
            this.runNotifier.fireTestIgnored(Description.createSuiteDescription((String)this.testDescriptionName(suiteName, suiteClassName, testName), (Annotation[])new Annotation[0]));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (event2 instanceof SuiteAborted) {
            Throwable throwable;
            SuiteAborted suiteAborted = (SuiteAborted)event2;
            String suiteName = suiteAborted.suiteName();
            Option<String> suiteClassName = suiteAborted.suiteClassName();
            Option<Throwable> throwable3 = suiteAborted.throwable();
            Option<Throwable> option = throwable3;
            if (option instanceof Some) {
                Throwable t;
                Some some = (Some)option;
                throwable = t = (Throwable)some.value();
            } else if (None$.MODULE$.equals(option)) {
                throwable = null;
            } else {
                throw new MatchError(option);
            }
            Throwable throwableOrNull = throwable;
            Description description = Description.createSuiteDescription((String)this.suiteDescriptionName(suiteName, suiteClassName), (Annotation[])new Annotation[0]);
            this.runNotifier.fireTestFailure(new Failure(description, throwableOrNull));
            this.runNotifier.fireTestFinished(description);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (event2 instanceof RunAborted) {
            Throwable throwable;
            RunAborted runAborted = (RunAborted)event2;
            String message = runAborted.message();
            Option<Throwable> throwable4 = runAborted.throwable();
            Option<Throwable> option = throwable4;
            if (option instanceof Some) {
                Throwable t;
                Some some = (Some)option;
                throwable = t = (Throwable)some.value();
            } else if (None$.MODULE$.equals(option)) {
                throwable = null;
            } else {
                throw new MatchError(option);
            }
            Throwable throwableOrNull = throwable;
            String possiblyEmptyMessage = this.messageOrThrowablesDetailMessage(message, throwable4);
            Description description = Description.createSuiteDescription((String)new StringBuilder(1).append(Resources$.MODULE$.runAborted()).append(" ").append(possiblyEmptyMessage).toString(), (Annotation[])new Annotation[0]);
            this.runNotifier.fireTestFailure(new Failure(description, throwableOrNull));
            this.runNotifier.fireTestFinished(description);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    @Override
    public String messageOrThrowablesDetailMessage(String message, Option<Throwable> throwable) {
        String string;
        String trimmedMessage = message.trim();
        if (!trimmedMessage.isEmpty()) {
            string = trimmedMessage;
        } else {
            String string2;
            Option<Throwable> option = throwable;
            if (option instanceof Some) {
                Some some = (Some)option;
                Throwable t = (Throwable)some.value();
                string2 = t.getMessage().trim();
            } else if (None$.MODULE$.equals(option)) {
                string2 = "";
            } else {
                throw new MatchError(option);
            }
            string = string2;
        }
        return string;
    }

    public RunNotifierReporter(RunNotifier runNotifier) {
        this.runNotifier = runNotifier;
    }
}

