/*
 * Decompiled with CFR 0.152.
 */
package org.scalatest.selenium;

import com.google.common.base.Function;
import java.io.File;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.openqa.selenium.Cookie;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.ExpectedCondition;
import org.openqa.selenium.support.ui.Select;
import org.openqa.selenium.support.ui.WebDriverWait;
import org.scalatest.exceptions.ModifiableMessage;
import org.scalatest.exceptions.StackDepthException;
import org.scalatest.exceptions.TestFailedException;
import org.scalatest.selenium.WebBrowser;
import org.scalatest.selenium.WebBrowser$Element$class;
import org.scalatest.time.Milliseconds$;
import org.scalatest.time.Span;
import org.scalatest.time.Span$;
import org.scalatest.time.Units;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Set;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassManifest;
import scala.reflect.Manifest$;
import scala.runtime.BoxesRunTime;

public abstract class WebBrowser$class {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean org$scalatest$selenium$WebBrowser$$isTextField(WebBrowser $this, WebElement webElement2) {
        String string = webElement2.getTagName().toLowerCase();
        String string2 = "input";
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        String string3 = webElement2.getAttribute("type").toLowerCase();
        String string4 = "text";
        if (string3 == null) {
            if (string4 == null) return true;
            return false;
        } else {
            if (!string3.equals(string4)) return false;
            return true;
        }
    }

    public static final boolean org$scalatest$selenium$WebBrowser$$isTextArea(WebBrowser $this, WebElement webElement2) {
        String string = webElement2.getTagName().toLowerCase();
        String string2 = "textarea";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean org$scalatest$selenium$WebBrowser$$isCheckBox(WebBrowser $this, WebElement webElement2) {
        String string = webElement2.getTagName().toLowerCase();
        String string2 = "input";
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        String string3 = webElement2.getAttribute("type").toLowerCase();
        String string4 = "checkbox";
        if (string3 == null) {
            if (string4 == null) return true;
            return false;
        } else {
            if (!string3.equals(string4)) return false;
            return true;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean org$scalatest$selenium$WebBrowser$$isRadioButton(WebBrowser $this, WebElement webElement2) {
        String string = webElement2.getTagName();
        String string2 = "input";
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        String string3 = webElement2.getAttribute("type");
        String string4 = "radio";
        if (string3 == null) {
            if (string4 == null) return true;
            return false;
        } else {
            if (!string3.equals(string4)) return false;
            return true;
        }
    }

    public static void goTo(WebBrowser $this, String url, WebDriver driver) {
        $this.go().to(url, driver);
    }

    public static void goTo(WebBrowser $this, WebBrowser.Page page, WebDriver driver) {
        $this.go().to(page, driver);
    }

    public static void close(WebBrowser $this, WebDriver driver) {
        driver.close();
    }

    public static String title(WebBrowser $this, WebDriver driver) {
        String t = driver.getTitle();
        return t == null ? "" : t;
    }

    public static String pageTitle(WebBrowser $this, WebDriver driver) {
        String t = driver.getTitle();
        return t == null ? "" : t;
    }

    public static String pageSource(WebBrowser $this, WebDriver driver) {
        return driver.getPageSource();
    }

    public static String currentUrl(WebBrowser $this, WebDriver driver) {
        return driver.getCurrentUrl();
    }

    public static WebBrowser.IdQuery id(WebBrowser $this, String elementId) {
        return new WebBrowser.IdQuery($this, elementId);
    }

    public static WebBrowser.NameQuery name(WebBrowser $this, String elementName) {
        return new WebBrowser.NameQuery($this, elementName);
    }

    public static WebBrowser.XPathQuery xpath(WebBrowser $this, String xpath) {
        return new WebBrowser.XPathQuery($this, xpath);
    }

    public static WebBrowser.ClassNameQuery className(WebBrowser $this, String className) {
        return new WebBrowser.ClassNameQuery($this, className);
    }

    public static WebBrowser.CssSelectorQuery cssSelector(WebBrowser $this, String cssSelector) {
        return new WebBrowser.CssSelectorQuery($this, cssSelector);
    }

    public static WebBrowser.LinkTextQuery linkText(WebBrowser $this, String linkText) {
        return new WebBrowser.LinkTextQuery($this, linkText);
    }

    public static WebBrowser.PartialLinkTextQuery partialLinkText(WebBrowser $this, String partialLinkText) {
        return new WebBrowser.PartialLinkTextQuery($this, partialLinkText);
    }

    public static WebBrowser.TagNameQuery tagName(WebBrowser $this, String tagName) {
        return new WebBrowser.TagNameQuery($this, tagName);
    }

    public static final WebBrowser.Element org$scalatest$selenium$WebBrowser$$createTypedElement(WebBrowser $this, WebElement element$1) {
        WebBrowser.Element element2;
        if (WebBrowser$class.org$scalatest$selenium$WebBrowser$$isTextField($this, element$1)) {
            element2 = new WebBrowser.TextField($this, element$1);
        } else if (WebBrowser$class.org$scalatest$selenium$WebBrowser$$isTextArea($this, element$1)) {
            element2 = new WebBrowser.TextArea($this, element$1);
        } else if (WebBrowser$class.org$scalatest$selenium$WebBrowser$$isCheckBox($this, element$1)) {
            element2 = new WebBrowser.Checkbox($this, element$1);
        } else if (WebBrowser$class.org$scalatest$selenium$WebBrowser$$isRadioButton($this, element$1)) {
            element2 = new WebBrowser.RadioButton($this, element$1);
        } else {
            Select select;
            String string = element$1.getTagName().toLowerCase();
            String string2 = "select";
            element2 = !(string != null ? !string.equals(string2) : string2 != null) ? ((select = new Select(element$1)).isMultiple() ? new WebBrowser.MultiSel($this, element$1) : new WebBrowser.SingleSel($this, element$1)) : new WebBrowser.Element($this, element$1){
                private final WebElement underlying;
                private final WebBrowser $outer;

                public WebElement underlying() {
                    return this.underlying;
                }

                public WebBrowser org$scalatest$selenium$WebBrowser$Element$$$outer() {
                    return this.$outer;
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    WebBrowser$Element$class.$init$(this);
                    this.underlying = webElement2;
                }
            };
        }
        return element2;
    }

    public static Option find(WebBrowser $this, WebBrowser.Query query, WebDriver driver) {
        return query.findElement(driver);
    }

    public static Option find(WebBrowser $this, String queryString, WebDriver driver) {
        Option<WebBrowser.Element> option;
        block4: {
            Option<WebBrowser.Element> option2;
            block6: {
                Some some;
                block3: {
                    block5: {
                        block2: {
                            option = new WebBrowser.IdQuery($this, queryString).findElement(driver);
                            if (!(option instanceof Some)) break block2;
                            some = new Some(((Some)option).x());
                            break block3;
                        }
                        None$ none$ = None$.MODULE$;
                        Option<WebBrowser.Element> option3 = option;
                        if (none$ != null ? !none$.equals(option3) : option3 != null) break block4;
                        option2 = new WebBrowser.NameQuery($this, queryString).findElement(driver);
                        if (!(option2 instanceof Some)) break block5;
                        some = new Some(((Some)option2).x());
                        break block3;
                    }
                    None$ none$ = None$.MODULE$;
                    Option<WebBrowser.Element> option4 = option2;
                    if (none$ != null ? !none$.equals(option4) : option4 != null) break block6;
                    some = None$.MODULE$;
                }
                return some;
            }
            throw new MatchError(option2);
        }
        throw new MatchError(option);
    }

    public static Iterator findAll(WebBrowser $this, WebBrowser.Query query, WebDriver driver) {
        return query.findAllElements(driver);
    }

    public static Iterator findAll(WebBrowser $this, String queryString, WebDriver driver) {
        Iterator<WebBrowser.Element> byIdItr = new WebBrowser.IdQuery($this, queryString).findAllElements(driver);
        return byIdItr.hasNext() ? byIdItr : new WebBrowser.NameQuery($this, queryString).findAllElements(driver);
    }

    public static final Object org$scalatest$selenium$WebBrowser$$tryQueries(WebBrowser $this, String queryString, Function1 f, WebDriver driver) {
        Object exceptionResult1 = null;
        try {
            exceptionResult1 = f.apply((Object)new WebBrowser.IdQuery($this, queryString));
        }
        catch (Throwable throwable) {
            exceptionResult1 = f.apply((Object)new WebBrowser.NameQuery($this, queryString));
        }
        return exceptionResult1;
    }

    public static WebBrowser.TextField textField(WebBrowser $this, WebBrowser.Query query, WebDriver driver) {
        return new WebBrowser.TextField($this, query.webElement(driver));
    }

    public static WebBrowser.TextField textField(WebBrowser $this, String queryString, WebDriver driver$1) {
        return (WebBrowser.TextField)WebBrowser$class.org$scalatest$selenium$WebBrowser$$tryQueries($this, queryString, (Function1)new Serializable($this, driver$1){
            public static final long serialVersionUID;
            private final WebBrowser $outer;
            private final WebDriver driver$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final WebBrowser.TextField apply(WebBrowser.Query q) {
                return new WebBrowser.TextField(this.$outer, q.webElement(this.driver$1));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.driver$1 = webDriver;
            }
        }, driver$1);
    }

    public static WebBrowser.TextArea textArea(WebBrowser $this, WebBrowser.Query query, WebDriver driver) {
        return new WebBrowser.TextArea($this, query.webElement(driver));
    }

    public static WebBrowser.TextArea textArea(WebBrowser $this, String queryString, WebDriver driver$2) {
        return (WebBrowser.TextArea)WebBrowser$class.org$scalatest$selenium$WebBrowser$$tryQueries($this, queryString, (Function1)new Serializable($this, driver$2){
            public static final long serialVersionUID;
            private final WebBrowser $outer;
            private final WebDriver driver$2;

            static {
                long l = serialVersionUID = 0L;
            }

            public final WebBrowser.TextArea apply(WebBrowser.Query q) {
                return new WebBrowser.TextArea(this.$outer, q.webElement(this.driver$2));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.driver$2 = webDriver;
            }
        }, driver$2);
    }

    public static WebBrowser.RadioButtonGroup radioButtonGroup(WebBrowser $this, String groupName, WebDriver driver) {
        return new WebBrowser.RadioButtonGroup($this, groupName, driver);
    }

    public static WebBrowser.RadioButton radioButton(WebBrowser $this, WebBrowser.Query query, WebDriver driver) {
        return new WebBrowser.RadioButton($this, query.webElement(driver));
    }

    public static WebBrowser.RadioButton radioButton(WebBrowser $this, String queryString, WebDriver driver$3) {
        return (WebBrowser.RadioButton)WebBrowser$class.org$scalatest$selenium$WebBrowser$$tryQueries($this, queryString, (Function1)new Serializable($this, driver$3){
            public static final long serialVersionUID;
            private final WebBrowser $outer;
            private final WebDriver driver$3;

            static {
                long l = serialVersionUID = 0L;
            }

            public final WebBrowser.RadioButton apply(WebBrowser.Query q) {
                return new WebBrowser.RadioButton(this.$outer, q.webElement(this.driver$3));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.driver$3 = webDriver;
            }
        }, driver$3);
    }

    public static WebBrowser.Checkbox checkbox(WebBrowser $this, WebBrowser.Query query, WebDriver driver) {
        return new WebBrowser.Checkbox($this, query.webElement(driver));
    }

    public static WebBrowser.Checkbox checkbox(WebBrowser $this, String queryString, WebDriver driver$4) {
        return (WebBrowser.Checkbox)WebBrowser$class.org$scalatest$selenium$WebBrowser$$tryQueries($this, queryString, (Function1)new Serializable($this, driver$4){
            public static final long serialVersionUID;
            private final WebBrowser $outer;
            private final WebDriver driver$4;

            static {
                long l = serialVersionUID = 0L;
            }

            public final WebBrowser.Checkbox apply(WebBrowser.Query q) {
                return new WebBrowser.Checkbox(this.$outer, q.webElement(this.driver$4));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.driver$4 = webDriver;
            }
        }, driver$4);
    }

    public static WebBrowser.SingleSel singleSel(WebBrowser $this, WebBrowser.Query query, WebDriver driver) {
        return new WebBrowser.SingleSel($this, query.webElement(driver));
    }

    public static WebBrowser.SingleSel singleSel(WebBrowser $this, String queryString, WebDriver driver$5) {
        return (WebBrowser.SingleSel)WebBrowser$class.org$scalatest$selenium$WebBrowser$$tryQueries($this, queryString, (Function1)new Serializable($this, driver$5){
            public static final long serialVersionUID;
            private final WebBrowser $outer;
            private final WebDriver driver$5;

            static {
                long l = serialVersionUID = 0L;
            }

            public final WebBrowser.SingleSel apply(WebBrowser.Query q) {
                return new WebBrowser.SingleSel(this.$outer, q.webElement(this.driver$5));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.driver$5 = webDriver;
            }
        }, driver$5);
    }

    public static WebBrowser.MultiSel multiSel(WebBrowser $this, WebBrowser.Query query, WebDriver driver) {
        return new WebBrowser.MultiSel($this, query.webElement(driver));
    }

    public static WebBrowser.MultiSel multiSel(WebBrowser $this, String queryString, WebDriver driver$6) {
        return (WebBrowser.MultiSel)WebBrowser$class.org$scalatest$selenium$WebBrowser$$tryQueries($this, queryString, (Function1)new Serializable($this, driver$6){
            public static final long serialVersionUID;
            private final WebBrowser $outer;
            private final WebDriver driver$6;

            static {
                long l = serialVersionUID = 0L;
            }

            public final WebBrowser.MultiSel apply(WebBrowser.Query q) {
                return new WebBrowser.MultiSel(this.$outer, q.webElement(this.driver$6));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.driver$6 = webDriver;
            }
        }, driver$6);
    }

    public static void clickOn(WebBrowser $this, WebElement element2) {
        $this.click().on(element2);
    }

    public static void clickOn(WebBrowser $this, WebBrowser.Query query, WebDriver driver) {
        $this.click().on(query, driver);
    }

    public static void clickOn(WebBrowser $this, String queryString, WebDriver driver) {
        $this.click().on(queryString, driver);
    }

    public static void clickOn(WebBrowser $this, WebBrowser.Element element2) {
        $this.click().on(element2);
    }

    public static void submit(WebBrowser $this, WebDriver driver) {
        try {
            $this.switch().to($this.activeElement(), driver).underlying().submit();
            return;
        }
        catch (Throwable throwable) {
            throw new TestFailedException((Function1<StackDepthException, Option<String>>)new Serializable($this, throwable){
                public static final long serialVersionUID;
                private final Throwable e$3;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final Some<String> apply(StackDepthException sde) {
                    return new Some((Object)new StringBuilder().append((Object)"WebDriver encountered problem to submit(): ").append((Object)this.e$3.getMessage()).toString());
                }
                {
                    this.e$3 = throwable;
                }
            }, (Option<Throwable>)new Some((Object)throwable), (Function1<StackDepthException, Object>)WebBrowser$class.org$scalatest$selenium$WebBrowser$$getStackDepthFun($this, "WebBrowser.scala", "submit", 0));
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new TestFailedException((Function1<StackDepthException, Option<String>>)new Serializable($this){
                public static final long serialVersionUID;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final Some<String> apply(StackDepthException sde) {
                    return new Some((Object)"Current element is not a form element.");
                }
            }, (Option<Throwable>)new Some((Object)noSuchElementException), (Function1<StackDepthException, Object>)WebBrowser$class.org$scalatest$selenium$WebBrowser$$getStackDepthFun($this, "WebBrowser.scala", "name", 1));
        }
    }

    public static void implicitlyWait(WebBrowser $this, Span timeout, WebDriver driver) {
        driver.manage().timeouts().implicitlyWait(timeout.totalNanos(), TimeUnit.NANOSECONDS);
    }

    public static Object wait(WebBrowser $this, Span timeout, Span interval, Function0 f$1, WebDriver driver) {
        return new WebDriverWait(driver, timeout.totalNanos() / 1000000000L, interval.totalNanos() / 1000000L).until((Function)new ExpectedCondition<T>($this, f$1){
            private final Function0 f$1;

            public T apply(WebDriver driver) {
                return (T)this.f$1.apply();
            }
            {
                this.f$1 = function0;
            }
        });
    }

    public static Span wait$default$2(WebBrowser $this) {
        return Span$.MODULE$.apply(500L, (Units)Milliseconds$.MODULE$);
    }

    public static void quit(WebBrowser $this, WebDriver driver) {
        driver.quit();
    }

    public static String windowHandle(WebBrowser $this, WebDriver driver) {
        return driver.getWindowHandle();
    }

    public static Set windowHandles(WebBrowser $this, WebDriver driver) {
        return ((TraversableOnce)JavaConverters$.MODULE$.asScalaSetConverter(driver.getWindowHandles()).asScala()).toSet();
    }

    public static WebBrowser.FrameIndexTarget frame(WebBrowser $this, int index) {
        return new WebBrowser.FrameIndexTarget($this, index);
    }

    public static WebBrowser.FrameNameOrIdTarget frame(WebBrowser $this, String nameOrId) {
        return new WebBrowser.FrameNameOrIdTarget($this, nameOrId);
    }

    public static WebBrowser.FrameWebElementTarget frame(WebBrowser $this, WebElement element2) {
        return new WebBrowser.FrameWebElementTarget($this, element2);
    }

    public static WebBrowser.FrameElementTarget frame(WebBrowser $this, WebBrowser.Element element2) {
        return new WebBrowser.FrameElementTarget($this, element2);
    }

    public static WebBrowser.FrameWebElementTarget frame(WebBrowser $this, WebBrowser.Query query, WebDriver driver) {
        return new WebBrowser.FrameWebElementTarget($this, query.webElement(driver));
    }

    public static WebBrowser.WindowTarget window(WebBrowser $this, String nameOrHandle) {
        return new WebBrowser.WindowTarget($this, nameOrHandle);
    }

    public static Object switchTo(WebBrowser $this, WebBrowser.SwitchTarget target, WebDriver driver) {
        return $this.switch().to(target, driver);
    }

    public static void goBack(WebBrowser $this, WebDriver driver) {
        driver.navigate().back();
    }

    public static void goForward(WebBrowser $this, WebDriver driver) {
        driver.navigate().forward();
    }

    public static void reloadPage(WebBrowser $this, WebDriver driver) {
        driver.navigate().refresh();
    }

    public static WebBrowser.WrappedCookie cookie(WebBrowser $this, String name, WebDriver driver) {
        return WebBrowser$class.org$scalatest$selenium$WebBrowser$$getCookie($this, name, driver);
    }

    public static final WebBrowser.WrappedCookie org$scalatest$selenium$WebBrowser$$getCookie(WebBrowser $this, String name$1, WebDriver driver) {
        Option option = ((TraversableOnce)JavaConverters$.MODULE$.asScalaSetConverter(driver.manage().getCookies()).asScala()).toList().find((Function1)new Serializable($this, name$1){
            public static final long serialVersionUID;
            private final String name$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(Cookie cookie) {
                String string = cookie.getName();
                String string2 = this.name$1;
                return !(string != null ? !string.equals(string2) : string2 != null);
            }
            {
                this.name$1 = string;
            }
        });
        if (option instanceof Some) {
            return new WebBrowser.WrappedCookie($this, (Cookie)((Some)option).x());
        }
        None$ none$ = None$.MODULE$;
        Option option2 = option;
        if (!(none$ != null ? !none$.equals(option2) : option2 != null)) {
            throw new TestFailedException((Function1<StackDepthException, Option<String>>)new Serializable($this, name$1){
                public static final long serialVersionUID;
                private final String name$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final Some<String> apply(StackDepthException sde) {
                    return new Some((Object)new StringBuilder().append((Object)"Cookie '").append((Object)this.name$1).append((Object)"' not found.").toString());
                }
                {
                    this.name$1 = string;
                }
            }, (Option<Throwable>)None$.MODULE$, (Function1<StackDepthException, Object>)WebBrowser$class.org$scalatest$selenium$WebBrowser$$getStackDepthFun($this, "WebBrowser.scala", "getCookie", 1));
        }
        throw new MatchError((Object)option);
    }

    public static void addCookie(WebBrowser $this, String name, String value2, String path, Date expiry, String domain, boolean secure, WebDriver driver) {
        $this.add().cookie(name, value2, path, expiry, domain, secure, driver);
    }

    public static boolean addCookie$default$6(WebBrowser $this) {
        return false;
    }

    public static String addCookie$default$5(WebBrowser $this) {
        return null;
    }

    public static Date addCookie$default$4(WebBrowser $this) {
        return null;
    }

    public static String addCookie$default$3(WebBrowser $this) {
        return "/";
    }

    public static void deleteCookie(WebBrowser $this, String name, WebDriver driver) {
        $this.delete().cookie(name, driver);
    }

    public static void deleteAllCookies(WebBrowser $this, WebDriver driver) {
        $this.delete().all($this.cookies(), driver);
    }

    public static boolean isScreenshotSupported(WebBrowser $this, WebDriver driver) {
        return driver instanceof TakesScreenshot;
    }

    public static void captureTo(WebBrowser $this, String fileName, WebDriver driver) {
        $this.capture().to(fileName, driver);
    }

    public static void setCaptureDir(WebBrowser $this, String targetDirPath) {
        $this.org$scalatest$selenium$WebBrowser$$targetDir_$eq(targetDirPath.endsWith(File.separator) ? new File(targetDirPath) : new File(new StringBuilder().append((Object)targetDirPath).append((Object)File.separator).toString()));
        if (!$this.org$scalatest$selenium$WebBrowser$$targetDir().exists()) {
            $this.org$scalatest$selenium$WebBrowser$$targetDir().mkdirs();
        }
    }

    public static void withScreenshot(WebBrowser $this, Function0 fun, WebDriver driver$8) {
        try {
            fun.apply();
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable2 instanceof Throwable && throwable2 instanceof ModifiableMessage) {
                throw ((ModifiableMessage)((Object)throwable2)).modifyMessage((Function1<Option<String>, Option<String>>)new Serializable($this, driver$8){
                    public static final long serialVersionUID;
                    private final WebBrowser $outer;
                    private final WebDriver driver$8;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final Option<String> apply(Option<String> currentMessage) {
                        Option<String> option;
                        block4: {
                            Some some;
                            block3: {
                                File captureFile;
                                block2: {
                                    captureFile = this.$outer.capture().apply(this.driver$8);
                                    option = currentMessage;
                                    if (!(option instanceof Some)) break block2;
                                    some = new Some((Object)new StringBuilder().append((Object)((String)((Some)option).x())).append((Object)"; screenshot captured in ").append((Object)captureFile.getAbsolutePath()).toString());
                                    break block3;
                                }
                                None$ none$ = None$.MODULE$;
                                Option<String> option2 = option;
                                if (none$ != null ? !none$.equals(option2) : option2 != null) break block4;
                                some = new Some((Object)new StringBuilder().append((Object)"screenshot captured in ").append((Object)captureFile.getAbsolutePath()).toString());
                            }
                            return some;
                        }
                        throw new MatchError(option);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.driver$8 = webDriver;
                    }
                });
            }
            throw throwable;
        }
    }

    public static Object executeScript(WebBrowser $this, String script, Seq args, WebDriver driver) {
        WebDriver webDriver = driver;
        if (webDriver instanceof WebDriver && webDriver instanceof JavascriptExecutor) {
            return ((JavascriptExecutor)webDriver).executeScript(script, (Object[])args.toArray((ClassManifest)Manifest$.MODULE$.Object()));
        }
        throw new UnsupportedOperationException(new StringBuilder().append((Object)"Web driver ").append((Object)driver.getClass().getName()).append((Object)" does not support javascript execution.").toString());
    }

    public static Object executeAsyncScript(WebBrowser $this, String script, Seq args, WebDriver driver) {
        WebDriver webDriver = driver;
        if (webDriver instanceof WebDriver && webDriver instanceof JavascriptExecutor) {
            return ((JavascriptExecutor)webDriver).executeAsyncScript(script, (Object[])args.toArray((ClassManifest)Manifest$.MODULE$.Object()));
        }
        throw new UnsupportedOperationException(new StringBuilder().append((Object)"Web driver ").append((Object)driver.getClass().getName()).append((Object)" does not support javascript execution.").toString());
    }

    public static void setScriptTimeout(WebBrowser $this, Span timeout, WebDriver driver) {
        driver.manage().timeouts().setScriptTimeout(timeout.totalNanos(), TimeUnit.NANOSECONDS);
    }

    public static final Function1 org$scalatest$selenium$WebBrowser$$getStackDepthFun(WebBrowser $this, String fileName$1, String methodName$1, int adjustment$1) {
        return new Serializable($this, fileName$1, methodName$1, adjustment$1){
            public static final long serialVersionUID;
            private final WebBrowser $outer;
            private final String fileName$1;
            private final String methodName$1;
            private final int adjustment$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final int apply(StackDepthException sde) {
                return WebBrowser$class.org$scalatest$selenium$WebBrowser$$getStackDepth(this.$outer, sde.getStackTrace(), this.fileName$1, this.methodName$1, this.adjustment$1);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.fileName$1 = string;
                this.methodName$1 = string2;
                this.adjustment$1 = n;
            }
        };
    }

    /*
     * Unable to fully structure code
     */
    public static final int org$scalatest$selenium$WebBrowser$$getStackDepth(WebBrowser $this, StackTraceElement[] stackTrace, String fileName$2, String methodName$2, int adjustment) {
        stackTraceList = Predef$.MODULE$.refArrayOps((Object[])stackTrace).toList();
        fileNameIsDesiredList = (List)stackTraceList.map((Function1)new Serializable($this, fileName$2){
            public static final long serialVersionUID;
            private final String fileName$2;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(StackTraceElement element2) {
                String string = element2.getFileName();
                String string2 = this.fileName$2;
                return !(string != null ? !string.equals(string2) : string2 != null);
            }
            {
                this.fileName$2 = string;
            }
        }, List$.MODULE$.canBuildFrom());
        methodNameIsDesiredList = (List)stackTraceList.map((Function1)new Serializable($this, methodName$2){
            public static final long serialVersionUID;
            private final String methodName$2;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(StackTraceElement element2) {
                String string = element2.getMethodName();
                String string2 = this.methodName$2;
                return !(string != null ? !string.equals(string2) : string2 != null);
            }
            {
                this.methodName$2 = string;
            }
        }, List$.MODULE$.canBuildFrom());
        var9_8 = false;
        previousFileNameIsDesiredList = ((List)fileNameIsDesiredList.dropRight(1)).$colon$colon((Object)BoxesRunTime.boxToBoolean((boolean)false));
        zipped1 = (List)methodNameIsDesiredList.zip((GenIterable)previousFileNameIsDesiredList, List$.MODULE$.canBuildFrom());
        methodNameAndPreviousFileNameAreDesiredList = (List)((TraversableLike)zipped1.filter((Function1)new Serializable($this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(Tuple2<Object, Object> tuple2) {
                Tuple2<Object, Object> tuple22 = tuple2;
                return tuple22 != null;
            }
        })).map((Function1)new Serializable($this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(Tuple2<Object, Object> tuple2) {
                Tuple2<Object, Object> tuple22 = tuple2;
                if (tuple22 != null) {
                    return BoxesRunTime.unboxToBoolean((Object)tuple22._1()) && BoxesRunTime.unboxToBoolean((Object)tuple22._2());
                }
                throw new MatchError(tuple22);
            }
        }, List$.MODULE$.canBuildFrom());
        zipped2 = (List)fileNameIsDesiredList.zip((GenIterable)methodNameAndPreviousFileNameAreDesiredList, List$.MODULE$.canBuildFrom());
        includeInStackDepthList = (List)((TraversableLike)zipped2.filter((Function1)new Serializable($this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(Tuple2<Object, Object> tuple2) {
                Tuple2<Object, Object> tuple22 = tuple2;
                return tuple22 != null;
            }
        })).map((Function1)new Serializable($this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(Tuple2<Object, Object> tuple2) {
                Tuple2<Object, Object> tuple22 = tuple2;
                if (tuple22 != null) {
                    return BoxesRunTime.unboxToBoolean((Object)tuple22._1()) || BoxesRunTime.unboxToBoolean((Object)tuple22._2());
                }
                throw new MatchError(tuple22);
            }
        }, List$.MODULE$.canBuildFrom());
        includeDepth = includeInStackDepthList.takeWhile((Function1)new Serializable($this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(boolean include) {
                return include;
            }
        }).length();
        if (includeDepth != 0) ** GOTO lbl-1000
        v0 = stackTrace[0].getFileName();
        var16_15 = fileName$2;
        if (!(v0 == null ? var16_15 != null : v0.equals(var16_15) == false)) ** GOTO lbl-1000
        v1 = stackTrace[0].getMethodName();
        var17_16 = methodName$2;
        if (v1 == null ? var17_16 != null : v1.equals(var17_16) == false) {
            v2 = stackTraceList.takeWhile((Function1)new Serializable($this, fileName$2, methodName$2){
                public static final long serialVersionUID;
                private final String fileName$2;
                private final String methodName$2;

                static {
                    long l = serialVersionUID = 0L;
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final boolean apply(StackTraceElement st) {
                    String string = st.getFileName();
                    String string2 = this.fileName$2;
                    if (string == null) {
                        if (string2 != null) {
                            return true;
                        }
                    } else if (!string.equals(string2)) return true;
                    String string3 = st.getMethodName();
                    String string4 = this.methodName$2;
                    if (string3 == null) {
                        if (string4 == null) return false;
                        return true;
                    } else {
                        if (!string3.equals(string4)) return true;
                        return false;
                    }
                }
                {
                    this.fileName$2 = string;
                    this.methodName$2 = string2;
                }
            }).length();
        } else lbl-1000:
        // 3 sources

        {
            v2 = includeDepth;
        }
        depth = v2;
        return depth + adjustment;
    }

    private static int getStackDepth$default$4(WebBrowser $this) {
        return 0;
    }

    private static int getStackDepthFun$default$3(WebBrowser $this) {
        return 0;
    }

    public static void enter(WebBrowser $this, String value2, WebDriver driver) {
        block4: {
            block3: {
                WebBrowser.Element element2;
                block2: {
                    WebBrowser.Element ae = $this.switch().to($this.activeElement(), driver);
                    element2 = ae;
                    if (!(element2 instanceof WebBrowser.TextField)) break block2;
                    ((WebBrowser.TextField)element2).value_$eq(value2);
                    break block3;
                }
                if (!(element2 instanceof WebBrowser.TextArea)) break block4;
                ((WebBrowser.TextArea)element2).value_$eq(value2);
            }
            return;
        }
        throw new TestFailedException((Function1<StackDepthException, Option<String>>)new Serializable($this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Some<String> apply(StackDepthException sde) {
                return new Some((Object)"Currently selected element is neither a text field nor a text area");
            }
        }, (Option<Throwable>)None$.MODULE$, (Function1<StackDepthException, Object>)WebBrowser$class.org$scalatest$selenium$WebBrowser$$getStackDepthFun($this, "WebBrowser.scala", "switch", 1));
    }

    public static void pressKeys(WebBrowser $this, String value2, WebDriver driver) {
        WebElement ae = driver.switchTo().activeElement();
        ae.sendKeys(new CharSequence[]{value2});
    }

    public static void $init$(WebBrowser $this) {
        $this.org$scalatest$selenium$WebBrowser$_setter_$cookies_$eq(new WebBrowser.CookiesNoun($this));
        $this.org$scalatest$selenium$WebBrowser$_setter_$activeElement_$eq(new WebBrowser.ActiveElementTarget($this));
        $this.org$scalatest$selenium$WebBrowser$_setter_$alert_$eq(new WebBrowser.AlertTarget($this));
        $this.org$scalatest$selenium$WebBrowser$_setter_$defaultContent_$eq(new WebBrowser.DefaultContentTarget($this));
        $this.org$scalatest$selenium$WebBrowser$$targetDir_$eq(new File(System.getProperty("java.io.tmpdir")));
    }
}

