/*
 * Decompiled with CFR 0.152.
 */
package org.scalatestplus.junit;

import junit.framework.AssertionFailedError;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestListener;
import org.scalactic.NameUtil$;
import org.scalactic.Prettifier$;
import org.scalactic.Requirements$;
import org.scalactic.source.Position;
import org.scalactic.source.Position$;
import org.scalatest.Reporter;
import org.scalatest.StatefulStatus;
import org.scalatest.Tracker;
import org.scalatest.events.Event;
import org.scalatest.events.IndentedText;
import org.scalatest.events.MotionToSuppress$;
import org.scalatest.events.SeeStackDepthException$;
import org.scalatest.events.TestFailed$;
import org.scalatest.events.TestStarting$;
import org.scalatest.events.TestSucceeded$;
import org.scalatest.events.TopOfMethod;
import org.scalatest.events.TopOfMethod$;
import org.scalatest.exceptions.PayloadField;
import org.scalatestplus.junit.JUnit3Suite;
import org.scalatestplus.junit.JUnitHelper$;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Some$;
import scala.collection.IterableOnceOps;
import scala.collection.SeqOps;
import scala.collection.immutable.ArraySeq;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;

public class MyTestListener
implements TestListener {
    private final Reporter report;
    private final Tracker tracker;
    private final StatefulStatus status;
    private final Set<Test> failedTestsSet;

    public MyTestListener(Reporter report, Tracker tracker, StatefulStatus status) {
        this.report = report;
        this.tracker = tracker;
        this.status = status;
        this.failedTestsSet = (Set)Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Test[0]));
    }

    private String getSuiteNameForTestCase(Test testCase) {
        String string;
        Test test = testCase;
        if (test instanceof JUnit3Suite) {
            JUnit3Suite junit3Suite = (JUnit3Suite)test;
            string = junit3Suite.suiteName();
        } else {
            string = NameUtil$.MODULE$.getSimpleNameOfAnObjectsClass((Object)testCase);
        }
        return string;
    }

    public String getMessageGivenThrowable(Throwable throwable, boolean isAssertionFailedError) {
        return throwable.getMessage() == null ? "A JUnit3Suite test failed with an " + (isAssertionFailedError ? "AssertionFailedError" : "exception") : throwable.getMessage();
    }

    public Some<TopOfMethod> getTopOfMethod(String className, String methodName) {
        return Some$.MODULE$.apply((Object)TopOfMethod$.MODULE$.apply(className, "public void " + className + "." + methodName + "()"));
    }

    public void startTest(Test testCase) {
        ArraySeq arguments$proxy1 = ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{testCase});
        Position pos$proxy1 = Position$.MODULE$.apply("JUnit3Suite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 311);
        String string = "testCase";
        Requirements$.MODULE$.requirementsHelper().macroRequireNonNull((String[])((IterableOnceOps)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Nothing$[0]))).$plus$colon((Object)string)).toArray(ClassTag$.MODULE$.apply(String.class)), (Object[])arguments$proxy1.toArray(ClassTag$.MODULE$.Any()), Prettifier$.MODULE$.default(), pos$proxy1);
        String suiteName = this.getSuiteNameForTestCase(testCase);
        this.report.apply((Event)TestStarting$.MODULE$.apply(this.tracker.nextOrdinal(), suiteName, testCase.getClass().getName(), (Option)Some$.MODULE$.apply((Object)testCase.getClass().getName()), testCase.toString(), testCase.toString(), (Option)Some$.MODULE$.apply((Object)MotionToSuppress$.MODULE$), this.getTopOfMethod(testCase.getClass().getName(), ((TestCase)testCase).getName()), TestStarting$.MODULE$.$lessinit$greater$default$9(), TestStarting$.MODULE$.$lessinit$greater$default$10(), TestStarting$.MODULE$.$lessinit$greater$default$11(), TestStarting$.MODULE$.$lessinit$greater$default$12()));
    }

    public void addError(Test testCase, Throwable throwable) {
        None$ none$;
        ArraySeq arguments$proxy2 = ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{testCase, throwable});
        Position pos$proxy2 = Position$.MODULE$.apply("JUnit3Suite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 318);
        String string = "testCase";
        String string2 = "throwable";
        Requirements$.MODULE$.requirementsHelper().macroRequireNonNull((String[])((IterableOnceOps)((SeqOps)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Nothing$[0]))).$plus$colon((Object)string2)).$plus$colon((Object)string)).toArray(ClassTag$.MODULE$.apply(String.class)), (Object[])arguments$proxy2.toArray(ClassTag$.MODULE$.Any()), Prettifier$.MODULE$.default(), pos$proxy2);
        IndentedText formatter = JUnitHelper$.MODULE$.getIndentedTextForTest(testCase.toString(), 1, true);
        String suiteName = this.getSuiteNameForTestCase(testCase);
        Throwable throwable2 = throwable;
        if (throwable2 instanceof PayloadField) {
            Throwable optPayload = (Throwable)((PayloadField)throwable2);
            none$ = ((PayloadField)optPayload).payload();
        } else {
            none$ = None$.MODULE$;
        }
        None$ payload = none$;
        this.report.apply((Event)TestFailed$.MODULE$.apply(this.tracker.nextOrdinal(), this.getMessageGivenThrowable(throwable, false), suiteName, testCase.getClass().getName(), (Option)Some$.MODULE$.apply((Object)testCase.getClass().getName()), testCase.toString(), testCase.toString(), (IndexedSeq)package$.MODULE$.Vector().empty(), (IndexedSeq)package$.MODULE$.Vector().empty(), (Option)Some$.MODULE$.apply((Object)throwable), (Option)None$.MODULE$, (Option)Some$.MODULE$.apply((Object)formatter), (Option)Some$.MODULE$.apply((Object)SeeStackDepthException$.MODULE$), (Option)None$.MODULE$, (Option)payload, TestFailed$.MODULE$.$lessinit$greater$default$16(), TestFailed$.MODULE$.$lessinit$greater$default$17()));
        this.failedTestsSet.$plus$eq((Object)testCase);
    }

    public void addFailure(Test testCase, AssertionFailedError assertionFailedError) {
        ArraySeq arguments$proxy3 = ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{testCase, assertionFailedError});
        Position pos$proxy3 = Position$.MODULE$.apply("JUnit3Suite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 336);
        String string = "testCase";
        String string2 = "assertionFailedError";
        Requirements$.MODULE$.requirementsHelper().macroRequireNonNull((String[])((IterableOnceOps)((SeqOps)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Nothing$[0]))).$plus$colon((Object)string2)).$plus$colon((Object)string)).toArray(ClassTag$.MODULE$.apply(String.class)), (Object[])arguments$proxy3.toArray(ClassTag$.MODULE$.Any()), Prettifier$.MODULE$.default(), pos$proxy3);
        IndentedText formatter = JUnitHelper$.MODULE$.getIndentedTextForTest(testCase.toString(), 1, true);
        String suiteName = this.getSuiteNameForTestCase(testCase);
        this.report.apply((Event)TestFailed$.MODULE$.apply(this.tracker.nextOrdinal(), this.getMessageGivenThrowable((Throwable)assertionFailedError, true), suiteName, testCase.getClass().getName(), (Option)Some$.MODULE$.apply((Object)testCase.getClass().getName()), testCase.toString(), testCase.toString(), (IndexedSeq)package$.MODULE$.Vector().empty(), (IndexedSeq)package$.MODULE$.Vector().empty(), (Option)Some$.MODULE$.apply((Object)assertionFailedError), (Option)None$.MODULE$, (Option)Some$.MODULE$.apply((Object)formatter), (Option)Some$.MODULE$.apply((Object)SeeStackDepthException$.MODULE$), (Option)None$.MODULE$, TestFailed$.MODULE$.$lessinit$greater$default$15(), TestFailed$.MODULE$.$lessinit$greater$default$16(), TestFailed$.MODULE$.$lessinit$greater$default$17()));
        this.failedTestsSet.$plus$eq((Object)testCase);
    }

    public void endTest(Test testCase) {
        boolean testHadFailed = this.failedTestsSet.contains((Object)testCase);
        if (!testHadFailed) {
            ArraySeq arguments$proxy4 = ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{testCase});
            Position pos$proxy4 = Position$.MODULE$.apply("JUnit3Suite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 350);
            String string = "testCase";
            Requirements$.MODULE$.requirementsHelper().macroRequireNonNull((String[])((IterableOnceOps)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Nothing$[0]))).$plus$colon((Object)string)).toArray(ClassTag$.MODULE$.apply(String.class)), (Object[])arguments$proxy4.toArray(ClassTag$.MODULE$.Any()), Prettifier$.MODULE$.default(), pos$proxy4);
            IndentedText formatter = JUnitHelper$.MODULE$.getIndentedTextForTest(testCase.toString(), 1, true);
            String suiteName = this.getSuiteNameForTestCase(testCase);
            this.report.apply((Event)TestSucceeded$.MODULE$.apply(this.tracker.nextOrdinal(), suiteName, testCase.getClass().getName(), (Option)Some$.MODULE$.apply((Object)testCase.getClass().getName()), testCase.toString(), testCase.toString(), (IndexedSeq)package$.MODULE$.Vector().empty(), (Option)None$.MODULE$, (Option)Some$.MODULE$.apply((Object)formatter), this.getTopOfMethod(testCase.getClass().getName(), ((TestCase)testCase).getName()), TestSucceeded$.MODULE$.$lessinit$greater$default$11(), TestSucceeded$.MODULE$.$lessinit$greater$default$12(), TestSucceeded$.MODULE$.$lessinit$greater$default$13(), TestSucceeded$.MODULE$.$lessinit$greater$default$14()));
        } else {
            this.failedTestsSet.$minus$eq((Object)testCase);
            this.status.setFailed();
        }
    }
}

