/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.scalate.util;

import java.io.File;
import java.io.Serializable;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.fusesource.scalate.util.ClassPathBuilder$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Seq;
import scala.collection.StrictOptimizedIterableOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.package$;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;

public class ClassPathBuilder {
    private final ArrayBuffer<String> classpath = new ArrayBuffer();
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(ClassPathBuilder$.class.getDeclaredField("log$lzy1"));

    public static void debug(Function0<String> function0, scala.collection.immutable.Seq<Object> seq) {
        ClassPathBuilder$.MODULE$.debug((Function0)function0, (scala.collection.immutable.Seq)seq);
    }

    public static void debug(Throwable throwable) {
        ClassPathBuilder$.MODULE$.debug(throwable);
    }

    public static void debug(Throwable throwable, Function0<String> function0, scala.collection.immutable.Seq<Object> seq) {
        ClassPathBuilder$.MODULE$.debug(throwable, (Function0)function0, (scala.collection.immutable.Seq)seq);
    }

    public static void error(Function0<String> function0, scala.collection.immutable.Seq<Object> seq) {
        ClassPathBuilder$.MODULE$.error((Function0)function0, (scala.collection.immutable.Seq)seq);
    }

    public static void error(Throwable throwable) {
        ClassPathBuilder$.MODULE$.error(throwable);
    }

    public static void error(Throwable throwable, Function0<String> function0, scala.collection.immutable.Seq<Object> seq) {
        ClassPathBuilder$.MODULE$.error(throwable, (Function0)function0, (scala.collection.immutable.Seq)seq);
    }

    public static scala.collection.immutable.Seq<String> getClassPathFrom(ClassLoader classLoader) {
        return ClassPathBuilder$.MODULE$.getClassPathFrom(classLoader);
    }

    public static void info(Function0<String> function0, scala.collection.immutable.Seq<Object> seq) {
        ClassPathBuilder$.MODULE$.info((Function0)function0, (scala.collection.immutable.Seq)seq);
    }

    public static void info(Throwable throwable) {
        ClassPathBuilder$.MODULE$.info(throwable);
    }

    public static void info(Throwable throwable, Function0<String> function0, scala.collection.immutable.Seq<Object> seq) {
        ClassPathBuilder$.MODULE$.info(throwable, (Function0)function0, (scala.collection.immutable.Seq)seq);
    }

    public static scala.collection.immutable.Seq<String> javaClassPath() {
        return ClassPathBuilder$.MODULE$.javaClassPath();
    }

    public static Logger log() {
        return ClassPathBuilder$.MODULE$.log();
    }

    public static void trace(Function0<String> function0, scala.collection.immutable.Seq<Object> seq) {
        ClassPathBuilder$.MODULE$.trace((Function0)function0, (scala.collection.immutable.Seq)seq);
    }

    public static void trace(Throwable throwable) {
        ClassPathBuilder$.MODULE$.trace(throwable);
    }

    public static void trace(Throwable throwable, Function0<String> function0, scala.collection.immutable.Seq<Object> seq) {
        ClassPathBuilder$.MODULE$.trace(throwable, (Function0)function0, (scala.collection.immutable.Seq)seq);
    }

    public static void warn(Function0<String> function0, scala.collection.immutable.Seq<Object> seq) {
        ClassPathBuilder$.MODULE$.warn((Function0)function0, (scala.collection.immutable.Seq)seq);
    }

    public static void warn(Throwable throwable) {
        ClassPathBuilder$.MODULE$.warn(throwable);
    }

    public static void warn(Throwable throwable, Function0<String> function0, scala.collection.immutable.Seq<Object> seq) {
        ClassPathBuilder$.MODULE$.warn(throwable, (Function0)function0, (scala.collection.immutable.Seq)seq);
    }

    public String classPath() {
        ArrayBuffer cp = (ArrayBuffer)this.classpath.distinct();
        ArrayBuffer all = (ArrayBuffer)((StrictOptimizedIterableOps)cp.$plus$plus(this.findManifestEntries((Seq<String>)cp))).map((Function1 & Serializable)s -> {
            File f = new File((String)s);
            if (f.exists()) {
                return f.getCanonicalPath();
            }
            return s;
        });
        return ((IterableOnceOps)all.distinct()).mkString(File.pathSeparator);
    }

    public Seq<String> findManifestEntries(Seq<String> cp) {
        return (Seq)cp.flatMap((Function1 & Serializable)p -> {
            Nil$ answer;
            block3: {
                answer = package$.MODULE$.Nil();
                File f = new File((String)p);
                if (!f.exists() || !f.isFile()) break block3;
                File parent = f.getParentFile();
                try {
                    Attributes attrs;
                    Object v;
                    JarFile jar = new JarFile(f);
                    Manifest m = jar.getManifest();
                    if (m != null && (v = (attrs = m.getMainAttributes()).get(Attributes.Name.CLASS_PATH)) != null) {
                        Object object = Predef$.MODULE$.refArrayOps((Object[])v.toString().trim().split("\\s+"));
                        answer = (scala.collection.immutable.Seq)ArrayOps$.MODULE$.toIndexedSeq$extension(object).map((Function1 & Serializable)n -> {
                            if (new File((String)n).exists()) {
                                return n;
                            }
                            return new File(parent, (String)n).getPath();
                        });
                        ClassPathBuilder$.MODULE$.debug(ClassPathBuilder::findManifestEntries$$anonfun$1$$anonfun$2, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{answer, f}));
                    }
                }
                catch (Exception e) {
                    ClassPathBuilder$.MODULE$.debug((Throwable)e, ClassPathBuilder::findManifestEntries$$anonfun$1$$anonfun$3, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{f}));
                }
            }
            return answer;
        });
    }

    public ClassPathBuilder addClassesDir(String dir) {
        return this.addEntry(dir);
    }

    public ClassPathBuilder addEntry(String path) {
        if (path != null && StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(path))) {
            this.classpath.$plus$eq((Object)path);
        }
        return this;
    }

    public ClassPathBuilder addJar(String jar) {
        return this.addEntry(jar);
    }

    public ClassPathBuilder addLibDir(String dir) {
        if (dir != null) {
            this.classpath.$plus$plus$eq((IterableOnce)ClassPathBuilder.listJars$1(new File(dir)));
        }
        return this;
    }

    public ClassPathBuilder addPathFrom(Class<?> clazz) {
        if (clazz != null) {
            this.addPathFrom(clazz.getClassLoader());
        }
        return this;
    }

    public ClassPathBuilder addPathFromContextClassLoader() {
        this.addPathFrom(Thread.currentThread().getContextClassLoader());
        return this;
    }

    public ClassPathBuilder addPathFromSystemClassLoader() {
        this.addPathFrom(ClassLoader.getSystemClassLoader());
        return this;
    }

    public ClassPathBuilder addPathFrom(ClassLoader loader) {
        this.classpath.$plus$plus$eq(ClassPathBuilder$.MODULE$.getClassPathFrom(loader));
        return this;
    }

    public ClassPathBuilder addJavaPath() {
        this.classpath.$plus$plus$eq(ClassPathBuilder$.MODULE$.javaClassPath());
        return this;
    }

    private static final String findManifestEntries$$anonfun$1$$anonfun$2() {
        return "Found manifest classpath values %s in ";
    }

    private static final String findManifestEntries$$anonfun$1$$anonfun$3() {
        return "Ignoring exception trying to open jar file: %s";
    }

    private static final scala.collection.immutable.Seq makeSeq$1(File[] a) {
        if (a == null) {
            return package$.MODULE$.Nil();
        }
        Object object = Predef$.MODULE$.refArrayOps((Object[])a);
        return ArrayOps$.MODULE$.toIndexedSeq$extension(object);
    }

    private static final scala.collection.immutable.Seq listJars$1(File root) {
        if (root.isFile()) {
            return (scala.collection.immutable.Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{root.toString()}));
        }
        return (scala.collection.immutable.Seq)ClassPathBuilder.makeSeq$1(root.listFiles()).flatMap((Function1 & Serializable)f -> ClassPathBuilder.listJars$1(f));
    }
}

