/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.scalate.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import org.fusesource.scalate.util.FileResource$;
import org.fusesource.scalate.util.Files$;
import org.fusesource.scalate.util.IOUtil$;
import org.fusesource.scalate.util.WriteableResource;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.Some$;
import scala.collection.Iterable;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public class FileResource
implements WriteableResource,
Product,
Serializable {
    private final File file;
    private final String uri;

    public static FileResource apply(File file, String string) {
        return FileResource$.MODULE$.apply(file, string);
    }

    public static FileResource fromProduct(Product product) {
        return FileResource$.MODULE$.fromProduct(product);
    }

    public static FileResource unapply(FileResource fileResource) {
        return FileResource$.MODULE$.unapply(fileResource);
    }

    public FileResource(File file, String uri) {
        this.file = file;
        this.uri = uri;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof FileResource)) return false;
        FileResource fileResource = (FileResource)object;
        File file = this.file();
        File file2 = fileResource.file();
        if (file == null) {
            if (file2 != null) {
                return false;
            }
        } else if (!((Object)file).equals(file2)) return false;
        String string = this.uri();
        String string2 = fileResource.uri();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        if (!fileResource.canEqual(this)) return false;
        return true;
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof FileResource;
    }

    public int productArity() {
        return 2;
    }

    public String productPrefix() {
        return "FileResource";
    }

    public Object productElement(int n) {
        int n2 = n;
        if (0 == n2) {
            return this._1();
        }
        if (1 == n2) {
            return this._2();
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        if (0 == n2) {
            return "file";
        }
        if (1 == n2) {
            return "uri";
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public File file() {
        return this.file;
    }

    @Override
    public String uri() {
        return this.uri;
    }

    @Override
    public String text() {
        return IOUtil$.MODULE$.loadTextFile(this.file(), IOUtil$.MODULE$.loadTextFile$default$2());
    }

    @Override
    public Reader reader() {
        return new FileReader(this.file());
    }

    @Override
    public InputStream inputStream() {
        return new FileInputStream(this.file());
    }

    @Override
    public OutputStream outputStream() {
        return new FileOutputStream(this.file());
    }

    @Override
    public long lastModified() {
        return this.file().lastModified();
    }

    public FileResource $div(String name) {
        return FileResource$.MODULE$.apply(new File(this.file(), name), new StringBuilder(1).append(this.uri()).append("/").append(name).toString());
    }

    public File asFile() {
        return this.file();
    }

    @Override
    public Option<File> toFile() {
        return Some$.MODULE$.apply((Object)this.file());
    }

    public String name() {
        return this.file().getName();
    }

    public String extension() {
        return Files$.MODULE$.extension(this.name());
    }

    public String nameDropExtension() {
        return Files$.MODULE$.dropExtension(this.name());
    }

    public Option<File> recursiveFind(Function1<File, Object> f) {
        return Files$.MODULE$.recursiveFind(this.file(), f);
    }

    public Iterable<File> children() {
        return Files$.MODULE$.children(this.file());
    }

    public Iterable<File> descendants() {
        return Files$.MODULE$.descendants(this.file());
    }

    public Iterable<File> andDescendants() {
        return Files$.MODULE$.andDescendants(this.file());
    }

    public String relativeUri(File root) {
        return Files$.MODULE$.relativeUri(root, this.file());
    }

    public FileResource copy(File file, String uri) {
        return new FileResource(file, uri);
    }

    public File copy$default$1() {
        return this.file();
    }

    public String copy$default$2() {
        return this.uri();
    }

    public File _1() {
        return this.file();
    }

    public String _2() {
        return this.uri();
    }
}

