/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.scalate.util;

import java.io.File;
import java.io.Serializable;
import java.net.URL;
import org.fusesource.scalate.util.FileResourceLoader$;
import org.fusesource.scalate.util.Resource;
import org.fusesource.scalate.util.Resource$;
import org.fusesource.scalate.util.ResourceLoader;
import org.fusesource.scalate.util.ResourceLoader$;
import org.fusesource.scalate.util.ResourceNotFoundException;
import org.fusesource.scalate.util.ResourceNotFoundException$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

public class FileResourceLoader
implements ResourceLoader,
Product,
Serializable {
    private String pageFileEncoding;
    private final Iterable sourceDirectories;

    public static FileResourceLoader apply(Iterable<File> iterable) {
        return FileResourceLoader$.MODULE$.apply(iterable);
    }

    public static FileResourceLoader fromProduct(Product product) {
        return FileResourceLoader$.MODULE$.fromProduct(product);
    }

    public static FileResourceLoader unapply(FileResourceLoader fileResourceLoader) {
        return FileResourceLoader$.MODULE$.unapply(fileResourceLoader);
    }

    public static Iterable<File> $lessinit$greater$default$1() {
        return FileResourceLoader$.MODULE$.$lessinit$greater$default$1();
    }

    public FileResourceLoader(Iterable<File> sourceDirectories) {
        this.sourceDirectories = sourceDirectories;
        ResourceLoader.$init$(this);
        Statics.releaseFence();
    }

    @Override
    public String pageFileEncoding() {
        return this.pageFileEncoding;
    }

    @Override
    public void org$fusesource$scalate$util$ResourceLoader$_setter_$pageFileEncoding_$eq(String x$0) {
        this.pageFileEncoding = x$0;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof FileResourceLoader)) return false;
        FileResourceLoader fileResourceLoader = (FileResourceLoader)object;
        Iterable<File> iterable = this.sourceDirectories();
        Iterable<File> iterable2 = fileResourceLoader.sourceDirectories();
        if (iterable == null) {
            if (iterable2 != null) {
                return false;
            }
        } else if (!iterable.equals(iterable2)) return false;
        if (!fileResourceLoader.canEqual(this)) return false;
        return true;
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof FileResourceLoader;
    }

    public int productArity() {
        return 1;
    }

    public String productPrefix() {
        return "FileResourceLoader";
    }

    public Object productElement(int n) {
        int n2 = n;
        if (0 == n2) {
            return this._1();
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        if (0 == n2) {
            return "sourceDirectories";
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public Iterable<File> sourceDirectories() {
        return this.sourceDirectories;
    }

    @Override
    public Option<Resource> resource(String uri) {
        ResourceLoader$.MODULE$.debug(() -> FileResourceLoader.resource$$anonfun$1(uri), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]));
        if (uri != null) {
            File file = this.toFile(uri);
            if (file != null && file.exists() && file.isFile()) {
                if (!file.canRead()) {
                    String string = new StringBuilder(20).append("Could not read from ").append(file.getAbsolutePath()).toString();
                    String string2 = ResourceNotFoundException$.MODULE$.$lessinit$greater$default$2();
                    throw new ResourceNotFoundException(uri, string2, string);
                }
                return Some$.MODULE$.apply((Object)Resource$.MODULE$.fromFile(file));
            }
            String relativeUri = StringOps$.MODULE$.stripPrefix$extension(Predef$.MODULE$.augmentString(uri), "/");
            URL url = Thread.currentThread().getContextClassLoader().getResource(relativeUri);
            if (url == null) {
                url = this.getClass().getClassLoader().getResource(relativeUri);
            }
            if (url != null) {
                return Some$.MODULE$.apply((Object)Resource$.MODULE$.fromURL(url));
            }
        }
        return None$.MODULE$;
    }

    public File toFile(String uri) {
        Option option = ((IterableOnceOps)this.sourceDirectories().view().map((Function1 & Serializable)_$1 -> new File((File)_$1, uri))).find((Function1 & Serializable)_$2 -> _$2.exists());
        if (option instanceof Some) {
            File file = (File)((Some)option).value();
            return file;
        }
        return new File(uri);
    }

    public FileResourceLoader copy(Iterable<File> sourceDirectories) {
        return new FileResourceLoader(sourceDirectories);
    }

    public Iterable<File> copy$default$1() {
        return this.sourceDirectories();
    }

    public Iterable<File> _1() {
        return this.sourceDirectories();
    }

    private static final String resource$$anonfun$1(String uri$1) {
        return new StringBuilder(20).append("Trying to load uri: ").append(uri$1).toString();
    }
}

