/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.scalate.util;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.net.URL;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.fusesource.scalate.util.FileResource;
import org.fusesource.scalate.util.FileResource$;
import org.fusesource.scalate.util.IOUtil;
import org.fusesource.scalate.util.Log;
import org.fusesource.scalate.util.Log$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.util.matching.Regex;
import scala.util.parsing.input.OffsetPosition$;
import scala.util.parsing.input.Position;

public final class IOUtil$
implements Serializable {
    private static final Log log;
    private static final Regex includeRegEx;
    public static final IOUtil$ MODULE$;

    private IOUtil$() {
    }

    static {
        MODULE$ = new IOUtil$();
        log = Log$.MODULE$.apply(MODULE$.getClass());
        includeRegEx = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("@@include\\(\\\"(.+)\\\"\\)"));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(IOUtil$.class);
    }

    public Log log() {
        return log;
    }

    public FileResource toResource(File file) {
        return FileResource$.MODULE$.apply(file, file.getPath());
    }

    public File toFile(FileResource resource) {
        return resource.asFile();
    }

    public void makeParentDirs(String fileName) {
        this.makeParentDirs(new File(fileName));
    }

    public void makeParentDirs(File file) {
        File parent = file.getParentFile();
        if (parent != null) {
            parent.mkdirs();
            return;
        }
    }

    public boolean recursiveDelete(File file) {
        Object[] children;
        if (file.isDirectory() && (children = file.listFiles()) != null) {
            Object object = Predef$.MODULE$.refArrayOps(children);
            ArrayOps$.MODULE$.foreach$extension(object, (Function1 & Serializable)child -> this.recursiveDelete((File)child));
        }
        return file.delete();
    }

    public Regex includeRegEx() {
        return includeRegEx;
    }

    public String mergeIncludes(String sourceCode, String encoding) {
        Regex.MatchIterator matches = this.includeRegEx().findAllIn((CharSequence)sourceCode);
        if (!matches.hasNext()) {
            return sourceCode;
        }
        return (String)matches.foldLeft((Object)sourceCode, (Function2 & Serializable)(result, include) -> {
            String string;
            try {
                String string2;
                List list;
                Option option;
                String string3 = include;
                if (string3 == null || (option = this.includeRegEx().unapplySeq((CharSequence)string3)).isEmpty() || (list = (List)option.get()).lengthCompare(1) != 0) {
                    throw new MatchError((Object)string3);
                }
                String fileName = string2 = (String)list.apply(0);
                String fileName2 = fileName;
                string = this.loadTextFile(new File(fileName2), encoding);
            }
            catch (MatchError m) {
                throw new IOUtil.InvalidDirectiveException("include", (Position)OffsetPosition$.MODULE$.apply((CharSequence)include, 0));
            }
            catch (FileNotFoundException n) {
                throw n;
            }
            String includeSource = string;
            return result.replace((CharSequence)include, includeSource);
        });
    }

    public String mergeIncludes$default$2() {
        return "UTF-8";
    }

    public String loadText(InputStream in, String encoding) {
        String sourceCode = new String(this.loadBytes(in), encoding);
        return this.mergeIncludes(sourceCode, encoding);
    }

    public String loadText$default$2() {
        return "UTF-8";
    }

    public String loadTextFile(File path, String encoding) {
        String sourceCode = new String(this.loadBinaryFile(path), encoding);
        return this.mergeIncludes(sourceCode, encoding);
    }

    public String loadTextFile$default$2() {
        return "UTF-8";
    }

    public byte[] loadBinaryFile(File path) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (FileInputStream in = new FileInputStream(path);){
            this.copy((InputStream)in, (OutputStream)baos);
        }
        return baos.toByteArray();
    }

    public byte[] loadBytes(InputStream in) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            this.copy(in, (OutputStream)baos);
        }
        finally {
            in.close();
        }
        return baos.toByteArray();
    }

    public void writeText(String path, String text) {
        this.writeText(new File(path), text);
    }

    public void writeText(File path, String text) {
        this.writeText(new FileWriter(path), text);
    }

    public void writeText(OutputStream stream, String text) {
        this.writeText(new OutputStreamWriter(stream), text);
    }

    public void writeText(Writer out, String text) {
        try {
            out.write(text);
        }
        finally {
            out.close();
        }
    }

    public void writeBinaryFile(String path, byte[] contents) {
        this.writeBinaryFile(new File(path), contents);
    }

    public void writeBinaryFile(File path, byte[] contents) {
        try (FileOutputStream out = new FileOutputStream(path);){
            out.write(contents);
        }
    }

    public long copy(File in, File out) {
        out.getParentFile().mkdirs();
        return this.copy((InputStream)new FileInputStream(in), (OutputStream)new FileOutputStream(out));
    }

    public long copy(File file, OutputStream out) {
        return this.copy((InputStream)new BufferedInputStream(new FileInputStream(file)), out);
    }

    public long copy(InputStream in, File file) {
        long l;
        try (FileOutputStream out = new FileOutputStream(file);){
            l = this.copy(in, (OutputStream)out);
        }
        return l;
    }

    public long copy(URL url, File file) {
        long l;
        try (InputStream in = url.openStream();){
            l = this.copy(in, file);
        }
        return l;
    }

    public <R, C extends Closeable> R using(C c, Function1<C, R> func) {
        Object object;
        try {
            object = func.apply(c);
        }
        catch (Throwable throwable) {
            try {
                c.close();
            }
            catch (Exception exception) {}
            throw throwable;
        }
        Object object2 = object;
        try {
            c.close();
        }
        catch (Exception exception) {}
        return (R)object2;
    }

    public long copy(InputStream in, OutputStream out) {
        long bytesCopied = 0L;
        byte[] buffer = new byte[8192];
        int bytes = in.read(buffer);
        while (bytes >= 0) {
            out.write(buffer, 0, bytes);
            bytesCopied += (long)bytes;
            bytes = in.read(buffer);
        }
        return bytesCopied;
    }

    public long copy(Reader in, Writer out) {
        long charsCopied = 0L;
        char[] buffer = new char[8192];
        int chars = in.read(buffer);
        while (chars >= 0) {
            out.write(buffer, 0, chars);
            charsCopied += (long)chars;
            chars = in.read(buffer);
        }
        return charsCopied;
    }

    public void unjar(File outputDir, InputStream input, Function1<ZipEntry, Object> filter) {
        try (ZipInputStream zip = new ZipInputStream(input);){
            byte[] buffer = new byte[65536];
            boolean ok = true;
            while (ok) {
                ZipEntry entry = zip.getNextEntry();
                if (entry == null) {
                    ok = false;
                    continue;
                }
                String name = entry.getName();
                if (!entry.isDirectory() && BoxesRunTime.unboxToBoolean((Object)filter.apply((Object)entry))) {
                    this.log().debug((Function0<String>)((Function0 & Serializable)this::unjar$$anonfun$1), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{name}));
                    File file = new File(new StringBuilder(1).append(outputDir.getCanonicalPath()).append("/").append(name).toString());
                    file.getParentFile().mkdirs();
                    try (FileOutputStream bos = new FileOutputStream(file);){
                        int bytes = 1;
                        while (bytes > 0) {
                            bytes = zip.read(buffer);
                            if (bytes <= 0) continue;
                            bos.write(buffer, 0, bytes);
                        }
                    }
                }
                zip.closeEntry();
            }
        }
    }

    public Function1<ZipEntry, Object> unjar$default$3() {
        return (Function1 & Serializable)entry -> this.allZipEntries((ZipEntry)entry);
    }

    public void recursiveDelete(File file, Function1<File, Object> filter) {
        if (file.exists()) {
            if (file.isDirectory()) {
                Object object = Predef$.MODULE$.refArrayOps((Object[])file.listFiles());
                ArrayOps$.MODULE$.foreach$extension(object, (Function1 & Serializable)c -> this.recursiveDelete((File)c));
            }
            if (BoxesRunTime.unboxToBoolean((Object)filter.apply((Object)file))) {
                file.delete();
                return;
            }
            return;
        }
    }

    public Function1<File, Object> recursiveDelete$default$2() {
        return (Function1 & Serializable)file -> this.allFiles((File)file);
    }

    public boolean allZipEntries(ZipEntry entry) {
        return true;
    }

    public boolean allFiles(File file) {
        return true;
    }

    private final String unjar$$anonfun$1() {
        return "processing resource: %s";
    }
}

