/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.scalate.util;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import scala.Function0;
import scala.MatchError;
import scala.runtime.BoxesRunTime;

public class ObjectPool<T> {
    private final int number;
    private final Function0<T> newInstance;
    private final AtomicInteger size;
    private final ArrayBlockingQueue<T> pool;

    public ObjectPool(int number, Function0<T> newInstance) {
        this.number = number;
        this.newInstance = newInstance;
        this.size = new AtomicInteger(0);
        this.pool = new ArrayBlockingQueue(number);
    }

    public T fetch() {
        T t = this.pool.poll();
        if (t == null) {
            return this.createOrBlock();
        }
        T o = t;
        return o;
    }

    public boolean release(T o) {
        return this.pool.offer(o);
    }

    public boolean add(T o) {
        return this.pool.add(o);
    }

    private T createOrBlock() {
        int e;
        int n = this.size.get();
        if (true && (e = n) == this.number) {
            return this.block();
        }
        return this.create();
    }

    private T create() {
        int n = this.size.incrementAndGet();
        if (true) {
            int n2 = n;
            int e = n2;
            if (e > this.number) {
                this.size.decrementAndGet();
                return this.fetch();
            }
            int e2 = n2;
            return (T)this.newInstance.apply();
        }
        throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
    }

    private T block() {
        return this.pool.take();
    }
}

