/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.scalate.util;

import java.io.Serializable;
import org.fusesource.scalate.util.SourceMap$;
import org.fusesource.scalate.util.SourceMapStratum;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.mutable.StringBuilder;
import scala.package$;
import scala.runtime.ScalaRunTime$;

public class SourceMap {
    private String outputFileName = null;
    private boolean doEmbedded = true;
    private List<String> embedded = (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[0]));
    private List<SourceMapStratum> strata = (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SourceMapStratum[0]));
    private String defaultStratum = "Java";

    public static SourceMap parse(String string) {
        return SourceMap$.MODULE$.parse(string);
    }

    public void addSmap(String smap, String stratumName) {
        String value = new java.lang.StringBuilder(8).append("*O ").append(stratumName).append("\n").append(smap).append("*C ").append(stratumName).append("\n").toString();
        this.embedded = this.embedded.$colon$colon((Object)value);
    }

    public void addStratum(SourceMapStratum stratum, boolean defaultStratum) {
        this.strata = this.strata.$colon$colon((Object)stratum);
        if (defaultStratum) {
            this.defaultStratum = stratum.name();
            return;
        }
    }

    public void setOutputFileName(String x) {
        this.outputFileName = x;
    }

    public void setDoEmbedded(boolean status) {
        this.doEmbedded = status;
    }

    public Option<Tuple2<String, Object>> mapToStratum(int line, String name) {
        Option matches = this.strata.find((Function1 & Serializable)_$2 -> {
            String string = _$2.name();
            String string2 = name;
            return !(string != null ? !string.equals(string2) : string2 != null);
        });
        if (matches.isDefined()) {
            return ((SourceMapStratum)matches.get()).mapToStratum(line);
        }
        return None$.MODULE$;
    }

    public String mapToStratum$default$2() {
        return this.defaultStratum;
    }

    public String toString() {
        if (this.outputFileName == null) {
            throw new IllegalStateException();
        }
        StringBuilder out = new StringBuilder();
        out.append("SMAP\n");
        out.append(new java.lang.StringBuilder(11).append(this.outputFileName).append('\n').toString());
        out.append(new java.lang.StringBuilder(11).append(this.defaultStratum).append('\n').toString());
        if (this.doEmbedded) {
            this.embedded.foreach((Function1 & Serializable)_$3 -> out.append(_$3));
        }
        this.strata.foreach((Function1 & Serializable)_$4 -> out.append(_$4));
        out.append("*E\n");
        return out.toString();
    }
}

