/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.scalate.util;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import org.fusesource.scalate.util.EnhancedByteArrayOutputStream;
import org.fusesource.scalate.util.SourceMapInstaller$;
import org.fusesource.scalate.util.SourceMapInstaller$Reader$;
import org.fusesource.scalate.util.SourceMapInstaller$Writer$;
import org.slf4j.Logger;
import scala.Byte$;
import scala.Char$;
import scala.Function0;
import scala.Int$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Short$;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;

public final class SourceMapInstaller {
    public static int SOURCE_DEBUG_EXTENSION_MAX_SIZE() {
        return SourceMapInstaller$.MODULE$.SOURCE_DEBUG_EXTENSION_MAX_SIZE();
    }

    public static String load(byte[] byArray) {
        return SourceMapInstaller$.MODULE$.load(byArray);
    }

    public static String load(File file) {
        return SourceMapInstaller$.MODULE$.load(file);
    }

    public static void main(String[] stringArray) {
        SourceMapInstaller$.MODULE$.main(stringArray);
    }

    public static String nameSDE() {
        return SourceMapInstaller$.MODULE$.nameSDE();
    }

    public static byte[] store(byte[] byArray, String string) {
        return SourceMapInstaller$.MODULE$.store(byArray, string);
    }

    public static void store(byte[] byArray, String string, File file) {
        SourceMapInstaller$.MODULE$.store(byArray, string, file);
    }

    public static void store(File file, File file2) {
        SourceMapInstaller$.MODULE$.store(file, file2);
    }

    public static void store(File file, File file2, File file3) {
        SourceMapInstaller$.MODULE$.store(file, file2, file3);
    }

    public static void store(File file, String string) {
        SourceMapInstaller$.MODULE$.store(file, string);
    }

    public static void store(File file, String string, File file2) {
        SourceMapInstaller$.MODULE$.store(file, string, file2);
    }

    public static class Reader {
        private final byte[] orig;
        private final ByteArrayInputStream bais;
        private final DataInputStream dis;
        public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(SourceMapInstaller$Reader$.class.getDeclaredField("log$lzy2"));

        public static void debug(Function0<String> function0, Seq<Object> seq) {
            SourceMapInstaller$Reader$.MODULE$.debug((Function0)function0, (Seq)seq);
        }

        public static void debug(Throwable throwable) {
            SourceMapInstaller$Reader$.MODULE$.debug(throwable);
        }

        public static void debug(Throwable throwable, Function0<String> function0, Seq<Object> seq) {
            SourceMapInstaller$Reader$.MODULE$.debug(throwable, (Function0)function0, (Seq)seq);
        }

        public static void error(Function0<String> function0, Seq<Object> seq) {
            SourceMapInstaller$Reader$.MODULE$.error((Function0)function0, (Seq)seq);
        }

        public static void error(Throwable throwable) {
            SourceMapInstaller$Reader$.MODULE$.error(throwable);
        }

        public static void error(Throwable throwable, Function0<String> function0, Seq<Object> seq) {
            SourceMapInstaller$Reader$.MODULE$.error(throwable, (Function0)function0, (Seq)seq);
        }

        public static void info(Function0<String> function0, Seq<Object> seq) {
            SourceMapInstaller$Reader$.MODULE$.info((Function0)function0, (Seq)seq);
        }

        public static void info(Throwable throwable) {
            SourceMapInstaller$Reader$.MODULE$.info(throwable);
        }

        public static void info(Throwable throwable, Function0<String> function0, Seq<Object> seq) {
            SourceMapInstaller$Reader$.MODULE$.info(throwable, (Function0)function0, (Seq)seq);
        }

        public static Logger log() {
            return SourceMapInstaller$Reader$.MODULE$.log();
        }

        public static void trace(Function0<String> function0, Seq<Object> seq) {
            SourceMapInstaller$Reader$.MODULE$.trace((Function0)function0, (Seq)seq);
        }

        public static void trace(Throwable throwable) {
            SourceMapInstaller$Reader$.MODULE$.trace(throwable);
        }

        public static void trace(Throwable throwable, Function0<String> function0, Seq<Object> seq) {
            SourceMapInstaller$Reader$.MODULE$.trace(throwable, (Function0)function0, (Seq)seq);
        }

        public static void warn(Function0<String> function0, Seq<Object> seq) {
            SourceMapInstaller$Reader$.MODULE$.warn((Function0)function0, (Seq)seq);
        }

        public static void warn(Throwable throwable) {
            SourceMapInstaller$Reader$.MODULE$.warn(throwable);
        }

        public static void warn(Throwable throwable, Function0<String> function0, Seq<Object> seq) {
            SourceMapInstaller$Reader$.MODULE$.warn(throwable, (Function0)function0, (Seq)seq);
        }

        public Reader(byte[] orig) {
            this.orig = orig;
            this.bais = new ByteArrayInputStream(orig);
            this.dis = new DataInputStream(this.bais());
        }

        public byte[] orig() {
            return this.orig;
        }

        public ByteArrayInputStream bais() {
            return this.bais;
        }

        public DataInputStream dis() {
            return this.dis;
        }

        public String load() {
            this.dis().skip(8L);
            Map<String, Object> constants = this.readConstantPoolStrings();
            Option sdeIndex = constants.get((Object)SourceMapInstaller$.MODULE$.nameSDE());
            if (sdeIndex.isEmpty()) {
                return null;
            }
            this.dis().skip(6L);
            short interfaceCount = this.dis().readShort();
            this.dis().skip(Int$.MODULE$.int2long(interfaceCount * 2));
            this.skipMembers();
            this.skipMembers();
            Option attrbute = this.readAttributes().get(sdeIndex.get());
            return new String((byte[])attrbute.get(), "UTF-8");
        }

        public Map<String, Object> readConstantPoolStrings() {
            Map rc = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
            int count = this.dis().readShort() & 0xFFFF;
            block6: for (int i = 1; i < count; ++i) {
                byte tag;
                byte by = tag = this.dis().readByte();
                switch (by) {
                    case 7: 
                    case 8: {
                        Long l = BoxesRunTime.boxToLong((long)this.dis().skip(2L));
                        continue block6;
                    }
                    case 3: 
                    case 4: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: {
                        Long l = BoxesRunTime.boxToLong((long)this.dis().skip(4L));
                        continue block6;
                    }
                    case 5: 
                    case 6: {
                        this.dis().skip(8L);
                        ++i;
                        Long l = BoxedUnit.UNIT;
                        continue block6;
                    }
                    case 1: {
                        int len = this.dis().readShort() & 0xFFFF;
                        byte[] data = new byte[len];
                        this.dis().readFully(data);
                        String str = new String(data, "UTF-8");
                        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)str);
                        rc = (Map)rc.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)BoxesRunTime.boxToShort((short)((short)i))));
                        Long l = BoxedUnit.UNIT;
                        continue block6;
                    }
                    default: {
                        throw new IOException(new StringBuilder(16).append("unexpected tag: ").append(tag).toString());
                    }
                }
            }
            return rc;
        }

        public void skipMembers() {
            int count = this.dis().readShort();
            for (int i = 0; i < count; ++i) {
                this.dis().skip(6L);
                this.readAttributes();
            }
        }

        public Map<Object, byte[]> readAttributes() {
            Map rc = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
            int count = this.dis().readShort();
            for (int i = 0; i < count; ++i) {
                short index = this.dis().readShort();
                int len = this.dis().readInt();
                byte[] data = new byte[len];
                this.dis().readFully(data);
                Short s = (Short)Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToShort((short)index));
                rc = (Map)rc.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)s, (Object)data));
            }
            return rc;
        }
    }

    public static class Writer {
        private final byte[] orig;
        private final String sourceDebug;
        private final ByteArrayInputStream bais;
        private final DataInputStream dis;
        private final EnhancedByteArrayOutputStream baos;
        private final DataOutputStream dos;
        private int sdeIndex;
        public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(SourceMapInstaller$Writer$.class.getDeclaredField("log$lzy1"));

        public static void debug(Function0<String> function0, Seq<Object> seq) {
            SourceMapInstaller$Writer$.MODULE$.debug((Function0)function0, (Seq)seq);
        }

        public static void debug(Throwable throwable) {
            SourceMapInstaller$Writer$.MODULE$.debug(throwable);
        }

        public static void debug(Throwable throwable, Function0<String> function0, Seq<Object> seq) {
            SourceMapInstaller$Writer$.MODULE$.debug(throwable, (Function0)function0, (Seq)seq);
        }

        public static void error(Function0<String> function0, Seq<Object> seq) {
            SourceMapInstaller$Writer$.MODULE$.error((Function0)function0, (Seq)seq);
        }

        public static void error(Throwable throwable) {
            SourceMapInstaller$Writer$.MODULE$.error(throwable);
        }

        public static void error(Throwable throwable, Function0<String> function0, Seq<Object> seq) {
            SourceMapInstaller$Writer$.MODULE$.error(throwable, (Function0)function0, (Seq)seq);
        }

        public static void info(Function0<String> function0, Seq<Object> seq) {
            SourceMapInstaller$Writer$.MODULE$.info((Function0)function0, (Seq)seq);
        }

        public static void info(Throwable throwable) {
            SourceMapInstaller$Writer$.MODULE$.info(throwable);
        }

        public static void info(Throwable throwable, Function0<String> function0, Seq<Object> seq) {
            SourceMapInstaller$Writer$.MODULE$.info(throwable, (Function0)function0, (Seq)seq);
        }

        public static Logger log() {
            return SourceMapInstaller$Writer$.MODULE$.log();
        }

        public static void trace(Function0<String> function0, Seq<Object> seq) {
            SourceMapInstaller$Writer$.MODULE$.trace((Function0)function0, (Seq)seq);
        }

        public static void trace(Throwable throwable) {
            SourceMapInstaller$Writer$.MODULE$.trace(throwable);
        }

        public static void trace(Throwable throwable, Function0<String> function0, Seq<Object> seq) {
            SourceMapInstaller$Writer$.MODULE$.trace(throwable, (Function0)function0, (Seq)seq);
        }

        public static void warn(Function0<String> function0, Seq<Object> seq) {
            SourceMapInstaller$Writer$.MODULE$.warn((Function0)function0, (Seq)seq);
        }

        public static void warn(Throwable throwable) {
            SourceMapInstaller$Writer$.MODULE$.warn(throwable);
        }

        public static void warn(Throwable throwable, Function0<String> function0, Seq<Object> seq) {
            SourceMapInstaller$Writer$.MODULE$.warn(throwable, (Function0)function0, (Seq)seq);
        }

        public Writer(byte[] orig, String sourceDebug) {
            this.orig = orig;
            this.sourceDebug = sourceDebug;
            this.bais = new ByteArrayInputStream(orig);
            this.dis = new DataInputStream(this.bais());
            this.baos = new EnhancedByteArrayOutputStream(orig.length + sourceDebug.length() * 2 + 100);
            this.dos = new DataOutputStream(this.baos());
            this.sdeIndex = -1;
        }

        public byte[] orig() {
            return this.orig;
        }

        public String sourceDebug() {
            return this.sourceDebug;
        }

        public ByteArrayInputStream bais() {
            return this.bais;
        }

        public DataInputStream dis() {
            return this.dis;
        }

        public EnhancedByteArrayOutputStream baos() {
            return this.baos;
        }

        public DataOutputStream dos() {
            return this.dos;
        }

        public int sdeIndex() {
            return this.sdeIndex;
        }

        public void sdeIndex_$eq(int x$1) {
            this.sdeIndex = x$1;
        }

        public void copy(int count) {
            for (int i = 0; i < count; ++i) {
                this.dos().writeByte(Byte$.MODULE$.byte2int(this.dis().readByte()));
            }
        }

        public short copyShort() {
            short rc = this.dis().readShort();
            this.dos().writeShort(Short$.MODULE$.short2int(rc));
            return rc;
        }

        public byte[] store() {
            this.copy(8);
            int constantPoolCountPos = this.baos().position();
            IntRef constantPoolCount = IntRef.create((int)(this.copyShort() & 0xFFFF));
            this.sdeIndex_$eq(this.copyConstantPool(constantPoolCount.elem));
            if (this.sdeIndex() < 0) {
                int n;
                this.writeSourceDebugConstant();
                this.sdeIndex_$eq(constantPoolCount.elem);
                constantPoolCount.elem = n = constantPoolCount.elem + 1;
                this.baos().update(constantPoolCountPos, (Function0<BoxedUnit>)(Function0 & Serializable)() -> {
                    this.store$$anonfun$1(constantPoolCount);
                    return BoxedUnit.UNIT;
                });
            }
            this.copy(6);
            short interfaceCount = this.copyShort();
            this.copy(interfaceCount * 2);
            this.copyMembers();
            this.copyMembers();
            int attrCountPos = this.baos().position();
            IntRef attrCount = IntRef.create((int)Short$.MODULE$.short2int(this.dis().readShort()));
            this.dos().writeShort(attrCount.elem);
            if (!this.copyAttrs(attrCount.elem)) {
                int n;
                attrCount.elem = n = attrCount.elem + 1;
                this.baos().update(attrCountPos, (Function0<BoxedUnit>)(Function0 & Serializable)() -> {
                    this.store$$anonfun$2(attrCount);
                    return BoxedUnit.UNIT;
                });
            }
            this.writeSourceDebugAttribute(this.sdeIndex());
            return this.baos().toByteArray();
        }

        public void copyMembers() {
            int count = Short$.MODULE$.short2int(this.dis().readShort());
            this.dos().writeShort(count);
            for (int i = 0; i < count; ++i) {
                this.copy(6);
                this.copyAttrs(Short$.MODULE$.short2int(this.copyShort()));
            }
        }

        public int copyConstantPool(int constantPoolCount) {
            int sdeIndex = -1;
            block7: for (int i = 1; i < constantPoolCount; ++i) {
                int tag = Byte$.MODULE$.byte2int(this.dis().readByte());
                this.dos().writeByte(tag);
                int n = tag;
                switch (n) {
                    case 7: 
                    case 8: 
                    case 16: {
                        this.copy(2);
                        continue block7;
                    }
                    case 15: {
                        this.copy(3);
                        continue block7;
                    }
                    case 3: 
                    case 4: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 18: {
                        this.copy(4);
                        continue block7;
                    }
                    case 5: 
                    case 6: {
                        this.copy(8);
                        ++i;
                        continue block7;
                    }
                    case 1: {
                        IntRef len = IntRef.create((int)(this.copyShort() & 0xFFFF));
                        if (len.elem < 0) {
                            int n2;
                            SourceMapInstaller$Writer$.MODULE$.warn(() -> this.copyConstantPool$$anonfun$1(len, constantPoolCount), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]));
                            len.elem = n2 = 0;
                        }
                        byte[] data = new byte[len.elem];
                        this.dis().readFully(data);
                        String str = new String(data, "UTF-8");
                        if (str.equals(SourceMapInstaller$.MODULE$.nameSDE())) {
                            sdeIndex = i;
                        }
                        this.dos().write(data);
                        continue block7;
                    }
                    default: {
                        throw new IOException(new StringBuilder(16).append("unexpected tag: ").append(tag).toString());
                    }
                }
            }
            return sdeIndex;
        }

        public boolean copyAttrs(int attrCount) {
            boolean sdeFound = false;
            for (int i = 0; i < attrCount; ++i) {
                int nameIndex = Short$.MODULE$.short2int(this.dis().readShort());
                if (nameIndex == this.sdeIndex()) {
                    sdeFound = true;
                    continue;
                }
                this.dos().writeShort(nameIndex);
                int len = this.dis().readInt();
                this.dos().writeInt(len);
                this.copy(len);
            }
            return sdeFound;
        }

        public void writeSourceDebugAttribute(int index) {
            this.dos().writeShort(index);
            byte[] data = this.sourceDebug().getBytes("UTF-8");
            this.dos().writeInt(data.length);
            this.dos().write(data);
        }

        public void writeSourceDebugConstant() {
            int len = SourceMapInstaller$.MODULE$.nameSDE().length();
            this.dos().writeByte(1);
            this.dos().writeShort(len);
            for (int i = 0; i < len; ++i) {
                this.dos().writeByte(Char$.MODULE$.char2int(SourceMapInstaller$.MODULE$.nameSDE().charAt(i)));
            }
        }

        private final void store$$anonfun$1(IntRef constantPoolCount$1) {
            this.dos().writeShort(constantPoolCount$1.elem);
        }

        private final void store$$anonfun$2(IntRef attrCount$1) {
            this.dos().writeShort(attrCount$1.elem);
        }

        private final String copyConstantPool$$anonfun$1(IntRef len$1, int constantPoolCount$2) {
            return new StringBuilder(50).append("Index is ").append(len$1.elem).append(" for constantPoolCount: ").append(constantPoolCount$2).append(" nothing to write").toString();
        }
    }
}

