/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.scalate.util;

import java.io.Serializable;
import java.util.ArrayList;
import org.fusesource.scalate.util.SourceMapStratum$LineInfo$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IterableOps;
import scala.collection.StringOps$;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

public class SourceMapStratum {
    private final String name;
    private ArrayList files;
    private final ArrayList lines;
    public final SourceMapStratum$LineInfo$ LineInfo$lzy1;

    public SourceMapStratum(String name) {
        this.name = name;
        this.LineInfo$lzy1 = new SourceMapStratum$LineInfo$();
        this.files = new ArrayList();
        this.lines = new ArrayList();
    }

    public String name() {
        return this.name;
    }

    public ArrayList<Tuple2<String, String>> files() {
        return this.files;
    }

    public void files_$eq(ArrayList<Tuple2<String, String>> x$1) {
        this.files = x$1;
    }

    public ArrayList<LineInfo> lines() {
        return this.lines;
    }

    public Option<Tuple2<String, Object>> mapToStratum(int line) {
        Buffer lines = CollectionConverters$.MODULE$.ListHasAsScala(this.lines()).asScala();
        Buffer rc = (Buffer)((IterableOps)lines.filter((Function1 & Serializable)_$1 -> _$1.containsOutputLine(line))).map((Function1 & Serializable)x -> Tuple2$.MODULE$.apply((Object)this.file$1(x.file()), (Object)BoxesRunTime.boxToInteger((int)x.mapOutputLine(line))));
        return rc.headOption();
    }

    public int addFile(String filename) {
        return this.addFile(filename, null);
    }

    public int addFile(String filename, String filePath) {
        int rc = this.files().size();
        this.files().add((Tuple2<String, String>)Tuple2$.MODULE$.apply((Object)filename, (Object)filePath));
        return rc;
    }

    public void addLine(int istart, int ifile, int icount, int oline, int oincrement) {
        if (ifile < 0 || this.files().size() <= ifile) {
            throw new IllegalArgumentException(new StringBuilder(7).append("ifile: ").append(ifile).toString());
        }
        this.lines().add(new LineInfo(this, istart, oline, ifile, icount, oincrement));
    }

    public void optimize() {
        int i = 0;
        while (i < this.lines().size() - 1) {
            LineInfo li = this.lines().get(i);
            LineInfo liNext = this.lines().get(i + 1);
            if (li.file() == liNext.file() && liNext.istart() == li.istart() && liNext.icount() == 1 && li.icount() == 1 && liNext.ostart() == li.ostart() + li.icount() * li.oincrement()) {
                li.oincrement_$eq(liNext.ostart() - li.ostart() + liNext.oincrement());
                this.lines().remove(i + 1);
                continue;
            }
            ++i;
        }
        i = 0;
        while (i < this.lines().size() - 1) {
            LineInfo li = this.lines().get(i);
            LineInfo liNext = this.lines().get(i + 1);
            if (li.file() == liNext.file() && liNext.istart() == li.istart() + li.icount() && liNext.oincrement() == li.oincrement() && liNext.ostart() == li.ostart() + li.icount() * li.oincrement()) {
                li.icount_$eq(li.icount() + liNext.icount());
                this.lines().remove(i + 1);
                continue;
            }
            ++i;
        }
    }

    public String toString() {
        if (this.files().size() == 0 || this.lines().size() == 0) {
            return null;
        }
        scala.collection.mutable.StringBuilder out = new scala.collection.mutable.StringBuilder();
        out.append(new StringBuilder(4).append("*S ").append(this.name()).append("\n").toString());
        out.append("*F\n");
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.files().size()).foreach((Function1 & Serializable)i -> this.toString$$anonfun$1(out, BoxesRunTime.unboxToInt((Object)i)));
        out.append("*L\n");
        IntRef lastFile = IntRef.create((int)0);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.lines().size()).foreach((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            int n;
            LineInfo line = this.lines().get(i);
            out.append(line.toString(lastFile$1.elem));
            lastFile$1.elem = n = line.file();
        });
        return out.toString();
    }

    public final SourceMapStratum$LineInfo$ LineInfo() {
        return this.LineInfo$lzy1;
    }

    private final String file$1(int id) {
        Tuple2<String, String> value = this.files().get(id);
        if (value._2() == null) {
            return (String)value._1();
        }
        return (String)value._2();
    }

    private final /* synthetic */ scala.collection.mutable.StringBuilder toString$$anonfun$1(scala.collection.mutable.StringBuilder out$1, int i) {
        Tuple2<String, String> tuple2 = this.files().get(i);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String file = (String)tuple2._1();
        String filePath = (String)tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)file, (Object)filePath);
        String file2 = (String)tuple22._1();
        String filePath2 = (String)tuple22._2();
        if (filePath2 != null) {
            out$1.append(new StringBuilder(4).append("+ ").append(i).append(" ").append(file2).append("\n").toString());
            return out$1.append(new StringBuilder(1).append(StringOps$.MODULE$.stripPrefix$extension(Predef$.MODULE$.augmentString(filePath2), "/")).append("\n").toString());
        }
        return out$1.append(new StringBuilder(2).append(i).append(" ").append(file2).append("\n").toString());
    }

    public class LineInfo {
        private int istart;
        private int ostart;
        private int file;
        private int icount;
        private int oincrement;
        private final /* synthetic */ SourceMapStratum $outer;

        public LineInfo(SourceMapStratum $outer, int istart, int ostart, int file, int icount, int oincrement) {
            this.istart = istart;
            this.ostart = ostart;
            this.file = file;
            this.icount = icount;
            this.oincrement = oincrement;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            this.check((Function0<Object>)((Function0 & Serializable)this::$init$$$anonfun$1));
            this.check((Function0<Object>)((Function0 & Serializable)this::$init$$$anonfun$2));
            this.check((Function0<Object>)((Function0 & Serializable)this::$init$$$anonfun$3));
            this.check((Function0<Object>)((Function0 & Serializable)this::$init$$$anonfun$4));
            this.check((Function0<Object>)((Function0 & Serializable)this::$init$$$anonfun$5));
        }

        public int istart() {
            return this.istart;
        }

        public void istart_$eq(int x$1) {
            this.istart = x$1;
        }

        public int ostart() {
            return this.ostart;
        }

        public void ostart_$eq(int x$1) {
            this.ostart = x$1;
        }

        public int file() {
            return this.file;
        }

        public void file_$eq(int x$1) {
            this.file = x$1;
        }

        public int icount() {
            return this.icount;
        }

        public void icount_$eq(int x$1) {
            this.icount = x$1;
        }

        public int oincrement() {
            return this.oincrement;
        }

        public void oincrement_$eq(int x$1) {
            this.oincrement = x$1;
        }

        public boolean containsOutputLine(int line) {
            int oend = this.ostart() + this.icount() * this.oincrement();
            return this.ostart() <= line && line < oend;
        }

        public int mapOutputLine(int line) {
            return this.istart() + (line - this.ostart()) / this.oincrement();
        }

        private void check(Function0<Object> proc) {
            if (!proc.apply$mcZ$sp()) {
                throw new IllegalArgumentException();
            }
        }

        public String toString() {
            return this.toString(-1);
        }

        public String toString(int lastFile) {
            if (this.istart() == -1 || this.ostart() == -1) {
                throw new IllegalStateException();
            }
            scala.collection.mutable.StringBuilder out = new scala.collection.mutable.StringBuilder();
            out.append(this.istart());
            if (this.file() != lastFile) {
                out.append(new StringBuilder(1).append("#").append(this.file()).toString());
            }
            if (this.icount() != 1) {
                out.append(new StringBuilder(1).append(",").append(this.icount()).toString());
            }
            out.append(new StringBuilder(1).append(":").append(this.ostart()).toString());
            if (this.oincrement() != 1) {
                out.append(new StringBuilder(1).append(",").append(this.oincrement()).toString());
            }
            out.append('\n');
            return out.toString();
        }

        public final /* synthetic */ SourceMapStratum org$fusesource$scalate$util$SourceMapStratum$LineInfo$$$outer() {
            return this.$outer;
        }

        private final boolean $init$$$anonfun$1() {
            return this.istart() > 0;
        }

        private final boolean $init$$$anonfun$2() {
            return this.file() >= 0;
        }

        private final boolean $init$$$anonfun$3() {
            return this.ostart() > 0;
        }

        private final boolean $init$$$anonfun$4() {
            return this.icount() > 0;
        }

        private final boolean $init$$$anonfun$5() {
            return this.oincrement() >= 0;
        }
    }
}

