/*
 * Decompiled with CFR 0.152.
 */
package org.scalatra.auth;

import java.io.Serializable;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.scalatra.ScalatraBase;
import org.scalatra.auth.Scentry$;
import org.scalatra.auth.ScentryAuthStore;
import org.scalatra.auth.ScentryStrategy;
import org.scalatra.servlet.ServletApiImplicits$;
import org.scalatra.util.MultiMapHeadView;
import org.scalatra.util.RicherString.package;
import org.scalatra.util.RicherString.package$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOps;
import scala.collection.StrictOptimizedMapOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.Map;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction0;

public class Scentry<UserType> {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(Scentry.class.getDeclaredField("logger$lzy1"));
    private final ScalatraBase app;
    private final PartialFunction<UserType, String> serialize;
    private final PartialFunction<String, UserType> deserialize;
    private ScentryAuthStore.ScentryAuthStore _store;
    private volatile Object logger$lzy1;
    private final HashMap<String, Function1<ScalatraBase, ScentryStrategy<UserType>>> _strategies;
    private Option<Function0<BoxedUnit>> defaultUnauthenticated;

    public static String ScentryRequestKey() {
        return Scentry$.MODULE$.ScentryRequestKey();
    }

    public static void clearGlobalStrategies() {
        Scentry$.MODULE$.clearGlobalStrategies();
    }

    public static HashMap<String, Function1<ScalatraBase, ScentryStrategy<? extends Object>>> globalStrategies() {
        return Scentry$.MODULE$.globalStrategies();
    }

    public static String scentryAuthKey() {
        return Scentry$.MODULE$.scentryAuthKey();
    }

    public Scentry(ScalatraBase app, PartialFunction<UserType, String> serialize, PartialFunction<String, UserType> deserialize, ScentryAuthStore.ScentryAuthStore _store) {
        this.app = app;
        this.serialize = serialize;
        this.deserialize = deserialize;
        this._store = _store;
        this._strategies = new HashMap();
        this.defaultUnauthenticated = None$.MODULE$;
    }

    private Logger logger() {
        Object object = this.logger$lzy1;
        if (object instanceof Logger) {
            return (Logger)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Logger)this.logger$lzyINIT1();
    }

    private Object logger$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.logger$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Logger logger = null;
                    try {
                        logger = LoggerFactory.getLogger(this.getClass());
                        object2 = logger == null ? LazyVals.NullValue$.MODULE$ : logger;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.logger$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return logger;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private UserType _user(HttpServletRequest request) {
        return (UserType)ServletApiImplicits$.MODULE$.enrichRequest(request).get(Scentry$.MODULE$.scentryAuthKey()).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public ScentryAuthStore.ScentryAuthStore store() {
        return this._store;
    }

    public void store_$eq(ScentryAuthStore.ScentryAuthStore newStore) {
        this._store = newStore;
    }

    public boolean isAuthenticated(HttpServletRequest request, HttpServletResponse response) {
        return this.userOption(request, response).isDefined();
    }

    public MultiMapHeadView<String, String> params(HttpServletRequest request) {
        return this.app.params(request);
    }

    public void redirect(String uri, HttpServletRequest request, HttpServletResponse response) {
        throw this.app.redirect(uri, request, response);
    }

    public void register(Function0<ScentryStrategy<UserType>> strategy) {
        this.register(((ScentryStrategy)strategy.apply()).name(), (Function1 & Serializable)_$1 -> (ScentryStrategy)strategy.apply());
    }

    public void register(String name, Function1<ScalatraBase, ScentryStrategy<UserType>> strategyFactory) {
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)name);
        this._strategies.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, strategyFactory));
    }

    public Map<String, ScentryStrategy<UserType>> strategies() {
        return (Map)((StrictOptimizedMapOps)Scentry$.MODULE$.globalStrategies().$plus$plus(this._strategies)).map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String nm = (String)tuple2._1();
                Function1 fact = (Function1)tuple2._2();
                String string = (String)Predef$.MODULE$.ArrowAssoc((Object)nm);
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, fact.apply((Object)this.app));
            }
            throw new MatchError((Object)tuple2);
        });
    }

    public Option<UserType> userOption(HttpServletRequest request, HttpServletResponse response) {
        return Option$.MODULE$.apply(this._user(request)).orElse(() -> this.userOption$$anonfun$1(request, response));
    }

    public UserType user(HttpServletRequest request, HttpServletResponse response) {
        return (UserType)this.userOption(request, response).getOrElse(Scentry::user$$anonfun$1);
    }

    public String user_$eq(UserType v, HttpServletRequest request, HttpServletResponse response) {
        ServletApiImplicits$.MODULE$.enrichRequest(request).update(Scentry$.MODULE$.scentryAuthKey(), v);
        if (v != null) {
            this.runCallbacks(this.runCallbacks$default$1(), (Function1<ScentryStrategy<UserType>, BoxedUnit>)(JProcedure1 & Serializable)_$5 -> _$5.beforeSetUser(v, request, response));
            String res = (String)this.toSession().apply(v);
            this.store().set(res, request, response);
            this.runCallbacks(this.runCallbacks$default$1(), (Function1<ScentryStrategy<UserType>, BoxedUnit>)(JProcedure1 & Serializable)_$6 -> _$6.afterSetUser(v, request, response));
            return res;
        }
        return "";
    }

    public PartialFunction<String, UserType> fromSession() {
        return this.deserialize.orElse(this.missingDeserializer());
    }

    public PartialFunction<UserType, String> toSession() {
        return this.serialize.orElse(this.missingSerializer());
    }

    private PartialFunction<UserType, String> missingSerializer() {
        return new Serializable(){

            public final boolean isDefinedAt(Object x) {
                Object object = x;
                return true;
            }

            public final Object applyOrElse(Object x, Function1 function1) {
                Object object = x;
                throw new RuntimeException("You need to provide a session serializer for Scentry");
            }
        };
    }

    private PartialFunction<String, UserType> missingDeserializer() {
        return new Serializable(){

            public final boolean isDefinedAt(String x) {
                String string = x;
                return true;
            }

            public final Object applyOrElse(String x, Function1 function1) {
                String string = x;
                throw new RuntimeException("You need to provide a session deserializer for Scentry");
            }
        };
    }

    public Option<UserType> authenticate(Seq<String> names, HttpServletRequest request, HttpServletResponse response) {
        Option r = this.runAuthentication(names, request, response).map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String stratName = (String)tuple2._1();
                Object usr = tuple2._2();
                this.runCallbacks(this.runCallbacks$default$1(), (Function1<ScentryStrategy<UserType>, BoxedUnit>)(JProcedure1 & Serializable)_$7 -> _$7.afterAuthenticate(stratName, usr, request, response));
                this.user_$eq(usr, request, response);
                return this.user(request, response);
            }
            throw new MatchError((Object)tuple2);
        });
        if (names.isEmpty()) {
            return r.orElse(this::authenticate$$anonfun$1);
        }
        return r;
    }

    private Option<Tuple2<String, UserType>> runAuthentication(Seq<String> names, HttpServletRequest request, HttpServletResponse response) {
        Iterable subset = names.isEmpty() ? this.strategies().values() : this.strategies().filterKeys((Function1 & Serializable)elem -> names.contains(elem)).values();
        return ((IterableOps)subset.withFilter((Function1 & Serializable)_$9 -> _$9.isValid(request)).flatMap((Function1 & Serializable)strat -> {
            this.logger().debug(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Authenticating with: %s"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{strat.name()})));
            this.runCallbacks((Function1<ScentryStrategy<UserType>, Object>)(Function1 & Serializable)_$10 -> _$10.isValid(request), (Function1<ScentryStrategy<UserType>, BoxedUnit>)(JProcedure1 & Serializable)_$11 -> _$11.beforeAuthenticate(request, response));
            Option option = strat.authenticate(request, response);
            if (option instanceof Some) {
                Object usr = ((Some)option).value();
                String string = (String)Predef$.MODULE$.ArrowAssoc((Object)strat.name());
                return Some$.MODULE$.apply((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, usr));
            }
            strat.unauthenticated(request, response);
            return None$.MODULE$;
        })).headOption();
    }

    public void unauthenticated(Function0<BoxedUnit> callback) {
        this.defaultUnauthenticated = Some$.MODULE$.apply((JFunction0.mcV.sp & Serializable)() -> callback.apply$mcV$sp());
    }

    public void logout(HttpServletRequest request, HttpServletResponse response) {
        Object usr = this.user(request, response);
        this.runCallbacks(this.runCallbacks$default$1(), (Function1<ScentryStrategy<UserType>, BoxedUnit>)(JProcedure1 & Serializable)_$12 -> _$12.beforeLogout(usr, request, response));
        ServletApiImplicits$.MODULE$.enrichRequest(request).$minus$eq(Scentry$.MODULE$.scentryAuthKey());
        this.store().invalidate(request, response);
        this.runCallbacks(this.runCallbacks$default$1(), (Function1<ScentryStrategy<UserType>, BoxedUnit>)(JProcedure1 & Serializable)_$13 -> _$13.afterLogout(usr, request, response));
    }

    private void runCallbacks(Function1<ScentryStrategy<UserType>, Object> guard, Function1<ScentryStrategy<UserType>, BoxedUnit> which) {
        this.strategies().foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
            ScentryStrategy v;
            Tuple2 tuple2 = x$1;
            if (tuple2 != null && BoxesRunTime.unboxToBoolean((Object)guard.apply((Object)(v = (ScentryStrategy)tuple2._2())))) {
                which.apply((Object)v);
                return;
            }
        });
    }

    private Function1<ScentryStrategy<UserType>, Object> runCallbacks$default$1() {
        return (Function1 & Serializable)s -> true;
    }

    private final Option userOption$$anonfun$1(HttpServletRequest request$1, HttpServletResponse response$1) {
        return package.RicherStringImplicitClass$.MODULE$.blankOption$extension(package$.MODULE$.RicherStringImplicitClass(this.store().get(request$1, response$1))).flatMap((Function1 & Serializable)key -> {
            this.runCallbacks(this.runCallbacks$default$1(), (Function1<ScentryStrategy<UserType>, BoxedUnit>)(JProcedure1 & Serializable)_$2 -> _$2.beforeFetch(key, request$1, response$1));
            Option o = ((Option)this.fromSession().lift().apply(key)).flatMap((Function1 & Serializable)_$3 -> Option$.MODULE$.apply(_$3)).map((Function1 & Serializable)res -> {
                this.runCallbacks(this.runCallbacks$default$1(), (Function1<ScentryStrategy<UserType>, BoxedUnit>)(JProcedure1 & Serializable)_$4 -> _$4.afterFetch(res, request$1, response$1));
                ServletApiImplicits$.MODULE$.enrichRequest(request$1).update(Scentry$.MODULE$.scentryAuthKey(), res);
                return res;
            });
            if (o.isEmpty()) {
                ServletApiImplicits$.MODULE$.enrichRequest(request$1).update(Scentry$.MODULE$.scentryAuthKey(), null);
            }
            return o;
        });
    }

    private static final Object user$$anonfun$1() {
        return null;
    }

    private final Option authenticate$$anonfun$1() {
        this.defaultUnauthenticated.foreach((Function1)(JProcedure1 & Serializable)_$8 -> _$8.apply$mcV$sp());
        return None$.MODULE$;
    }
}

