/*
 * Decompiled with CFR 0.152.
 */
package org.scalatra.auth.strategy;

import java.io.Serializable;
import java.util.Base64;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.scalatra.ScalatraBase;
import org.scalatra.Unauthorized$;
import org.scalatra.auth.ScentryStrategy;
import org.scalatra.auth.strategy.BasicAuthStrategy$;
import org.scalatra.auth.strategy.RemoteAddress;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.io.Codec$;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public abstract class BasicAuthStrategy<UserType>
implements ScentryStrategy<UserType>,
RemoteAddress {
    private final ScalatraBase app;
    private final String realm;
    private final String REMOTE_USER;

    public BasicAuthStrategy(ScalatraBase app, String realm) {
        this.app = app;
        this.realm = realm;
        this.REMOTE_USER = "REMOTE_USER";
    }

    @Override
    public ScalatraBase app() {
        return this.app;
    }

    public BasicAuthRequest request2BasicAuthRequest(HttpServletRequest r) {
        return new BasicAuthRequest(r);
    }

    public String challenge() {
        return StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Basic realm=\"%s\""), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.realm}));
    }

    @Override
    public boolean isValid(HttpServletRequest request) {
        return this.request2BasicAuthRequest(request).isBasicAuth() && this.request2BasicAuthRequest(request).providesAuth();
    }

    @Override
    public Option<UserType> authenticate(HttpServletRequest request, HttpServletResponse response) {
        return this.validate(this.request2BasicAuthRequest(request).username(), this.request2BasicAuthRequest(request).password(), request, response);
    }

    public abstract String getUserId(UserType var1, HttpServletRequest var2, HttpServletResponse var3);

    public abstract Option<UserType> validate(String var1, String var2, HttpServletRequest var3, HttpServletResponse var4);

    @Override
    public void afterSetUser(UserType user, HttpServletRequest request, HttpServletResponse response) {
        response.setHeader(this.REMOTE_USER, this.getUserId(user, request, response));
    }

    @Override
    public void unauthenticated(HttpServletRequest request, HttpServletResponse response) {
        Object[] objectArray = new Tuple2[1];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"WWW-Authenticate");
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)this.challenge());
        Map map = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        Object object = Unauthorized$.MODULE$.apply$default$1();
        throw this.app().halt(Unauthorized$.MODULE$.apply(object, map));
    }

    @Override
    public void afterLogout(UserType user, HttpServletRequest request, HttpServletResponse response) {
        response.setHeader(this.REMOTE_USER, "");
    }

    public static class BasicAuthRequest {
        private final HttpServletRequest r;
        private Option<Tuple2<String, String>> _credentials;

        public BasicAuthRequest(HttpServletRequest r) {
            this.r = r;
            this._credentials = None$.MODULE$;
        }

        public List<String> parts() {
            return (List)this.authorizationKey().map((Function1 & Serializable)_$1 -> Predef$.MODULE$.wrapRefArray((Object[])this.r.getHeader(_$1).split(" ", 2)).toList()).getOrElse(this::parts$$anonfun$2);
        }

        public Option<String> scheme() {
            return this.parts().headOption().map((Function1 & Serializable)sch -> sch.toLowerCase(Locale.ENGLISH));
        }

        public Option<String> params() {
            return this.parts().lastOption();
        }

        private Option<String> authorizationKey() {
            return BasicAuthStrategy$.org$scalatra$auth$strategy$BasicAuthStrategy$$$AUTHORIZATION_KEYS.find((Function1 & Serializable)_$2 -> this.r.getHeader(_$2) != null);
        }

        public boolean isBasicAuth() {
            return BoxesRunTime.unboxToBoolean((Object)Option$.MODULE$.option2Iterable(this.scheme()).foldLeft((Object)BoxesRunTime.boxToBoolean((boolean)false), (Function2 & Serializable)(_$3, sch) -> this.isBasicAuth$$anonfun$1(BoxesRunTime.unboxToBoolean((Object)_$3), (String)sch)));
        }

        public boolean providesAuth() {
            return this.authorizationKey().isDefined();
        }

        public Option<Tuple2<String, String>> credentials() {
            if (this._credentials.isEmpty()) {
                this._credentials = this.params().map((Function1 & Serializable)p -> {
                    Object object = Predef$.MODULE$.refArrayOps((Object[])new String(Base64.getDecoder().decode((String)p), Codec$.MODULE$.UTF8().charSet()).split(":", 2));
                    return (Tuple2)ArrayOps$.MODULE$.foldLeft$extension(object, null, (Function2 & Serializable)(t, l) -> {
                        if (t == null) {
                            return Tuple2$.MODULE$.apply(l, null);
                        }
                        return Tuple2$.MODULE$.apply(t._1(), l);
                    });
                });
            }
            return this._credentials;
        }

        public String username() {
            return (String)this.credentials().map((Function1 & Serializable)_$4 -> (String)_$4._1()).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
        }

        public String password() {
            return (String)this.credentials().map((Function1 & Serializable)_$5 -> (String)_$5._2()).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
        }

        private final List parts$$anonfun$2() {
            return package$.MODULE$.Nil();
        }

        private final /* synthetic */ boolean isBasicAuth$$anonfun$1(boolean _$3, String sch) {
            String string = sch;
            String string2 = "basic";
            return !(string != null ? !string.equals(string2) : string2 != null);
        }
    }
}

