/*
 * Decompiled with CFR 0.152.
 */
package org.scalatra.validation;

import java.net.URI;
import java.util.Locale;
import mojolly.inflector.InflectorImports$;
import org.apache.commons.validator.routines.EmailValidator;
import org.apache.commons.validator.routines.UrlValidator;
import org.scalatra.util.RicherString$;
import org.scalatra.validation.Validators;
import org.scalatra.validation.Validators$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.ScalaObject;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SetLike;
import scala.collection.Traversable;
import scala.collection.immutable.Set$;
import scala.math.Ordered;
import scala.runtime.BoxesRunTime;
import scala.util.control.Exception$;
import scala.util.matching.Regex;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Validators$
implements ScalaObject {
    public static final Validators$ MODULE$;

    static {
        new Validators$();
    }

    public <TValue> Validators.PredicateValidator<TValue> validate(String fieldName, String messageFormat, Function1<TValue, Object> validate2) {
        return new Validators.PredicateValidator<TValue>(fieldName, validate2, messageFormat);
    }

    public String validate$default$2() {
        return "%s is invalid.";
    }

    public Validators.Validator<String> nonEmptyString(String fieldName, String messageFormat) {
        return new Validators.PredicateValidator<String>(fieldName, (Function1<String, Object>)new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(String string) {
                return RicherString$.MODULE$.stringToRicherString(string).nonBlank();
            }
        }, messageFormat);
    }

    public String nonEmptyString$default$2() {
        return "%s must be present.";
    }

    public Validators.Validator<Object> notNull(String fieldName, String messageFormat) {
        return new Validators.PredicateValidator<Object>(fieldName, (Function1<Object, Object>)new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(Object object) {
                return object != null;
            }
        }, messageFormat);
    }

    public String notNull$default$2() {
        return "%s must be present.";
    }

    public <TResult extends Traversable<Object>> Validators.Validator<TResult> nonEmptyCollection(String fieldName, String messageFormat) {
        return new Validators.PredicateValidator(fieldName, new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(TResult TResult) {
                return TResult.nonEmpty();
            }
        }, messageFormat);
    }

    public String nonEmptyCollection$default$2() {
        return "%s must not be empty.";
    }

    public Validators.Validator<String> validEmail(String fieldName, String messageFormat) {
        return new Validators.PredicateValidator<String>(fieldName, (Function1<String, Object>)new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(String string) {
                return EmailValidator.getInstance().isValid(string);
            }
        }, messageFormat);
    }

    public String validEmail$default$2() {
        return "%s must be a valid email.";
    }

    public Validators.Validator<String> validAbsoluteUrl(String fieldName, boolean allowLocalHost, String messageFormat, Seq<String> schemes) {
        return this.buildUrlValidator(fieldName, true, allowLocalHost, messageFormat, schemes);
    }

    public Seq validAbsoluteUrl$default$4() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"http", "https"}));
    }

    public String validAbsoluteUrl$default$3() {
        return "%s must be a valid absolute url.";
    }

    public Validators.Validator<String> validUrl(String fieldName, boolean allowLocalHost, String messageFormat, Seq<String> schemes) {
        return this.buildUrlValidator(fieldName, false, allowLocalHost, messageFormat, schemes);
    }

    public Seq validUrl$default$4() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"http", "https"}));
    }

    public String validUrl$default$3() {
        return "%s must be a valid url.";
    }

    public Validators.Validator<String> validFormat(String fieldName, Regex regex$1, String messageFormat) {
        return new Validators.PredicateValidator<String>(fieldName, (Function1<String, Object>)new Serializable(regex$1){
            public static final long serialVersionUID;
            private final Regex regex$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(String string) {
                return this.regex$1.findFirstIn((CharSequence)string).isDefined();
            }
            {
                this.regex$1 = regex;
            }
        }, messageFormat);
    }

    public String validFormat$default$3() {
        return "%s is invalid.";
    }

    public Validators.Validator<String> validConfirmation(String fieldName, String confirmationFieldName, Function0<String> confirmationValue$1, String messageFormat) {
        return new Validators.PredicateValidator<String>(fieldName, (Function1<String, Object>)new Serializable(confirmationValue$1){
            public static final long serialVersionUID;
            private final Function0 confirmationValue$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(String string) {
                String string2 = string;
                Object object = this.confirmationValue$1.apply();
                return !(string2 != null ? !string2.equals(object) : object != null);
            }
            {
                this.confirmationValue$1 = function0;
            }
        }, Predef$.MODULE$.augmentString(messageFormat).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{InflectorImports$.MODULE$.string2InflectorString(InflectorImports$.MODULE$.string2InflectorString(confirmationFieldName).underscore()).humanize().toLowerCase(Locale.ENGLISH)})));
    }

    public String validConfirmation$default$4() {
        return "%%s must match %s.";
    }

    public <T> Validators.Validator<T> greaterThan(String fieldName, T min$1, String messageFormat, Function1<T, Ordered<T>> evidence$1$1) {
        return new Validators.PredicateValidator(fieldName, new Serializable(min$1, evidence$1$1){
            public static final long serialVersionUID;
            private final Object min$1;
            private final Function1 evidence$1$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(T t) {
                return ((Ordered)this.evidence$1$1.apply(t)).$greater(this.min$1);
            }
            {
                this.min$1 = object;
                this.evidence$1$1 = function1;
            }
        }, Predef$.MODULE$.augmentString(messageFormat).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{min$1.toString()})));
    }

    public String greaterThan$default$3() {
        return "%%s must be greater than %s.";
    }

    public <T> Validators.Validator<T> lessThan(String fieldName, T max$1, String messageFormat, Function1<T, Ordered<T>> evidence$2$1) {
        return new Validators.PredicateValidator(fieldName, new Serializable(max$1, evidence$2$1){
            public static final long serialVersionUID;
            private final Object max$1;
            private final Function1 evidence$2$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(T t) {
                return ((Ordered)this.evidence$2$1.apply(t)).$less(this.max$1);
            }
            {
                this.max$1 = object;
                this.evidence$2$1 = function1;
            }
        }, Predef$.MODULE$.augmentString(messageFormat).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{max$1.toString()})));
    }

    public String lessThan$default$3() {
        return "%%s must be less than %s.";
    }

    public <T> Validators.Validator<T> greaterThanOrEqualTo(String fieldName, T min$2, String messageFormat, Function1<T, Ordered<T>> evidence$3$1) {
        return new Validators.PredicateValidator(fieldName, new Serializable(min$2, evidence$3$1){
            public static final long serialVersionUID;
            private final Object min$2;
            private final Function1 evidence$3$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(T t) {
                return ((Ordered)this.evidence$3$1.apply(t)).$greater$eq(this.min$2);
            }
            {
                this.min$2 = object;
                this.evidence$3$1 = function1;
            }
        }, Predef$.MODULE$.augmentString(messageFormat).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{min$2})));
    }

    public String greaterThanOrEqualTo$default$3() {
        return "%%s must be greater than or equal to %s.";
    }

    public <T> Validators.Validator<T> lessThanOrEqualTo(String fieldName, T max$2, String messageFormat, Function1<T, Ordered<T>> evidence$4$1) {
        return new Validators.PredicateValidator(fieldName, new Serializable(max$2, evidence$4$1){
            public static final long serialVersionUID;
            private final Object max$2;
            private final Function1 evidence$4$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(T t) {
                return ((Ordered)this.evidence$4$1.apply(t)).$less$eq(this.max$2);
            }
            {
                this.max$2 = object;
                this.evidence$4$1 = function1;
            }
        }, Predef$.MODULE$.augmentString(messageFormat).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{max$2})));
    }

    public String lessThanOrEqualTo$default$3() {
        return "%%s must be less than or equal to %s.";
    }

    public Validators.Validator<String> minLength(String fieldName, int min$3, String messageFormat) {
        return new Validators.PredicateValidator<String>(fieldName, (Function1<String, Object>)new Serializable(min$3){
            public static final long serialVersionUID;
            private final int min$3;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(String string) {
                return Predef$.MODULE$.augmentString(string).size() >= this.min$3;
            }
            {
                this.min$3 = n;
            }
        }, Predef$.MODULE$.augmentString(messageFormat).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)min$3)})));
    }

    public String minLength$default$3() {
        return "%%s must be at least %s characters long.";
    }

    public <TResult> Validators.Validator<TResult> oneOf(String fieldName, String messageFormat, Seq<TResult> expected$1) {
        return new Validators.PredicateValidator(fieldName, new Serializable(expected$1){
            public static final long serialVersionUID;
            private final Seq expected$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(Object object) {
                return this.expected$1.contains(object);
            }
            {
                this.expected$1 = seq;
            }
        }, Predef$.MODULE$.augmentString(messageFormat).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{expected$1.mkString("[", ", ", "]")})));
    }

    public String oneOf$default$2() {
        return "%%s must be one of %s.";
    }

    public Validators.Validator<String> enumValue(String fieldName, Enumeration enumeration, String messageFormat) {
        return this.oneOf(fieldName, messageFormat, ((SetLike)enumeration.values().map((Function1)new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply(Enumeration.Value value) {
                return value.toString();
            }
        }, Set$.MODULE$.canBuildFrom())).toSeq());
    }

    public String enumValue$default$3() {
        return "%%s must be one of %s.";
    }

    private Validators.Validator<String> buildUrlValidator(String fieldName, boolean absolute$1, boolean allowLocalHost$1, String messageFormat, Seq<String> schemes) {
        Serializable validator = new Serializable(absolute$1, allowLocalHost$1){
            public static final long serialVersionUID;
            public final boolean absolute$1;
            private final boolean allowLocalHost$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(String url$1) {
                return Exception$.MODULE$.allCatch().opt((Function0)new Serializable(this, url$1){
                    public static final long serialVersionUID;
                    private final anonfun.1 $outer;
                    private final String url$1;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final boolean apply() {
                        return this.apply$mcZ$sp();
                    }

                    public boolean apply$mcZ$sp() {
                        URI u = URI.create(this.url$1).normalize();
                        return !this.$outer.absolute$1 || u.isAbsolute();
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.url$1 = string;
                    }
                }).isDefined() && (this.allowLocalHost$1 || UrlValidator.getInstance().isValid(url$1));
            }
            {
                this.absolute$1 = bl;
                this.allowLocalHost$1 = bl2;
            }
        };
        return new Validators.PredicateValidator<String>(fieldName, (Function1<String, Object>)validator, messageFormat);
    }

    private String buildUrlValidator$default$4() {
        return "%s must be a valid url.";
    }

    private Validators$() {
        MODULE$ = this;
    }
}

