/*
 * Decompiled with CFR 0.152.
 */
package scalikejdbc;

import java.io.Serializable;
import scala.Function0;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.StringOps$;
import scala.collection.concurrent.TrieMap;
import scala.collection.immutable.Seq;
import scala.util.matching.Regex;
import scalikejdbc.Log;
import scalikejdbc.LogSupport;
import scalikejdbc.interpolation.SQLSyntax;

public final class SQLSyntaxSupportFeature$
implements LogSupport {
    public static final SQLSyntaxSupportFeature$ MODULE$ = new SQLSyntaxSupportFeature$();
    private static final Regex whiteSpaceRegExp;
    private static final Regex semicolonRegExp;
    private static final TrieMap<Tuple2<Object, String>, Seq<String>> SQLSyntaxSupportLoadedColumns;
    private static final TrieMap<Tuple2<Object, String>, TrieMap<Object, TrieMap<String, SQLSyntax>>> SQLSyntaxSupportCachedColumns;
    private static Log log;

    static {
        LogSupport.$init$((LogSupport)MODULE$);
        whiteSpaceRegExp = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString(".*\\s+.*"));
        semicolonRegExp = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString(".*;.*"));
        SQLSyntaxSupportLoadedColumns = new TrieMap();
        SQLSyntaxSupportCachedColumns = new TrieMap();
    }

    public Log log() {
        return log;
    }

    public void scalikejdbc$LogSupport$_setter_$log_$eq(Log x$1) {
        log = x$1;
    }

    private Regex whiteSpaceRegExp() {
        return whiteSpaceRegExp;
    }

    private Regex semicolonRegExp() {
        return semicolonRegExp;
    }

    public TrieMap<Tuple2<Object, String>, Seq<String>> SQLSyntaxSupportLoadedColumns() {
        return SQLSyntaxSupportLoadedColumns;
    }

    public TrieMap<Tuple2<Object, String>, TrieMap<Object, TrieMap<String, SQLSyntax>>> SQLSyntaxSupportCachedColumns() {
        return SQLSyntaxSupportCachedColumns;
    }

    public void verifyTableName(String tableNameWithSchema) {
        if (tableNameWithSchema != null) {
            String name = tableNameWithSchema.trim();
            boolean hasWhiteSpace = this.whiteSpaceRegExp().pattern().matcher(name).matches();
            boolean hasSemicolon = this.semicolonRegExp().pattern().matcher(name).matches();
            if (hasWhiteSpace || hasSemicolon) {
                this.log().warn((Function0 & Serializable)() -> new StringBuilder(62).append("The table name (").append(name).append(") might bring you SQL injection vulnerability.").toString());
                return;
            }
            return;
        }
    }

    private SQLSyntaxSupportFeature$() {
    }
}

