/*
 * Decompiled with CFR 0.152.
 */
package scalus.uplc.eval;

import java.io.Serializable;
import scala.;
import scala.$less$colon$less$;
import scala.Function2;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.runtime.ScalaRunTime$;
import scalus.builtin.Data;
import scalus.builtin.PlatformSpecific;
import scalus.uplc.Constant$;
import scalus.uplc.DeBruijn$;
import scalus.uplc.DeBruijnedProgram;
import scalus.uplc.DefaultUni$;
import scalus.uplc.Program;
import scalus.uplc.ProgramFlatCodec$;
import scalus.uplc.Term;
import scalus.uplc.Term$Apply$;
import scalus.uplc.Term$Const$;
import scalus.uplc.eval.CekMachine;
import scalus.uplc.eval.CekResult;
import scalus.uplc.eval.CountingBudgetSpender;
import scalus.uplc.eval.ExBudget;
import scalus.uplc.eval.ExBudgetCategory;
import scalus.uplc.eval.Log;
import scalus.uplc.eval.MachineParams;
import scalus.uplc.eval.MachineParams$;
import scalus.uplc.eval.NoBudgetSpender$;
import scalus.uplc.eval.NoLogger$;
import scalus.uplc.eval.RestrictingBudgetSpender;
import scalus.uplc.eval.Result;
import scalus.uplc.eval.Result$Failure$;
import scalus.uplc.eval.Result$Success$;
import scalus.uplc.eval.TallyingBudgetSpenderLogger;

public class PlutusVM {
    private final PlatformSpecific platformSpecific;

    public PlutusVM(PlatformSpecific platformSpecific) {
        this.platformSpecific = platformSpecific;
    }

    public CekResult evaluateScriptCounting(MachineParams params, byte[] script, scala.collection.immutable.Seq<Data> args) {
        DeBruijnedProgram program = ProgramFlatCodec$.MODULE$.decodeFlat(script);
        Term applied = (Term)args.foldLeft((Object)program.term(), (Function2 & Serializable)(acc, arg) -> Term$Apply$.MODULE$.apply((Term)acc, Term$Const$.MODULE$.apply(DefaultUni$.MODULE$.asConstant(arg, Constant$.MODULE$.LiftValueData()))));
        CountingBudgetSpender spender = new CountingBudgetSpender();
        Log logger = new Log();
        CekMachine cek = new CekMachine(params, spender, logger, this.platformSpecific);
        Term resultTerm = cek.evaluateTerm(applied);
        return new CekResult(resultTerm, spender.getSpentBudget(), logger.getLogs());
    }

    public CekResult evaluateScriptCounting(MachineParams params, byte[] script, Data ... args) {
        return this.evaluateScriptCounting(params, script, (scala.collection.immutable.Seq<Data>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])args));
    }

    public CekResult evaluateScriptRestricting(MachineParams params, ExBudget budget, byte[] script, scala.collection.immutable.Seq<Data> args) {
        DeBruijnedProgram program = ProgramFlatCodec$.MODULE$.decodeFlat(script);
        Term applied = (Term)args.foldLeft((Object)program.term(), (Function2 & Serializable)(acc, arg) -> Term$Apply$.MODULE$.apply((Term)acc, Term$Const$.MODULE$.apply(DefaultUni$.MODULE$.asConstant(arg, Constant$.MODULE$.LiftValueData()))));
        RestrictingBudgetSpender spender = new RestrictingBudgetSpender(budget);
        Log logger = new Log();
        CekMachine cek = new CekMachine(params, spender, logger, this.platformSpecific);
        Term resultTerm = cek.evaluateTerm(applied);
        return new CekResult(resultTerm, spender.getSpentBudget(), logger.getLogs());
    }

    public CekResult evaluateScriptRestricting(MachineParams params, ExBudget budget, byte[] script, Data ... args) {
        return this.evaluateScriptRestricting(params, budget, script, (scala.collection.immutable.Seq<Data>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])args));
    }

    public Term evaluateTerm(Term term, MachineParams params) {
        CekMachine cek = new CekMachine(params, NoBudgetSpender$.MODULE$, NoLogger$.MODULE$, this.platformSpecific);
        Term debruijnedTerm = DeBruijn$.MODULE$.deBruijnTerm(term);
        return cek.evaluateTerm(debruijnedTerm);
    }

    public MachineParams evaluateTerm$default$2() {
        return MachineParams$.MODULE$.defaultPlutusV2PostConwayParams();
    }

    public Result evaluateDebug(Term term, MachineParams params) {
        Result result;
        TallyingBudgetSpenderLogger spenderLogger = new TallyingBudgetSpenderLogger(new CountingBudgetSpender());
        CekMachine cekMachine = new CekMachine(params, spenderLogger, spenderLogger, this.platformSpecific);
        Term debruijnedTerm = DeBruijn$.MODULE$.deBruijnTerm(term);
        try {
            result = Result$Success$.MODULE$.apply(DeBruijn$.MODULE$.fromDeBruijnTerm(cekMachine.evaluateTerm(debruijnedTerm)), spenderLogger.getSpentBudget(), (Map<ExBudgetCategory, Seq<ExBudget>>)spenderLogger.costs().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()), spenderLogger.getLogsWithBudget());
        }
        catch (Exception e) {
            result = Result$Failure$.MODULE$.apply(e, spenderLogger.getSpentBudget(), (Map<ExBudgetCategory, Seq<ExBudget>>)spenderLogger.costs().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()), spenderLogger.getLogsWithBudget());
        }
        return result;
    }

    public MachineParams evaluateDebug$default$2() {
        return MachineParams$.MODULE$.defaultPlutusV2PostConwayParams();
    }

    public Term evaluateProgram(Program p, MachineParams params) {
        return this.evaluateTerm(p.term(), params);
    }

    public MachineParams evaluateProgram$default$2() {
        return MachineParams$.MODULE$.defaultPlutusV2PostConwayParams();
    }
}

