/*
 * Decompiled with CFR 0.152.
 */
package com.titan.clients;

import com.titan.clients.InitializeDB;
import com.titan.domain.Customer;
import com.titan.domain.Phone;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import javax.persistence.Query;

public class FetchJoins {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("hibernate.show_sql", "true");
        EntityManagerFactory factory = Persistence.createEntityManagerFactory((String)"titan", props);
        EntityManager manager = factory.createEntityManager();
        try {
            manager.getTransaction().begin();
            System.out.println("Initialize DB");
            InitializeDB.initialize(manager);
            System.out.println();
            System.out.println();
            manager.getTransaction().commit();
            System.out.println();
            System.out.println();
            System.out.println();
            manager.getTransaction().begin();
            FetchJoins.noJoin(manager);
            manager.clear();
            manager.getTransaction().commit();
            System.out.println();
            System.out.println();
            System.out.println();
            manager.getTransaction().begin();
            FetchJoins.joinFetch(manager);
            manager.clear();
            manager.getTransaction().commit();
        }
        finally {
            manager.close();
            factory.close();
        }
    }

    public static void noJoin(EntityManager manager) {
        System.out.println("-----------");
        System.out.println("  NO JOIN  ");
        System.out.println("-----------");
        Query query = manager.createQuery("SELECT c FROM Customer c");
        List results = query.getResultList();
        System.out.println();
        for (Customer c : results) {
            Collection<Phone> phoneNumbers = c.getPhoneNumbers();
            phoneNumbers.size();
            System.out.print(c.getFirstName() + " " + c.getLastName());
            for (Phone p : phoneNumbers) {
                System.out.print(" " + p.getNumber());
            }
            System.out.println("");
        }
    }

    public static void joinFetch(EntityManager manager) {
        System.out.println("------------");
        System.out.println(" JOIN FETCH ");
        System.out.println("------------");
        Query query = manager.createQuery("SELECT c FROM Customer c LEFT JOIN FETCH c.phoneNumbers");
        List results = query.getResultList();
        HashSet set = new HashSet();
        set.addAll(results);
        System.out.println();
        for (Customer c : set) {
            System.out.print(c.getFirstName() + " " + c.getLastName());
            for (Phone p : c.getPhoneNumbers()) {
                System.out.print(" " + p.getNumber());
            }
            System.out.println("");
        }
    }
}

