/*
 * Decompiled with CFR 0.152.
 */
package org.scassandra.cql;

import java.util.Arrays;
import java.util.List;
import org.scassandra.cql.CqlType;

public class TupleType
extends CqlType {
    private final CqlType[] types;

    public static TupleType tuple(CqlType ... types) {
        return new TupleType(types);
    }

    TupleType(CqlType ... types) {
        this.types = types;
    }

    @Override
    public String serialise() {
        StringBuilder s = new StringBuilder("tuple<");
        for (int i = 0; i < this.types.length; ++i) {
            CqlType type = this.types[i];
            s.append(type.serialise());
            if (i >= this.types.length - 1) continue;
            s.append(",");
        }
        s.append(">");
        return s.toString();
    }

    @Override
    public boolean equals(Object expected, Object actual) {
        if (expected == null) {
            return actual == null;
        }
        if (actual == null) {
            return false;
        }
        if (expected instanceof List) {
            List typedExpected = (List)expected;
            List actualList = (List)actual;
            if (typedExpected.size() != actualList.size()) {
                return false;
            }
            if (this.types == null || typedExpected.size() != this.types.length) {
                throw this.throwInvalidType(expected, actual, this);
            }
            for (int i = 0; i < actualList.size(); ++i) {
                CqlType type = this.types[i];
                if (type.equals(typedExpected.get(i), actualList.get(i))) continue;
                return false;
            }
            return true;
        }
        throw this.throwInvalidType(expected, actual, this);
    }

    public CqlType[] getTypes() {
        return this.types;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TupleType)) {
            return false;
        }
        TupleType tupleType = (TupleType)o;
        return Arrays.equals(this.types, tupleType.types);
    }

    public int hashCode() {
        return Arrays.hashCode(this.types);
    }
}

