/*
 * Decompiled with CFR 0.152.
 */
package org.scassandra.http.client;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.scassandra.cql.CqlType;
import org.scassandra.http.client.ColumnTypes;
import org.scassandra.http.client.Config;
import org.scassandra.http.client.Consistency;
import org.scassandra.http.client.Result;
import org.scassandra.http.client.types.ColumnMetadata;

public final class PrimingRequest {
    transient PrimingRequestBuilder.PrimeType primeType;
    private final When when;
    private final Then then;

    public static PrimingRequestBuilder queryBuilder() {
        return new PrimingRequestBuilder(PrimingRequestBuilder.PrimeType.QUERY);
    }

    public static PrimingRequestBuilder preparedStatementBuilder() {
        return new PrimingRequestBuilder(PrimingRequestBuilder.PrimeType.PREPARED);
    }

    public static Then.ThenBuilder then() {
        return new Then.ThenBuilder();
    }

    public static Then.ThenBuilder andThen() {
        return PrimingRequest.then();
    }

    private PrimingRequest(PrimingRequestBuilder.PrimeType primeType, String query, String queryPattern, List<Consistency> consistency, List<Map<String, ?>> rows, Result result, List<ColumnMetadata> columnTypes, List<CqlType> variableTypes, Long fixedDelay, Map<String, Object> config) {
        this(primeType, query, queryPattern, consistency, new Then(rows, result, columnTypes, variableTypes, fixedDelay, config));
    }

    private PrimingRequest(PrimingRequestBuilder.PrimeType primeType, String query, String queryPattern, List<Consistency> consistency, Then then) {
        this.primeType = primeType;
        this.when = new When(query, queryPattern, consistency);
        this.then = then;
    }

    public When getWhen() {
        return this.when;
    }

    public Then getThen() {
        return this.then;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PrimingRequest that = (PrimingRequest)o;
        if (this.then != null ? !this.then.equals(that.then) : that.then != null) {
            return false;
        }
        return !(this.when != null ? !this.when.equals(that.when) : that.when != null);
    }

    public int hashCode() {
        int result = this.when != null ? this.when.hashCode() : 0;
        result = 31 * result + (this.then != null ? this.then.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "PrimingRequest{when='" + this.when + '\'' + ", then=" + this.then + '}';
    }

    public static final class When {
        private final String query;
        private final String queryPattern;
        private final List<Consistency> consistency;

        private When(String query, String queryPattern, List<Consistency> consistency) {
            this.query = query;
            this.consistency = consistency;
            this.queryPattern = queryPattern;
        }

        public String toString() {
            return "When{query='" + this.query + '\'' + ", queryPattern='" + this.queryPattern + '\'' + ", consistency=" + this.consistency + '}';
        }

        public String getQuery() {
            return this.query;
        }

        public List<Consistency> getConsistency() {
            return Collections.unmodifiableList(this.consistency);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof When)) {
                return false;
            }
            When when = (When)o;
            if (this.consistency != null ? !this.consistency.equals(when.consistency) : when.consistency != null) {
                return false;
            }
            if (this.query != null ? !this.query.equals(when.query) : when.query != null) {
                return false;
            }
            return !(this.queryPattern != null ? !this.queryPattern.equals(when.queryPattern) : when.queryPattern != null);
        }

        public int hashCode() {
            int result = this.query != null ? this.query.hashCode() : 0;
            result = 31 * result + (this.queryPattern != null ? this.queryPattern.hashCode() : 0);
            result = 31 * result + (this.consistency != null ? this.consistency.hashCode() : 0);
            return result;
        }
    }

    public static final class Then {
        private final List<CqlType> variable_types;
        private final List<Map<String, ? extends Object>> rows;
        private final Result result;
        private final Map<String, CqlType> column_types;
        private final Long fixedDelay;
        private final Map<String, Object> config;

        private Then(List<Map<String, ?>> rows, Result result, List<ColumnMetadata> column_types, List<CqlType> variable_types, Long fixedDelay, Map<String, Object> config) {
            this.rows = rows;
            this.result = result;
            this.variable_types = variable_types;
            this.fixedDelay = fixedDelay;
            Map<String, Object> map = this.config = config.isEmpty() ? null : config;
            if (column_types != null) {
                this.column_types = new HashMap<String, CqlType>();
                for (ColumnMetadata column_type : column_types) {
                    this.column_types.put(column_type.getName(), column_type.getType());
                }
            } else {
                this.column_types = null;
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Then then = (Then)o;
            if (this.column_types != null ? !this.column_types.equals(then.column_types) : then.column_types != null) {
                return false;
            }
            if (this.config != null ? !this.config.equals(then.config) : then.config != null) {
                return false;
            }
            if (this.fixedDelay != null ? !this.fixedDelay.equals(then.fixedDelay) : then.fixedDelay != null) {
                return false;
            }
            if (this.result != then.result) {
                return false;
            }
            if (this.rows != null ? !this.rows.equals(then.rows) : then.rows != null) {
                return false;
            }
            return !(this.variable_types != null ? !this.variable_types.equals(then.variable_types) : then.variable_types != null);
        }

        public int hashCode() {
            int result1 = this.variable_types != null ? this.variable_types.hashCode() : 0;
            result1 = 31 * result1 + (this.rows != null ? this.rows.hashCode() : 0);
            result1 = 31 * result1 + (this.result != null ? this.result.hashCode() : 0);
            result1 = 31 * result1 + (this.column_types != null ? this.column_types.hashCode() : 0);
            result1 = 31 * result1 + (this.fixedDelay != null ? this.fixedDelay.hashCode() : 0);
            result1 = 31 * result1 + (this.config != null ? this.config.hashCode() : 0);
            return result1;
        }

        public String toString() {
            return "Then{variable_types=" + this.variable_types + ", rows=" + this.rows + ", result=" + (Object)((Object)this.result) + ", column_types=" + this.column_types + ", fixedDelay=" + this.fixedDelay + ", config=" + this.config + '}';
        }

        public List<CqlType> getVariableTypes() {
            return this.variable_types;
        }

        public List<Map<String, ? extends Object>> getRows() {
            return Collections.unmodifiableList(this.rows);
        }

        public Result getResult() {
            return this.result;
        }

        public Map<String, CqlType> getColumnTypes() {
            return this.column_types;
        }

        public long getFixedDelay() {
            return this.fixedDelay;
        }

        public Map<String, Object> getConfig() {
            return Collections.unmodifiableMap(this.config);
        }

        public static class ThenBuilder {
            private List<CqlType> variable_types;
            private List<Map<String, ? extends Object>> rows;
            private Result result;
            private Long fixedDelay;
            private Map<String, Object> config = new HashMap<String, Object>();
            private List<ColumnMetadata> columnTypesMeta;

            ThenBuilder() {
            }

            public ThenBuilder withVariableTypes(List<CqlType> variable_types) {
                this.variable_types = variable_types;
                return this;
            }

            public ThenBuilder withVariableTypes(CqlType ... variableTypes) {
                this.variable_types = Arrays.asList(variableTypes);
                return this;
            }

            public ThenBuilder withRows(List<Map<String, ? extends Object>> rows) {
                this.rows = rows;
                return this;
            }

            @SafeVarargs
            public final ThenBuilder withRows(Map<String, ? extends Object> ... rows) {
                this.rows = Arrays.asList(rows);
                return this;
            }

            public ThenBuilder withResult(Result result) {
                this.result = result;
                return this;
            }

            public ThenBuilder withColumnTypes(ColumnMetadata ... columnMetadata) {
                this.columnTypesMeta = Arrays.asList(columnMetadata);
                return this;
            }

            public ThenBuilder withFixedDelay(Long fixedDelay) {
                this.fixedDelay = fixedDelay;
                return this;
            }

            @Deprecated
            public ThenBuilder withConfig(Map<String, Object> config) {
                this.config = config;
                return this;
            }

            public ThenBuilder withConfig(Config config) {
                this.config.putAll(config.getProperties());
                return this;
            }

            public Then build() {
                List<Map<String, Object>> rowsDefaultedToEmptyForSuccess = this.rows;
                if (this.result == Result.success && this.rows == null) {
                    rowsDefaultedToEmptyForSuccess = Collections.emptyList();
                }
                return new Then(rowsDefaultedToEmptyForSuccess, this.result, this.columnTypesMeta, this.variable_types, this.fixedDelay, this.config);
            }
        }
    }

    public static class PrimingRequestBuilder {
        PrimeType type;
        private Consistency[] consistency;
        private List<ColumnMetadata> columnTypesMeta;
        private List<CqlType> variableTypesMeta;
        private String query;
        private String queryPattern;
        private List<Map<String, ?>> rows;
        private Result result = Result.success;
        private Long fixedDelay;
        private Map<String, Object> config = new HashMap<String, Object>();
        private Then then;

        private PrimingRequestBuilder(PrimeType type) {
            this.type = type;
        }

        public PrimingRequestBuilder withQuery(String query) {
            this.query = query;
            return this;
        }

        public PrimingRequestBuilder withConsistency(Consistency ... consistencies) {
            this.consistency = consistencies;
            return this;
        }

        public PrimingRequestBuilder withQueryPattern(String queryPattern) {
            this.queryPattern = queryPattern;
            return this;
        }

        public PrimingRequestBuilder withThen(Then then) {
            this.then = then;
            return this;
        }

        public PrimingRequestBuilder withThen(Then.ThenBuilder then) {
            this.then = then.build();
            return this;
        }

        @Deprecated
        public PrimingRequestBuilder withFixedDelay(long fixedDelay) {
            this.fixedDelay = fixedDelay;
            return this;
        }

        @Deprecated
        public PrimingRequestBuilder withRows(List<Map<String, ?>> rows) {
            this.rows = rows;
            return this;
        }

        @Deprecated
        @SafeVarargs
        public final PrimingRequestBuilder withRows(Map<String, ? extends Object> ... rows) {
            this.rows = Arrays.asList(rows);
            return this;
        }

        @Deprecated
        public PrimingRequestBuilder withResult(Result result) {
            this.result = result;
            return this;
        }

        @Deprecated
        public PrimingRequestBuilder withColumnTypes(ColumnMetadata ... columnMetadata) {
            this.columnTypesMeta = Arrays.asList(columnMetadata);
            return this;
        }

        @Deprecated
        public PrimingRequestBuilder withConfig(Config readTimeoutConfig) {
            this.config.putAll(readTimeoutConfig.getProperties());
            return this;
        }

        @Deprecated
        public PrimingRequestBuilder withColumnTypes(Map<String, ColumnTypes> types) {
            ArrayList<ColumnMetadata> columnMetadata = new ArrayList<ColumnMetadata>();
            for (Map.Entry<String, ColumnTypes> entry : types.entrySet()) {
                columnMetadata.add(ColumnMetadata.column(entry.getKey(), entry.getValue().getType()));
            }
            this.columnTypesMeta = columnMetadata;
            return this;
        }

        @Deprecated
        public PrimingRequestBuilder withVariableTypes(ColumnTypes ... variableTypes) {
            ArrayList<CqlType> variableTypesMeta = new ArrayList<CqlType>();
            for (ColumnTypes variableType : variableTypes) {
                variableTypesMeta.add(variableType.getType());
            }
            this.variableTypesMeta = variableTypesMeta;
            return this;
        }

        @Deprecated
        public PrimingRequestBuilder withVariableTypes(CqlType ... variableTypes) {
            this.variableTypesMeta = Arrays.asList(variableTypes);
            return this;
        }

        public PrimingRequest build() {
            List<Consistency> consistencies;
            if (this.query != null && this.queryPattern != null) {
                throw new IllegalStateException("Can't specify query and queryPattern");
            }
            if (this.query == null && this.queryPattern == null) {
                throw new IllegalStateException("Must set either query or queryPattern for PrimingRequest");
            }
            List<Consistency> list = consistencies = this.consistency == null ? null : Arrays.asList(this.consistency);
            if (this.then == null) {
                List<Map<String, Object>> rowsDefaultedToEmptyForSuccess = this.rows;
                if (this.result == Result.success && this.rows == null) {
                    rowsDefaultedToEmptyForSuccess = Collections.emptyList();
                }
                return new PrimingRequest(this.type, this.query, this.queryPattern, consistencies, rowsDefaultedToEmptyForSuccess, this.result, this.columnTypesMeta, this.variableTypesMeta, this.fixedDelay, this.config);
            }
            return new PrimingRequest(this.type, this.query, this.queryPattern, consistencies, this.then);
        }

        static enum PrimeType {
            QUERY,
            PREPARED;

        }
    }
}

