/*
 * Decompiled with CFR 0.152.
 */
package org.scassandra.http.client;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.scassandra.http.client.Config;
import org.scassandra.http.client.Consistency;
import org.scassandra.http.client.WriteTypePrime;
import org.scassandra.server.priming.ErrorConstants;

public class WriteTimeoutConfig
extends Config {
    private final WriteTypePrime writeType;
    private final int receivedAcknowledgements;
    private final int requiredAcknowledgements;
    private final Consistency consistencyLevel;

    public WriteTimeoutConfig(WriteTypePrime writeType, int receivedAcknowledgements, int requiredAcknowledgements) {
        this(writeType, receivedAcknowledgements, requiredAcknowledgements, null);
    }

    public WriteTimeoutConfig(WriteTypePrime writeType, int receivedAcknowledgements, int requiredAcknowledgements, Consistency consistencyLevel) {
        this.writeType = writeType;
        this.receivedAcknowledgements = receivedAcknowledgements;
        this.requiredAcknowledgements = requiredAcknowledgements;
        this.consistencyLevel = consistencyLevel;
    }

    @Override
    Map<String, ?> getProperties() {
        ImmutableMap.Builder builder = ImmutableMap.builder().put((Object)ErrorConstants.ReceivedResponse(), (Object)String.valueOf(this.receivedAcknowledgements)).put((Object)ErrorConstants.RequiredResponse(), (Object)String.valueOf(this.requiredAcknowledgements)).put((Object)ErrorConstants.WriteType(), (Object)String.valueOf(this.writeType.toString()));
        if (this.consistencyLevel != null) {
            builder.put((Object)ErrorConstants.ConsistencyLevel(), (Object)String.valueOf(this.consistencyLevel.toString()));
        }
        return builder.build();
    }
}

