/*
 * Decompiled with CFR 0.152.
 */
package org.scassandra.junit;

import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.scassandra.Scassandra;
import org.scassandra.ScassandraFactory;
import org.scassandra.http.client.ActivityClient;
import org.scassandra.http.client.PrimingClient;

public class ScassandraServerRule
implements TestRule {
    private Scassandra scassandra;
    private boolean started = false;

    public ScassandraServerRule() {
        this.scassandra = ScassandraFactory.createServer();
    }

    public ScassandraServerRule(int binaryPort, int adminPort) {
        this.scassandra = ScassandraFactory.createServer(binaryPort, adminPort);
    }

    public Statement apply(final Statement base, Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                if (!ScassandraServerRule.this.started) {
                    ScassandraServerRule.this.started = true;
                    ScassandraServerRule.this.scassandra.start();
                    try {
                        base.evaluate();
                    }
                    finally {
                        ScassandraServerRule.this.scassandra.stop();
                        ScassandraServerRule.this.started = false;
                    }
                } else {
                    ScassandraServerRule.this.primingClient().clearAllPrimes();
                    ScassandraServerRule.this.activityClient().clearAllRecordedActivity();
                    base.evaluate();
                }
            }
        };
    }

    public PrimingClient primingClient() {
        return this.scassandra.primingClient();
    }

    public ActivityClient activityClient() {
        return this.scassandra.activityClient();
    }
}

