/*
 * Decompiled with CFR 0.152.
 */
package org.scassandra.http.client;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.scassandra.http.client.BatchQueryKind;

public final class BatchQuery {
    private final String query;
    private final BatchQueryKind batchQueryKind;
    private final List<Object> variables;

    private BatchQuery(String query, BatchQueryKind batchQueryKind, List<Object> variables) {
        this.query = query;
        this.batchQueryKind = batchQueryKind;
        this.variables = variables;
    }

    public String getQuery() {
        return this.query;
    }

    public BatchQueryKind getBatchQueryKind() {
        return this.batchQueryKind;
    }

    public List<Object> getVariables() {
        return this.variables;
    }

    public String toString() {
        return "BatchQuery{query='" + this.query + '\'' + ", batchQueryKind=" + (Object)((Object)this.batchQueryKind) + ", variables=" + this.variables + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BatchQuery that = (BatchQuery)o;
        if (this.query != null ? !this.query.equals(that.query) : that.query != null) {
            return false;
        }
        if (this.batchQueryKind != that.batchQueryKind) {
            return false;
        }
        return !(this.variables == null ? that.variables != null : !this.variables.equals(that.variables));
    }

    public int hashCode() {
        int result = this.query != null ? this.query.hashCode() : 0;
        result = 31 * result + (this.batchQueryKind != null ? this.batchQueryKind.hashCode() : 0);
        result = 31 * result + (this.variables != null ? this.variables.hashCode() : 0);
        return result;
    }

    public static BatchQueryBuilder builder() {
        return new BatchQueryBuilder();
    }

    public static class BatchQueryBuilder {
        private String query;
        private BatchQueryKind batchQueryKind = BatchQueryKind.query;
        private List<Object> variables = new ArrayList<Object>();

        private BatchQueryBuilder() {
        }

        public BatchQueryBuilder withQuery(String query) {
            this.query = query;
            return this;
        }

        public BatchQueryBuilder withType(BatchQueryKind type) {
            this.batchQueryKind = type;
            return this;
        }

        public BatchQueryBuilder withVariables(Object ... variables) {
            this.variables = Arrays.asList(variables);
            return this;
        }

        public BatchQuery build() {
            return new BatchQuery(this.query, this.batchQueryKind, this.variables);
        }
    }
}

