/*
 * Decompiled with CFR 0.152.
 */
package org.scassandra.http.client;

import java.net.InetSocketAddress;

public final class ClientConnection {
    private final String host;
    private final int port;

    private ClientConnection(String host, int port) {
        this.host = host;
        this.port = port;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public InetSocketAddress getAddress() {
        return new InetSocketAddress(this.host, this.port);
    }

    public String toString() {
        return "ClientConnection{host='" + this.host + '\'' + ",port=" + this.port + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ClientConnection)) {
            return false;
        }
        ClientConnection that = (ClientConnection)o;
        if (this.port != that.port) {
            return false;
        }
        return !(this.host == null ? that.host != null : !this.host.equals(that.host));
    }

    public int hashCode() {
        int result = this.host != null ? this.host.hashCode() : 0;
        result = 31 * result + this.port;
        return result;
    }
}

