/*
 * Decompiled with CFR 0.152.
 */
package org.scassandra.http.client;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.lang.reflect.Type;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.scassandra.http.client.ClosedConnectionReport;
import org.scassandra.http.client.ConnectionReport;
import org.scassandra.http.client.ConnectionsRequestFailed;
import org.scassandra.http.client.CurrentConnectionReport;
import org.scassandra.http.client.ListenerRequestFailed;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CurrentClient {
    private static final String REQUEST_FOR_CONNECTIONS_FAILED = "Request for connections failed";
    private static final String REQUEST_FAILED = "Request failed";
    private final Type map = new TypeToken<Map<String, Boolean>>(){}.getType();
    private static final Logger LOGGER = LoggerFactory.getLogger(CurrentClient.class);
    private final CloseableHttpClient httpClient;
    private final String currentUrl;
    private final String connectionsUrl;
    private final String listenerUrl;
    private final Gson gson = new GsonBuilder().create();

    public static CurrentClientBuilder builder() {
        return new CurrentClientBuilder();
    }

    private CurrentClient(String host, int port, int socketTimeout) {
        RequestConfig.Builder requestBuilder = RequestConfig.custom();
        requestBuilder = requestBuilder.setConnectTimeout(socketTimeout);
        requestBuilder = requestBuilder.setConnectionRequestTimeout(socketTimeout);
        requestBuilder = requestBuilder.setSocketTimeout(socketTimeout);
        HttpClientBuilder builder = HttpClientBuilder.create();
        builder.setDefaultRequestConfig(requestBuilder.build());
        this.httpClient = builder.build();
        this.currentUrl = "http://" + host + ":" + port + "/current";
        this.connectionsUrl = this.currentUrl + "/connections";
        this.listenerUrl = this.currentUrl + "/listener";
    }

    public ConnectionReport getConnections() {
        return this.getConnectionsByUrl("");
    }

    public ConnectionReport getConnections(String ip) {
        return this.getConnectionsByUrl("/" + ip);
    }

    public ConnectionReport getConnections(InetAddress address) {
        return this.getConnectionsByUrl("/" + address.getHostAddress());
    }

    public ConnectionReport getConnection(String host, int port) {
        return this.getConnectionsByUrl("/" + host + "/" + port);
    }

    public ConnectionReport getConnection(InetSocketAddress address) {
        return this.getConnection(address.getAddress().getHostAddress(), address.getPort());
    }

    private ConnectionReport getConnectionsByUrl(String url) {
        HttpGet get = new HttpGet(this.connectionsUrl + url);
        try {
            CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)get);
            String body = EntityUtils.toString((HttpEntity)response.getEntity());
            LOGGER.debug("Received response {}", (Object)body);
            return (ConnectionReport)this.gson.fromJson(body, CurrentConnectionReport.class);
        }
        catch (IOException e) {
            LOGGER.info(REQUEST_FOR_CONNECTIONS_FAILED, (Throwable)e);
            throw new ConnectionsRequestFailed(REQUEST_FOR_CONNECTIONS_FAILED, e);
        }
    }

    public ClosedConnectionReport closeConnections(ClosedConnectionReport.CloseType closeType) {
        return this.closeConnectionsByUrl(closeType, "");
    }

    public ClosedConnectionReport closeConnections(ClosedConnectionReport.CloseType closeType, String ip) {
        return this.closeConnectionsByUrl(closeType, "/" + ip);
    }

    public ClosedConnectionReport closeConnections(ClosedConnectionReport.CloseType closeType, InetAddress address) {
        return this.closeConnectionsByUrl(closeType, "/" + address.getHostAddress());
    }

    public ClosedConnectionReport closeConnection(ClosedConnectionReport.CloseType closeType, String host, int port) {
        return this.closeConnectionsByUrl(closeType, "/" + host + "/" + port);
    }

    public ClosedConnectionReport closeConnection(ClosedConnectionReport.CloseType closeType, InetSocketAddress address) {
        return this.closeConnectionsByUrl(closeType, "/" + address.getAddress().getHostAddress() + "/" + address.getPort());
    }

    private ClosedConnectionReport closeConnectionsByUrl(ClosedConnectionReport.CloseType closeType, String url) {
        URI httpUrl;
        try {
            httpUrl = new URIBuilder(this.connectionsUrl + url).setParameter("type", closeType.name().toLowerCase()).build();
        }
        catch (URISyntaxException e) {
            throw new ConnectionsRequestFailed(REQUEST_FAILED, e);
        }
        HttpDelete delete = new HttpDelete(httpUrl);
        try {
            CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)delete);
            String body = EntityUtils.toString((HttpEntity)response.getEntity());
            LOGGER.debug("Received response {}", (Object)body);
            return (ClosedConnectionReport)this.gson.fromJson(body, ClosedConnectionReport.class);
        }
        catch (IOException e) {
            LOGGER.warn(REQUEST_FAILED, (Throwable)e);
            throw new ConnectionsRequestFailed(REQUEST_FAILED, e);
        }
    }

    public boolean enableListener() {
        HttpPut put = new HttpPut(this.listenerUrl);
        return this.invokeListener((HttpUriRequest)put);
    }

    public boolean disableListener() {
        return this.disableListener(0);
    }

    public boolean disableListener(int after) {
        URI httpUrl;
        try {
            httpUrl = new URIBuilder(this.listenerUrl).setParameter("after", Integer.toString(after)).build();
        }
        catch (URISyntaxException e) {
            throw new ListenerRequestFailed(REQUEST_FAILED, e);
        }
        HttpDelete delete = new HttpDelete(httpUrl);
        return this.invokeListener((HttpUriRequest)delete);
    }

    private boolean invokeListener(HttpUriRequest request) {
        try {
            CloseableHttpResponse response = this.httpClient.execute(request);
            String body = EntityUtils.toString((HttpEntity)response.getEntity());
            LOGGER.debug("Received response {}", (Object)body);
            Map data = (Map)this.gson.fromJson(body, this.map);
            Boolean changed = (Boolean)data.get("changed");
            return changed == null ? false : changed;
        }
        catch (IOException e) {
            LOGGER.info(REQUEST_FAILED, (Throwable)e);
            throw new ListenerRequestFailed(REQUEST_FAILED, e);
        }
    }

    public static class CurrentClientBuilder {
        private String host = "localhost";
        private int port = 8043;
        private int socketTimeout = 5000;

        public CurrentClientBuilder withHost(String host) {
            this.host = host;
            return this;
        }

        public CurrentClientBuilder withPort(int port) {
            this.port = port;
            return this;
        }

        public CurrentClientBuilder withSocketTimeout(int timeout) {
            this.socketTimeout = timeout;
            return this;
        }

        public CurrentClient build() {
            return new CurrentClient(this.host, this.port, this.socketTimeout);
        }
    }
}

