/*
 * Decompiled with CFR 0.152.
 */
package org.scassandra.http.client;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.scassandra.http.client.Config;
import org.scassandra.http.client.Consistency;
import org.scassandra.server.priming.ErrorConstants;

public class ReadFailureConfig
extends Config {
    private final int receivedAcknowledgements;
    private final int requiredAcknowledgements;
    private final int numberOfFailures;
    private final boolean dataRetrieved;
    private final Consistency consistencyLevel;

    public ReadFailureConfig(int receivedAcknowledgements, int requiredAcknowledgements, int numberOfFailures, boolean dataRetrieved) {
        this(receivedAcknowledgements, requiredAcknowledgements, numberOfFailures, dataRetrieved, null);
    }

    public ReadFailureConfig(int receivedAcknowledgements, int requiredAcknowledgements, int numberOfFailures, boolean dataRetrieved, Consistency consistencyLevel) {
        this.receivedAcknowledgements = receivedAcknowledgements;
        this.requiredAcknowledgements = requiredAcknowledgements;
        this.numberOfFailures = numberOfFailures;
        this.dataRetrieved = dataRetrieved;
        this.consistencyLevel = consistencyLevel;
    }

    @Override
    Map<String, ?> getProperties() {
        ImmutableMap.Builder builder = ImmutableMap.builder().put((Object)ErrorConstants.ReceivedResponse(), (Object)String.valueOf(this.receivedAcknowledgements)).put((Object)ErrorConstants.RequiredResponse(), (Object)String.valueOf(this.requiredAcknowledgements)).put((Object)ErrorConstants.NumberOfFailures(), (Object)String.valueOf(this.numberOfFailures)).put((Object)ErrorConstants.DataPresent(), (Object)String.valueOf(this.dataRetrieved));
        if (this.consistencyLevel != null) {
            builder.put((Object)ErrorConstants.ConsistencyLevel(), (Object)String.valueOf(this.consistencyLevel.toString()));
        }
        return builder.build();
    }
}

