/*
 * Decompiled with CFR 0.152.
 */
package org.scassandra.http.client;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.scassandra.http.client.Config;
import org.scassandra.http.client.Consistency;
import org.scassandra.http.client.WriteTypePrime;
import org.scassandra.server.priming.ErrorConstants;

public class WriteFailureConfig
extends Config {
    private final WriteTypePrime writeType;
    private final int receivedAcknowledgements;
    private final int requiredAcknowledgements;
    private final int numberOfFailures;
    private final Consistency consistencyLevel;

    public WriteFailureConfig(WriteTypePrime writeType, int receivedAcknowledgements, int requiredAcknowledgements, int numberOfFailures) {
        this(writeType, receivedAcknowledgements, requiredAcknowledgements, numberOfFailures, null);
    }

    public WriteFailureConfig(WriteTypePrime writeType, int receivedAcknowledgements, int requiredAcknowledgements, int numberOfFailures, Consistency consistencyLevel) {
        this.writeType = writeType;
        this.receivedAcknowledgements = receivedAcknowledgements;
        this.requiredAcknowledgements = requiredAcknowledgements;
        this.numberOfFailures = numberOfFailures;
        this.consistencyLevel = consistencyLevel;
    }

    @Override
    Map<String, ?> getProperties() {
        ImmutableMap.Builder builder = ImmutableMap.builder().put((Object)ErrorConstants.ReceivedResponse(), (Object)String.valueOf(this.receivedAcknowledgements)).put((Object)ErrorConstants.RequiredResponse(), (Object)String.valueOf(this.requiredAcknowledgements)).put((Object)ErrorConstants.NumberOfFailures(), (Object)String.valueOf(this.numberOfFailures)).put((Object)ErrorConstants.WriteType(), (Object)String.valueOf(this.writeType.toString()));
        if (this.consistencyLevel != null) {
            builder.put((Object)ErrorConstants.ConsistencyLevel(), (Object)String.valueOf(this.consistencyLevel.toString()));
        }
        return builder.build();
    }
}

