/*
 * Decompiled with CFR 0.152.
 */
package org.scassandra.http.client;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.scassandra.http.client.BatchQuery;
import org.scassandra.http.client.BatchType;

public final class BatchExecution {
    private final List<BatchQuery> batchQueries;
    private final String consistency;
    private final String serialConsistency;
    private final BatchType batchType;
    private final Long timestamp;

    private BatchExecution(List<BatchQuery> batchQueries, String consistency, String serialConsistency, BatchType batchType, Long timestamp) {
        this.batchQueries = batchQueries;
        this.consistency = consistency;
        this.serialConsistency = serialConsistency;
        this.batchType = batchType;
        this.timestamp = timestamp;
    }

    public List<BatchQuery> getBatchQueries() {
        return this.batchQueries;
    }

    public String getConsistency() {
        return this.consistency;
    }

    public String getSerialConsistency() {
        return this.serialConsistency;
    }

    public BatchType getBatchType() {
        return this.batchType;
    }

    public Long getTimestamp() {
        return this.timestamp;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BatchExecution that = (BatchExecution)o;
        if (this.batchQueries != null ? !this.batchQueries.equals(that.batchQueries) : that.batchQueries != null) {
            return false;
        }
        if (this.consistency != null ? !this.consistency.equals(that.consistency) : that.consistency != null) {
            return false;
        }
        if (this.serialConsistency != null ? !this.serialConsistency.equals(that.serialConsistency) : that.serialConsistency != null) {
            return false;
        }
        if (this.batchType != that.batchType) {
            return false;
        }
        return this.timestamp != null ? this.timestamp.equals(that.timestamp) : that.timestamp == null;
    }

    public int hashCode() {
        int result = this.batchQueries != null ? this.batchQueries.hashCode() : 0;
        result = 31 * result + (this.consistency != null ? this.consistency.hashCode() : 0);
        result = 31 * result + (this.serialConsistency != null ? this.serialConsistency.hashCode() : 0);
        result = 31 * result + (this.batchType != null ? this.batchType.hashCode() : 0);
        result = 31 * result + (this.timestamp != null ? this.timestamp.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "BatchExecution{batchQueries=" + this.batchQueries + ", consistency='" + this.consistency + '\'' + ", serialConsistency='" + this.serialConsistency + '\'' + ", batchType=" + (Object)((Object)this.batchType) + ", timestamp=" + this.timestamp + '}';
    }

    public static BatchExecutionBuilder builder() {
        return new BatchExecutionBuilder();
    }

    public static class BatchExecutionBuilder {
        private List<BatchQuery> batchQueries;
        private String consistency = "ONE";
        private String serialConsistency;
        private BatchType batchType = BatchType.LOGGED;
        private Long timestamp;

        private BatchExecutionBuilder() {
        }

        public BatchExecutionBuilder withBatchQueries(List<BatchQuery> batchQueries) {
            this.batchQueries = batchQueries;
            return this;
        }

        public BatchExecutionBuilder withBatchQueries(BatchQuery ... batchQueries) {
            this.batchQueries = Arrays.asList(batchQueries);
            return this;
        }

        public BatchExecutionBuilder withBatchQueries(BatchQuery.BatchQueryBuilder ... batchQueries) {
            this.batchQueries = new ArrayList<BatchQuery>();
            for (BatchQuery.BatchQueryBuilder bq : batchQueries) {
                this.batchQueries.add(bq.build());
            }
            return this;
        }

        public BatchExecutionBuilder withConsistency(String consistency) {
            this.consistency = consistency;
            return this;
        }

        public BatchExecutionBuilder withSerialConsistency(String serialConsistency) {
            this.serialConsistency = serialConsistency;
            return this;
        }

        public BatchExecutionBuilder withBatchType(BatchType batchType) {
            this.batchType = batchType;
            return this;
        }

        public BatchExecutionBuilder withTimestamp(Long timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public BatchExecution build() {
            return new BatchExecution(this.batchQueries, this.consistency, this.serialConsistency, this.batchType, this.timestamp);
        }
    }
}

