/*
 * Decompiled with CFR 0.152.
 */
package org.scassandra.http.client;

import com.google.common.base.Function;
import com.google.common.collect.FluentIterable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.scassandra.cql.CqlType;
import org.scassandra.http.client.ColumnTypes;

public final class PreparedStatementExecution {
    private final String preparedStatementText;
    private final String consistency;
    private final String serialConsistency;
    private final List<Object> variables;
    private final List<CqlType> variableTypes;
    private final Long timestamp;

    private PreparedStatementExecution(String preparedStatementText, String consistency, String serialConsistency, List<Object> variables, List<CqlType> variableTypes, Long timestamp) {
        this.preparedStatementText = preparedStatementText;
        this.consistency = consistency;
        this.serialConsistency = serialConsistency;
        this.variables = variables;
        this.variableTypes = variableTypes;
        this.timestamp = timestamp;
    }

    public String getPreparedStatementText() {
        return this.preparedStatementText;
    }

    public String getConsistency() {
        return this.consistency;
    }

    public String getSerialConsistency() {
        return this.serialConsistency;
    }

    public Long getTimestamp() {
        return this.timestamp;
    }

    public List<Object> getVariables() {
        return Collections.unmodifiableList(this.variables);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PreparedStatementExecution that = (PreparedStatementExecution)o;
        if (this.preparedStatementText != null ? !this.preparedStatementText.equals(that.preparedStatementText) : that.preparedStatementText != null) {
            return false;
        }
        if (this.consistency != null ? !this.consistency.equals(that.consistency) : that.consistency != null) {
            return false;
        }
        if (this.serialConsistency != null ? !this.serialConsistency.equals(that.serialConsistency) : that.serialConsistency != null) {
            return false;
        }
        if (this.variables != null ? !this.variables.equals(that.variables) : that.variables != null) {
            return false;
        }
        if (this.variableTypes != null ? !this.variableTypes.equals(that.variableTypes) : that.variableTypes != null) {
            return false;
        }
        return this.timestamp != null ? this.timestamp.equals(that.timestamp) : that.timestamp == null;
    }

    public int hashCode() {
        int result = this.preparedStatementText != null ? this.preparedStatementText.hashCode() : 0;
        result = 31 * result + (this.consistency != null ? this.consistency.hashCode() : 0);
        result = 31 * result + (this.serialConsistency != null ? this.serialConsistency.hashCode() : 0);
        result = 31 * result + (this.variables != null ? this.variables.hashCode() : 0);
        result = 31 * result + (this.variableTypes != null ? this.variableTypes.hashCode() : 0);
        result = 31 * result + (this.timestamp != null ? this.timestamp.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "PreparedStatementExecution{preparedStatementText='" + this.preparedStatementText + '\'' + ", consistency='" + this.consistency + '\'' + ", serialConsistency='" + this.serialConsistency + "', variables=" + this.variables + ", timestamp=" + this.timestamp + '}';
    }

    public static PreparedStatementExecutionBuilder builder() {
        return new PreparedStatementExecutionBuilder();
    }

    public static PreparedStatementExecutionBuilder builder(List<ColumnTypes> variableTypes) {
        return new PreparedStatementExecutionBuilder(variableTypes);
    }

    public static PreparedStatementExecutionBuilder builder(ColumnTypes ... variableTypes) {
        return new PreparedStatementExecutionBuilder(Arrays.asList(variableTypes));
    }

    public List<CqlType> getVariableTypes() {
        return this.variableTypes;
    }

    public static class PreparedStatementExecutionBuilder {
        private List<CqlType> variableTypes = Collections.emptyList();
        private String preparedStatementText;
        private String consistency = "ONE";
        private String serialConsistency;
        private List<Object> variables = Collections.emptyList();
        private Long timestamp;

        private PreparedStatementExecutionBuilder() {
        }

        @Deprecated
        public PreparedStatementExecutionBuilder(List<ColumnTypes> variableTypes) {
            this.variableTypes = FluentIterable.from(variableTypes).transform((Function)new Function<ColumnTypes, CqlType>(){

                public CqlType apply(ColumnTypes input) {
                    return input.getType();
                }
            }).toList();
        }

        public PreparedStatementExecutionBuilder(CqlType ... variableTypes) {
            this.variableTypes = Arrays.asList(variableTypes);
        }

        public PreparedStatementExecutionBuilder withConsistency(String consistency) {
            this.consistency = consistency;
            return this;
        }

        public PreparedStatementExecutionBuilder withSerialConsistency(String serialConsistency) {
            this.serialConsistency = serialConsistency;
            return this;
        }

        public PreparedStatementExecutionBuilder withPreparedStatementText(String preparedStatementText) {
            this.preparedStatementText = preparedStatementText;
            return this;
        }

        public PreparedStatementExecutionBuilder withVariables(Object ... variables) {
            this.variables = Arrays.asList(variables);
            return this;
        }

        public PreparedStatementExecutionBuilder withVariables(List<Object> variables) {
            this.variables = variables;
            return this;
        }

        public PreparedStatementExecutionBuilder withTimestamp(Long timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public PreparedStatementExecution build() {
            if (this.preparedStatementText == null) {
                throw new IllegalStateException("Must set preparedStatementText in PreparedStatementExecutionBuilder");
            }
            return new PreparedStatementExecution(this.preparedStatementText, this.consistency, this.serialConsistency, this.variables, this.variableTypes, this.timestamp);
        }
    }
}

