/*
 * Decompiled with CFR 0.152.
 */
package org.scassandra.http.client;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.scassandra.cql.CqlType;

public final class Query {
    private final String query;
    private final String consistency;
    private final String serialConsistency;
    private final List<Object> variables;
    private final List<CqlType> variableTypes;
    private final Long timestamp;

    private Query(String query, String consistency, String serialConsistency, List<Object> variables, List<CqlType> variableTypes, Long timestamp) {
        this.query = query;
        this.consistency = consistency;
        this.serialConsistency = serialConsistency;
        this.variables = variables;
        this.variableTypes = variableTypes;
        this.timestamp = timestamp;
    }

    public String getQuery() {
        return this.query;
    }

    public String getConsistency() {
        return this.consistency;
    }

    public String getSerialConsistency() {
        return this.serialConsistency;
    }

    public Long getTimestamp() {
        return this.timestamp;
    }

    public List<Object> getVariables() {
        return this.variables;
    }

    public List<CqlType> getVariableTypes() {
        return this.variableTypes;
    }

    public String toString() {
        return "Query{query='" + this.query + '\'' + ", consistency='" + this.consistency + '\'' + ", serialConsistency='" + this.serialConsistency + '\'' + ", variables=" + this.variables + ", variableTypes=" + this.variableTypes + ", timestamp=" + this.timestamp + '}';
    }

    public static QueryBuilder builder() {
        return new QueryBuilder();
    }

    public static QueryBuilder builder(CqlType ... variableTypes) {
        return new QueryBuilder(Arrays.asList(variableTypes));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Query query1 = (Query)o;
        if (this.query != null ? !this.query.equals(query1.query) : query1.query != null) {
            return false;
        }
        if (this.consistency != null ? !this.consistency.equals(query1.consistency) : query1.consistency != null) {
            return false;
        }
        if (this.serialConsistency != null ? !this.serialConsistency.equals(query1.serialConsistency) : query1.serialConsistency != null) {
            return false;
        }
        if (this.variables != null ? !this.variables.equals(query1.variables) : query1.variables != null) {
            return false;
        }
        if (this.variableTypes != null ? !this.variableTypes.equals(query1.variableTypes) : query1.variableTypes != null) {
            return false;
        }
        return this.timestamp != null ? this.timestamp.equals(query1.timestamp) : query1.timestamp == null;
    }

    public int hashCode() {
        int result = this.query != null ? this.query.hashCode() : 0;
        result = 31 * result + (this.consistency != null ? this.consistency.hashCode() : 0);
        result = 31 * result + (this.serialConsistency != null ? this.serialConsistency.hashCode() : 0);
        result = 31 * result + (this.variables != null ? this.variables.hashCode() : 0);
        result = 31 * result + (this.variableTypes != null ? this.variableTypes.hashCode() : 0);
        result = 31 * result + (this.timestamp != null ? this.timestamp.hashCode() : 0);
        return result;
    }

    public static class QueryBuilder {
        private String query;
        private String consistency = "ONE";
        private String serialConsistency = null;
        private Long timestamp = null;
        private List<Object> variables = Collections.emptyList();
        private List<CqlType> variableTypes = Collections.emptyList();

        private QueryBuilder() {
        }

        private QueryBuilder(List<CqlType> variableTypes) {
            this.variableTypes = variableTypes;
        }

        public QueryBuilder withQuery(String query) {
            this.query = query;
            return this;
        }

        public QueryBuilder withConsistency(String consistency) {
            this.consistency = consistency;
            return this;
        }

        public QueryBuilder withSerialConsistency(String consistency) {
            this.serialConsistency = consistency;
            return this;
        }

        public QueryBuilder withTimestamp(Long timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public QueryBuilder withVariables(List<Object> variables) {
            this.variables = variables;
            return this;
        }

        public QueryBuilder withVariables(Object ... variables) {
            this.variables = Arrays.asList(variables);
            return this;
        }

        public Query build() {
            if (this.query == null) {
                throw new IllegalStateException("Must set query");
            }
            return new Query(this.query, this.consistency, this.serialConsistency, this.variables, this.variableTypes, this.timestamp);
        }
    }
}

